/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Ascii;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.CodePrinter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.jspecify.nullness.Nullable;

public final class JSDocInfoPrinter {
    private final boolean useOriginalName;
    private final boolean printDesc;

    public JSDocInfoPrinter(boolean useOriginalName) {
        this(useOriginalName, false);
    }

    public JSDocInfoPrinter(boolean useOriginalName, boolean printDesc) {
        this.useOriginalName = useOriginalName;
        this.printDesc = printDesc;
    }

    public String print(JSDocInfo info) {
        Object cleaned;
        ImmutableMap<ImmutableSet<String>, String> suppressions;
        ImmutableMap<String, Node> typeTransformations;
        ImmutableMap<String, JSTypeExpression> immutableMap;
        Node typeNode;
        String description;
        boolean multiline = false;
        ArrayList<Object> parts = new ArrayList<Object>();
        parts.add("/**");
        if (info.isExterns()) {
            parts.add("@externs");
        }
        if (info.isTypeSummary()) {
            parts.add("@typeSummary");
        }
        if (info.isExport()) {
            parts.add("@export");
        } else if (info.getVisibility() != null && info.getVisibility() != JSDocInfo.Visibility.INHERITED) {
            parts.add("@" + Ascii.toLowerCase((String)info.getVisibility().toString()));
        }
        if (info.getAuthors() != null) {
            multiline = true;
            for (String string : info.getAuthors()) {
                parts.add("@author " + string);
            }
        }
        if (info.isAbstract()) {
            parts.add("@abstract");
        }
        if (info.hasLendsName()) {
            parts.add(this.buildAnnotationWithType("lends", info.getLendsName().getRoot()));
        }
        if (info.hasConstAnnotation() && !info.isDefine()) {
            parts.add("@const");
        }
        if (info.isFinal()) {
            parts.add("@final");
        }
        if ((description = info.getDescription()) != null) {
            multiline = true;
            parts.add("@desc " + description);
        }
        if (info.getReferences() != null) {
            multiline = true;
            for (String desc : info.getReferences()) {
                parts.add("@see " + desc);
            }
        }
        if (info.isWizaction()) {
            parts.add("@wizaction");
        }
        if (info.isPolymerBehavior()) {
            parts.add("@polymerBehavior");
        }
        if (info.isPolymer()) {
            parts.add("@polymer");
        }
        if (info.isCustomElement()) {
            parts.add("@customElement");
        }
        if (info.isMixinClass()) {
            parts.add("@mixinClass");
        }
        if (info.isMixinFunction()) {
            parts.add("@mixinFunction");
        }
        if (info.isNoSideEffects()) {
            parts.add("@nosideeffects");
        }
        if (info.isNoCompile()) {
            parts.add("@nocompile");
        }
        if (info.isNoInline()) {
            parts.add("@noinline");
        }
        if (info.isProvideAlreadyProvided()) {
            parts.add("@provideAlreadyProvided");
        }
        if (info.isIdGenerator()) {
            parts.add("@idGenerator {unique}");
        }
        if (info.isConsistentIdGenerator()) {
            parts.add("@idGenerator {consistent}");
        }
        if (info.isStableIdGenerator()) {
            parts.add("@idGenerator {stable}");
        }
        if (info.isXidGenerator()) {
            parts.add("@idGenerator {xid}");
        }
        if (info.isMappedIdGenerator()) {
            parts.add("@idGenerator {mapped}");
        }
        if (info.makesDicts()) {
            parts.add("@dict");
        }
        if (info.makesStructs()) {
            parts.add("@struct");
        }
        if (info.makesUnrestricted()) {
            parts.add("@unrestricted ");
        }
        if (info.isConstructor()) {
            parts.add("@constructor");
        }
        if (info.isInterface() && !info.usesImplicitMatch()) {
            parts.add("@interface");
        }
        if (info.isInterface() && info.usesImplicitMatch()) {
            parts.add("@record");
        }
        if (info.hasBaseType()) {
            multiline = true;
            Node node = this.stripBang(info.getBaseType().getRoot());
            parts.add(this.buildAnnotationWithType("extends", node));
        }
        for (JSTypeExpression type : info.getExtendedInterfaces()) {
            multiline = true;
            typeNode = this.stripBang(type.getRoot());
            parts.add(this.buildAnnotationWithType("extends", typeNode));
        }
        for (JSTypeExpression type : info.getImplementedInterfaces()) {
            multiline = true;
            typeNode = this.stripBang(type.getRoot());
            parts.add(this.buildAnnotationWithType("implements", typeNode));
        }
        if (info.hasThisType()) {
            multiline = true;
            Node node = this.stripBang(info.getThisType().getRoot());
            parts.add(this.buildAnnotationWithType("this", node));
        }
        if (info.getParameterCount() > 0) {
            multiline = true;
            for (String name2 : info.getParameterNames()) {
                parts.add("@param " + this.buildParamType(info, name2));
            }
        }
        if (info.hasReturnType()) {
            multiline = true;
            parts.add(this.buildAnnotationWithType("return", info.getReturnType(), info.getReturnDescription()));
        }
        if (!info.getThrowsAnnotations().isEmpty() && !info.getThrowsAnnotations().get(0).isEmpty()) {
            multiline = true;
            parts.add("@throws " + info.getThrowsAnnotations().get(0));
        }
        if (!(immutableMap = info.getTemplateTypes()).isEmpty()) {
            multiline = true;
            immutableMap.forEach((name, boundExpr) -> {
                Node boundRoot = boundExpr.getRoot();
                if (boundRoot.getToken() == Token.QMARK && !boundRoot.hasChildren()) {
                    parts.add("@template " + name);
                } else {
                    parts.add(this.buildAnnotationWithType("template", (JSTypeExpression)boundExpr, (String)name));
                }
            });
        }
        if (!(typeTransformations = info.getTypeTransformations()).isEmpty()) {
            multiline = true;
            for (Map.Entry e : typeTransformations.entrySet()) {
                String name3 = (String)e.getKey();
                String tranformationDefinition = new CodePrinter.Builder((Node)e.getValue()).build();
                parts.add("@template " + name3 + " := " + tranformationDefinition + " =:");
            }
        }
        if (info.isOverride()) {
            parts.add("@override");
        }
        if (info.hasType() && !info.isDefine()) {
            if (info.isInlineType()) {
                parts.add(this.typeNode(info.getType().getRoot()));
            } else {
                parts.add(this.buildAnnotationWithType("type", info.getType()));
            }
        }
        if (info.isDefine()) {
            parts.add(this.buildAnnotationWithType("define", info.getType()));
        }
        if (info.hasTypedefType()) {
            parts.add(this.buildAnnotationWithType("typedef", info.getTypedefType()));
        }
        if (info.hasEnumParameterType()) {
            parts.add(this.buildAnnotationWithType("enum", info.getEnumParameterType()));
        }
        if (info.isImplicitCast()) {
            parts.add("@implicitCast");
        }
        if (info.isNoCollapse()) {
            parts.add("@nocollapse");
        }
        if (!(suppressions = info.getSuppressionsAndTheirDescription()).isEmpty()) {
            for (Map.Entry suppression : suppressions.entrySet()) {
                Object[] warnings = (String[])((ImmutableSet)suppression.getKey()).toArray((Object[])new String[0]);
                Arrays.sort(warnings, Comparator.naturalOrder());
                String text = (String)suppression.getValue();
                StringBuilder sb = new StringBuilder();
                sb.append("@suppress {").append(Joiner.on((char)',').join(warnings)).append("}");
                if (!text.isEmpty()) {
                    sb.append(" ").append(text);
                }
                parts.add(sb.toString());
            }
            multiline = true;
        }
        if (info.isDeprecated()) {
            String deprecationReason = info.getDeprecationReason();
            parts.add("@deprecated" + (String)(deprecationReason != null ? " " + deprecationReason : ""));
            multiline = true;
        }
        if (info.isPolymer()) {
            multiline = true;
            parts.add("@polymer");
        }
        if (info.isPolymerBehavior()) {
            multiline = true;
            parts.add("@polymerBehavior");
        }
        if (info.isMixinFunction()) {
            multiline = true;
            parts.add("@mixinFunction");
        }
        if (info.isMixinClass()) {
            multiline = true;
            parts.add("@mixinClass");
        }
        if (info.isCustomElement()) {
            multiline = true;
            parts.add("@customElement");
        }
        if (info.getClosurePrimitiveId() != null) {
            parts.add("@closurePrimitive {" + info.getClosurePrimitiveId() + "}");
        }
        if (info.isNgInject()) {
            parts.add("@ngInject");
        }
        for (String tsType : info.getTsTypes()) {
            parts.add("@tsType " + tsType);
        }
        if (this.printDesc && info.getBlockDescription() != null && !((String)(cleaned = info.getBlockDescription().replaceAll("\n\\s*\\*\\s*", "\n"))).isEmpty()) {
            multiline = true;
            cleaned = ((String)cleaned).trim();
            if (parts.size() > 1) {
                cleaned = (String)cleaned + "\n";
            }
            parts.add(1, cleaned);
        }
        StringBuilder sb = new StringBuilder();
        if (multiline) {
            Joiner.on((String)"\n").appendTo(sb, parts);
        } else {
            Joiner.on((String)" ").appendTo(sb, parts);
            sb.append(" */");
        }
        Object s = sb.toString().replace("\n", "\n *").replaceAll("\n \\*([^ \n])", "\n * $1");
        s = multiline ? (String)s + "\n */\n" : (String)s + " ";
        return s;
    }

    private Node stripBang(Node typeNode) {
        if (typeNode.getToken() == Token.BANG) {
            typeNode = typeNode.getFirstChild();
        }
        return typeNode;
    }

    private String buildAnnotationWithType(String annotation, JSTypeExpression type) {
        return this.buildAnnotationWithType(annotation, type, null);
    }

    private String buildAnnotationWithType(String annotation, JSTypeExpression type, @Nullable String description) {
        return this.buildAnnotationWithType(annotation, type.getRoot(), description);
    }

    private String buildAnnotationWithType(String annotation, Node type) {
        return this.buildAnnotationWithType(annotation, type, null);
    }

    private String buildAnnotationWithType(String annotation, Node type, @Nullable String description) {
        StringBuilder sb = new StringBuilder();
        sb.append("@");
        sb.append(annotation);
        sb.append(" {");
        this.appendTypeNode(sb, type);
        sb.append("}");
        if (description != null) {
            sb.append(" ");
            sb.append(description);
        }
        return sb.toString();
    }

    private String buildParamType(JSDocInfo info, String name) {
        JSTypeExpression type = info.getParameterType(name);
        if (type != null) {
            String p = "{" + this.typeNode(type.getRoot()) + "} " + name + (this.printDesc && info.getDescriptionForParameter(name) != null ? info.getDescriptionForParameter(name) : "");
            return p.trim();
        }
        return name;
    }

    private String typeNode(Node typeNode) {
        StringBuilder sb = new StringBuilder();
        this.appendTypeNode(sb, typeNode);
        return sb.toString();
    }

    private void appendTypeNode(StringBuilder sb, Node typeNode) {
        if (this.useOriginalName && typeNode.getOriginalName() != null) {
            sb.append(typeNode.getOriginalName());
            return;
        }
        switch (typeNode.getToken()) {
            case BANG: {
                sb.append("!");
                this.appendTypeNode(sb, typeNode.getFirstChild());
                break;
            }
            case EQUALS: {
                this.appendTypeNode(sb, typeNode.getFirstChild());
                sb.append("=");
                break;
            }
            case PIPE: {
                sb.append("(");
                Node lastChild = typeNode.getLastChild();
                for (Node child = typeNode.getFirstChild(); child != null; child = child.getNext()) {
                    this.appendTypeNode(sb, child);
                    if (child == lastChild) continue;
                    sb.append("|");
                }
                sb.append(")");
                break;
            }
            case ITER_REST: {
                sb.append("...");
                if (!typeNode.hasChildren() || typeNode.getFirstChild().isEmpty()) break;
                this.appendTypeNode(sb, typeNode.getFirstChild());
                break;
            }
            case STAR: {
                sb.append("*");
                break;
            }
            case QMARK: {
                sb.append("?");
                if (!typeNode.hasChildren()) break;
                this.appendTypeNode(sb, typeNode.getFirstChild());
                break;
            }
            case FUNCTION: {
                this.appendFunctionNode(sb, typeNode);
                break;
            }
            case LC: {
                sb.append("{");
                Node lb = typeNode.getFirstChild();
                Node lastColon = lb.getLastChild();
                for (Node colon = lb.getFirstChild(); colon != null; colon = colon.getNext()) {
                    if (colon.hasChildren()) {
                        sb.append(colon.getFirstChild().getString()).append(":");
                        this.appendTypeNode(sb, colon.getLastChild());
                    } else {
                        sb.append(colon.getString());
                    }
                    if (colon == lastColon) continue;
                    sb.append(",");
                }
                sb.append("}");
                break;
            }
            case VOID: {
                sb.append("void");
                break;
            }
            case TYPEOF: {
                sb.append("typeof ");
                this.appendTypeNode(sb, typeNode.getFirstChild());
                break;
            }
            case BLOCK: {
                sb.append("<");
                Node last = typeNode.getLastChild();
                for (Node type = typeNode.getFirstChild(); type != null; type = type.getNext()) {
                    this.appendTypeNode(sb, type);
                    if (type == last) continue;
                    sb.append(",");
                }
                sb.append(">");
                break;
            }
            case STRINGLIT: {
                sb.append(typeNode.getString());
                if (!typeNode.hasChildren()) break;
                this.appendTypeNode(sb, typeNode.getOnlyChild());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected typeNode: " + typeNode);
            }
        }
    }

    private void appendFunctionNode(StringBuilder sb, Node function) {
        boolean hasNewOrThis = false;
        sb.append("function(");
        Node first = function.getFirstChild();
        if (first.isNew()) {
            sb.append("new:");
            this.appendTypeNode(sb, first.getFirstChild());
            hasNewOrThis = true;
        } else if (first.isThis()) {
            sb.append("this:");
            this.appendTypeNode(sb, first.getFirstChild());
            hasNewOrThis = true;
        } else {
            if (first.isEmpty()) {
                sb.append(")");
                return;
            }
            if (!first.isParamList()) {
                sb.append("):");
                this.appendTypeNode(sb, first);
                return;
            }
        }
        Node paramList = null;
        if (first.isParamList()) {
            paramList = first;
        } else if (first.getNext().isParamList()) {
            paramList = first.getNext();
        }
        if (paramList != null) {
            boolean firstParam = true;
            for (Node param = paramList.getFirstChild(); param != null; param = param.getNext()) {
                if (!firstParam || hasNewOrThis) {
                    sb.append(",");
                }
                this.appendTypeNode(sb, param);
                firstParam = false;
            }
        }
        sb.append(")");
        Node returnType = function.getLastChild();
        if (!returnType.isEmpty()) {
            sb.append(":");
            this.appendTypeNode(sb, returnType);
        }
    }
}

