/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.WarningsGuard;
import org.jspecify.nullness.Nullable;

public final class J2clSuppressWarningsGuard
extends WarningsGuard {
    private static final DiagnosticGroup DEFAULT_J2CL_SUPRRESIONS = new DiagnosticGroup("j2clIncomaptible", DiagnosticGroups.CHECK_STATIC_OVERRIDES, DiagnosticGroups.CHECK_USELESS_CODE, DiagnosticGroups.CONST, DiagnosticGroups.EXTRA_REQUIRE, DiagnosticGroups.LATE_PROVIDE, DiagnosticGroups.MISSING_OVERRIDE, DiagnosticGroups.MISSING_REQUIRE, DiagnosticGroups.STRICT_MODULE_DEP_CHECK, DiagnosticGroups.SUSPICIOUS_CODE, DiagnosticGroups.UNUSED_LOCAL_VARIABLE, DiagnosticGroups.STRICT_MISSING_PROPERTIES, DiagnosticGroups.forName("transitionalSuspiciousCodeWarnings"));

    @Override
    public @Nullable CheckLevel level(JSError error) {
        if (error.getSourceName() == null || !error.getSourceName().endsWith(".java.js")) {
            return null;
        }
        return DEFAULT_J2CL_SUPRRESIONS.matches(error) ? CheckLevel.OFF : null;
    }

    @Override
    protected int getPriority() {
        return WarningsGuard.Priority.MAX.getValue();
    }
}

