/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstAnalyzer;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.InvocationsCallback;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jspecify.nullness.Nullable;

class InlineSimpleMethods
implements CompilerPass {
    final ImmutableSet<String> externProperties;
    final Set<String> nonMethodProperties = new HashSet<String>();
    final SetMultimap<String, Node> methodDefinitions = LinkedHashMultimap.create();
    private final AbstractCompiler compiler;
    private static final Logger logger = Logger.getLogger(InlineSimpleMethods.class.getName());
    private final AstAnalyzer astAnalyzer;

    InlineSimpleMethods(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astAnalyzer = compiler.getAstAnalyzer();
        this.externProperties = compiler.getExternProperties();
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized(), (Object)this.compiler.getLifeCycleStage());
        Preconditions.checkState((boolean)this.methodDefinitions.isEmpty());
        Preconditions.checkState((externs != null ? 1 : 0) != 0);
        NodeTraversal.traverseRoots(this.compiler, new GatherSignatures(), externs, root);
        NodeTraversal.traverseRoots(this.compiler, new InlineTrivialAccessors(), externs, root);
    }

    private static boolean isPropertyTree(Node expectedGetprop) {
        if (!expectedGetprop.isGetProp()) {
            return false;
        }
        Node getpropLhs = expectedGetprop.getFirstChild();
        return getpropLhs.isThis() || InlineSimpleMethods.isPropertyTree(getpropLhs);
    }

    private static void replaceThis(Node expectedGetprop, Node replacement) {
        Node leftChild = expectedGetprop.getFirstChild();
        if (leftChild.isThis()) {
            leftChild.replaceWith(replacement);
        } else {
            InlineSimpleMethods.replaceThis(leftChild, replacement);
        }
    }

    private static @Nullable Node returnedExpression(Node fn) {
        Node expectedBlock = NodeUtil.getFunctionBody(fn);
        if (!expectedBlock.hasOneChild()) {
            return null;
        }
        Node expectedReturn = expectedBlock.getFirstChild();
        if (!expectedReturn.isReturn()) {
            return null;
        }
        if (!expectedReturn.hasOneChild()) {
            return null;
        }
        return expectedReturn.getOnlyChild();
    }

    private static boolean isEmptyMethod(Node fn) {
        return NodeUtil.isEmptyBlock(NodeUtil.getFunctionBody(fn));
    }

    private boolean allDefinitionsEquivalent(Set<Node> definitions) {
        Node first = null;
        for (Node n : definitions) {
            if (first == null) {
                first = n;
                continue;
            }
            if (this.compiler.areNodesEqualForInlining(first, n)) continue;
            return false;
        }
        return true;
    }

    private void inlinePropertyReturn(Node call, Node returnedValue) {
        Node getProp = returnedValue.cloneTree();
        InlineSimpleMethods.replaceThis(getProp, call.getFirstChild().removeFirstChild());
        call.replaceWith(getProp);
        this.compiler.reportChangeToEnclosingScope(getProp);
    }

    private void inlineConstReturn(Node call, Node returnedValue) {
        Node retValue = returnedValue.cloneTree();
        call.replaceWith(retValue);
        this.compiler.reportChangeToEnclosingScope(retValue);
    }

    private void inlineEmptyMethod(NodeTraversal t, Node parent, Node call) {
        if (NodeUtil.isExprCall(parent)) {
            parent.replaceWith(IR.empty());
            NodeUtil.markFunctionsDeleted(parent, this.compiler);
        } else {
            Node srcLocation = call;
            call.replaceWith(NodeUtil.newUndefinedNode(srcLocation));
            NodeUtil.markFunctionsDeleted(call, this.compiler);
        }
        t.reportCodeChange();
    }

    private boolean argsMayHaveSideEffects(Node call) {
        for (Node currentChild = call.getSecondChild(); currentChild != null; currentChild = currentChild.getNext()) {
            if (!this.astAnalyzer.mayHaveSideEffects(currentChild)) continue;
            return true;
        }
        return false;
    }

    private void addPossibleSignature(String name, Node node) {
        if (node != null && node.isFunction()) {
            this.addSignature(name, node);
        } else {
            this.nonMethodProperties.add(name);
        }
    }

    private void addSignature(String name, Node function) {
        if (this.externProperties.contains((Object)name)) {
            return;
        }
        this.methodDefinitions.put((Object)name, (Object)function);
    }

    private static @Nullable String getPropName(Node getPropElem) {
        if (getPropElem.isGetProp()) {
            return getPropElem.getString();
        }
        if (getPropElem.getSecondChild().isStringLit()) {
            return getPropElem.getSecondChild().getString();
        }
        return null;
    }

    private class GatherSignatures
    extends NodeTraversal.AbstractPostOrderCallback {
        private GatherSignatures() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case GETPROP: 
                case GETELEM: {
                    String name = InlineSimpleMethods.getPropName(n);
                    if (name == null) {
                        return;
                    }
                    if (name.equals("prototype")) {
                        this.processPrototypeParent(parent);
                        break;
                    }
                    if (!parent.isAssign() || !n.isFirstChildOf(parent)) break;
                    InlineSimpleMethods.this.addPossibleSignature(name, n.getNext());
                    break;
                }
                case OBJECTLIT: 
                case CLASS_MEMBERS: {
                    block9: for (Node key = n.getFirstChild(); key != null; key = key.getNext()) {
                        switch (key.getToken()) {
                            case MEMBER_FUNCTION_DEF: 
                            case MEMBER_FIELD_DEF: 
                            case STRING_KEY: {
                                InlineSimpleMethods.this.addPossibleSignature(key.getString(), key.getFirstChild());
                                continue block9;
                            }
                            case SETTER_DEF: 
                            case GETTER_DEF: {
                                InlineSimpleMethods.this.nonMethodProperties.add(key.getString());
                                continue block9;
                            }
                            case COMPUTED_PROP: 
                            case OBJECT_SPREAD: 
                            case COMPUTED_FIELD_DEF: {
                                continue block9;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected " + n.getToken() + " key: " + key);
                            }
                        }
                    }
                    break;
                }
            }
        }

        private void processPrototypeParent(Node n) {
            switch (n.getToken()) {
                case GETPROP: 
                case GETELEM: {
                    Node grandparent = n.getGrandparent();
                    String name = InlineSimpleMethods.getPropName(n);
                    if (name == null || !grandparent.isAssign()) break;
                    Node assignee = grandparent.getSecondChild();
                    InlineSimpleMethods.this.addPossibleSignature(name, assignee);
                    break;
                }
            }
        }
    }

    private class InlineTrivialAccessors
    extends InvocationsCallback {
        private InlineTrivialAccessors() {
        }

        @Override
        void visit(NodeTraversal t, Node callNode, Node parent, String callName) {
            if (InlineSimpleMethods.this.externProperties.contains((Object)callName) || InlineSimpleMethods.this.nonMethodProperties.contains(callName)) {
                return;
            }
            Set definitions = InlineSimpleMethods.this.methodDefinitions.get((Object)callName);
            if (definitions == null || definitions.isEmpty()) {
                return;
            }
            Node firstDefinition = (Node)definitions.iterator().next();
            if (definitions.size() == 1 || InlineSimpleMethods.this.allDefinitionsEquivalent(definitions)) {
                if (!InlineSimpleMethods.this.argsMayHaveSideEffects(callNode) && !NodeUtil.referencesSuper(callNode)) {
                    Node returned = InlineSimpleMethods.returnedExpression(firstDefinition);
                    if (returned != null) {
                        if (InlineSimpleMethods.isPropertyTree(returned) && !firstDefinition.isArrowFunction()) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Inlining property accessor: " + callName);
                            }
                            InlineSimpleMethods.this.inlinePropertyReturn(callNode, returned);
                        } else if (NodeUtil.isLiteralValue(returned, false) && !InlineSimpleMethods.this.astAnalyzer.mayHaveSideEffects(callNode.getFirstChild())) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Inlining constant accessor: " + callName);
                            }
                            InlineSimpleMethods.this.inlineConstReturn(callNode, returned);
                        }
                    } else if (InlineSimpleMethods.isEmptyMethod(firstDefinition) && !InlineSimpleMethods.this.astAnalyzer.mayHaveSideEffects(callNode.getFirstChild())) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Inlining empty method: " + callName);
                        }
                        InlineSimpleMethods.this.inlineEmptyMethod(t, parent, callNode);
                    }
                }
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine("Method '" + callName + "' has conflicting definitions.");
            }
        }
    }
}

