/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.rhino.Node;

class InjectRuntimeLibraries
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Stage stage;

    private InjectRuntimeLibraries(AbstractCompiler compiler, Stage stage) {
        this.compiler = compiler;
        this.stage = stage;
    }

    @Override
    public void process(Node externs, Node root) {
        CompilerOptions options = this.compiler.getOptions();
        switch (this.stage) {
            case CHECKS: {
                return;
            }
            case OPTIMIZATIONS: {
                this.injectOptimizationsLibraries(options);
                return;
            }
        }
        throw new AssertionError();
    }

    private void injectOptimizationsLibraries(CompilerOptions options) {
        for (String forced : options.forceLibraryInjection) {
            this.compiler.ensureLibraryInjected(forced, true);
        }
    }

    public static InjectRuntimeLibraries forChecks(AbstractCompiler compiler) {
        return new InjectRuntimeLibraries(compiler, Stage.CHECKS);
    }

    public static InjectRuntimeLibraries forOptimizations(AbstractCompiler compiler) {
        return new InjectRuntimeLibraries(compiler, Stage.OPTIMIZATIONS);
    }

    private static enum Stage {
        CHECKS,
        OPTIMIZATIONS;

    }
}

