/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;

public class ForbidDynamicImportUsage
implements CompilerPass,
NodeTraversal.Callback {
    private final AbstractCompiler compiler;
    static final DiagnosticType DYNAMIC_IMPORT_USAGE = DiagnosticType.error("JSC_DYNAMIC_IMPORT_USAGE", "Dynamic import expressions cannot be transpiled.");

    public ForbidDynamicImportUsage(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isScript()) {
            return this.getFeatureSetOfScript(n).contains(FeatureSet.Feature.DYNAMIC_IMPORT);
        }
        return true;
    }

    private FeatureSet getFeatureSetOfScript(Node n) {
        FeatureSet featureSet = NodeUtil.getFeatureSetOfScript(n);
        return featureSet == null ? FeatureSet.BARE_MINIMUM : featureSet;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case DYNAMIC_IMPORT: {
                t.report(n, DYNAMIC_IMPORT_USAGE, new String[0]);
                break;
            }
        }
    }
}

