/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

class ExploitAssigns
extends AbstractPeepholeOptimization {
    ExploitAssigns() {
    }

    @Override
    Node optimizeSubtree(Node subtree) {
        Node child = subtree.getFirstChild();
        while (child != null) {
            Node next = child.getNext();
            if (NodeUtil.isExprAssign(child)) {
                this.collapseAssign(child.getFirstChild(), child, subtree);
            }
            child = next;
        }
        return subtree;
    }

    private void collapseAssign(Node assign, Node expr, Node exprParent) {
        Node leftValue = assign.getFirstChild();
        Node rightValue = leftValue.getNext();
        if (leftValue.isDestructuringPattern()) {
            return;
        }
        if (!(ExploitAssigns.isCollapsibleValue(leftValue, true) && this.collapseAssignEqualTo(expr, exprParent, leftValue) || ExploitAssigns.isCollapsibleValue(rightValue, false) && this.collapseAssignEqualTo(expr, exprParent, rightValue) || !rightValue.isAssign())) {
            this.collapseAssign(rightValue, expr, exprParent);
        }
    }

    private static boolean isCollapsibleValue(Node value, boolean isLValue) {
        switch (value.getToken()) {
            case GETPROP: 
            case OPTCHAIN_GETPROP: {
                return !isLValue || value.getFirstChild().isThis();
            }
            case NAME: {
                return true;
            }
        }
        return NodeUtil.isImmutableValue(value);
    }

    private boolean collapseAssignEqualTo(Node expr, Node exprParent, Node value) {
        Node assign = expr.getFirstChild();
        Node parent = exprParent;
        Node next = expr.getNext();
        block7: while (next != null) {
            switch (next.getToken()) {
                case AND: 
                case OR: 
                case HOOK: 
                case IF: 
                case RETURN: 
                case EXPR_RESULT: 
                case COALESCE: {
                    parent = next;
                    next = next.getFirstChild();
                    continue block7;
                }
                case CONST: 
                case LET: 
                case VAR: {
                    if (next.getFirstChild().hasChildren()) {
                        parent = next.getFirstChild();
                        next = parent.getFirstChild();
                        continue block7;
                    }
                    return false;
                }
                case OPTCHAIN_GETPROP: {
                    return false;
                }
                case GETPROP: 
                case NAME: {
                    if (next.isQualifiedName() && value.isQualifiedName() && next.matchesQualifiedName(value)) {
                        if (!this.isSafeReplacement(next, assign)) {
                            return false;
                        }
                        expr.detach();
                        assign.detach();
                        next.replaceWith(assign);
                        this.reportChangeToEnclosingScope(parent);
                        return true;
                    }
                    return false;
                }
                case ASSIGN: {
                    Node leftSide = next.getFirstChild();
                    if (leftSide.isName() || leftSide.isGetProp() && leftSide.getFirstChild().isThis()) {
                        parent = next;
                        next = leftSide.getNext();
                        continue block7;
                    }
                    return false;
                }
            }
            if (NodeUtil.isImmutableValue(next) && next.isEquivalentTo(value)) {
                expr.detach();
                assign.detach();
                next.replaceWith(assign);
                this.reportChangeToEnclosingScope(parent);
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean isSafeReplacement(Node node, Node replacement) {
        if (node.isName()) {
            return true;
        }
        Preconditions.checkArgument((boolean)node.isGetProp());
        while (node.isGetProp()) {
            node = node.getFirstChild();
        }
        return !node.isName() || !ExploitAssigns.isNameAssignedTo(node.getString(), replacement);
    }

    private static boolean isNameAssignedTo(String name, Node node) {
        Node parent;
        for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
            if (!ExploitAssigns.isNameAssignedTo(name, c)) continue;
            return true;
        }
        return node.isName() && (parent = node.getParent()).isAssign() && parent.getFirstChild() == node && name.equals(node.getString());
    }
}

