/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.UniqueIdSupplier;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;
import java.util.function.Supplier;

public final class Es7RewriteExponentialOperator
implements NodeTraversal.Callback,
CompilerPass {
    static final DiagnosticType TRANSPILE_EXPONENT_USING_BIGINT = DiagnosticType.error("JSC_TRANSPILE_EXPONENT_USING_BIGINT", "Cannot transpile `**` operator applied to BigInt operands.");
    private static final String TEMP_VAR_NAME_PREFIX = "$jscomp$exp$assign$tmp";
    private static final String TEMP_INDEX_VAR_NAME_PREFIX = "$jscomp$exp$assign$tmpindex";
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private final UniqueIdSupplier uniqueIdSupplier;
    private final Supplier<Node> mathPowCall = Suppliers.memoize(this::createMathPowCall);

    public Es7RewriteExponentialOperator(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.uniqueIdSupplier = compiler.getUniqueIdSupplier();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, FeatureSet.Feature.EXPONENT_OP, new FeatureSet.Feature[0]);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isScript()) {
            FeatureSet scriptFeatures = NodeUtil.getFeatureSetOfScript(n);
            return scriptFeatures == null || scriptFeatures.contains(FeatureSet.Feature.EXPONENT_OP);
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case EXPONENT: {
                if (!this.checkOperatorType(n)) break;
                this.visitExponentiationOperator(n);
                break;
            }
            case ASSIGN_EXPONENT: {
                if (!this.checkOperatorType(n)) break;
                this.visitExponentiationAssignmentOperator(t, n);
                break;
            }
        }
    }

    private void visitExponentiationOperator(Node operator) {
        Node callClone = this.mathPowCall.get().cloneTree();
        callClone.addChildToBack(operator.removeFirstChild());
        callClone.addChildToBack(operator.removeFirstChild());
        callClone.srcrefTreeIfMissing(operator);
        operator.replaceWith(callClone);
        this.compiler.reportChangeToEnclosingScope(callClone);
    }

    private void visitExponentiationAssignmentOperator(NodeTraversal t, Node operator) {
        Node replacement;
        Node enclosingStatement = NodeUtil.getEnclosingStatement(operator);
        Node left = operator.removeFirstChild();
        if (left.isName()) {
            replacement = this.handleLHSName(operator, left);
        } else {
            Preconditions.checkState((left.isGetProp() || left.isGetElem() ? 1 : 0) != 0, (Object)left);
            replacement = this.handleLHSPropertyReference(t, operator, left, enclosingStatement);
        }
        operator.replaceWith(replacement);
        this.compiler.reportChangeToEnclosingScope(enclosingStatement);
    }

    private Node handleLHSName(Node operator, Node left) {
        Node callClone = this.mathPowCall.get().cloneTree();
        callClone.addChildToBack(left.cloneTree());
        callClone.addChildToBack(operator.removeFirstChild());
        return this.astFactory.createAssign(left, callClone).srcrefTreeIfMissing(operator);
    }

    private Node handleLHSPropertyReference(NodeTraversal t, Node operator, Node left, Node enclosingStatement) {
        Node newLHS;
        Node tempPropOrElem;
        CompilerInput input = t.getInput();
        String uniqueId = this.uniqueIdSupplier.getUniqueId(input);
        String tempVarName = TEMP_VAR_NAME_PREFIX + uniqueId;
        Node objectNode = left.removeFirstChild();
        Node let = this.astFactory.createSingleLetNameDeclaration(tempVarName).srcrefTree(operator);
        let.insertBefore(enclosingStatement);
        Node tempName = this.astFactory.createName(tempVarName, AstFactory.type(objectNode)).srcref(objectNode);
        Node assignTemp = this.astFactory.createAssign(tempName, objectNode).srcref(objectNode);
        if (left.isGetProp()) {
            String propertyName = left.getString();
            tempPropOrElem = this.astFactory.createGetProp(tempName.cloneNode(), propertyName, AstFactory.type(left)).srcref(left);
            newLHS = this.astFactory.createGetProp(assignTemp, propertyName, AstFactory.type(left)).srcref(left);
        } else {
            Preconditions.checkState((boolean)left.isGetElem(), (Object)left);
            String tempIndexVarName = TEMP_INDEX_VAR_NAME_PREFIX + uniqueId;
            Node indexExprNode = left.getLastChild().detach();
            Node letIndex = this.astFactory.createSingleLetNameDeclaration(tempIndexVarName).srcrefTree(operator);
            letIndex.insertBefore(enclosingStatement);
            Node tempIndexName = this.astFactory.createName(tempIndexVarName, AstFactory.type(indexExprNode)).srcref(indexExprNode);
            Node assignTempIndex = this.astFactory.createAssign(tempIndexName, indexExprNode).srcref(indexExprNode);
            tempPropOrElem = this.astFactory.createGetElem(tempName.cloneNode(), tempIndexName.cloneNode()).copyTypeFrom(left).srcref(left);
            newLHS = this.astFactory.createGetElem(assignTemp, assignTempIndex).copyTypeFrom(left).srcref(left);
        }
        Node callClone = this.mathPowCall.get().cloneTree();
        callClone.addChildToBack(tempPropOrElem.cloneTree());
        callClone.addChildToBack(operator.removeFirstChild());
        NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.LET_DECLARATIONS, this.compiler);
        return this.astFactory.createAssign(newLHS, callClone).srcrefTreeIfMissing(operator);
    }

    private Node createMathPowCall() {
        return this.astFactory.createCall(this.astFactory.createQName(this.compiler.getTranspilationNamespace(), "Math.pow"), AstFactory.type(StandardColors.NUMBER), new Node[0]);
    }

    private boolean checkOperatorType(Node operator) {
        Preconditions.checkArgument((operator.isExponent() || operator.isAssignExponent() ? 1 : 0) != 0, (Object)operator);
        if (this.compiler.hasTypeCheckingRun() && operator.getColor().equals(StandardColors.BIGINT)) {
            this.compiler.report(JSError.make(operator, TRANSPILE_EXPONENT_USING_BIGINT, new String[0]));
            return false;
        }
        return true;
    }
}

