/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.TranspilationUtil;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

public final class Es6SplitVariableDeclarations
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.ARRAY_DESTRUCTURING, FeatureSet.Feature.OBJECT_DESTRUCTURING);

    public Es6SplitVariableDeclarations(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (NodeUtil.isDestructuringDeclaration(n)) {
            this.splitDeclaration(t, n, parent);
        }
    }

    public void splitDeclaration(NodeTraversal t, Node n, Node parent) {
        if (n.hasMoreThanOneChild() && !NodeUtil.isStatementBlock(parent)) {
            if (parent.isVanillaFor()) {
                return;
            }
            t.report(n, TranspilationUtil.CANNOT_CONVERT_YET, "declaration with multiple destructuring children not in statement block");
            return;
        }
        while (n.getFirstChild() != n.getLastChild()) {
            Node child = n.getLastChild().detach();
            Node newVar = IR.declaration(child, n.getToken()).srcref(n);
            newVar.insertAfter(n);
            t.reportCodeChange();
        }
    }
}

