/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ExpressionDecomposer;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.TranspilationUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.deps.ModuleNames;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Deque;

public final class Es6ExtractClasses
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final String CLASS_DECL_VAR = "$classdecl$var";
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private final ExpressionDecomposer expressionDecomposer;
    private int classDeclVarCounter = 0;
    private static final FeatureSet features = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.CLASSES);

    Es6ExtractClasses(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.expressionDecomposer = compiler.createDefaultExpressionDecomposer();
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, features, this, new SelfReferenceRewriter());
        TranspilationPasses.processTranspile(this.compiler, root, features, this, new SelfReferenceRewriter());
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isClass() && this.shouldExtractClass(n)) {
            this.extractClass(t, n);
        }
    }

    private boolean shouldExtractClass(Node classNode) {
        Node parent = classNode.getParent();
        boolean isAnonymous = classNode.getFirstChild().isEmpty();
        if (NodeUtil.isClassDeclaration(classNode) || isAnonymous && parent.isName() || isAnonymous && parent.isAssign() && parent.getFirstChild().isQualifiedName() && parent.getParent().isExprResult()) {
            return false;
        }
        if (this.expressionDecomposer.canExposeExpression(classNode) == ExpressionDecomposer.DecompositionType.UNDECOMPOSABLE) {
            this.compiler.report(JSError.make(classNode, TranspilationUtil.CANNOT_CONVERT, "class expression that cannot be extracted"));
            return false;
        }
        return true;
    }

    private void extractClass(NodeTraversal t, Node classNode) {
        Node expr;
        if (this.expressionDecomposer.canExposeExpression(classNode) == ExpressionDecomposer.DecompositionType.DECOMPOSABLE) {
            this.expressionDecomposer.maybeExposeExpression(classNode);
        }
        Node parent = classNode.getParent();
        String name = ModuleNames.fileToJsIdentifier(classNode.getStaticSourceFile().getName()) + CLASS_DECL_VAR + this.classDeclVarCounter++;
        JSDocInfo info = NodeUtil.getBestJSDocInfo(classNode);
        Node statement = NodeUtil.getEnclosingStatement(parent);
        Node classNameLhs = this.astFactory.createName(name, AstFactory.type(classNode));
        Node classNameRhs = classNameLhs.cloneTree();
        classNode.replaceWith(classNameRhs);
        Node classDeclaration = IR.constNode(classNameLhs, classNode).srcrefTreeIfMissing(classNode);
        NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.CONST_DECLARATIONS, this.compiler);
        classDeclaration.setJSDocInfo(JSDocInfo.Builder.maybeCopyFrom(info).build());
        classDeclaration.insertBefore(statement);
        if (NodeUtil.isNameDeclaration(statement) && statement.hasOneChild() && statement.getOnlyChild() == parent) {
            this.addAtConstructor(statement);
        } else if (statement.isExprResult() && (expr = statement.getOnlyChild()).isAssign() && expr.getFirstChild().isQualifiedName() && expr.getSecondChild() == classNameRhs) {
            this.addAtConstructor(expr);
        }
        this.compiler.reportChangeToEnclosingScope(classDeclaration);
    }

    private void addAtConstructor(Node node) {
        JSDocInfo.Builder builder = JSDocInfo.Builder.maybeCopyFrom(node.getJSDocInfo());
        builder.recordConstructor();
        node.setJSDocInfo(builder.build());
    }

    private class SelfReferenceRewriter
    implements NodeTraversal.Callback {
        private final Deque<ClassDescription> classStack = new ArrayDeque<ClassDescription>();

        private SelfReferenceRewriter() {
        }

        private boolean needsInnerNameRewriting(Node classNode, Node parent) {
            Preconditions.checkArgument((boolean)classNode.isClass());
            return classNode.getFirstChild().isName() && parent.isName();
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (n.isClass() && this.needsInnerNameRewriting(n, parent)) {
                this.classStack.addFirst(new ClassDescription(n.getFirstChild(), parent.getString()));
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case CLASS: {
                    if (!this.needsInnerNameRewriting(n, parent)) break;
                    this.classStack.removeFirst();
                    n.getFirstChild().replaceWith(IR.empty().srcref(n.getFirstChild()));
                    Es6ExtractClasses.this.compiler.reportChangeToEnclosingScope(n);
                    break;
                }
                case NAME: {
                    this.maybeUpdateClassSelfRef(t, n);
                    break;
                }
            }
        }

        private void maybeUpdateClassSelfRef(NodeTraversal t, Node nameNode) {
            for (ClassDescription klass : this.classStack) {
                Var var;
                if (nameNode == klass.nameNode || !nameNode.matchesQualifiedName(klass.nameNode) || (var = (Var)t.getScope().getVar(nameNode.getString())) == null || var.getNameNode() != klass.nameNode) continue;
                Node newNameNode = Es6ExtractClasses.this.astFactory.createName(klass.outerName, AstFactory.type(nameNode)).srcref(nameNode);
                nameNode.replaceWith(newNameNode);
                Es6ExtractClasses.this.compiler.reportChangeToEnclosingScope(newNameNode);
                return;
            }
        }

        private class ClassDescription {
            final Node nameNode;
            final String outerName;

            ClassDescription(Node nameNode, String outerName) {
                this.nameNode = nameNode;
                this.outerName = outerName;
            }
        }
    }
}

