/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SynthesizeExplicitConstructors;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.TranspilationUtil;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;

public final class Es6ConvertSuper
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private final SynthesizeExplicitConstructors constructorSynthesizer;
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.SUPER);

    public Es6ConvertSuper(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.constructorSynthesizer = new SynthesizeExplicitConstructors(compiler);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isClass()) {
            this.constructorSynthesizer.synthesizeClassConstructorIfMissing(t, n);
        } else if (n.isSuper()) {
            this.visitSuper(n, parent);
        }
    }

    private boolean isInterface(Node classNode) {
        JSDocInfo classJsDocInfo = NodeUtil.getBestJSDocInfo(classNode);
        return classJsDocInfo != null && classJsDocInfo.isInterface();
    }

    private void visitSuper(Node node, Node parent) {
        Preconditions.checkState((boolean)node.isSuper());
        Node exprRoot = node;
        if (exprRoot.getParent().isGetElem() || exprRoot.getParent().isGetProp()) {
            exprRoot = exprRoot.getParent();
        }
        Node enclosingMemberDef = NodeUtil.getEnclosingNode(exprRoot, (Predicate<Node>)((Predicate)n -> {
            switch (n.getToken()) {
                case MEMBER_FUNCTION_DEF: 
                case GETTER_DEF: 
                case SETTER_DEF: 
                case COMPUTED_PROP: {
                    return true;
                }
            }
            return false;
        }));
        if (parent.isCall()) {
            this.visitSuperCall(node, parent, enclosingMemberDef);
        } else if (parent.isGetProp() || parent.isGetElem()) {
            if (parent.getFirstChild() == node) {
                if (parent.getParent().isCall() && NodeUtil.isInvocationTarget(parent)) {
                    this.visitSuperPropertyCall(node, parent, enclosingMemberDef);
                } else {
                    this.visitSuperPropertyAccess(node, parent, enclosingMemberDef);
                }
            } else {
                this.compiler.report(JSError.make(node, TranspilationUtil.CANNOT_CONVERT_YET, "Only calls to super or to a method of super are supported."));
            }
        } else {
            if (parent.isNew()) {
                throw new IllegalStateException("This should never happen. Did Es6SuperCheck fail to run?");
            }
            this.compiler.report(JSError.make(node, TranspilationUtil.CANNOT_CONVERT_YET, "Only calls to super or to a method of super are supported."));
        }
    }

    private void visitSuperCall(Node node, Node parent, Node enclosingMemberDef) {
        Preconditions.checkState((boolean)parent.isCall(), (Object)parent);
        Preconditions.checkState((boolean)node.isSuper(), (Object)node);
        Node clazz = NodeUtil.getEnclosingClass(node);
        Node superName = clazz.getSecondChild();
        if (!superName.isQualifiedName()) {
            return;
        }
        if (NodeUtil.isEs6ConstructorMemberFunctionDef(enclosingMemberDef)) {
            if (node.isFromExterns() || this.isInterface(clazz)) {
                Node enclosingStatement = NodeUtil.getEnclosingStatement(node);
                Node enclosingStatementParent = enclosingStatement.getParent();
                enclosingStatement.detach();
                this.compiler.reportChangeToEnclosingScope(enclosingStatementParent);
            }
            return;
        }
        throw new IllegalStateException("This should never happen. Did Es6SuperCheck fail to run?");
    }

    private void visitSuperPropertyCall(Node node, Node parent, Node enclosingMemberDef) {
        Preconditions.checkState((parent.isGetProp() || parent.isGetElem() ? 1 : 0) != 0, (Object)parent);
        Preconditions.checkState((boolean)node.isSuper(), (Object)node);
        Node grandparent = parent.getParent();
        Preconditions.checkState((boolean)grandparent.isCall());
        Node clazz = NodeUtil.getEnclosingClass(node);
        Node superName = clazz.getSecondChild();
        if (!superName.isQualifiedName()) {
            return;
        }
        Node callTarget = parent;
        if (enclosingMemberDef.isStaticMember()) {
            Node expandedSuper = superName.cloneTree().srcrefTree(node);
            expandedSuper.setOriginalName("super");
            node.replaceWith(expandedSuper);
            callTarget = this.astFactory.createGetPropWithUnknownType(callTarget.detach(), "call");
            grandparent.addChildToFront(callTarget);
            Node thisNode = this.astFactory.createThis(AstFactory.type(clazz));
            thisNode.makeNonIndexable();
            thisNode.insertAfter(callTarget);
            grandparent.srcrefTreeIfMissing(parent);
        } else {
            Node expandedSuper = this.astFactory.createPrototypeAccess(superName.cloneTree()).srcrefTree(node);
            expandedSuper.setOriginalName("super");
            node.replaceWith(expandedSuper);
            callTarget = this.astFactory.createGetPropWithUnknownType(callTarget.detach(), "call");
            grandparent.addChildToFront(callTarget);
            Node thisNode = this.astFactory.createThisForEs6Class(clazz);
            thisNode.makeNonIndexable();
            thisNode.insertAfter(callTarget);
            grandparent.putBooleanProp(Node.FREE_CALL, false);
            grandparent.srcrefTreeIfMissing(parent);
        }
        this.compiler.reportChangeToEnclosingScope(grandparent);
    }

    private void visitSuperPropertyAccess(Node node, Node parent, Node enclosingMemberDef) {
        Preconditions.checkState((parent.isGetProp() || parent.isGetElem() ? 1 : 0) != 0, (Object)parent);
        Preconditions.checkState((boolean)node.isSuper(), (Object)node);
        Node grandparent = parent.getParent();
        if (NodeUtil.isLValue(parent)) {
            this.compiler.report(JSError.make(parent, TranspilationUtil.CANNOT_CONVERT_YET, "assigning to a super property"));
            return;
        }
        Node clazz = NodeUtil.getEnclosingClass(node);
        Node superName = clazz.getSecondChild();
        if (!superName.isQualifiedName()) {
            return;
        }
        if (enclosingMemberDef.isStaticMember()) {
            Node expandedSuper = superName.cloneTree().srcrefTree(node);
            expandedSuper.setOriginalName("super");
            node.replaceWith(expandedSuper);
        } else {
            Node newprop = this.astFactory.createPrototypeAccess(superName.cloneTree()).srcrefTree(node);
            newprop.setOriginalName("super");
            node.replaceWith(newprop);
        }
        this.compiler.reportChangeToEnclosingScope(grandparent);
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, transpiledFeatures, this);
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
    }
}

