/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.SourceFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class DefaultExterns {
    private static final ImmutableList<String> BUILTIN_LANG_EXTERNS = ImmutableList.of((Object)"es3.js", (Object)"es5.js", (Object)"es6.js", (Object)"es6_collections.js");
    private static final ImmutableList<String> BROWSER_EXTERN_DEP_ORDER = ImmutableList.of((Object)"intl.js", (Object)"w3c_event.js", (Object)"w3c_event3.js", (Object)"gecko_event.js", (Object)"ie_event.js", (Object)"webkit_event.js", (Object)"w3c_device_sensor_event.js", (Object)"w3c_dom1.js", (Object)"w3c_dom2.js", (Object)"w3c_dom3.js", (Object)"w3c_dom4.js", (Object)"gecko_dom.js", (Object[])new String[]{"ie_dom.js", "webkit_dom.js", "w3c_css.js", "gecko_css.js", "ie_css.js", "webkit_css.js", "w3c_touch_event.js", "webstorage.js", "whatwg_console.js", "nonstandard_console.js", "w3c_rtc.js"});

    private DefaultExterns() {
    }

    public static List<SourceFile> prepareExterns(CompilerOptions.Environment env, Map<String, SourceFile> externs) {
        ArrayList<SourceFile> out = new ArrayList<SourceFile>();
        for (String key : BUILTIN_LANG_EXTERNS) {
            Preconditions.checkState((boolean)externs.containsKey(key), (String)"Externs must contain builtin: %s", (Object)key);
            out.add(externs.remove(key));
        }
        if (env == CompilerOptions.Environment.BROWSER) {
            for (String key : BROWSER_EXTERN_DEP_ORDER) {
                Preconditions.checkState((boolean)externs.containsKey(key), (String)"Externs must contain builtin for env %s: %s", (Object)((Object)env), (Object)key);
                out.add(externs.remove(key));
            }
            out.addAll(externs.values());
        }
        return out;
    }
}

