/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jspecify.nullness.Nullable;

public class DeadPropertyAssignmentElimination
implements CompilerPass {
    private final AbstractCompiler compiler;

    DeadPropertyAssignmentElimination(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        if (this.compiler.getExternProperties() == null || this.compiler.getAccessorSummary() == null) {
            return;
        }
        Sets.SetView skiplistedPropNames = Sets.union((Set)this.compiler.getAccessorSummary().getAccessors().keySet(), this.compiler.getExternProperties());
        NodeTraversal.traverse(this.compiler, this.compiler.getJsRoot(), new FunctionVisitor((Set<String>)skiplistedPropNames));
    }

    private static class FindCandidateAssignmentTraversal
    implements NodeTraversal.Callback {
        final Map<String, Property> propertyMap = new HashMap<String, Property>();
        private final Set<String> skiplistedPropNames;

        FindCandidateAssignmentTraversal(Set<String> skiplistedPropNames) {
            this.skiplistedPropNames = skiplistedPropNames;
        }

        private @Nullable Property getOrCreateProperty(Node propNode) {
            Property parentProperty;
            if (!propNode.isQualifiedName()) {
                return null;
            }
            String propName = propNode.isGetProp() ? propNode.getString() : propNode.getQualifiedName();
            Property property = this.propertyMap.computeIfAbsent(propName, Property::new);
            if (propNode.isGetProp() && (parentProperty = this.getOrCreateProperty(propNode.getFirstChild())) != null) {
                parentProperty.children.add(property);
            }
            return property;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return this.visitNode(n, parent);
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (NodeUtil.isAssignmentOp(n)) {
                this.visitAssignmentLhs(n.getFirstChild());
            }
            if (NodeUtil.isInvocation(n) || n.isYield() || n.isAwait()) {
                this.markAllPropsRead();
            }
            if (n.isBlock()) {
                this.visitBlock(n);
            }
        }

        private void visitBlock(Node blockNode) {
            Preconditions.checkArgument((boolean)blockNode.isBlock());
            if (blockNode.hasChildren()) {
                this.markAllPropsRead();
            }
        }

        private static boolean isConditionalExpression(Node n) {
            switch (n.getToken()) {
                case AND: 
                case OR: 
                case HOOK: 
                case COALESCE: 
                case OPTCHAIN_CALL: 
                case OPTCHAIN_GETELEM: 
                case OPTCHAIN_GETPROP: {
                    return true;
                }
            }
            return false;
        }

        private void visitAssignmentLhs(Node lhs) {
            Property childProperty;
            Property property = this.getOrCreateProperty(lhs);
            if (property == null) {
                return;
            }
            if (!lhs.isGetProp()) {
                property.markLastWriteRead();
                property.markChildrenRead();
                return;
            }
            Node assignNode = lhs.getParent();
            if (!assignNode.isAssign()) {
                property.markLastWriteRead();
            }
            property.markChildrenRead();
            property.addWrite(lhs);
            for (Node child = lhs.getFirstChild(); child != null && (childProperty = this.getOrCreateProperty(child)) != null; child = child.getFirstChild()) {
                childProperty.markLastWriteRead();
            }
        }

        private boolean visitNode(Node n, Node parent) {
            switch (n.getToken()) {
                case GETPROP: {
                    if (n.isGetProp() && this.skiplistedPropNames.contains(n.getString())) {
                        this.markAllPropsRead();
                        return true;
                    }
                    if (NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == n) {
                        return true;
                    }
                    Property property = this.getOrCreateProperty(n);
                    if (property != null) {
                        property.markLastWriteRead();
                        if (!parent.isGetProp()) {
                            property.markChildrenRead();
                        }
                    }
                    return true;
                }
                case THIS: 
                case NAME: {
                    Property nameProp = (Property)Preconditions.checkNotNull((Object)this.getOrCreateProperty(n));
                    nameProp.markLastWriteRead();
                    if (!parent.isGetProp()) {
                        nameProp.markChildrenRead();
                    }
                    return true;
                }
                case THROW: 
                case FOR: 
                case FOR_IN: 
                case SWITCH: {
                    this.markAllPropsRead();
                    return false;
                }
                case BLOCK: {
                    this.visitBlock(n);
                    return true;
                }
            }
            if (FindCandidateAssignmentTraversal.isConditionalExpression(n)) {
                this.markAllPropsRead();
                return false;
            }
            return true;
        }

        private void markAllPropsRead() {
            for (Property property : this.propertyMap.values()) {
                if (property.writes.isEmpty()) continue;
                property.markLastWriteRead();
            }
        }
    }

    private static class PropertyWrite {
        private final Node assignedAt;
        private boolean isRead = false;
        private final String qualifiedName;

        PropertyWrite(Node assignedAt) {
            Preconditions.checkArgument((boolean)assignedAt.isQualifiedName());
            this.assignedAt = assignedAt;
            this.qualifiedName = assignedAt.getQualifiedName();
        }

        boolean isSafeToRemove(@Nullable PropertyWrite nextWrite) {
            return !this.isRead && nextWrite != null && Objects.equals(this.qualifiedName, nextWrite.qualifiedName);
        }

        void markRead() {
            this.isRead = true;
        }
    }

    private static class Property {
        private final String name;
        private final Deque<PropertyWrite> writes = new ArrayDeque<PropertyWrite>();
        private final Set<Property> children = new HashSet<Property>();

        Property(String name) {
            this.name = name;
        }

        void markLastWriteRead() {
            if (!this.writes.isEmpty()) {
                this.writes.getLast().markRead();
            }
        }

        void markChildrenRead() {
            HashSet<Property> propertiesSet = new HashSet<Property>(this.children);
            ArrayDeque<Property> propertyQueue = new ArrayDeque<Property>(propertiesSet);
            propertiesSet.add(this);
            while (!propertyQueue.isEmpty()) {
                Property childProperty = (Property)propertyQueue.remove();
                childProperty.markLastWriteRead();
                for (Property grandchildProperty : childProperty.children) {
                    if (!propertiesSet.add(grandchildProperty)) continue;
                    propertyQueue.add(grandchildProperty);
                }
            }
        }

        void addWrite(Node lhs) {
            Preconditions.checkArgument((boolean)lhs.isQualifiedName());
            this.writes.addLast(new PropertyWrite(lhs));
        }

        public String toString() {
            return "Property " + this.name;
        }
    }

    private static class FunctionVisitor
    extends NodeTraversal.AbstractChangedScopeCallback {
        private final Set<String> skiplistedPropNames;

        FunctionVisitor(Set<String> skiplistedPropNames) {
            this.skiplistedPropNames = skiplistedPropNames;
        }

        @Override
        public void enterChangedScopeRoot(AbstractCompiler compiler, Node root) {
            if (!root.isFunction()) {
                return;
            }
            Node body = NodeUtil.getFunctionBody(root);
            if (!body.hasChildren() || NodeUtil.has(body, (Predicate<Node>)((Predicate)Node::isFunction), (Predicate<Node>)Predicates.alwaysTrue())) {
                return;
            }
            FindCandidateAssignmentTraversal traversal = new FindCandidateAssignmentTraversal(this.skiplistedPropNames);
            NodeTraversal.traverse(compiler, body, traversal);
            for (Property property : traversal.propertyMap.values()) {
                if (property.writes.size() <= 1) continue;
                PeekingIterator iter = Iterators.peekingIterator(property.writes.iterator());
                while (iter.hasNext()) {
                    PropertyWrite propertyWrite = (PropertyWrite)iter.next();
                    if (!iter.hasNext() || !propertyWrite.isSafeToRemove((PropertyWrite)iter.peek())) continue;
                    Node lhs = propertyWrite.assignedAt;
                    Node rhs = lhs.getNext();
                    Node assignNode = lhs.getParent();
                    if (assignNode.isAssign()) {
                        rhs.detach();
                        assignNode.replaceWith(rhs);
                        compiler.reportChangeToEnclosingScope(rhs);
                        continue;
                    }
                    Preconditions.checkState((boolean)NodeUtil.isAssignmentOp(assignNode));
                    Token opType = NodeUtil.getOpFromAssignmentOp(assignNode);
                    assignNode.setToken(opType);
                    compiler.reportChangeToEnclosingScope(assignNode);
                }
            }
        }
    }
}

