/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.base.format.SimpleFormat;
import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.LatticeElement;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import org.jspecify.nullness.Nullable;

abstract class DataFlowAnalysis<N, L extends LatticeElement> {
    private final ControlFlowGraph<N> cfg;
    private final UniqueQueue<DiGraph.DiGraphNode<N, ControlFlowGraph.Branch>> workQueue;
    public static final int MAX_STEPS_PER_NODE = 20000;

    DataFlowAnalysis(ControlFlowGraph<N> cfg) {
        this.cfg = cfg;
        this.workQueue = new UniqueQueue<DiGraph.DiGraphNode<N, ControlFlowGraph.Branch>>(cfg.getOptionalNodeComparator(this.isForward()));
        if (this.isBranched()) {
            Preconditions.checkState((boolean)this.isForward());
        }
    }

    final ControlFlowGraph<N> getCfg() {
        return this.cfg;
    }

    abstract boolean isForward();

    boolean isBranched() {
        return false;
    }

    final L join(L latticeA, L latticeB) {
        FlowJoiner<L> joiner = this.createFlowJoiner();
        joiner.joinFlow(latticeA);
        joiner.joinFlow(latticeB);
        return (L)((LatticeElement)joiner.finish());
    }

    abstract FlowJoiner<L> createFlowJoiner();

    FlowBrancher<L> createFlowBrancher(N node, L output) {
        throw new UnsupportedOperationException();
    }

    abstract L flowThrough(N var1, L var2);

    final void analyze() {
        this.initialize();
        while (!this.workQueue.isEmpty()) {
            DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> curNode = this.workQueue.removeFirst();
            LinearFlowState curState = (LinearFlowState)curNode.getAnnotation();
            if (curState.stepCount++ > 20000) {
                throw new IllegalStateException("Dataflow analysis appears to diverge around: " + curNode);
            }
            this.joinInputs(curNode);
            if (!this.flow(curNode)) continue;
            List<LinkedDirectedGraph.LinkedDiGraphNode<N, ControlFlowGraph.Branch>> nextNodes = this.isForward() ? this.cfg.getDirectedSuccNodes(curNode) : this.cfg.getDirectedPredNodes(curNode);
            for (DiGraph.DiGraphNode diGraphNode : nextNodes) {
                if (diGraphNode == this.cfg.getImplicitReturn()) continue;
                this.workQueue.add(diGraphNode);
            }
        }
        if (this.isForward()) {
            this.joinInputs(this.getCfg().getImplicitReturn());
        }
    }

    abstract L createInitialEstimateLattice();

    abstract L createEntryLattice();

    private void initialize() {
        this.workQueue.clear();
        for (DiGraph.DiGraphNode diGraphNode : this.cfg.getNodes()) {
            diGraphNode.setAnnotation(new LinearFlowState<L>(this.createInitialEstimateLattice(), this.createInitialEstimateLattice()));
            if (diGraphNode == this.cfg.getImplicitReturn()) continue;
            this.workQueue.add(diGraphNode);
        }
        if (this.isBranched()) {
            for (DiGraph.DiGraphEdge diGraphEdge : this.cfg.getEdges()) {
                diGraphEdge.setAnnotation((Annotation)this.createInitialEstimateLattice());
            }
        }
    }

    private boolean flow(DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> node) {
        LinearFlowState state = (LinearFlowState)node.getAnnotation();
        if (this.isForward()) {
            boolean changed;
            LatticeElement outBefore = (LatticeElement)state.getOut();
            state.setOut(this.flowThrough(node.getValue(), (LatticeElement)state.getIn()));
            boolean bl = changed = !outBefore.equals(state.getOut());
            if (this.isBranched()) {
                FlowBrancher<LatticeElement> brancher = this.createFlowBrancher(node.getValue(), (LatticeElement)state.getOut());
                for (DiGraph.DiGraphEdge<N, ControlFlowGraph.Branch> outEdge : node.getOutEdges()) {
                    LatticeElement outBranchBefore = (LatticeElement)outEdge.getAnnotation();
                    outEdge.setAnnotation(brancher.branchFlow((ControlFlowGraph.Branch)((Object)outEdge.getValue())));
                    if (changed) continue;
                    changed = !outBranchBefore.equals(outEdge.getAnnotation());
                }
            }
            return changed;
        }
        LatticeElement inBefore = (LatticeElement)state.getIn();
        state.setIn(this.flowThrough(node.getValue(), (LatticeElement)state.getOut()));
        return !inBefore.equals(state.getIn());
    }

    private void joinInputs(DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> node) {
        Object result;
        LinearFlowState state = (LinearFlowState)node.getAnnotation();
        if (this.isForward() && this.cfg.getEntry() == node) {
            state.setIn(this.createEntryLattice());
            return;
        }
        List<DiGraph.DiGraphEdge<N, ControlFlowGraph.Branch>> inEdges = this.isForward() ? node.getInEdges() : node.getOutEdges();
        switch (inEdges.size()) {
            case 0: {
                return;
            }
            case 1: {
                result = this.getInputFromEdge(inEdges.get(0));
                break;
            }
            default: {
                FlowJoiner<L> joiner = this.createFlowJoiner();
                for (DiGraph.DiGraphEdge<N, ControlFlowGraph.Branch> inEdge : inEdges) {
                    joiner.joinFlow(this.getInputFromEdge(inEdge));
                }
                result = (LatticeElement)joiner.finish();
            }
        }
        if (this.isForward()) {
            state.setIn(result);
        } else {
            state.setOut(result);
        }
    }

    private L getInputFromEdge(DiGraph.DiGraphEdge<N, ControlFlowGraph.Branch> edge) {
        if (this.isBranched()) {
            return (L)((LatticeElement)edge.getAnnotation());
        }
        if (this.isForward()) {
            LinearFlowState state = (LinearFlowState)edge.getSource().getAnnotation();
            return (L)((LatticeElement)state.getOut());
        }
        DiGraph.DiGraphNode<N, ControlFlowGraph.Branch> node = edge.getDestination();
        if (node == this.cfg.getImplicitReturn()) {
            return this.createEntryLattice();
        }
        LinearFlowState state = (LinearFlowState)node.getAnnotation();
        return (L)((LatticeElement)state.getIn());
    }

    static void computeEscaped(final Scope jsScope, final Set<Var> escaped, AbstractCompiler compiler, ScopeCreator scopeCreator, Map<String, Var> allVarsInFn) {
        Preconditions.checkArgument((boolean)jsScope.isFunctionScope());
        NodeTraversal.AbstractPostOrderCallback finder = new NodeTraversal.AbstractPostOrderCallback(){

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (!n.isName() || parent.isFunction()) {
                    return;
                }
                String name = n.getString();
                Var var = (Var)t.getScope().getVar(name);
                if (var == null) {
                    return;
                }
                Scope variableCfgScope = (Scope)((Scope)var.getScope()).getClosestCfgRootScope();
                if (variableCfgScope != jsScope) {
                    return;
                }
                Scope referenceCfgScope = (Scope)t.getScope().getClosestCfgRootScope();
                if (referenceCfgScope != variableCfgScope) {
                    escaped.add(var);
                }
            }
        };
        NodeTraversal.builder().setCompiler(compiler).setCallback(finder).setScopeCreator(scopeCreator).traverseAtScope(jsScope);
        for (Var var : allVarsInFn.values()) {
            if (!var.getParentNode().isCatch() && !compiler.getCodingConvention().isExported(var.getName())) continue;
            escaped.add(var);
        }
    }

    private static final class UniqueQueue<T> {
        private final HashSet<T> seenSet = new HashSet();
        private final Queue<T> queue;

        UniqueQueue(@Nullable Comparator<T> priority) {
            this.queue = priority == null ? new ArrayDeque() : new PriorityQueue<T>(priority);
        }

        boolean isEmpty() {
            return this.queue.isEmpty();
        }

        T removeFirst() {
            T t = this.queue.poll();
            this.seenSet.remove(t);
            return t;
        }

        void add(T t) {
            if (this.seenSet.add(t)) {
                this.queue.add(t);
            }
        }

        void clear() {
            this.seenSet.clear();
            this.queue.clear();
        }
    }

    static final class LinearFlowState<L>
    implements Annotation {
        private int stepCount = 0;
        private L in;
        private L out;

        private LinearFlowState(L in, L out) {
            Preconditions.checkNotNull(in);
            Preconditions.checkNotNull(out);
            this.in = in;
            this.out = out;
        }

        int getStepCount() {
            return this.stepCount;
        }

        final L getIn() {
            return this.in;
        }

        private final void setIn(L in) {
            Preconditions.checkNotNull(in);
            this.in = in;
        }

        final L getOut() {
            return this.out;
        }

        private final void setOut(L out) {
            Preconditions.checkNotNull(out);
            this.out = out;
        }

        public final String toString() {
            return SimpleFormat.format("IN: %s OUT: %s", this.in, this.out);
        }
    }

    @FunctionalInterface
    static interface FlowBrancher<L> {
        public L branchFlow(ControlFlowGraph.Branch var1);
    }

    static interface FlowJoiner<L> {
        public void joinFlow(L var1);

        public L finish();
    }
}

