/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.GatherGetterAndSetterProperties;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

class ConvertToDottedProperties
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;

    ConvertToDottedProperties(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
        GatherGetterAndSetterProperties.update(this.compiler, externs, root);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case COMPUTED_PROP: 
            case COMPUTED_FIELD_DEF: {
                Node temp;
                Node leftElem = n.getFirstChild();
                Node rightElem = leftElem.getNext();
                if (!leftElem.isStringLit() || !NodeUtil.isValidPropertyName(FeatureSet.ES3, leftElem.getString()) || leftElem.getString().equals("constructor")) break;
                leftElem.detach();
                rightElem.detach();
                if (n.isComputedProp()) {
                    if (rightElem.isFunction()) {
                        if (n.getBooleanProp(Node.COMPUTED_PROP_GETTER)) {
                            temp = IR.getterDef(leftElem.getString(), rightElem);
                        } else if (n.getBooleanProp(Node.COMPUTED_PROP_SETTER)) {
                            temp = IR.setterDef(leftElem.getString(), rightElem);
                        } else if (n.getParent().isClassMembers()) {
                            temp = IR.memberFunctionDef(leftElem.getString(), rightElem);
                            NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.MEMBER_DECLARATIONS, this.compiler);
                        } else {
                            temp = IR.stringKey(leftElem.getString(), rightElem);
                        }
                    } else {
                        temp = IR.stringKey(leftElem.getString(), rightElem);
                    }
                } else {
                    temp = IR.memberFieldDef(leftElem.getString(), rightElem);
                }
                temp.setStaticMember(n.isStaticMember());
                n.replaceWith(temp);
                this.compiler.reportChangeToEnclosingScope(temp);
                break;
            }
            case GETTER_DEF: 
            case SETTER_DEF: 
            case STRING_KEY: {
                if (!NodeUtil.isValidPropertyName(FeatureSet.ES3, n.getString()) || !n.getBooleanProp(Node.QUOTED_PROP)) break;
                n.putBooleanProp(Node.QUOTED_PROP, false);
                this.compiler.reportChangeToEnclosingScope(n);
                break;
            }
            case OPTCHAIN_GETELEM: 
            case GETELEM: {
                Node left = n.getFirstChild();
                Node right = left.getNext();
                if (!right.isStringLit() || !NodeUtil.isValidPropertyName(FeatureSet.ES3, right.getString())) break;
                left.detach();
                right.detach();
                Node newGetProp = n.isGetElem() ? IR.getprop(left, right.getString()) : (n.isOptionalChainStart() ? IR.startOptChainGetprop(left, right.getString()) : IR.continueOptChainGetprop(left, right.getString()));
                n.replaceWith(newGetProp);
                this.compiler.reportChangeToEnclosingScope(newGetProp);
                break;
            }
        }
    }
}

