/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ClosurePrimitiveErrors;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.QualifiedName;
import com.google.javascript.rhino.Token;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jspecify.nullness.Nullable;

public final class ClosureCheckModule
extends NodeTraversal.AbstractModuleCallback
implements CompilerPass {
    static final DiagnosticType AT_EXPORT_IN_GOOG_MODULE = DiagnosticType.error("JSC_AT_EXPORT_IN_GOOG_MODULE", "@export has no effect on top-level names in a goog.module. Consider using goog.exportSymbol instead.");
    static final DiagnosticType AT_EXPORT_IN_NON_LEGACY_GOOG_MODULE = DiagnosticType.error("JSC_AT_EXPORT_IN_NON_LEGACY_GOOG_MODULE", "@export is not allowed here in a non-legacy goog.module. Consider using goog.exportSymbol instead.");
    static final DiagnosticType GOOG_MODULE_IN_NON_MODULE = DiagnosticType.error("JSC_GOOG_MODULE_IN_NON_MODULE", "goog.module() call must be the first statement in a module.");
    static final DiagnosticType GOOG_MODULE_MISPLACED = DiagnosticType.error("JSC_GOOG_MODULE_MISPLACED", "goog.module() call must be the first statement in a file.");
    static final DiagnosticType DECLARE_LEGACY_NAMESPACE_IN_NON_MODULE = DiagnosticType.error("JSC_DECLARE_LEGACY_NAMESPACE_IN_NON_MODULE", "goog.module.declareLegacyNamespace may only be called in a goog.module.");
    static final DiagnosticType GOOG_MODULE_REFERENCES_THIS = DiagnosticType.error("JSC_GOOG_MODULE_REFERENCES_THIS", "The body of a goog.module cannot reference 'this'.");
    static final DiagnosticType GOOG_MODULE_USES_THROW = DiagnosticType.error("JSC_GOOG_MODULE_USES_THROW", "The body of a goog.module cannot use 'throw'.");
    static final DiagnosticType DUPLICATE_NAME_SHORT_REQUIRE = DiagnosticType.error("JSC_DUPLICATE_NAME_SHORT_REQUIRE", "Found multiple goog.require statements importing identifier ''{0}''.");
    static final DiagnosticType INVALID_DESTRUCTURING_REQUIRE = DiagnosticType.error("JSC_INVALID_DESTRUCTURING_REQUIRE", "Destructuring goog.require must be a simple object pattern.");
    static final DiagnosticType AWAIT_GOOG_REQUIRE_CALLS = DiagnosticType.error("JSC_AWAIT_GOOG_REQUIRE_CALLS", "goog.require(Type) and goog.forwardDeclare can not be in an 'await' expression.");
    static final DiagnosticType GOOG_REQUIRE_DYNAMIC_MISSING_AWAIT = DiagnosticType.error("JSC_GOOG_REQUIRE_DYNAMIC_MISSING_AWAIT", "goog.requireDynamic must be proceeded by 'await' in an assignment expression.");
    static final DiagnosticType LET_GOOG_REQUIRE = DiagnosticType.disabled("JSC_LET_GOOG_REQUIRE", "Module imports must be constant. Please use ''const'' instead of ''let''.");
    static final DiagnosticType MULTIPLE_MODULES_IN_FILE = DiagnosticType.error("JSC_MULTIPLE_MODULES_IN_FILE", "There should only be a single goog.module() statement per file.");
    static final DiagnosticType ONE_REQUIRE_PER_DECLARATION = DiagnosticType.error("JSC_ONE_REQUIRE_PER_DECLARATION", "There may only be one goog.require() per var/let/const declaration.");
    static final DiagnosticType INCORRECT_SHORTNAME_CAPITALIZATION = DiagnosticType.disabled("JSC_INCORRECT_SHORTNAME_CAPITALIZATION", "The capitalization of short name {0} is incorrect; it should be {1}.");
    static final DiagnosticType EXPORT_NOT_AT_MODULE_SCOPE = DiagnosticType.error("JSC_EXPORT_NOT_AT_MODULE_SCOPE", "Exports must be at the top-level of a module");
    static final DiagnosticType EXPORT_NOT_A_STATEMENT = DiagnosticType.error("JSC_EXPORT_NOT_A_STATEMENT", "Exports should be a statement.");
    static final DiagnosticType EXPORT_REPEATED_ERROR = DiagnosticType.error("JSC_EXPORT_REPEATED_ERROR", "Name cannot be exported multiple times. Previous export on line {0}.");
    static final DiagnosticType REFERENCE_TO_MODULE_GLOBAL_NAME = DiagnosticType.error("JSC_REFERENCE_TO_MODULE_GLOBAL_NAME", "References to the global name of a module are not allowed. Perhaps you meant exports?");
    static final DiagnosticType REFERENCE_TO_FULLY_QUALIFIED_IMPORT_NAME = DiagnosticType.disabled("JSC_REFERENCE_TO_FULLY_QUALIFIED_IMPORT_NAME", "Reference to fully qualified import name ''{0}''. Imports in goog.module should use the return value of goog.require / goog.forwardDeclare instead.");
    public static final DiagnosticType REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME = DiagnosticType.disabled("JSC_REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME", "Reference to fully qualified import name ''{0}''. Please use the short name ''{1}'' instead.");
    static final DiagnosticType USE_OF_GOOG_PROVIDE = DiagnosticType.disabled("JSC_USE_OF_GOOG_PROVIDE", "goog.provide is deprecated in favor of goog.module.");
    static final DiagnosticType REQUIRE_NOT_AT_TOP_LEVEL = DiagnosticType.error("JSC_REQUIRE_NOT_AT_TOP_LEVEL", "goog.require() must be called at file scope.");
    static final DiagnosticType LEGACY_NAMESPACE_NOT_AT_TOP_LEVEL = DiagnosticType.error("JSC_LEGACY_NAMESPACE_NOT_AT_TOP_LEVEL", "goog.module.declareLegacyNamespace() does not return a value");
    static final DiagnosticType LEGACY_NAMESPACE_NOT_AFTER_GOOG_MODULE = DiagnosticType.error("JSC_LEGACY_NAMESPACE_NOT_AT_TOP_LEVEL", "goog.module.declareLegacyNamespace() must be immediately after the goog.module('...'); call");
    static final DiagnosticType LEGACY_NAMESPACE_ARGUMENT = DiagnosticType.error("JSC_LEGACY_NAMESPACE_ARGUMENT", "goog.module.declareLegacyNamespace() takes no arguments");
    private static final QualifiedName GOOG_MODULE = QualifiedName.of("goog.module");
    private static final QualifiedName GOOG_PROVIDE = QualifiedName.of("goog.provide");
    private static final QualifiedName GOOG_REQUIRE = QualifiedName.of("goog.require");
    private static final QualifiedName GOOG_REQUIRE_TYPE = QualifiedName.of("goog.requireType");
    private static final QualifiedName GOOG_REQUIRE_DYNAMIC = QualifiedName.of("goog.requireDynamic");
    private static final QualifiedName GOOG_MODULE_GET = QualifiedName.of("goog.module.get");
    private static final QualifiedName GOOG_FORWARD_DECLARE = QualifiedName.of("goog.forwardDeclare");
    private static final QualifiedName GOOG_MODULE_DECLARE_LEGACY_NAMESPACE = QualifiedName.of("goog.module.declareLegacyNamespace");
    private @Nullable ModuleInfo currentModuleInfo = null;

    public ClosureCheckModule(AbstractCompiler compiler, ModuleMetadataMap moduleMetadataMap) {
        super(compiler, moduleMetadataMap);
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void enterModule(ModuleMetadataMap.ModuleMetadata currentModule, Node moduleScopeRoot) {
        if (!currentModule.isGoogModule()) {
            return;
        }
        Preconditions.checkState((this.currentModuleInfo == null ? 1 : 0) != 0);
        Preconditions.checkState((!currentModule.googNamespaces().isEmpty() ? 1 : 0) != 0);
        this.currentModuleInfo = new ModuleInfo((String)Iterables.getFirst(currentModule.googNamespaces(), (Object)""));
    }

    @Override
    public void exitModule(ModuleMetadataMap.ModuleMetadata currentModule, Node moduleScopeRoot) {
        this.currentModuleInfo = null;
    }

    @Override
    protected void visit(NodeTraversal t, Node n, @Nullable ModuleMetadataMap.ModuleMetadata currentModule, @Nullable Node moduleScopeRoot) {
        Node parent = n.getParent();
        if (this.currentModuleInfo == null) {
            if (NodeUtil.isCallTo(n, GOOG_MODULE)) {
                t.report(n, GOOG_MODULE_IN_NON_MODULE, new String[0]);
            } else if (NodeUtil.isGoogModuleDeclareLegacyNamespaceCall(n)) {
                t.report(n, DECLARE_LEGACY_NAMESPACE_IN_NON_MODULE, new String[0]);
            } else if (NodeUtil.isCallTo(n, GOOG_PROVIDE)) {
                t.report(n, USE_OF_GOOG_PROVIDE, new String[0]);
            }
            return;
        }
        JSDocInfo jsDoc = n.getJSDocInfo();
        if (jsDoc != null) {
            this.checkJSDoc(t, jsDoc);
        }
        switch (n.getToken()) {
            case CALL: {
                Node callee = n.getFirstChild();
                if (GOOG_MODULE.matches(callee)) {
                    if (!this.currentModuleInfo.name.equals(ClosureCheckModule.extractFirstArgumentName(n))) {
                        t.report(n, MULTIPLE_MODULES_IN_FILE, new String[0]);
                        break;
                    }
                    if (ClosureCheckModule.isFirstExpressionInGoogModule(parent)) break;
                    t.report(n, GOOG_MODULE_MISPLACED, new String[0]);
                    break;
                }
                if (GOOG_REQUIRE.matches(callee) || GOOG_REQUIRE_TYPE.matches(callee) || GOOG_REQUIRE_DYNAMIC.matches(callee) || GOOG_FORWARD_DECLARE.matches(callee)) {
                    this.checkRequireCall(t, n, parent);
                    break;
                }
                if (GOOG_MODULE_GET.matches(callee) && t.inModuleHoistScope()) {
                    t.report(n, ClosurePrimitiveErrors.MODULE_USES_GOOG_MODULE_GET, new String[0]);
                    break;
                }
                if (!GOOG_MODULE_DECLARE_LEGACY_NAMESPACE.matches(callee)) break;
                ClosureCheckModule.checkLegacyNamespaceCall(t, n, parent);
                break;
            }
            case ASSIGN: {
                if (!ClosureCheckModule.isExportLhs(n.getFirstChild())) break;
                this.checkModuleExport(t, n, parent);
                break;
            }
            case CLASS: 
            case FUNCTION: {
                if (!NodeUtil.isStatement(n)) break;
            }
            case VAR: 
            case LET: 
            case CONST: {
                JSDocInfo jsdoc;
                if (!t.inModuleHoistScope() || !n.isClass() && NodeUtil.getEnclosingClass(n) != null || NodeUtil.getEnclosingType(n, Token.OBJECTLIT) != null || (jsdoc = NodeUtil.getBestJSDocInfo(n)) == null || !jsdoc.isExport()) break;
                t.report(n, AT_EXPORT_IN_GOOG_MODULE, new String[0]);
                break;
            }
            case THIS: {
                if (!t.inModuleHoistScope()) break;
                t.report(n, GOOG_MODULE_REFERENCES_THIS, new String[0]);
                break;
            }
            case THROW: {
                if (!t.inModuleHoistScope()) break;
                t.report(n, GOOG_MODULE_USES_THROW, new String[0]);
                break;
            }
            case NAME: 
            case GETPROP: {
                if (n.matchesQualifiedName(this.currentModuleInfo.name)) {
                    if (!n.isGetProp()) break;
                    t.report(n, REFERENCE_TO_MODULE_GLOBAL_NAME, new String[0]);
                    break;
                }
                this.checkImproperReferenceToImport(t, n, n.getQualifiedName(), parent.isGetProp() ? parent.getString() : null);
                break;
            }
        }
    }

    private void checkJSDoc(NodeTraversal t, JSDocInfo jsDoc) {
        for (Node typeNode : jsDoc.getTypeNodes()) {
            this.checkTypeExpression(t, typeNode);
        }
    }

    private void checkTypeExpression(final NodeTraversal t, Node typeNode) {
        NodeUtil.visitPreOrder(typeNode, new NodeUtil.Visitor(){

            @Override
            public void visit(Node node) {
                if (!node.isStringLit()) {
                    return;
                }
                String qname = node.getString();
                String nextQnamePart = null;
                while (true) {
                    ClosureCheckModule.this.checkImproperReferenceToImport(t, node, qname, nextQnamePart);
                    int lastDot = qname.lastIndexOf(46);
                    if (lastDot < 0) {
                        return;
                    }
                    nextQnamePart = qname.substring(lastDot + 1);
                    qname = qname.substring(0, lastDot);
                }
            }
        });
    }

    private static boolean isLocalVar(Var v) {
        if (v == null) {
            return false;
        }
        return v.isLocal();
    }

    private void checkImproperReferenceToImport(NodeTraversal t, Node n, String qname, @Nullable String nextQnamePart) {
        if (qname == null) {
            return;
        }
        Node importLhs = this.currentModuleInfo.importsByLongRequiredName.get(qname);
        if (importLhs == null) {
            return;
        }
        if (!qname.contains(".") && ClosureCheckModule.isLocalVar((Var)t.getScope().getVar(qname))) {
            return;
        }
        if (importLhs.isName()) {
            this.compiler.report(JSError.make(n, REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME, qname, importLhs.getString()));
            return;
        }
        if (importLhs.isDestructuringLhs() && nextQnamePart != null) {
            Node objPattern = importLhs.getFirstChild();
            Preconditions.checkState((boolean)objPattern.isObjectPattern(), (Object)objPattern);
            for (Node strKey = objPattern.getFirstChild(); strKey != null; strKey = strKey.getNext()) {
                if (!strKey.hasOneChild() || !strKey.getString().equals(nextQnamePart)) continue;
                Node parent = n.getParent();
                this.compiler.report(JSError.make(parent != null && parent.isGetProp() ? parent : n, REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME, qname + "." + nextQnamePart, strKey.getFirstChild().getString()));
                return;
            }
        }
        this.compiler.report(JSError.make(n, REFERENCE_TO_FULLY_QUALIFIED_IMPORT_NAME, qname));
    }

    private static boolean isExportLhs(Node lhs) {
        if (!lhs.isQualifiedName()) {
            return false;
        }
        return lhs.matchesName("exports") || lhs.isGetProp() && lhs.getFirstChild().matchesName("exports");
    }

    private void checkModuleExport(NodeTraversal t, Node n, Node parent) {
        JSDocInfo jsDoc;
        Node defaultExportNode;
        Preconditions.checkArgument((boolean)n.isAssign());
        Node lhs = n.getFirstChild();
        Preconditions.checkState((boolean)ClosureCheckModule.isExportLhs(lhs));
        Node previousDefinition = this.currentModuleInfo.exportNodesByName.get(lhs.getQualifiedName());
        if (previousDefinition != null) {
            int previousLine = previousDefinition.getLineno();
            t.report(n, EXPORT_REPEATED_ERROR, String.valueOf(previousLine));
        }
        if ((defaultExportNode = this.currentModuleInfo.exportNodesByName.get("exports")) == null || lhs.matchesName("exports")) {
            this.currentModuleInfo.exportNodesByName.put(lhs.getQualifiedName(), lhs);
            if (!t.inModuleScope()) {
                t.report(n, EXPORT_NOT_AT_MODULE_SCOPE, new String[0]);
            } else if (!parent.isExprResult()) {
                t.report(n, EXPORT_NOT_A_STATEMENT, new String[0]);
            }
        }
        if (!NodeUtil.isPrototypeProperty(lhs) && !NodeUtil.isLegacyGoogModuleFile(NodeUtil.getEnclosingScript(n)) && (jsDoc = n.getJSDocInfo()) != null && jsDoc.isExport()) {
            t.report(n, AT_EXPORT_IN_NON_LEGACY_GOOG_MODULE, new String[0]);
        }
    }

    private static @Nullable String extractFirstArgumentName(Node callNode) {
        Node firstArg = callNode.getSecondChild();
        if (firstArg != null && firstArg.isStringLit()) {
            return firstArg.getString();
        }
        return null;
    }

    private void checkRequireCall(NodeTraversal t, Node callNode, Node parent) {
        Preconditions.checkState((boolean)callNode.isCall());
        Preconditions.checkState((boolean)callNode.getLastChild().isStringLit());
        switch (parent.getToken()) {
            case EXPR_RESULT: {
                String key = ClosureCheckModule.extractFirstArgumentName(callNode);
                this.currentModuleInfo.importsByLongRequiredName.putIfAbsent(key, parent);
                return;
            }
            case NAME: 
            case DESTRUCTURING_LHS: {
                if (GOOG_REQUIRE_DYNAMIC.matches(callNode.getFirstChild())) {
                    t.report(parent, GOOG_REQUIRE_DYNAMIC_MISSING_AWAIT, new String[0]);
                    return;
                }
                this.checkShortGoogRequireCall(t, callNode, parent.getParent());
                return;
            }
            case AWAIT: {
                if (!GOOG_REQUIRE_DYNAMIC.matches(callNode.getFirstChild())) {
                    t.report(parent, AWAIT_GOOG_REQUIRE_CALLS, new String[0]);
                    return;
                }
                Token grandParentToken = parent.getParent().getToken();
                if (grandParentToken.equals((Object)Token.DESTRUCTURING_LHS) || grandParentToken.equals((Object)Token.NAME)) {
                    this.checkShortGoogRequireCall(t, callNode, parent.getGrandparent());
                }
                return;
            }
        }
        t.report(callNode, REQUIRE_NOT_AT_TOP_LEVEL, new String[0]);
    }

    private void checkShortGoogRequireCall(NodeTraversal t, Node callNode, Node declaration) {
        if (declaration.isLet() && !GOOG_FORWARD_DECLARE.matches(callNode.getFirstChild())) {
            t.report(declaration, LET_GOOG_REQUIRE, new String[0]);
        }
        if (!declaration.hasOneChild()) {
            t.report(declaration, ONE_REQUIRE_PER_DECLARATION, new String[0]);
            return;
        }
        Node lhs = declaration.getFirstChild();
        if (lhs.isDestructuringLhs()) {
            if (!ClosureCheckModule.isValidDestructuringImport(lhs)) {
                t.report(declaration, INVALID_DESTRUCTURING_REQUIRE, new String[0]);
            }
            if (GOOG_FORWARD_DECLARE.matches(callNode.getFirstChild())) {
                t.report(lhs, ClosurePrimitiveErrors.INVALID_DESTRUCTURING_FORWARD_DECLARE, new String[0]);
            }
        } else {
            Preconditions.checkState((boolean)lhs.isName());
            ClosureCheckModule.checkShortName(t, lhs, callNode.getLastChild().getString());
        }
        this.currentModuleInfo.importsByLongRequiredName.put(ClosureCheckModule.extractFirstArgumentName(callNode), lhs);
        NodeUtil.visitLhsNodesInNode(declaration, nameNode -> {
            String name = nameNode.getString();
            if (!this.currentModuleInfo.shortImportNames.add(name)) {
                t.report((Node)nameNode, DUPLICATE_NAME_SHORT_REQUIRE, name);
            }
        });
    }

    private static void checkShortName(NodeTraversal t, Node shortNameNode, String namespace) {
        String lastSegment;
        String nextQnamePart = shortNameNode.getString();
        if (nextQnamePart.equals(lastSegment = namespace.substring(namespace.lastIndexOf(46) + 1)) || lastSegment.isEmpty()) {
            return;
        }
        if (Ascii.isUpperCase((char)nextQnamePart.charAt(0)) != Ascii.isUpperCase((char)lastSegment.charAt(0))) {
            char newStartChar = Ascii.isUpperCase((char)nextQnamePart.charAt(0)) ? Ascii.toLowerCase((char)nextQnamePart.charAt(0)) : Ascii.toUpperCase((char)nextQnamePart.charAt(0));
            String correctedName = newStartChar + nextQnamePart.substring(1);
            t.report(shortNameNode, INCORRECT_SHORTNAME_CAPITALIZATION, nextQnamePart, correctedName);
        }
    }

    private static boolean isValidDestructuringImport(Node destructuringLhs) {
        Preconditions.checkArgument((boolean)destructuringLhs.isDestructuringLhs());
        Node objectPattern = destructuringLhs.getFirstChild();
        if (!objectPattern.isObjectPattern()) {
            return false;
        }
        for (Node stringKey = objectPattern.getFirstChild(); stringKey != null; stringKey = stringKey.getNext()) {
            if (!stringKey.isStringKey()) {
                return false;
            }
            if (stringKey.getFirstChild().isName()) continue;
            return false;
        }
        return true;
    }

    private static void checkLegacyNamespaceCall(NodeTraversal t, Node callNode, Node parent) {
        Preconditions.checkArgument((boolean)callNode.isCall());
        if (callNode.getChildCount() > 1) {
            t.report(callNode, LEGACY_NAMESPACE_ARGUMENT, new String[0]);
        }
        if (!parent.isExprResult()) {
            t.report(callNode, LEGACY_NAMESPACE_NOT_AT_TOP_LEVEL, new String[0]);
            return;
        }
        Node prev = parent.getPrevious();
        if (prev == null || !NodeUtil.isGoogModuleCall(prev)) {
            t.report(callNode, LEGACY_NAMESPACE_NOT_AFTER_GOOG_MODULE, new String[0]);
        }
    }

    private static boolean isFirstExpressionInGoogModule(Node node) {
        if (!node.isExprResult() || node.getPrevious() != null) {
            return false;
        }
        Node statementBlock = node.getParent();
        return statementBlock.isModuleBody() || NodeUtil.isBundledGoogModuleScopeRoot(statementBlock);
    }

    private static class ModuleInfo {
        private final String name;
        private final Map<String, Node> importsByLongRequiredName = new HashMap<String, Node>();
        private final Set<String> shortImportNames = new HashSet<String>();
        private final Map<String, Node> exportNodesByName = new HashMap<String, Node>();

        ModuleInfo(String moduleName) {
            this.name = moduleName;
        }
    }
}

