/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.io.Serializable;

final class BasicBlock
implements Serializable {
    private final BasicBlock parent;
    private final Node root;
    private final boolean isFunction;
    private final boolean isLoop;

    BasicBlock(BasicBlock parent, Node root) {
        Token pType;
        this.parent = parent;
        this.root = root;
        this.isFunction = root.isFunction();
        this.isLoop = root.hasParent() ? (pType = root.getParent().getToken()) == Token.DO || pType == Token.WHILE || pType == Token.FOR || pType == Token.FOR_OF || pType == Token.FOR_AWAIT_OF || pType == Token.FOR_IN : false;
    }

    BasicBlock getParent() {
        return this.parent;
    }

    boolean isGlobalScopeBlock() {
        return this.getParent() == null;
    }

    boolean provablyExecutesBefore(BasicBlock thatBlock) {
        BasicBlock currentBlock;
        for (currentBlock = thatBlock; currentBlock != null && currentBlock != this; currentBlock = currentBlock.getParent()) {
        }
        if (currentBlock == this) {
            return true;
        }
        return this.isGlobalScopeBlock() && thatBlock.isGlobalScopeBlock();
    }

    boolean isFunction() {
        return this.isFunction;
    }

    boolean isLoop() {
        return this.isLoop;
    }

    Node getRoot() {
        return this.root;
    }

    public String toString() {
        return "BasicBlock @ " + this.root;
    }
}

