/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSChunk;
import com.google.javascript.jscomp.JSChunkGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.FixedPointGraphTraversal;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jspecify.nullness.Nullable;

class AnalyzePrototypeProperties
implements CompilerPass {
    private static final SymbolType PROPERTY = SymbolType.PROPERTY;
    private static final SymbolType VAR = SymbolType.VAR;
    private final AbstractCompiler compiler;
    private final boolean canModifyExterns;
    private final boolean anchorUnusedVars;
    private final boolean rootScopeUsesAreGlobal;
    private final JSChunkGraph moduleGraph;
    private final @Nullable JSChunk firstModule;
    private static final ImmutableSet<String> IMPLICITLY_USED_PROPERTIES = ImmutableSet.of((Object)"length", (Object)"toString", (Object)"valueOf");
    private final LinkedDirectedGraph<NameInfo, JSChunk> symbolGraph = LinkedDirectedGraph.createWithoutAnnotations();
    private final NameInfo globalNode = new NameInfo("[global]");
    private final NameInfo externNode = new NameInfo("[extern]");
    private final NameInfo anonymousNode = new NameInfo("[anonymous]");
    private final Map<String, NameInfo> propertyNameInfo = new LinkedHashMap<String, NameInfo>();
    private final Map<String, NameInfo> varNameInfo = new LinkedHashMap<String, NameInfo>();

    AnalyzePrototypeProperties(AbstractCompiler compiler, JSChunkGraph moduleGraph, boolean canModifyExterns, boolean anchorUnusedVars, boolean rootScopeUsesAreGlobal) {
        this.compiler = compiler;
        this.moduleGraph = moduleGraph;
        this.canModifyExterns = canModifyExterns;
        this.anchorUnusedVars = anchorUnusedVars;
        this.rootScopeUsesAreGlobal = rootScopeUsesAreGlobal;
        this.firstModule = moduleGraph.getChunkCount() > 1 ? moduleGraph.getRootChunk() : null;
        this.globalNode.markReference(null);
        this.externNode.markReference(null);
        this.symbolGraph.createNode((Object)this.globalNode);
        this.symbolGraph.createNode((Object)this.externNode);
        for (String property : IMPLICITLY_USED_PROPERTIES) {
            NameInfo nameInfo = this.getNameInfoForName(property, PROPERTY);
            if (moduleGraph == null) {
                this.symbolGraph.connect(this.externNode, null, nameInfo);
                continue;
            }
            for (JSChunk module : moduleGraph.getAllChunks()) {
                this.symbolGraph.connect(this.externNode, module, nameInfo);
            }
        }
    }

    @Override
    public void process(Node externRoot, Node root) {
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized());
        if (!this.canModifyExterns) {
            NodeTraversal.traverse(this.compiler, externRoot, new ProcessExternProperties());
        }
        NodeTraversal.traverse(this.compiler, root, new ProcessProperties());
        FixedPointGraphTraversal<NameInfo, JSChunk> t = FixedPointGraphTraversal.newTraversal(new PropagateReferences());
        t.computeFixedPoint(this.symbolGraph, (Set<NameInfo>)ImmutableSet.of((Object)this.externNode, (Object)this.globalNode));
    }

    public Collection<NameInfo> getAllNameInfo() {
        ArrayList<NameInfo> result = new ArrayList<NameInfo>(this.propertyNameInfo.values());
        result.addAll(this.varNameInfo.values());
        return result;
    }

    private NameInfo getNameInfoForName(String name, SymbolType type) {
        Map<String, NameInfo> map;
        Map<String, NameInfo> map2 = map = type == PROPERTY ? this.propertyNameInfo : this.varNameInfo;
        if (map.containsKey(name)) {
            return map.get(name);
        }
        NameInfo nameInfo = new NameInfo(name);
        map.put(name, nameInfo);
        this.symbolGraph.createNode((Object)nameInfo);
        return nameInfo;
    }

    class NameInfo {
        final String name;
        private boolean referenced = false;
        private final Deque<Symbol> declarations = new ArrayDeque<Symbol>();
        private @Nullable JSChunk deepestCommonModuleRef = null;
        private boolean readClosureVariables = false;
        private boolean referencesSuper = false;

        NameInfo(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        boolean isReferenced() {
            return this.referenced;
        }

        boolean readsClosureVariables() {
            return this.readClosureVariables;
        }

        boolean referencesSuper() {
            return this.referencesSuper;
        }

        boolean markReference(@Nullable JSChunk module) {
            boolean hasChanged = false;
            if (!this.referenced) {
                this.referenced = true;
                hasChanged = true;
            }
            JSChunk originalDeepestCommon = this.deepestCommonModuleRef;
            this.deepestCommonModuleRef = this.deepestCommonModuleRef == null ? module : AnalyzePrototypeProperties.this.moduleGraph.getDeepestCommonDependencyInclusive(this.deepestCommonModuleRef, module);
            if (originalDeepestCommon != this.deepestCommonModuleRef) {
                hasChanged = true;
            }
            return hasChanged;
        }

        JSChunk getDeepestCommonModuleRef() {
            return this.deepestCommonModuleRef;
        }

        Deque<Symbol> getDeclarations() {
            return this.declarations;
        }
    }

    private static class NameContext {
        final NameInfo name;
        final Scope scope;

        NameContext(NameInfo name, @Nullable Scope scope) {
            this.name = name;
            this.scope = scope;
        }
    }

    static class LiteralPrototypeProperty
    implements PrototypeProperty {
        private final Node value;
        private final Node assign;
        private final Var rootVar;
        private final JSChunk module;

        LiteralPrototypeProperty(Node value, Node assign, Var rootVar, JSChunk module) {
            this.value = value;
            this.assign = assign;
            this.rootVar = rootVar;
            this.module = module;
        }

        @Override
        public Var getRootVar() {
            return this.rootVar;
        }

        @Override
        public Node getPrototype() {
            return this.assign.getFirstChild();
        }

        @Override
        public Node getValue() {
            return this.value;
        }

        @Override
        public JSChunk getModule() {
            return this.module;
        }
    }

    static class AssignmentPrototypeProperty
    implements PrototypeProperty {
        private final Node exprNode;
        private final Var rootVar;
        private final JSChunk module;

        AssignmentPrototypeProperty(Node node, Var rootVar, JSChunk module) {
            this.exprNode = node;
            this.rootVar = rootVar;
            this.module = module;
        }

        @Override
        public Var getRootVar() {
            return this.rootVar;
        }

        @Override
        public Node getPrototype() {
            return this.getAssignNode().getFirstFirstChild();
        }

        @Override
        public Node getValue() {
            return this.getAssignNode().getLastChild();
        }

        private Node getAssignNode() {
            return this.exprNode.getFirstChild();
        }

        @Override
        public JSChunk getModule() {
            return this.module;
        }
    }

    static interface PrototypeProperty
    extends Property {
        public Node getPrototype();

        public Node getValue();
    }

    static class ClassMemberFunction
    implements Property {
        private final Node node;
        private final Var var;
        private final JSChunk module;

        ClassMemberFunction(Node node, Var var, JSChunk module) {
            Preconditions.checkState((boolean)node.getParent().isClassMembers());
            Preconditions.checkState((node.isMemberFunctionDef() || node.isSetterDef() || node.isGetterDef() ? 1 : 0) != 0);
            this.node = node;
            this.var = var;
            this.module = module;
        }

        @Override
        public Var getRootVar() {
            return this.var;
        }

        @Override
        public JSChunk getModule() {
            return this.module;
        }

        public Node getFunctionNode() {
            return this.node.getOnlyChild();
        }

        public Node getDefinitionNode() {
            return this.node;
        }
    }

    static interface Property
    extends Symbol {
    }

    static class GlobalFunction
    implements Symbol {
        private final Var var;
        private final JSChunk module;

        GlobalFunction(Node nameNode, Var var, JSChunk module) {
            Node parent = nameNode.getParent();
            Preconditions.checkState((NodeUtil.isNameDeclaration(parent) && var.isGlobal() || NodeUtil.isFunctionDeclaration(parent) ? 1 : 0) != 0);
            this.var = var;
            this.module = module;
        }

        @Override
        public Var getRootVar() {
            return this.var;
        }

        @Override
        public JSChunk getModule() {
            return this.module;
        }
    }

    private static enum SymbolType {
        PROPERTY,
        VAR;

    }

    static interface Symbol {
        public Var getRootVar();

        public JSChunk getModule();
    }

    private class PropagateReferences
    implements FixedPointGraphTraversal.EdgeCallback<NameInfo, JSChunk> {
        private PropagateReferences() {
        }

        @Override
        public boolean traverseEdge(NameInfo start, JSChunk edge, NameInfo dest) {
            if (start.isReferenced()) {
                JSChunk startModule = start.getDeepestCommonModuleRef();
                if (startModule != null && AnalyzePrototypeProperties.this.moduleGraph.dependsOn(startModule, edge)) {
                    return dest.markReference(startModule);
                }
                return dest.markReference(edge);
            }
            return false;
        }
    }

    private class ProcessExternProperties
    extends NodeTraversal.AbstractPostOrderCallback {
        private ProcessExternProperties() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isGetProp()) {
                AnalyzePrototypeProperties.this.symbolGraph.connect(AnalyzePrototypeProperties.this.externNode, AnalyzePrototypeProperties.this.firstModule, AnalyzePrototypeProperties.this.getNameInfoForName(n.getString(), PROPERTY));
            } else if (n.isMemberFunctionDef() || n.isGetterDef() || n.isSetterDef()) {
                AnalyzePrototypeProperties.this.symbolGraph.connect(AnalyzePrototypeProperties.this.externNode, AnalyzePrototypeProperties.this.firstModule, AnalyzePrototypeProperties.this.getNameInfoForName(n.getString(), PROPERTY));
            }
        }
    }

    private class ProcessProperties
    implements NodeTraversal.ScopedCallback {
        private final Deque<NameContext> symbolStack = new ArrayDeque<NameContext>();

        private ProcessProperties() {
        }

        @Override
        public void enterScope(NodeTraversal t) {
            Node n = t.getCurrentNode();
            Scope scope = t.getScope();
            Node root = scope.getRootNode();
            if (root.isFunction()) {
                String propName = this.getPrototypePropertyNameFromRValue(n);
                if (propName != null) {
                    this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.getNameInfoForName(propName, PROPERTY), scope));
                } else if (this.isGlobalFunctionDeclaration(t, n)) {
                    Node parent = n.getParent();
                    String name = parent.isName() ? parent.getString() : n.getFirstChild().getString();
                    this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.getNameInfoForName(name, VAR), (Scope)scope.getClosestHoistScope()));
                } else {
                    this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.anonymousNode, scope));
                }
            } else if (t.inGlobalScope()) {
                this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.globalNode, scope));
            } else {
                Preconditions.checkState((NodeUtil.createsBlockScope(root) || root.isModuleBody() || root.isComputedFieldDef() || root.isMemberFieldDef() ? 1 : 0) != 0, (Object)scope);
                this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.anonymousNode, scope));
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
            this.symbolStack.pop();
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            String propName;
            if (!AnalyzePrototypeProperties.this.rootScopeUsesAreGlobal && (propName = this.processNonFunctionPrototypeAssign(n, parent)) != null) {
                this.symbolStack.push(new NameContext(AnalyzePrototypeProperties.this.getNameInfoForName(propName, PROPERTY), null));
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            block0 : switch (n.getToken()) {
                case SUPER: {
                    for (NameContext context : this.symbolStack) {
                        context.name.referencesSuper = true;
                        if (!NodeUtil.isMethodDeclaration(context.scope.getRootNode())) continue;
                        break block0;
                    }
                    break;
                }
                case OPTCHAIN_GETPROP: {
                    this.addSymbolUse(n.getString(), t.getChunk(), PROPERTY);
                    break;
                }
                case GETPROP: {
                    String propName = n.getString();
                    if (n.isQualifiedName()) {
                        if (propName.equals("prototype")) {
                            if (this.handlePossibleAssignmentToPrototype(t, n)) {
                                return;
                            }
                        } else {
                            String rValueName;
                            if (AnalyzePrototypeProperties.this.compiler.getCodingConvention().isExported(propName, false)) {
                                this.addGlobalUseOfSymbol(propName, t.getChunk(), PROPERTY);
                                return;
                            }
                            if (parent.isAssign() && n == parent.getFirstChild() && (rValueName = this.getPrototypePropertyNameFromRValue(n)) != null) {
                                return;
                            }
                        }
                    }
                    this.addSymbolUse(propName, t.getChunk(), PROPERTY);
                    break;
                }
                case OBJECTLIT: {
                    String lValueName = NodeUtil.getBestLValueName(NodeUtil.getBestLValue(n));
                    if (lValueName != null && lValueName.endsWith(".prototype")) {
                        return;
                    }
                }
                case OBJECT_PATTERN: {
                    block14: for (Node propNode = n.getFirstChild(); propNode != null; propNode = propNode.getNext()) {
                        switch (propNode.getToken()) {
                            case COMPUTED_PROP: 
                            case ITER_REST: 
                            case OBJECT_REST: 
                            case ITER_SPREAD: 
                            case OBJECT_SPREAD: {
                                continue block14;
                            }
                            case STRING_KEY: 
                            case GETTER_DEF: 
                            case SETTER_DEF: 
                            case MEMBER_FUNCTION_DEF: {
                                if (propNode.isQuotedString()) continue block14;
                                this.addSymbolUse(propNode.getString(), t.getChunk(), PROPERTY);
                                continue block14;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected child of " + n.getToken() + ": " + propNode.toStringTree());
                            }
                        }
                    }
                    break;
                }
                case CLASS: {
                    Node classMembers = n.getLastChild();
                    for (Node child = classMembers.getFirstChild(); child != null; child = child.getNext()) {
                        if (!child.isMemberFunctionDef() && !child.isSetterDef() && !child.isGetterDef()) continue;
                        this.processMemberDef(t, child);
                    }
                    break;
                }
                case NAME: {
                    String name = n.getString();
                    Var var = (Var)t.getScope().getVar(name);
                    if (var == null) break;
                    if (var.isGlobal()) {
                        if (var.getInitialValue() == null || !var.getInitialValue().isFunction()) break;
                        if (t.inGlobalHoistScope()) {
                            if (this.processGlobalFunctionDeclaration(t, n, var)) break;
                            this.addGlobalUseOfSymbol(name, t.getChunk(), VAR);
                            break;
                        }
                        this.addSymbolUse(name, t.getChunk(), VAR);
                        break;
                    }
                    if (var.getScope() == t.getScope()) break;
                    for (NameContext context : this.symbolStack) {
                        if (context.scope == var.getScope()) break block0;
                        context.name.readClosureVariables = true;
                    }
                    break;
                }
            }
            if (!AnalyzePrototypeProperties.this.rootScopeUsesAreGlobal && this.processNonFunctionPrototypeAssign(n, parent) != null) {
                this.symbolStack.pop();
            }
        }

        private void addSymbolUse(String name, JSChunk module, SymbolType type) {
            NameInfo info = AnalyzePrototypeProperties.this.getNameInfoForName(name, type);
            Object def = null;
            for (NameContext context : this.symbolStack) {
                def = context.name;
                if (def == AnalyzePrototypeProperties.this.anonymousNode) continue;
                break;
            }
            if (!def.equals(info)) {
                AnalyzePrototypeProperties.this.symbolGraph.connect((NameInfo)def, module, info);
            }
        }

        private @Nullable String processNonFunctionPrototypeAssign(Node n, Node parent) {
            if (this.isAssignRValue(n, parent) && !n.isFunction()) {
                return this.getPrototypePropertyNameFromRValue(n);
            }
            return null;
        }

        private boolean isGlobalFunctionDeclaration(NodeTraversal t, Node n) {
            if (!(t.inGlobalHoistScope() || n.isFunction() && t.getScopeRoot() == n && ((Scope)t.getScope().getParent().getClosestHoistScope()).isGlobal())) {
                return false;
            }
            return NodeUtil.isFunctionDeclaration(n) || n.isFunction() && n.getParent().isName();
        }

        private boolean isAssignRValue(Node n, Node parent) {
            return parent != null && parent.isAssign() && parent.getFirstChild() != n;
        }

        private @Nullable String getPrototypePropertyNameFromRValue(Node rValue) {
            Node lValue = NodeUtil.getBestLValue(rValue);
            if (lValue == null || (!NodeUtil.mayBeObjectLitKey(lValue) || lValue.isQuotedString()) && !NodeUtil.isExprAssign(lValue.getGrandparent())) {
                return null;
            }
            String lValueName = NodeUtil.getBestLValueName(lValue);
            if (lValueName == null) {
                return null;
            }
            int lastDot = lValueName.lastIndexOf(46);
            if (lastDot == -1) {
                return null;
            }
            String firstPart = lValueName.substring(0, lastDot);
            if (!firstPart.endsWith(".prototype")) {
                return null;
            }
            return lValueName.substring(lastDot + 1);
        }

        private boolean processGlobalFunctionDeclaration(NodeTraversal t, Node nameNode, Var v) {
            Node firstChild = nameNode.getFirstChild();
            Node parent = nameNode.getParent();
            if (this.isGlobalFunctionDeclaration(t, parent) || firstChild != null && this.isGlobalFunctionDeclaration(t, firstChild)) {
                String name = nameNode.getString();
                AnalyzePrototypeProperties.this.getNameInfoForName(name, VAR).getDeclarations().add(new GlobalFunction(nameNode, v, t.getChunk()));
                if (AnalyzePrototypeProperties.this.compiler.getCodingConvention().isExported(name, false) || AnalyzePrototypeProperties.this.anchorUnusedVars) {
                    this.addGlobalUseOfSymbol(name, t.getChunk(), VAR);
                }
                return true;
            }
            return false;
        }

        private boolean handlePossibleAssignmentToPrototype(NodeTraversal t, Node ref) {
            Node root = NodeUtil.getRootOfQualifiedName(ref);
            Node n = ref.getParent();
            switch (n.getToken()) {
                case GETPROP: {
                    Node parent = n.getParent();
                    Node grandParent = parent.getParent();
                    if (!NodeUtil.isExprAssign(grandParent) || !NodeUtil.isNameDeclOrSimpleAssignLhs(n, parent)) break;
                    AssignmentPrototypeProperty prop = new AssignmentPrototypeProperty(grandParent, this.maybeGetVar(t, root), t.getChunk());
                    AnalyzePrototypeProperties.this.getNameInfoForName(n.getString(), PROPERTY).getDeclarations().add(prop);
                    return true;
                }
                case ASSIGN: {
                    Node map = n.getSecondChild();
                    if (!map.isObjectLit()) break;
                    for (Node key = map.getFirstChild(); key != null; key = key.getNext()) {
                        if (key.isQuotedString() || key.isComputedProp()) continue;
                        String name = key.getString();
                        LiteralPrototypeProperty prop = new LiteralPrototypeProperty(key.getFirstChild(), n, this.maybeGetVar(t, root), t.getChunk());
                        AnalyzePrototypeProperties.this.getNameInfoForName(name, PROPERTY).getDeclarations().add(prop);
                    }
                    return true;
                }
            }
            return false;
        }

        private void processMemberDef(NodeTraversal t, Node n) {
            Preconditions.checkState((n.isMemberFunctionDef() || n.isGetterDef() || n.isSetterDef() ? 1 : 0) != 0);
            String name = n.getString();
            if (NodeUtil.isEs6ConstructorMemberFunctionDef(n) || n.isStaticMember()) {
                return;
            }
            Node classNameNode = NodeUtil.getNameNode(n.getGrandparent());
            Var var = classNameNode != null && classNameNode.isName() ? (Var)t.getScope().getVar(classNameNode.getString()) : null;
            AnalyzePrototypeProperties.this.getNameInfoForName(name, PROPERTY).getDeclarations().add(new ClassMemberFunction(n, var, t.getChunk()));
        }

        private @Nullable Var maybeGetVar(NodeTraversal t, Node maybeName) {
            return maybeName.isName() ? (Var)t.getScope().getVar(maybeName.getString()) : null;
        }

        private void addGlobalUseOfSymbol(String name, JSChunk module, SymbolType type) {
            AnalyzePrototypeProperties.this.symbolGraph.connect(AnalyzePrototypeProperties.this.globalNode, module, AnalyzePrototypeProperties.this.getNameInfoForName(name, type));
        }
    }
}

