/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstAnalyzer;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.base.Tri;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;
import java.math.BigInteger;

abstract class AbstractPeepholeOptimization {
    private AbstractCompiler compiler;
    private AstAnalyzer astAnalyzer;

    AbstractPeepholeOptimization() {
    }

    abstract Node optimizeSubtree(Node var1);

    protected void report(DiagnosticType diagnostic, Node n) {
        JSError error = JSError.make(n, diagnostic, n.toString());
        this.compiler.report(error);
    }

    protected boolean areNodesEqualForInlining(Node n1, Node n2) {
        Preconditions.checkNotNull((Object)this.compiler);
        return this.compiler.areNodesEqualForInlining(n1, n2);
    }

    protected boolean isASTNormalized() {
        Preconditions.checkNotNull((Object)this.compiler);
        return this.compiler.getLifeCycleStage().isNormalized();
    }

    void beginTraversal(AbstractCompiler compiler) {
        this.compiler = (AbstractCompiler)Preconditions.checkNotNull((Object)compiler);
        this.astAnalyzer = compiler.getAstAnalyzer();
    }

    protected boolean mayEffectMutableState(Node n) {
        return this.astAnalyzer.mayEffectMutableState(n);
    }

    protected boolean mayHaveSideEffects(Node n) {
        return this.astAnalyzer.mayHaveSideEffects(n);
    }

    protected Double getSideEffectFreeNumberValue(Node n) {
        Double value = NodeUtil.getNumberValue(n);
        if (value != null && this.astAnalyzer.mayHaveSideEffects(n)) {
            value = null;
        }
        return value;
    }

    protected BigInteger getSideEffectFreeBigIntValue(Node n) {
        BigInteger value = NodeUtil.getBigIntValue(n);
        if (value != null && this.astAnalyzer.mayHaveSideEffects(n)) {
            value = null;
        }
        return value;
    }

    protected String getSideEffectFreeStringValue(Node n) {
        String value = NodeUtil.getStringValue(n);
        if (value != null && this.astAnalyzer.mayHaveSideEffects(n)) {
            value = null;
        }
        return value;
    }

    protected Tri getSideEffectFreeBooleanValue(Node n) {
        Tri value = NodeUtil.getBooleanValue(n);
        if (value != Tri.UNKNOWN && this.astAnalyzer.mayHaveSideEffects(n)) {
            value = Tri.UNKNOWN;
        }
        return value;
    }

    protected boolean nodeTypeMayHaveSideEffects(Node n) {
        return this.astAnalyzer.nodeTypeMayHaveSideEffects(n);
    }

    protected boolean isEcmaScript5OrGreater() {
        return this.compiler != null && this.compiler.getOptions().getOutputFeatureSet().contains(FeatureSet.ES5);
    }

    protected CodingConvention getCodingConvention() {
        return this.compiler.getCodingConvention();
    }

    protected final void reportChangeToEnclosingScope(Node n) {
        this.compiler.reportChangeToEnclosingScope(n);
    }

    protected final void deleteNode(Node property) {
        Preconditions.checkNotNull((Object)this.compiler);
        NodeUtil.deleteNode(property, this.compiler);
    }

    protected final void markFunctionsDeleted(Node function) {
        Preconditions.checkNotNull((Object)this.compiler);
        NodeUtil.markFunctionsDeleted(function, this.compiler);
    }

    protected final void markNewScopesChanged(Node n) {
        Preconditions.checkNotNull((Object)this.compiler);
        NodeUtil.markNewScopesChanged(n, this.compiler);
    }
}

