/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.MustBeClosed;
import com.google.errorprone.annotations.OverridingMethodsMustInvokeSuper;
import com.google.javascript.jscomp.AccessorSummary;
import com.google.javascript.jscomp.AstAnalyzer;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodeChangeHandler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerInputProvider;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.CssRenamingMap;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.ExpressionDecomposer;
import com.google.javascript.jscomp.IdGenerator;
import com.google.javascript.jscomp.IndexProvider;
import com.google.javascript.jscomp.JSChunk;
import com.google.javascript.jscomp.JSChunkGraph;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.SourceExcerptProvider;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMapInput;
import com.google.javascript.jscomp.TypeMismatch;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.UniqueIdSupplier;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.colors.ColorRegistry;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.diagnostic.LogFile;
import com.google.javascript.jscomp.modules.ModuleMap;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.jscomp.parsing.parser.trees.Comment;
import com.google.javascript.jscomp.serialization.ColorPool;
import com.google.javascript.jscomp.type.ReverseAbstractInterpreter;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jspecify.nullness.Nullable;

public abstract class AbstractCompiler
implements SourceExcerptProvider,
CompilerInputProvider {
    static final DiagnosticType READ_ERROR = DiagnosticType.error("JSC_READ_ERROR", "Cannot read file {0}: {1}");
    private int currentPassIndex = -1;
    private LifeCycleStage stage = LifeCycleStage.RAW;
    private static final String FILL_FILE_SUFFIX = "$fillFile";
    static final String RUNTIME_LIB_DIR = "src/com/google/javascript/jscomp/js/";

    @OverridingMethodsMustInvokeSuper
    void beforePass(String passName) {
        ++this.currentPassIndex;
    }

    @OverridingMethodsMustInvokeSuper
    void afterPass(String passName) {
    }

    abstract Supplier<Node> getTypedAstDeserializer(SourceFile var1);

    @Override
    public abstract CompilerInput getInput(InputId var1);

    abstract @Nullable SourceFile getSourceFileByName(String var1);

    public abstract @Nullable Node getScriptNode(String var1);

    abstract @Nullable JSChunkGraph getModuleGraph();

    abstract Iterable<CompilerInput> getInputsInOrder();

    abstract int getNumberOfInputs();

    public abstract void addExportedNames(Set<String> var1);

    public abstract Set<String> getExportedNames();

    public abstract void setVariableMap(VariableMap var1);

    public abstract void setPropertyMap(VariableMap var1);

    public abstract void setStringMap(VariableMap var1);

    public abstract void setCssNames(LinkedHashMap<String, Integer> var1);

    public abstract void setInstrumentationMapping(VariableMap var1);

    public abstract void setIdGeneratorMap(String var1);

    public abstract IdGenerator getCrossModuleIdGenerator();

    public abstract void setAnonymousFunctionNameMap(VariableMap var1);

    abstract void setTypeCheckingHasRun(boolean var1);

    public abstract boolean hasTypeCheckingRun();

    public abstract boolean hasOptimizationColors();

    public abstract boolean isTypeRegistryCleared();

    public abstract JSTypeRegistry getTypeRegistry();

    public abstract void clearJSTypeRegistry();

    public abstract ColorRegistry getColorRegistry();

    public abstract void setColorRegistry(ColorRegistry var1);

    abstract void forwardDeclareType(String var1);

    abstract ScopeCreator getTypedScopeCreator();

    abstract void clearTypedScopeCreator();

    public abstract TypedScope getTopScope();

    abstract void setTopScope(TypedScope var1);

    abstract StaticScope getTranspilationNamespace();

    public abstract void report(JSError var1);

    abstract void throwInternalError(String var1, Throwable var2);

    public abstract CodingConvention getCodingConvention();

    public abstract void reportChangeToEnclosingScope(Node var1);

    public abstract void reportChangeToChangeScope(Node var1);

    abstract void reportFunctionDeleted(Node var1);

    abstract void setCssRenamingMap(CssRenamingMap var1);

    abstract CssRenamingMap getCssRenamingMap();

    abstract Node getNodeForCodeInsertion(@Nullable JSChunk var1);

    abstract TypeValidator getTypeValidator();

    public abstract Iterable<TypeMismatch> getTypeMismatches();

    abstract void setExternExports(String var1);

    public abstract Node parseSyntheticCode(String var1, String var2);

    @VisibleForTesting
    abstract Node parseTestCode(String var1);

    @VisibleForTesting
    abstract Node parseTestCode(ImmutableList<String> var1);

    public abstract String toSource();

    public abstract String toSource(Node var1);

    abstract ErrorReporter getDefaultErrorReporter();

    public abstract ReverseAbstractInterpreter getReverseAbstractInterpreter();

    public LifeCycleStage getLifeCycleStage() {
        return this.stage;
    }

    static String createFillFileName(String moduleName) {
        return moduleName + FILL_FILE_SUFFIX;
    }

    public static boolean isFillFileName(String fileName) {
        return fileName.endsWith(FILL_FILE_SUFFIX);
    }

    public void initRuntimeLibraryTypedAsts(Optional<ColorPool.Builder> colorPoolBuilder) {
        throw new UnsupportedOperationException("Implementation in Compiler.java is not J2CL compatible.");
    }

    abstract UniqueIdSupplier getUniqueIdSupplier();

    @Deprecated
    abstract com.google.common.base.Supplier<String> getUniqueNameIdSupplier();

    abstract boolean hasHaltingErrors();

    abstract void addChangeHandler(CodeChangeHandler var1);

    abstract void removeChangeHandler(CodeChangeHandler var1);

    abstract void addIndexProvider(IndexProvider<?> var1);

    abstract <T> T getIndex(Class<T> var1);

    abstract int getChangeStamp();

    abstract List<Node> getChangedScopeNodesForPass(String var1);

    abstract List<Node> getDeletedScopeNodesForPass(String var1);

    abstract void incrementChangeStamp();

    abstract Node getJsRoot();

    abstract boolean hasScopeChanged(Node var1);

    abstract Config getParserConfig(ConfigContext var1);

    public abstract ErrorManager getErrorManager();

    void setLifeCycleStage(LifeCycleStage stage) {
        this.stage = stage;
    }

    abstract boolean areNodesEqualForInlining(Node var1, Node var2);

    abstract void setHasRegExpGlobalReferences(boolean var1);

    abstract boolean hasRegExpGlobalReferences();

    abstract CheckLevel getErrorLevel(JSError var1);

    abstract void process(CompilerPass var1);

    public abstract Node getRoot();

    abstract CompilerOptions getOptions();

    abstract FeatureSet getFeatureSet();

    abstract void setFeatureSet(FeatureSet var1);

    abstract CompilerInput getSynthesizedExternsInput();

    abstract String getLastPassName();

    abstract Node ensureLibraryInjected(String var1, boolean var2);

    abstract void setExternProperties(ImmutableSet<String> var1);

    public abstract ImmutableSet<String> getExternProperties();

    public abstract void addInputSourceMap(String var1, SourceMapInput var2);

    abstract void addComments(String var1, List<Comment> var2);

    abstract AccessorSummary getAccessorSummary();

    public abstract void setAccessorSummary(AccessorSummary var1);

    abstract List<Comment> getComments(String var1);

    abstract ModuleLoader getModuleLoader();

    abstract CompilerInput.ModuleType getModuleTypeByName(String var1);

    abstract void setRunJ2clPasses(boolean var1);

    abstract boolean runJ2clPasses();

    public final AstFactory createAstFactory() {
        return this.hasTypeCheckingRun() ? (this.hasOptimizationColors() ? AstFactory.createFactoryWithColors(this.getColorRegistry()) : AstFactory.createFactoryWithTypes(this.getTypeRegistry())) : AstFactory.createFactoryWithoutTypes();
    }

    public final AstFactory createAstFactoryWithoutTypes() {
        return AstFactory.createFactoryWithoutTypes();
    }

    public AstAnalyzer getAstAnalyzer() {
        return new AstAnalyzer(this, this.getOptions().getAssumeGettersArePure());
    }

    public ExpressionDecomposer createDefaultExpressionDecomposer() {
        return this.createExpressionDecomposer(this.getUniqueNameIdSupplier(), (ImmutableSet<String>)ImmutableSet.of(), Scope.createGlobalScope(new Node(Token.SCRIPT)));
    }

    public ExpressionDecomposer createExpressionDecomposer(com.google.common.base.Supplier<String> uniqueNameIdSupplier, ImmutableSet<String> knownConstantFunctions, Scope scope) {
        EnumSet<ExpressionDecomposer.Workaround> enabledWorkarounds = FeatureSet.ES5.contains(this.getOptions().getOutputFeatureSet()) ? EnumSet.of(ExpressionDecomposer.Workaround.BROKEN_IE11_LOCATION_ASSIGN) : EnumSet.noneOf(ExpressionDecomposer.Workaround.class);
        return new ExpressionDecomposer(this, uniqueNameIdSupplier, knownConstantFunctions, scope, enabledWorkarounds);
    }

    public abstract ModuleMetadataMap getModuleMetadataMap();

    public abstract void setModuleMetadataMap(ModuleMetadataMap var1);

    public abstract ModuleMap getModuleMap();

    public abstract void setModuleMap(ModuleMap var1);

    public final boolean isDebugLoggingEnabled() {
        return this.getOptions().getDebugLogDirectory() != null;
    }

    public final List<String> getDebugLogFilterList() {
        if (this.getOptions().getDebugLogFilter() == null) {
            return new ArrayList<String>();
        }
        return Splitter.on((char)',').omitEmptyStrings().splitToList((CharSequence)this.getOptions().getDebugLogFilter());
    }

    @MustBeClosed
    public final LogFile createOrReopenLog(Class<?> owner, String firstNamePart, String ... restNameParts) {
        if (!this.isDebugLoggingEnabled()) {
            return LogFile.createNoOp();
        }
        Path dir = this.getOptions().getDebugLogDirectory();
        Path relativeParts = Paths.get(firstNamePart, restNameParts);
        Path file = dir.resolve(owner.getSimpleName()).resolve(relativeParts);
        List<String> filters = this.getDebugLogFilterList();
        if (filters.isEmpty()) {
            return LogFile.createOrReopen(file);
        }
        for (String filter : filters) {
            if (!file.toString().contains(filter)) continue;
            return LogFile.createOrReopen(file);
        }
        return LogFile.createNoOp();
    }

    @MustBeClosed
    public final LogFile createOrReopenIndexedLog(Class<?> owner, String firstNamePart, String ... restNameParts) {
        Preconditions.checkState((this.currentPassIndex >= 0 ? 1 : 0) != 0, (Object)this.currentPassIndex);
        String index = Strings.padStart((String)Integer.toString(this.currentPassIndex), (int)3, (char)'0');
        int length = restNameParts.length;
        if (length == 0) {
            firstNamePart = index + "_" + (String)firstNamePart;
        } else {
            restNameParts[length - 1] = index + "_" + restNameParts[length - 1];
        }
        return this.createOrReopenLog(owner, (String)firstNamePart, restNameParts);
    }

    abstract InputId getSyntheticCodeInputId();

    abstract void initializeSyntheticCodeInput();

    abstract void removeSyntheticCodeInput();

    abstract void mergeSyntheticCodeInput();

    public static enum LifeCycleStage implements Serializable
    {
        RAW,
        COLORS_AND_SIMPLIFIED_JSDOC,
        NORMALIZED,
        NORMALIZED_OBFUSCATED;


        public boolean isNormalized() {
            return this == NORMALIZED || this == NORMALIZED_OBFUSCATED;
        }

        public boolean isNormalizedUnobfuscated() {
            return this == NORMALIZED;
        }

        public boolean isNormalizedObfuscated() {
            return this == NORMALIZED_OBFUSCATED;
        }

        public boolean hasColorAndSimplifiedJSDoc() {
            return this != RAW;
        }
    }

    static enum ConfigContext {
        DEFAULT,
        EXTERNS;

    }
}

