/*
 * Decompiled with CFR 0.152.
 */
package com.google.debugging.sourcemap;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.debugging.sourcemap.Base64VLQ;
import com.google.debugging.sourcemap.FilePosition;
import com.google.debugging.sourcemap.SourceMapConsumer;
import com.google.debugging.sourcemap.SourceMapGeneratorV3;
import com.google.debugging.sourcemap.SourceMapObject;
import com.google.debugging.sourcemap.SourceMapObjectParser;
import com.google.debugging.sourcemap.SourceMapParseException;
import com.google.debugging.sourcemap.SourceMapSection;
import com.google.debugging.sourcemap.SourceMapSupplier;
import com.google.debugging.sourcemap.SourceMappingReversable;
import com.google.debugging.sourcemap.proto.Mapping;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.nullness.Nullable;

public final class SourceMapConsumerV3
implements SourceMapConsumer,
SourceMappingReversable {
    static final int UNMAPPED = -1;
    private String[] sources;
    private String[] sourcesContent;
    private String[] names;
    private int lineCount;
    private @Nullable ArrayList<ArrayList<Entry>> lines = null;
    private Map<String, Map<Integer, Collection<Mapping.OriginalMapping>>> reverseSourceMapping;
    private String sourceRoot;
    private final Map<String, Object> extensions = new LinkedHashMap<String, Object>();

    @Override
    public void parse(String contents) throws SourceMapParseException {
        SourceMapObject sourceMapObject = SourceMapObjectParser.parse(contents);
        this.parse(sourceMapObject, null);
    }

    public void parse(SourceMapObject sourceMapObject, @Nullable SourceMapSupplier sectionSupplier) throws SourceMapParseException {
        if (sourceMapObject.getVersion() != 3) {
            throw new SourceMapParseException("Unknown version: " + sourceMapObject.getVersion());
        }
        String file = sourceMapObject.getFile();
        if (file != null && file.isEmpty()) {
            throw new SourceMapParseException("File entry is empty");
        }
        if (sourceMapObject.getSections() != null) {
            this.parseMetaMap(sourceMapObject, sectionSupplier);
            return;
        }
        this.lineCount = sourceMapObject.getLineCount();
        this.sourceRoot = sourceMapObject.getSourceRoot();
        this.sources = sourceMapObject.getSources();
        this.sourcesContent = sourceMapObject.getSourcesContent();
        this.names = sourceMapObject.getNames();
        this.lines = this.lineCount >= 0 ? new ArrayList(this.lineCount) : new ArrayList();
        this.extensions.putAll(sourceMapObject.getExtensions());
        new MappingBuilder(sourceMapObject.getMappings()).build();
    }

    private void parseMetaMap(SourceMapObject sourceMapObject, SourceMapSupplier sectionSupplier) throws SourceMapParseException {
        if (sectionSupplier == null) {
            sectionSupplier = new DefaultSourceMapSupplier();
        }
        try {
            if (sourceMapObject.getLineCount() >= 0 || sourceMapObject.getMappings() != null || sourceMapObject.getSources() != null || sourceMapObject.getNames() != null) {
                throw new SourceMapParseException("Invalid map format");
            }
            SourceMapGeneratorV3 generator = new SourceMapGeneratorV3();
            for (SourceMapSection section : sourceMapObject.getSections()) {
                String mapSectionContents = section.getSectionValue();
                if (section.getSectionType() == SourceMapSection.SectionType.URL) {
                    mapSectionContents = sectionSupplier.getSourceMap(section.getSectionValue());
                }
                if (mapSectionContents == null) {
                    throw new SourceMapParseException("Unable to retrieve: " + section.getSectionValue());
                }
                generator.mergeMapSection(section.getLine(), section.getColumn(), mapSectionContents);
            }
            StringBuilder sb = new StringBuilder();
            generator.appendTo(sb, sourceMapObject.getFile());
            this.parse(sb.toString());
        }
        catch (IOException ex) {
            throw new SourceMapParseException("IO exception: " + ex);
        }
    }

    @Override
    public  @Nullable Mapping.OriginalMapping getMappingForLine(int lineNumber, int column) {
        --column;
        if (--lineNumber < 0 || lineNumber >= this.lines.size()) {
            return null;
        }
        Preconditions.checkState((lineNumber >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((column >= 0 ? 1 : 0) != 0);
        if (this.lines.get(lineNumber) == null) {
            return this.getPreviousMapping(lineNumber);
        }
        ArrayList<Entry> entries = this.lines.get(lineNumber);
        Preconditions.checkState((!entries.isEmpty() ? 1 : 0) != 0);
        if (entries.get(0).getGeneratedColumn() > column) {
            return this.getPreviousMapping(lineNumber);
        }
        int index = SourceMapConsumerV3.search(entries, column, 0, entries.size() - 1);
        Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (String)"unexpected:%s", (int)index);
        return this.getOriginalMappingForEntry(entries.get(index), Mapping.OriginalMapping.Precision.EXACT);
    }

    @Override
    public Collection<String> getOriginalSources() {
        return Arrays.asList(this.sources);
    }

    public @Nullable Collection<String> getOriginalSourcesContent() {
        return this.sourcesContent == null ? null : Arrays.asList(this.sourcesContent);
    }

    public List<String> getOriginalNames() {
        return Arrays.asList(this.names);
    }

    @Override
    public Collection<Mapping.OriginalMapping> getReverseMapping(String originalFile, int line, int column) {
        Map<Integer, Collection<Mapping.OriginalMapping>> sourceLineToCollectionMap;
        if (this.reverseSourceMapping == null) {
            this.createReverseMapping();
        }
        if ((sourceLineToCollectionMap = this.reverseSourceMapping.get(originalFile)) == null) {
            return Collections.emptyList();
        }
        Collection<Mapping.OriginalMapping> mappings = sourceLineToCollectionMap.get(line);
        if (mappings == null) {
            return Collections.emptyList();
        }
        return mappings;
    }

    public String getSourceRoot() {
        return this.sourceRoot;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    private static int search(ArrayList<Entry> entries, int target, int start, int end) {
        int mid;
        int compare;
        do {
            if ((compare = SourceMapConsumerV3.compareEntry(entries, mid = (end - start) / 2 + start, target)) != 0) continue;
            return mid;
        } while (!(compare < 0 ? (start = mid + 1) > end : (end = mid - 1) < start));
        return end;
    }

    private static int compareEntry(ArrayList<Entry> entries, int entry, int target) {
        return entries.get(entry).getGeneratedColumn() - target;
    }

    private  @Nullable Mapping.OriginalMapping getPreviousMapping(int lineNumber) {
        do {
            if (lineNumber != 0) continue;
            return null;
        } while (this.lines.get(--lineNumber) == null);
        ArrayList<Entry> entries = this.lines.get(lineNumber);
        return this.getOriginalMappingForEntry((Entry)Iterables.getLast(entries), Mapping.OriginalMapping.Precision.APPROXIMATE_LINE);
    }

    private  @Nullable Mapping.OriginalMapping getOriginalMappingForEntry(Entry entry, Mapping.OriginalMapping.Precision precision) {
        if (entry.getSourceFileId() == -1) {
            return null;
        }
        Mapping.OriginalMapping.Builder x = Mapping.OriginalMapping.newBuilder().setOriginalFile(this.sources[entry.getSourceFileId()]).setLineNumber(entry.getSourceLine() + 1).setColumnPosition(entry.getSourceColumn() + 1).setPrecision(precision);
        if (entry.getNameId() != -1) {
            x.setIdentifier(this.names[entry.getNameId()]);
        }
        return x.build();
    }

    private void createReverseMapping() {
        this.reverseSourceMapping = new LinkedHashMap<String, Map<Integer, Collection<Mapping.OriginalMapping>>>();
        for (int targetLine = 0; targetLine < this.lines.size(); ++targetLine) {
            ArrayList<Entry> entries = this.lines.get(targetLine);
            if (entries == null) continue;
            for (Entry entry : entries) {
                if (entry.getSourceFileId() == -1 || entry.getSourceLine() == -1) continue;
                String originalFile = this.sources[entry.getSourceFileId()];
                this.reverseSourceMapping.computeIfAbsent(originalFile, k -> new LinkedHashMap());
                Map<Integer, Collection<Mapping.OriginalMapping>> lineToCollectionMap = this.reverseSourceMapping.get(originalFile);
                int sourceLine = entry.getSourceLine();
                if (!lineToCollectionMap.containsKey(sourceLine)) {
                    lineToCollectionMap.put(sourceLine, new ArrayList(1));
                }
                Collection<Mapping.OriginalMapping> mappings = lineToCollectionMap.get(sourceLine);
                Mapping.OriginalMapping.Builder builder = Mapping.OriginalMapping.newBuilder().setLineNumber(targetLine).setColumnPosition(entry.getGeneratedColumn());
                mappings.add(builder.build());
            }
        }
    }

    public void visitMappings(EntryVisitor visitor) {
        boolean pending = false;
        String sourceName = null;
        String symbolName = null;
        FilePosition sourceStartPosition = null;
        FilePosition startPosition = null;
        int lineCount = this.lines.size();
        for (int i = 0; i < lineCount; ++i) {
            ArrayList<Entry> line = this.lines.get(i);
            if (line == null) continue;
            int entryCount = line.size();
            for (int j = 0; j < entryCount; ++j) {
                Entry entry = line.get(j);
                if (pending) {
                    FilePosition endPosition = new FilePosition(i, entry.getGeneratedColumn());
                    visitor.visit(sourceName, symbolName, sourceStartPosition, startPosition, endPosition);
                    pending = false;
                }
                if (entry.getSourceFileId() == -1) continue;
                pending = true;
                sourceName = this.sources[entry.getSourceFileId()];
                symbolName = entry.getNameId() != -1 ? this.names[entry.getNameId()] : null;
                sourceStartPosition = new FilePosition(entry.getSourceLine(), entry.getSourceColumn());
                startPosition = new FilePosition(i, entry.getGeneratedColumn());
            }
        }
        if (pending) {
            FilePosition endPosition = new FilePosition(startPosition.getLine(), startPosition.getColumn() + 1);
            visitor.visit(sourceName, symbolName, sourceStartPosition, startPosition, endPosition);
        }
    }

    public static interface EntryVisitor {
        public void visit(String var1, String var2, FilePosition var3, FilePosition var4, FilePosition var5);
    }

    private static class NamedEntry
    extends UnnamedEntry {
        private final int name;

        NamedEntry(int column, int srcFile, int srcLine, int srcColumn, int name) {
            super(column, srcFile, srcLine, srcColumn);
            this.name = name;
        }

        @Override
        public int getNameId() {
            return this.name;
        }
    }

    private static class UnnamedEntry
    extends UnmappedEntry {
        private final int srcFile;
        private final int srcLine;
        private final int srcColumn;

        UnnamedEntry(int column, int srcFile, int srcLine, int srcColumn) {
            super(column);
            this.srcFile = srcFile;
            this.srcLine = srcLine;
            this.srcColumn = srcColumn;
        }

        @Override
        public int getSourceFileId() {
            return this.srcFile;
        }

        @Override
        public int getSourceLine() {
            return this.srcLine;
        }

        @Override
        public int getSourceColumn() {
            return this.srcColumn;
        }

        @Override
        public int getNameId() {
            return -1;
        }
    }

    private static class UnmappedEntry
    implements Entry {
        private final int column;

        UnmappedEntry(int column) {
            this.column = column;
        }

        @Override
        public int getGeneratedColumn() {
            return this.column;
        }

        @Override
        public int getSourceFileId() {
            return -1;
        }

        @Override
        public int getSourceLine() {
            return -1;
        }

        @Override
        public int getSourceColumn() {
            return -1;
        }

        @Override
        public int getNameId() {
            return -1;
        }
    }

    private static interface Entry {
        public int getGeneratedColumn();

        public int getSourceFileId();

        public int getSourceLine();

        public int getSourceColumn();

        public int getNameId();
    }

    private static class StringCharIterator
    implements Base64VLQ.CharIterator {
        final String content;
        final int length;
        int current = 0;

        StringCharIterator(String content) {
            this.content = content;
            this.length = content.length();
        }

        @Override
        public char next() {
            return this.content.charAt(this.current++);
        }

        char peek() {
            return this.content.charAt(this.current);
        }

        @Override
        public boolean hasNext() {
            return this.current < this.length;
        }
    }

    private class MappingBuilder {
        private static final int MAX_ENTRY_VALUES = 5;
        private final StringCharIterator content;
        private int line = 0;
        private int previousCol = 0;
        private int previousSrcId = 0;
        private int previousSrcLine = 0;
        private int previousSrcColumn = 0;
        private int previousNameId = 0;

        MappingBuilder(String lineMap) {
            this.content = new StringCharIterator(lineMap);
        }

        void build() throws SourceMapParseException {
            int[] temp = new int[5];
            ArrayList<Entry> entries = new ArrayList<Entry>();
            while (this.content.hasNext()) {
                if (this.tryConsumeToken(';')) {
                    this.completeLine(entries);
                    if (entries.isEmpty()) continue;
                    entries = new ArrayList();
                    continue;
                }
                int entryValues = 0;
                while (!this.entryComplete()) {
                    temp[entryValues] = this.nextValue();
                    ++entryValues;
                }
                Entry entry = this.decodeEntry(temp, entryValues);
                this.validateEntry(entry);
                entries.add(entry);
                this.tryConsumeToken(',');
            }
            if (!entries.isEmpty()) {
                this.completeLine(entries);
            }
        }

        private void completeLine(ArrayList<Entry> entries) {
            if (!entries.isEmpty()) {
                SourceMapConsumerV3.this.lines.add(entries);
            } else {
                SourceMapConsumerV3.this.lines.add(null);
            }
            ++this.line;
            this.previousCol = 0;
        }

        private void validateEntry(Entry entry) {
            Preconditions.checkState((SourceMapConsumerV3.this.lineCount < 0 || this.line < SourceMapConsumerV3.this.lineCount ? 1 : 0) != 0, (String)"line=%s, lineCount=%s", (int)this.line, (int)SourceMapConsumerV3.this.lineCount);
            Preconditions.checkState((entry.getSourceFileId() == -1 || entry.getSourceFileId() < SourceMapConsumerV3.this.sources.length ? 1 : 0) != 0);
            Preconditions.checkState((entry.getNameId() == -1 || entry.getNameId() < SourceMapConsumerV3.this.names.length ? 1 : 0) != 0);
        }

        private Entry decodeEntry(int[] vals, int entryValues) throws SourceMapParseException {
            switch (entryValues) {
                case 1: {
                    UnmappedEntry entry = new UnmappedEntry(vals[0] + this.previousCol);
                    this.previousCol = entry.getGeneratedColumn();
                    return entry;
                }
                case 4: {
                    UnnamedEntry entry = new UnnamedEntry(vals[0] + this.previousCol, vals[1] + this.previousSrcId, vals[2] + this.previousSrcLine, vals[3] + this.previousSrcColumn);
                    this.previousCol = entry.getGeneratedColumn();
                    this.previousSrcId = entry.getSourceFileId();
                    this.previousSrcLine = entry.getSourceLine();
                    this.previousSrcColumn = entry.getSourceColumn();
                    return entry;
                }
                case 5: {
                    NamedEntry entry = new NamedEntry(vals[0] + this.previousCol, vals[1] + this.previousSrcId, vals[2] + this.previousSrcLine, vals[3] + this.previousSrcColumn, vals[4] + this.previousNameId);
                    this.previousCol = entry.getGeneratedColumn();
                    this.previousSrcId = entry.getSourceFileId();
                    this.previousSrcLine = entry.getSourceLine();
                    this.previousSrcColumn = entry.getSourceColumn();
                    this.previousNameId = entry.getNameId();
                    return entry;
                }
            }
            throw new SourceMapParseException("Unexpected number of values for entry:" + entryValues);
        }

        private boolean tryConsumeToken(char token) {
            if (this.content.hasNext() && this.content.peek() == token) {
                this.content.next();
                return true;
            }
            return false;
        }

        private boolean entryComplete() {
            if (!this.content.hasNext()) {
                return true;
            }
            char c = this.content.peek();
            return c == ';' || c == ',';
        }

        private int nextValue() {
            return Base64VLQ.decode(this.content);
        }
    }

    static class DefaultSourceMapSupplier
    implements SourceMapSupplier {
        DefaultSourceMapSupplier() {
        }

        @Override
        public String getSourceMap(String url) {
            return null;
        }
    }
}

