/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.NoResolvedType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.ProxyObjectType;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import com.google.javascript.rhino.jstype.StaticTypedSlot;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class NamedType
extends ProxyObjectType {
    private static final long serialVersionUID = 1L;
    private final String reference;
    private final String sourceName;
    private final int lineno;
    private final int charno;
    private transient Predicate<JSType> validator;
    private List<PropertyContinuation> propertyContinuations = null;
    @Nullable
    private final ImmutableList<JSType> templateTypes;
    @Nullable
    private StaticTypedScope resolutionScope;

    static int nominalHashCode(ObjectType type) {
        Preconditions.checkState((boolean)type.hasReferenceName());
        String name = (String)Preconditions.checkNotNull((Object)type.getReferenceName());
        return name.hashCode();
    }

    NamedType(StaticTypedScope scope, JSTypeRegistry registry, String reference, String sourceName, int lineno, int charno) {
        this(scope, registry, reference, sourceName, lineno, charno, null);
    }

    NamedType(StaticTypedScope scope, JSTypeRegistry registry, String reference, String sourceName, int lineno, int charno, ImmutableList<JSType> templateTypes) {
        super(registry, registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE));
        Preconditions.checkNotNull((Object)reference);
        this.resolutionScope = scope;
        this.reference = reference;
        this.sourceName = sourceName;
        this.lineno = lineno;
        this.charno = charno;
        this.templateTypes = templateTypes;
    }

    @Override
    public ImmutableList<JSType> getTemplateTypes() {
        return this.templateTypes;
    }

    @Override
    boolean defineProperty(String propertyName, JSType type, boolean inferred, Node propertyNode) {
        if (!this.isResolved()) {
            if (this.propertyContinuations == null) {
                this.propertyContinuations = new ArrayList<PropertyContinuation>();
            }
            this.propertyContinuations.add(new PropertyContinuation(propertyName, type, inferred, propertyNode));
            return true;
        }
        return super.defineProperty(propertyName, type, inferred, propertyNode);
    }

    private void finishPropertyContinuations() {
        ObjectType referencedObjType = this.getReferencedObjTypeInternal();
        if (referencedObjType != null && !referencedObjType.isUnknownType() && this.propertyContinuations != null) {
            for (PropertyContinuation c : this.propertyContinuations) {
                c.commit(this);
            }
        }
        this.propertyContinuations = null;
    }

    public JSType getReferencedType() {
        return this.getReferencedTypeInternal();
    }

    @Override
    public String getReferenceName() {
        return this.reference;
    }

    @Override
    StringBuilder appendTo(StringBuilder sb, boolean forAnnotations) {
        JSType type = this.getReferencedType();
        if (!this.isResolved() || type.isNoResolvedType()) {
            return sb.append(this.reference);
        }
        return type.appendTo(sb, forAnnotations);
    }

    @Override
    public NamedType toMaybeNamedType() {
        return this;
    }

    @Override
    public boolean isNominalType() {
        return true;
    }

    @Override
    int recursionUnsafeHashCode() {
        return this.isSuccessfullyResolved() ? super.recursionUnsafeHashCode() : NamedType.nominalHashCode(this);
    }

    @Override
    JSType resolveInternal(ErrorReporter reporter) {
        if (!this.getReferencedType().isUnknownType()) {
            return super.resolveInternal(reporter);
        }
        boolean resolved = this.resolveViaRegistry(reporter);
        if (!resolved) {
            this.resolveViaProperties(reporter);
        }
        if (this.detectInheritanceCycle()) {
            this.handleTypeCycle(reporter);
        }
        super.resolveInternal(reporter);
        this.finishPropertyContinuations();
        JSType result = this.getReferencedType();
        if (this.isSuccessfullyResolved()) {
            int numKeys = result.getTemplateTypeMap().numUnfilledTemplateKeys();
            if (result.isObjectType() && this.templateTypes != null && !this.templateTypes.isEmpty() && numKeys > 0) {
                ImmutableList typeArgs = this.templateTypes;
                if (numKeys < this.templateTypes.size()) {
                    typeArgs = typeArgs.subList(0, numKeys);
                }
                result = this.registry.createTemplatizedType(result.toMaybeObjectType(), (ImmutableList<JSType>)typeArgs);
                this.setReferencedType(result);
            }
            this.resolutionScope = null;
        }
        return result;
    }

    private boolean resolveViaRegistry(ErrorReporter reporter) {
        JSType type = this.registry.getType(this.resolutionScope, this.reference);
        if (type != null) {
            this.setReferencedAndResolvedType(type, reporter);
            return true;
        }
        return false;
    }

    private void resolveViaProperties(ErrorReporter reporter) {
        JSType value = this.lookupViaProperties();
        if (value != null && value.isFunctionType() && (value.isConstructor() || value.isInterface())) {
            FunctionType functionType = value.toMaybeFunctionType();
            this.setReferencedAndResolvedType(functionType.getInstanceType(), reporter);
        } else if (value != null && value.isNoObjectType()) {
            this.setReferencedAndResolvedType(this.registry.getNativeObjectType(JSTypeNative.NO_OBJECT_TYPE), reporter);
        } else if (value instanceof EnumType) {
            this.setReferencedAndResolvedType(((EnumType)value).getElementsType(), reporter);
        } else {
            this.handleUnresolvedType(reporter, value == null || value.isUnknownType());
        }
    }

    private JSType lookupViaProperties() {
        String[] componentNames = this.reference.split("\\.", -1);
        if (componentNames[0].length() == 0) {
            return null;
        }
        StaticTypedSlot slot = this.resolutionScope.getSlot(componentNames[0]);
        if (slot == null) {
            return null;
        }
        JSType slotType = slot.getType();
        if (slotType == null || slotType.isAllType() || slotType.isNoType()) {
            return null;
        }
        for (int i = 1; i < componentNames.length; ++i) {
            ObjectType parentObj = ObjectType.cast(slotType);
            if (parentObj == null) {
                return null;
            }
            if (componentNames[i].length() == 0) {
                return null;
            }
            slotType = parentObj.getPropertyType(componentNames[i]);
        }
        return slotType;
    }

    private void setReferencedAndResolvedType(JSType type, ErrorReporter reporter) {
        if (this.validator != null) {
            this.validator.apply((Object)type);
        }
        this.setReferencedType(type);
        this.checkEnumElementCycle(reporter);
        this.checkProtoCycle(reporter);
        this.setResolvedTypeInternal(this.getReferencedType());
    }

    private void handleTypeCycle(ErrorReporter reporter) {
        this.setReferencedType(this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE));
        this.warning(reporter, "Cycle detected in inheritance chain of type " + this.reference);
        this.setResolvedTypeInternal(this.getReferencedType());
    }

    private void checkEnumElementCycle(ErrorReporter reporter) {
        JSType referencedType = this.getReferencedType();
        if (referencedType instanceof EnumElementType && NamedType.areIdentical(this, ((EnumElementType)referencedType).getPrimitiveType())) {
            this.handleTypeCycle(reporter);
        }
    }

    private void checkProtoCycle(ErrorReporter reporter) {
        JSType referencedType = this.getReferencedType();
        if (NamedType.areIdentical(referencedType, this)) {
            this.handleTypeCycle(reporter);
        }
    }

    private void handleUnresolvedType(ErrorReporter reporter, boolean ignoreForwardReferencedTypes) {
        boolean isForwardDeclared;
        boolean bl = isForwardDeclared = ignoreForwardReferencedTypes && this.registry.isForwardDeclaredType(this.reference);
        if (!isForwardDeclared) {
            String msg = "Bad type annotation. Unknown type " + this.reference;
            this.warning(reporter, msg);
        } else {
            this.setReferencedType(new NoResolvedType(this.registry, this.getReferenceName(), this.getTemplateTypes()));
            if (this.validator != null) {
                this.validator.apply((Object)this.getReferencedType());
            }
        }
        this.setResolvedTypeInternal(this.getReferencedType());
    }

    @Override
    public boolean setValidator(Predicate<JSType> validator) {
        if (this.isResolved()) {
            return super.setValidator(validator);
        }
        this.validator = validator;
        return true;
    }

    void warning(ErrorReporter reporter, String message) {
        reporter.warning(message, this.sourceName, this.lineno, this.charno);
    }

    @Override
    public boolean isObject() {
        if (this.isEnumElementType()) {
            return this.toMaybeEnumElementType().isObject();
        }
        return super.isObject();
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseNamedType(this);
    }

    private static final class PropertyContinuation {
        private final String propertyName;
        private final JSType type;
        private final boolean inferred;
        private final Node propertyNode;

        private PropertyContinuation(String propertyName, JSType type, boolean inferred, Node propertyNode) {
            this.propertyName = propertyName;
            this.type = type;
            this.inferred = inferred;
            this.propertyNode = propertyNode;
        }

        void commit(ObjectType target) {
            target.defineProperty(this.propertyName, this.type, this.inferred, this.propertyNode);
        }
    }
}

