/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.BlackHoleErrorManager;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DependencyOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.refactoring.JsFlumeCallback;
import com.google.javascript.refactoring.Scanner;
import com.google.javascript.refactoring.SuggestedFix;
import com.google.javascript.rhino.Node;
import java.util.List;
import java.util.regex.Pattern;

public final class RefactoringDriver {
    private final Compiler compiler;
    private final Node rootNode;

    private RefactoringDriver(List<SourceFile> inputs, List<SourceFile> externs, CompilerOptions compilerOptions) {
        this.compiler = RefactoringDriver.createCompiler(inputs, externs, compilerOptions);
        this.rootNode = this.compiler.getRoot();
    }

    public List<SuggestedFix> drive(Scanner scanner, Pattern includeFilePattern) {
        JsFlumeCallback callback = new JsFlumeCallback(scanner, includeFilePattern);
        NodeTraversal.traverse(this.compiler, this.rootNode, callback);
        List<SuggestedFix> fixes = callback.getFixes();
        fixes.addAll(scanner.processAllMatches(callback.getMatches()));
        return fixes;
    }

    public List<SuggestedFix> drive(Scanner scanner) {
        return this.drive(scanner, null);
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    private static Compiler createCompiler(List<SourceFile> inputs, List<SourceFile> externs, CompilerOptions compilerOptions) {
        Compiler compiler = new Compiler(new BlackHoleErrorManager());
        compiler.disableThreads();
        compiler.compile(externs, inputs, compilerOptions);
        return compiler;
    }

    @VisibleForTesting
    public static CompilerOptions getCompilerOptions() {
        CompilerOptions options = new CompilerOptions();
        options.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT_NEXT);
        options.setLanguageOut(CompilerOptions.LanguageMode.ECMASCRIPT5);
        options.setSummaryDetailLevel(0);
        DependencyOptions deps = new DependencyOptions();
        deps.setDependencySorting(true);
        options.setDependencyOptions(deps);
        options.setChecksOnly(true);
        options.setContinueAfterErrors(true);
        options.setParseJsDocDocumentation(Config.JsDocParsing.INCLUDE_DESCRIPTIONS_NO_WHITESPACE);
        options.setCheckSuspiciousCode(true);
        options.setCheckSymbols(true);
        options.setCheckTypes(true);
        options.setBrokenClosureRequiresLevel(CheckLevel.OFF);
        options.setClosurePass(true);
        options.setGenerateExports(true);
        options.setPreserveClosurePrimitives(true);
        options.setWarningLevel(DiagnosticGroups.STRICT_MISSING_REQUIRE, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.EXTRA_REQUIRE, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.LINT_CHECKS, CheckLevel.WARNING);
        return options;
    }

    public static class Builder {
        private static final Function<String, SourceFile> TO_SOURCE_FILE_FN = file -> new SourceFile.Builder().buildFromFile((String)file);
        private final ImmutableList.Builder<SourceFile> inputs = ImmutableList.builder();
        private final ImmutableList.Builder<SourceFile> externs = ImmutableList.builder();
        private CompilerOptions compilerOptions = RefactoringDriver.getCompilerOptions();

        public Builder addExternsFromFile(String filename) {
            this.externs.add((Object)SourceFile.fromFile(filename));
            return this;
        }

        public Builder addExternsFromFile(Iterable<String> externs) {
            this.externs.addAll((Iterable)Lists.transform((List)ImmutableList.copyOf(externs), TO_SOURCE_FILE_FN));
            return this;
        }

        public Builder addExternsFromCode(String code) {
            this.externs.add((Object)SourceFile.fromCode("externs", code));
            return this;
        }

        public Builder addExterns(Iterable<SourceFile> externs) {
            this.externs.addAll(externs);
            return this;
        }

        public Builder addInputsFromFile(String filename) {
            this.inputs.add((Object)SourceFile.fromFile(filename));
            return this;
        }

        public Builder addInputsFromFile(Iterable<String> inputs) {
            this.inputs.addAll((Iterable)Lists.transform((List)ImmutableList.copyOf(inputs), TO_SOURCE_FILE_FN));
            return this;
        }

        public Builder addInputsFromCode(String code) {
            return this.addInputsFromCode(code, "input");
        }

        public Builder addInputsFromCode(String code, String filename) {
            this.inputs.add((Object)SourceFile.fromCode(filename, code));
            return this;
        }

        public Builder addInputs(Iterable<SourceFile> inputs) {
            this.inputs.addAll(inputs);
            return this;
        }

        public Builder withCompilerOptions(CompilerOptions compilerOptions) {
            this.compilerOptions = (CompilerOptions)Preconditions.checkNotNull((Object)compilerOptions);
            return this;
        }

        public RefactoringDriver build() {
            return new RefactoringDriver((List)this.inputs.build(), (List)this.externs.build(), this.compilerOptions);
        }
    }
}

