/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Reference;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.ReferenceCollection;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.VariableVisibilityAnalysis;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class SideEffectsAnalysis
implements CompilerPass {
    private static final Predicate<Node> NOT_FUNCTION_PREDICATE = new Predicate<Node>(){

        public boolean apply(Node input) {
            return !input.isFunction();
        }
    };
    private final AbstractCompiler compiler;
    private LocationAbstraction locationAbstraction;
    private final LocationAbstractionMode locationAbstractionIdentifier;

    public SideEffectsAnalysis(AbstractCompiler compiler, LocationAbstractionMode locationAbstractionMode) {
        this.compiler = compiler;
        this.locationAbstractionIdentifier = locationAbstractionMode;
    }

    public SideEffectsAnalysis(AbstractCompiler compiler) {
        this(compiler, LocationAbstractionMode.DEGENERATE);
    }

    @Override
    public void process(Node externs, Node root) {
        switch (this.locationAbstractionIdentifier) {
            case DEGENERATE: {
                this.locationAbstraction = new DegenerateLocationAbstraction();
                break;
            }
            case VISIBILITY_BASED: {
                this.locationAbstraction = this.createVisibilityAbstraction(externs, root);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized location abstraction identifier: " + (Object)((Object)this.locationAbstractionIdentifier));
            }
        }
    }

    private LocationAbstraction createVisibilityAbstraction(Node externs, Node root) {
        VariableVisibilityAnalysis variableVisibility = new VariableVisibilityAnalysis(this.compiler);
        variableVisibility.process(externs, root);
        VariableUseDeclarationMap variableMap = new VariableUseDeclarationMap(this.compiler);
        variableMap.mapUses(root);
        return new VisibilityLocationAbstraction(this.compiler, variableVisibility, variableMap);
    }

    public boolean safeToMoveBefore(Node source, AbstractMotionEnvironment environment, Node destination) {
        Preconditions.checkNotNull((Object)this.locationAbstraction);
        Preconditions.checkArgument((!SideEffectsAnalysis.nodeHasAncestor(destination, source) ? 1 : 0) != 0);
        if (SideEffectsAnalysis.isPure(source)) {
            return true;
        }
        if (SideEffectsAnalysis.nodeHasCall(source)) {
            return false;
        }
        LocationSummary sourceLocationSummary = this.locationAbstraction.calculateLocationSummary(source);
        EffectLocation sourceModSet = sourceLocationSummary.getModSet();
        if (!sourceModSet.isEmpty() && !SideEffectsAnalysis.nodesHaveSameControlFlow(source, destination)) {
            return false;
        }
        EffectLocation sourceRefSet = sourceLocationSummary.getRefSet();
        Set<Node> environmentNodes = environment.calculateEnvironment();
        for (Node environmentNode : environmentNodes) {
            if (!SideEffectsAnalysis.nodeHasCall(environmentNode)) continue;
            return false;
        }
        LocationSummary environmentLocationSummary = this.locationAbstraction.calculateLocationSummary(environmentNodes);
        EffectLocation environmentModSet = environmentLocationSummary.getModSet();
        EffectLocation environmentRefSet = environmentLocationSummary.getRefSet();
        return !environmentModSet.intersectsLocation(sourceRefSet) && !environmentRefSet.intersectsLocation(sourceModSet) && !environmentModSet.intersectsLocation(sourceModSet);
    }

    private static boolean isPure(Node node) {
        return false;
    }

    private static boolean nodesHaveSameControlFlow(Node node1, Node node2) {
        Node node2DeepestControlDependentBlock;
        Node node1DeepestControlDependentBlock = SideEffectsAnalysis.closestControlDependentAncestor(node1);
        if (node1DeepestControlDependentBlock == (node2DeepestControlDependentBlock = SideEffectsAnalysis.closestControlDependentAncestor(node2))) {
            if (node2DeepestControlDependentBlock != null) {
                if (node2DeepestControlDependentBlock.isCase()) {
                    return false;
                }
                Predicate<Node> isEarlyExitPredicate = new Predicate<Node>(){

                    public boolean apply(Node input) {
                        Token nodeType = input.getToken();
                        return nodeType == Token.RETURN || nodeType == Token.BREAK || nodeType == Token.CONTINUE;
                    }
                };
                return !NodeUtil.has(node2DeepestControlDependentBlock, isEarlyExitPredicate, NOT_FUNCTION_PREDICATE);
            }
            return true;
        }
        return false;
    }

    private static boolean isControlDependentChild(Node child) {
        Node parent = child.getParent();
        if (parent == null) {
            return false;
        }
        ArrayList siblings = new ArrayList();
        Iterables.addAll(siblings, parent.children());
        int indexOfChildInParent = siblings.indexOf(child);
        switch (parent.getToken()) {
            case IF: 
            case HOOK: {
                return indexOfChildInParent == 1 || indexOfChildInParent == 2;
            }
            case FOR: 
            case FOR_IN: {
                return indexOfChildInParent != 0;
            }
            case SWITCH: {
                return indexOfChildInParent > 0;
            }
            case WHILE: 
            case DO: 
            case AND: 
            case OR: 
            case FUNCTION: {
                return true;
            }
        }
        return false;
    }

    private static Node closestControlDependentAncestor(Node node) {
        if (SideEffectsAnalysis.isControlDependentChild(node)) {
            return node;
        }
        for (Node ancestor : node.getAncestors()) {
            if (!SideEffectsAnalysis.isControlDependentChild(ancestor)) continue;
            return ancestor;
        }
        return null;
    }

    private static boolean nodeHasAncestor(Node node, Node possibleAncestor) {
        for (Node ancestor : node.getAncestors()) {
            if (ancestor != possibleAncestor) continue;
            return true;
        }
        return false;
    }

    private static boolean nodeHasCall(Node node) {
        return NodeUtil.has(node, new Predicate<Node>(){

            public boolean apply(Node input) {
                return input.isCall() || input.isNew() || input.isTaggedTemplateLit();
            }
        }, NOT_FUNCTION_PREDICATE);
    }

    private static class VariableUseDeclarationMap {
        private final AbstractCompiler compiler;
        private Map<Node, Node> referencesByNameNode;

        public VariableUseDeclarationMap(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        public void mapUses(Node root) {
            this.referencesByNameNode = new HashMap<Node, Node>();
            ReferenceCollectingCallback callback = new ReferenceCollectingCallback(this.compiler, ReferenceCollectingCallback.DO_NOTHING_BEHAVIOR, new Es6SyntacticScopeCreator(this.compiler));
            callback.process(root);
            for (Var variable : callback.getAllSymbols()) {
                ReferenceCollection referenceCollection = callback.getReferences(variable);
                for (Reference reference : referenceCollection.references) {
                    Node referenceNameNode = reference.getNode();
                    this.referencesByNameNode.put(referenceNameNode, variable.getNameNode());
                }
            }
        }

        public Node findDeclaringNameNodeForUse(Node usingNameNode) {
            Preconditions.checkArgument((boolean)usingNameNode.isName());
            return this.referencesByNameNode.get(usingNameNode);
        }
    }

    private static class VisibilityLocationAbstraction
    extends LocationAbstraction {
        private static final int VISIBILITY_LOCATION_NONE = 0;
        private static final int UNKNOWN_LOCATION_MASK = -1;
        private static final int LOCAL_VARIABLE_LOCATION_MASK = 2;
        private static final int CAPTURED_LOCAL_VARIABLE_LOCATION_MASK = 4;
        private static final int GLOBAL_VARIABLE_LOCATION_MASK = 8;
        private static final int HEAP_LOCATION_MASK = 16;
        AbstractCompiler compiler;
        VariableVisibilityAnalysis variableVisibilityAnalysis;
        VariableUseDeclarationMap variableUseMap;

        private VisibilityLocationAbstraction(AbstractCompiler compiler, VariableVisibilityAnalysis variableVisibilityAnalysis, VariableUseDeclarationMap variableUseMap) {
            this.compiler = compiler;
            this.variableVisibilityAnalysis = variableVisibilityAnalysis;
            this.variableUseMap = variableUseMap;
        }

        @Override
        LocationSummary calculateLocationSummary(Node node) {
            int visibilityRefLocations = 0;
            int visibilityModLocations = 0;
            for (Node reference : this.findStorageLocationReferences(node)) {
                int effectMask = reference.isName() ? this.effectMaskForVariableReference(reference) : 16;
                if (VisibilityLocationAbstraction.storageNodeIsLValue(reference)) {
                    visibilityModLocations |= effectMask;
                }
                if (!VisibilityLocationAbstraction.storageNodeIsRValue(reference)) continue;
                visibilityRefLocations |= effectMask;
            }
            VisibilityBasedEffectLocation modSet = new VisibilityBasedEffectLocation(visibilityModLocations);
            VisibilityBasedEffectLocation refSet = new VisibilityBasedEffectLocation(visibilityRefLocations);
            return new LocationSummary(modSet, refSet);
        }

        private Set<Node> findStorageLocationReferences(Node root) {
            final HashSet<Node> references = new HashSet<Node>();
            NodeTraversal.traverse(this.compiler, root, new NodeTraversal.AbstractShallowCallback(){

                @Override
                public void visit(NodeTraversal t, Node n, Node parent) {
                    if (NodeUtil.isGet(n) || n.isName() && !parent.isFunction()) {
                        references.add(n);
                    }
                }
            });
            return references;
        }

        private int effectMaskForVariableReference(Node variableReference) {
            Preconditions.checkArgument((boolean)variableReference.isName());
            int effectMask = 0;
            Node declaringNameNode = this.variableUseMap.findDeclaringNameNodeForUse(variableReference);
            if (declaringNameNode != null) {
                VariableVisibilityAnalysis.VariableVisibility visibility = this.variableVisibilityAnalysis.getVariableVisibility(declaringNameNode);
                switch (visibility) {
                    case LOCAL: {
                        effectMask = 2;
                        break;
                    }
                    case CAPTURED_LOCAL: {
                        effectMask = 4;
                        break;
                    }
                    case PARAMETER: {
                        effectMask = 16;
                        break;
                    }
                    case GLOBAL: {
                        effectMask = 8;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unrecognized variable visibility: " + (Object)((Object)visibility));
                    }
                }
            } else {
                effectMask = -1;
            }
            return effectMask;
        }

        @Override
        EffectLocation getBottomLocation() {
            return new VisibilityBasedEffectLocation(0);
        }

        private static boolean isStorageNode(Node node) {
            return node.isName() || NodeUtil.isGet(node);
        }

        private static boolean storageNodeIsRValue(Node node) {
            Preconditions.checkArgument((boolean)VisibilityLocationAbstraction.isStorageNode(node));
            Node parent = node.getParent();
            if (VisibilityLocationAbstraction.storageNodeIsLValue(node)) {
                boolean nonSimpleAssign = NodeUtil.isAssignmentOp(parent) && !parent.isAssign();
                return nonSimpleAssign || parent.isDec() || parent.isInc();
            }
            return true;
        }

        private static boolean storageNodeIsLValue(Node node) {
            Preconditions.checkArgument((boolean)VisibilityLocationAbstraction.isStorageNode(node));
            return NodeUtil.isLValue(node);
        }

        private static class VisibilityBasedEffectLocation
        implements EffectLocation {
            int visibilityMask = 0;

            public VisibilityBasedEffectLocation(int visibilityMask) {
                this.visibilityMask = visibilityMask;
            }

            @Override
            public boolean intersectsLocation(EffectLocation otherLocation) {
                Preconditions.checkArgument((boolean)(otherLocation instanceof VisibilityBasedEffectLocation));
                int otherMask = ((VisibilityBasedEffectLocation)otherLocation).visibilityMask;
                return (this.visibilityMask & otherMask) > 0;
            }

            @Override
            public boolean isEmpty() {
                return this.visibilityMask == 0;
            }

            @Override
            public EffectLocation join(EffectLocation otherLocation) {
                Preconditions.checkArgument((boolean)(otherLocation instanceof VisibilityBasedEffectLocation));
                int otherMask = ((VisibilityBasedEffectLocation)otherLocation).visibilityMask;
                int joinedMask = this.visibilityMask | otherMask;
                return new VisibilityBasedEffectLocation(joinedMask);
            }
        }
    }

    private static class DegenerateLocationAbstraction
    extends LocationAbstraction {
        private static final EffectLocation EVERY_LOCATION = new DegenerateEffectLocation();
        private static final EffectLocation NO_LOCATION = new DegenerateEffectLocation();

        private DegenerateLocationAbstraction() {
        }

        @Override
        EffectLocation getBottomLocation() {
            return NO_LOCATION;
        }

        @Override
        public LocationSummary calculateLocationSummary(Node node) {
            return new LocationSummary(DegenerateLocationAbstraction.calculateModSet(node), DegenerateLocationAbstraction.calculateRefSet(node));
        }

        static EffectLocation calculateRefSet(Node node) {
            if (NodeUtil.canBeSideEffected(node)) {
                return EVERY_LOCATION;
            }
            return NO_LOCATION;
        }

        static EffectLocation calculateModSet(Node node) {
            if (NodeUtil.mayHaveSideEffects(node)) {
                return EVERY_LOCATION;
            }
            return NO_LOCATION;
        }

        private static class DegenerateEffectLocation
        implements EffectLocation {
            private DegenerateEffectLocation() {
            }

            @Override
            public EffectLocation join(EffectLocation otherLocation) {
                if (otherLocation == EVERY_LOCATION) {
                    return otherLocation;
                }
                return this;
            }

            @Override
            public boolean intersectsLocation(EffectLocation otherLocation) {
                return this == EVERY_LOCATION && otherLocation == EVERY_LOCATION;
            }

            @Override
            public boolean isEmpty() {
                return this == NO_LOCATION;
            }
        }
    }

    private static abstract class LocationAbstraction {
        private LocationAbstraction() {
        }

        abstract LocationSummary calculateLocationSummary(Node var1);

        public LocationSummary calculateLocationSummary(Set<Node> nodes) {
            EffectLocation modAccumulator = this.getBottomLocation();
            EffectLocation refAccumulator = this.getBottomLocation();
            for (Node node : nodes) {
                LocationSummary nodeLocationSummary = this.calculateLocationSummary(node);
                modAccumulator = modAccumulator.join(nodeLocationSummary.getModSet());
                refAccumulator = refAccumulator.join(nodeLocationSummary.getRefSet());
            }
            return new LocationSummary(modAccumulator, refAccumulator);
        }

        abstract EffectLocation getBottomLocation();
    }

    private static interface EffectLocation {
        public boolean intersectsLocation(EffectLocation var1);

        public EffectLocation join(EffectLocation var1);

        public boolean isEmpty();
    }

    private static class LocationSummary {
        private final EffectLocation modSet;
        private final EffectLocation refSet;

        public LocationSummary(EffectLocation modSet, EffectLocation refSet) {
            this.modSet = modSet;
            this.refSet = refSet;
        }

        public EffectLocation getModSet() {
            return this.modSet;
        }

        public EffectLocation getRefSet() {
            return this.refSet;
        }
    }

    public static class RawMotionEnvironment
    extends AbstractMotionEnvironment {
        Set<Node> environment;

        public RawMotionEnvironment(Set<Node> environment) {
            this.environment = environment;
        }

        @Override
        public Set<Node> calculateEnvironment() {
            return this.environment;
        }
    }

    public static class CrossModuleMotionEnvironment
    extends AbstractMotionEnvironment {
        public CrossModuleMotionEnvironment(Node sourceNode, JSModule sourceModule, Node destinationNode, JSModule destinationModule, JSModuleGraph moduleGraph) {
        }

        @Override
        public Set<Node> calculateEnvironment() {
            return null;
        }
    }

    public static class IntraproceduralMotionEnvironment
    extends AbstractMotionEnvironment {
        public IntraproceduralMotionEnvironment(ControlFlowGraph<Node> controlFlowGraph, Node cfgSource, Node cfgDestination) {
        }

        @Override
        public Set<Node> calculateEnvironment() {
            return null;
        }
    }

    public static abstract class AbstractMotionEnvironment {
        public abstract Set<Node> calculateEnvironment();
    }

    static enum LocationAbstractionMode {
        DEGENERATE,
        VISIBILITY_BASED;

    }
}

