/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class OptimizeReturns
implements OptimizeCalls.CallGraphCompilerPass,
CompilerPass {
    private final AbstractCompiler compiler;

    OptimizeReturns(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    @VisibleForTesting
    public void process(Node externs, Node root) {
        OptimizeCalls.ReferenceMap refMap = OptimizeCalls.buildPropAndGlobalNameReferenceMap(this.compiler, externs, root);
        this.process(externs, root, refMap);
    }

    @Override
    public void process(Node externs, Node root, OptimizeCalls.ReferenceMap definitions) {
        ArrayList<Node> refs;
        String key;
        ArrayList<ArrayList<Node>> toOptimize = new ArrayList<ArrayList<Node>>();
        for (Map.Entry<String, ArrayList<Node>> entry : definitions.getNameReferences()) {
            key = entry.getKey();
            if (!this.isCandidate(key, refs = entry.getValue())) continue;
            toOptimize.add(refs);
        }
        for (Map.Entry<String, ArrayList<Node>> entry : definitions.getPropReferences()) {
            key = entry.getKey();
            if (!this.isCandidate(key, refs = entry.getValue())) continue;
            toOptimize.add(refs);
        }
        for (ArrayList arrayList : toOptimize) {
            for (Node fn : OptimizeCalls.ReferenceMap.getFunctionNodes(arrayList)) {
                this.rewriteReturns(fn);
            }
        }
    }

    private boolean isCandidate(String name, List<Node> refs) {
        if (!OptimizeCalls.mayBeOptimizableName(this.compiler, name)) {
            return false;
        }
        boolean seenCandidateDefiniton = false;
        boolean seenUse = false;
        for (Node n : refs) {
            if (OptimizeCalls.ReferenceMap.isCallTarget(n)) {
                Node callNode = OptimizeCalls.ReferenceMap.getCallOrNewNodeForTarget(n);
                if (NodeUtil.isExpressionResultUsed(callNode)) {
                    return false;
                }
                seenUse = true;
                continue;
            }
            if (this.isCandidateDefinition(n)) {
                seenCandidateDefiniton = true;
                continue;
            }
            if (OptimizeCalls.isAllowedReference(n)) continue;
            return false;
        }
        return seenUse && seenCandidateDefiniton;
    }

    private boolean isCandidateDefinition(Node n) {
        Node parent = n.getParent();
        if (parent.isFunction() && NodeUtil.isFunctionDeclaration(parent)) {
            return true;
        }
        return OptimizeCalls.ReferenceMap.isSimpleAssignmentTarget(n) ? OptimizeReturns.isCandidateFunction(parent.getLastChild()) : (n.isName() ? n.hasChildren() && OptimizeReturns.isCandidateFunction(n.getFirstChild()) : this.isClassMemberDefinition(n));
    }

    private boolean isClassMemberDefinition(Node n) {
        return n.isMemberFunctionDef() && n.getParent().isClassMembers();
    }

    private static boolean isCandidateFunction(Node n) {
        switch (n.getToken()) {
            case FUNCTION: {
                return !NodeUtil.isNamedFunctionExpression(n);
            }
            case COMMA: 
            case CAST: {
                return OptimizeReturns.isCandidateFunction(n.getLastChild());
            }
            case HOOK: {
                return OptimizeReturns.isCandidateFunction(n.getSecondChild()) && OptimizeReturns.isCandidateFunction(n.getLastChild());
            }
            case OR: 
            case AND: {
                return OptimizeReturns.isCandidateFunction(n.getFirstChild()) && OptimizeReturns.isCandidateFunction(n.getLastChild());
            }
        }
        return false;
    }

    private void rewriteReturns(Node fnNode) {
        Preconditions.checkState((boolean)fnNode.isFunction());
        final Node body = fnNode.getLastChild();
        NodeUtil.visitPostOrder(body, new NodeUtil.Visitor(){

            @Override
            public void visit(Node n) {
                if (n.isReturn() && n.hasOneChild()) {
                    Node result = n.getFirstChild();
                    boolean keepValue = !OptimizeReturns.this.isRemovableValue(result);
                    result.detach();
                    if (keepValue) {
                        n.getParent().addChildBefore(IR.exprResult(result).srcref(result), n);
                    } else {
                        NodeUtil.markFunctionsDeleted(result, OptimizeReturns.this.compiler);
                    }
                    OptimizeReturns.this.compiler.reportChangeToEnclosingScope(body);
                }
            }
        }, new NodeUtil.MatchShallowStatement());
    }

    private boolean isRemovableValue(Node n) {
        switch (n.getToken()) {
            case TEMPLATELIT: 
            case ARRAYLIT: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    if (child.isEmpty() || this.isRemovableValue(child)) continue;
                    return false;
                }
                return true;
            }
            case REGEXP: 
            case STRING: 
            case NUMBER: 
            case NULL: 
            case TRUE: 
            case FALSE: 
            case TEMPLATELIT_STRING: {
                return true;
            }
            case CAST: 
            case TEMPLATELIT_SUB: 
            case NOT: 
            case VOID: 
            case NEG: {
                return this.isRemovableValue(n.getFirstChild());
            }
        }
        return false;
    }
}

