/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.Reference;
import com.google.javascript.jscomp.ReferenceCollection;
import com.google.javascript.jscomp.ReferenceMap;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class GlobalVarReferenceMap
implements ReferenceMap {
    private Map<String, ReferenceCollection> refMap = null;
    private final Map<InputId, Integer> inputOrder = new HashMap<InputId, Integer>();

    GlobalVarReferenceMap(Iterable<CompilerInput> inputs, Iterable<CompilerInput> externs) {
        int ind = 0;
        for (CompilerInput extern : externs) {
            this.inputOrder.put(extern.getInputId(), ind);
            ++ind;
        }
        for (CompilerInput input : inputs) {
            this.inputOrder.put(input.getInputId(), ind);
            ++ind;
        }
    }

    @Override
    public ReferenceCollection getReferences(Var var) {
        if (!var.isGlobal()) {
            return null;
        }
        return this.refMap.get(var.getName());
    }

    private void resetGlobalVarReferences(Map<Var, ReferenceCollection> globalRefMap) {
        this.refMap = new LinkedHashMap<String, ReferenceCollection>();
        for (Map.Entry<Var, ReferenceCollection> entry : globalRefMap.entrySet()) {
            Var var = entry.getKey();
            if (!var.isGlobal()) continue;
            this.refMap.put(var.getName(), entry.getValue());
        }
    }

    void updateGlobalVarReferences(Map<Var, ReferenceCollection> refMapPatch, Node root) {
        if (this.refMap == null || !root.isScript()) {
            this.resetGlobalVarReferences(refMapPatch);
            return;
        }
        InputId inputId = root.getInputId();
        Preconditions.checkNotNull((Object)inputId);
        this.removeScriptReferences(inputId);
        for (Map.Entry<Var, ReferenceCollection> entry : refMapPatch.entrySet()) {
            Var var = entry.getKey();
            if (!var.isGlobal()) continue;
            this.replaceReferences(var.getName(), inputId, entry.getValue());
        }
    }

    private void removeScriptReferences(InputId inputId) {
        Preconditions.checkNotNull((Object)inputId);
        if (!this.inputOrder.containsKey(inputId)) {
            return;
        }
        for (ReferenceCollection collection : this.refMap.values()) {
            if (collection == null) continue;
            List<Reference> oldRefs = collection.references;
            SourceRefRange range = this.findSourceRefRange(oldRefs, inputId);
            ArrayList<Reference> newRefs = new ArrayList<Reference>(range.refsBefore());
            newRefs.addAll(range.refsAfter());
            collection.references = newRefs;
        }
    }

    private void replaceReferences(String varName, InputId inputId, ReferenceCollection newSourceCollection) {
        ReferenceCollection combined = new ReferenceCollection();
        List<Reference> combinedRefs = combined.references;
        ReferenceCollection oldCollection = this.refMap.get(varName);
        this.refMap.put(varName, combined);
        if (oldCollection == null) {
            combinedRefs.addAll(newSourceCollection.references);
            return;
        }
        SourceRefRange range = this.findSourceRefRange(oldCollection.references, inputId);
        combinedRefs.addAll(range.refsBefore());
        combinedRefs.addAll(newSourceCollection.references);
        combinedRefs.addAll(range.refsAfter());
    }

    private SourceRefRange findSourceRefRange(List<Reference> refList, InputId inputId) {
        Preconditions.checkNotNull((Object)inputId);
        int lastBefore = -1;
        int firstAfter = refList.size();
        int index = 0;
        Preconditions.checkState((boolean)this.inputOrder.containsKey(inputId), (Object)inputId.getIdName());
        int sourceInputOrder = this.inputOrder.get(inputId);
        for (Reference ref : refList) {
            Preconditions.checkNotNull((Object)ref.getInputId());
            int order = this.inputOrder.get(ref.getInputId());
            if (order < sourceInputOrder) {
                lastBefore = index;
            } else if (order > sourceInputOrder) {
                firstAfter = index;
                break;
            }
            ++index;
        }
        return new SourceRefRange(refList, lastBefore, firstAfter);
    }

    public void updateReferencesWithGlobalScope(Scope globalScope) {
        for (ReferenceCollection collection : this.refMap.values()) {
            ArrayList<Reference> newRefs = new ArrayList<Reference>(collection.references.size());
            for (Reference ref : collection) {
                if (ref.getScope() != globalScope) {
                    newRefs.add(ref.cloneWithNewScope(globalScope));
                    continue;
                }
                newRefs.add(ref);
            }
            collection.references = newRefs;
        }
    }

    static class GlobalVarRefCleanupPass
    implements HotSwapCompilerPass {
        private final AbstractCompiler compiler;

        public GlobalVarRefCleanupPass(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public void hotSwapScript(Node scriptRoot, Node originalRoot) {
            GlobalVarReferenceMap refMap = this.compiler.getGlobalVarReferences();
            if (refMap != null) {
                refMap.updateReferencesWithGlobalScope(Scope.createGlobalScope(this.compiler.getTopScope().getRootNode()));
            }
        }

        @Override
        public void process(Node externs, Node root) {
        }
    }

    private static class SourceRefRange {
        private final int lastBefore;
        private final int firstAfter;
        private final List<Reference> refList;

        SourceRefRange(List<Reference> refList, int lastBefore, int firstAfter) {
            this.lastBefore = Math.max(lastBefore, -1);
            this.firstAfter = Math.min(firstAfter, refList.size());
            this.refList = refList;
        }

        List<Reference> refsBefore() {
            return this.refList.subList(0, this.lastBefore + 1);
        }

        List<Reference> refsAfter() {
            return this.refList.subList(this.firstAfter, this.refList.size());
        }
    }
}

