/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.NominalTypeBuilder;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@Immutable
public interface CodingConvention
extends Serializable {
    public boolean isConstant(String var1);

    public boolean isConstantKey(String var1);

    public boolean isValidEnumKey(String var1);

    public boolean isOptionalParameter(Node var1);

    public boolean isVarArgsParameter(Node var1);

    public boolean isFunctionCallThatAlwaysThrows(Node var1);

    public boolean isExported(String var1, boolean var2);

    public boolean isExported(String var1);

    public boolean blockRenamingForProperty(String var1);

    public String getPackageName(StaticSourceFile var1);

    public boolean isPrivate(String var1);

    public boolean hasPrivacyConvention();

    public SubclassRelationship getClassesDefinedByCall(Node var1);

    public boolean isClassFactoryCall(Node var1);

    public boolean isSuperClassReference(String var1);

    public boolean extractIsModuleFile(Node var1, Node var2);

    public String extractClassNameIfProvide(Node var1, Node var2);

    public String extractClassNameIfRequire(Node var1, Node var2);

    public String getExportPropertyFunction();

    public String getExportSymbolFunction();

    public List<String> identifyTypeDeclarationCall(Node var1);

    public void applySubclassRelationship(NominalTypeBuilder var1, NominalTypeBuilder var2, SubclassType var3);

    public String getAbstractMethodName();

    public String getSingletonGetterClassName(Node var1);

    public void applySingletonGetter(NominalTypeBuilder var1, FunctionType var2);

    public boolean isInlinableFunction(Node var1);

    public DelegateRelationship getDelegateRelationship(Node var1);

    public void applyDelegateRelationship(NominalTypeBuilder var1, NominalTypeBuilder var2, NominalTypeBuilder var3, ObjectType var4, FunctionType var5);

    public String getDelegateSuperclassName();

    public void checkForCallingConventionDefinitions(Node var1, Map<String, String> var2);

    public void defineDelegateProxyPrototypeProperties(JSTypeRegistry var1, List<NominalTypeBuilder> var2, Map<String, String> var3);

    public String getGlobalObject();

    public boolean isAliasingGlobalThis(Node var1);

    public Bind describeFunctionBind(Node var1);

    public Bind describeFunctionBind(Node var1, boolean var2, boolean var3);

    public Cache describeCachingCall(Node var1);

    public boolean isPropertyTestFunction(Node var1);

    public boolean isPrototypeAlias(Node var1);

    public boolean isPropertyRenameFunction(String var1);

    public ObjectLiteralCast getObjectLiteralCast(Node var1);

    public Collection<String> getIndirectlyDeclaredProperties();

    public Collection<AssertionFunctionSpec> getAssertionFunctions();

    public static class AssertionFunctionSpec {
        protected final String functionName;
        protected final JSTypeNative assertedType;

        @Deprecated
        public AssertionFunctionSpec(String functionName) {
            this(functionName, null);
        }

        public AssertionFunctionSpec(String functionName, JSTypeNative assertedType) {
            this.functionName = functionName;
            this.assertedType = assertedType;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public Node getAssertedParam(Node firstParam) {
            return firstParam;
        }

        public JSType getAssertedOldType(Node call, JSTypeRegistry registry) {
            return this.assertedType != null ? registry.getNativeType(this.assertedType) : null;
        }
    }

    public static class ObjectLiteralCast {
        final String typeName;
        final Node objectNode;
        final DiagnosticType diagnosticType;

        ObjectLiteralCast(String typeName, Node objectNode, DiagnosticType diagnosticType) {
            this.typeName = typeName;
            this.objectNode = objectNode;
            this.diagnosticType = diagnosticType;
        }
    }

    public static class DelegateRelationship {
        final String delegateBase;
        final String delegator;

        DelegateRelationship(String delegateBase, String delegator) {
            this.delegateBase = delegateBase;
            this.delegator = delegator;
        }
    }

    public static class SubclassRelationship {
        final SubclassType type;
        final String subclassName;
        final String superclassName;

        public SubclassRelationship(SubclassType type, Node subclassNode, Node superclassNode) {
            Preconditions.checkArgument((boolean)subclassNode.isQualifiedName(), (String)"Expected qualified name, found: %s", (Object)subclassNode);
            Preconditions.checkArgument((boolean)superclassNode.isQualifiedName(), (String)"Expected qualified name, found: %s", (Object)superclassNode);
            this.type = type;
            this.subclassName = subclassNode.getQualifiedName();
            this.superclassName = superclassNode.getQualifiedName();
        }
    }

    public static enum SubclassType {
        INHERITS,
        MIXIN;

    }

    public static class Cache {
        final Node cacheObj;
        final Node key;
        final Node valueFn;
        final Node keyFn;

        public Cache(Node cacheObj, Node key, Node valueFn, Node keyFn) {
            this.cacheObj = cacheObj;
            this.key = key;
            this.valueFn = valueFn;
            this.keyFn = keyFn;
        }
    }

    public static class Bind {
        final Node target;
        final Node thisValue;
        final Node parameters;

        public Bind(Node target, Node thisValue, Node parameters) {
            this.target = target;
            this.thisValue = thisValue;
            this.parameters = parameters;
        }

        int getBoundParameterCount() {
            if (this.parameters == null) {
                return 0;
            }
            Node paramParent = this.parameters.getParent();
            return paramParent.getChildCount() - paramParent.getIndexOfChild(this.parameters);
        }
    }
}

