/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.parsing.Annotation;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import java.util.Set;

public final class Config {
    final JsDocParsing parseJsDocDocumentation;
    final RunMode keepGoing;
    final ImmutableMap<String, Annotation> annotationNames;
    final ImmutableSet<String> suppressionNames;
    final LanguageMode languageMode;
    final StrictMode strictMode;
    final boolean parseInlineSourceMaps;

    Config(Set<String> annotationWhitelist, Set<String> suppressionNames, LanguageMode languageMode, StrictMode strictMode) {
        this(annotationWhitelist, JsDocParsing.TYPES_ONLY, RunMode.STOP_AFTER_ERROR, suppressionNames, languageMode, false, strictMode);
    }

    Config(Set<String> annotationWhitelist, JsDocParsing parseJsDocDocumentation, RunMode keepGoing, Set<String> suppressionNames, LanguageMode languageMode, boolean parseInlineSourceMaps, StrictMode strictMode) {
        this.parseInlineSourceMaps = parseInlineSourceMaps;
        this.annotationNames = Config.buildAnnotationNames(annotationWhitelist);
        this.parseJsDocDocumentation = parseJsDocDocumentation;
        this.keepGoing = keepGoing;
        this.suppressionNames = ImmutableSet.copyOf(suppressionNames);
        this.languageMode = languageMode;
        this.strictMode = strictMode;
    }

    private static ImmutableMap<String, Annotation> buildAnnotationNames(Set<String> annotationWhitelist) {
        ImmutableMap.Builder annotationBuilder = ImmutableMap.builder();
        annotationBuilder.putAll(Annotation.recognizedAnnotations);
        for (String unrecognizedAnnotation : annotationWhitelist) {
            if (unrecognizedAnnotation.isEmpty() || Annotation.recognizedAnnotations.containsKey(unrecognizedAnnotation)) continue;
            annotationBuilder.put((Object)unrecognizedAnnotation, (Object)Annotation.NOT_IMPLEMENTED);
        }
        return annotationBuilder.build();
    }

    public static enum RunMode {
        STOP_AFTER_ERROR,
        KEEP_GOING;

    }

    public static enum JsDocParsing {
        TYPES_ONLY,
        INCLUDE_DESCRIPTIONS_NO_WHITESPACE,
        INCLUDE_DESCRIPTIONS_WITH_WHITESPACE;


        boolean shouldParseDescriptions() {
            return this != TYPES_ONLY;
        }
    }

    public static enum LanguageMode {
        ECMASCRIPT3(FeatureSet.ES3),
        ECMASCRIPT5(FeatureSet.ES5),
        ECMASCRIPT6(FeatureSet.ES6_MODULES),
        ECMASCRIPT7(FeatureSet.ES7_MODULES),
        ECMASCRIPT8(FeatureSet.ES8_MODULES),
        TYPESCRIPT(FeatureSet.TYPESCRIPT);

        public final FeatureSet featureSet;

        private LanguageMode(FeatureSet featureSet) {
            this.featureSet = featureSet;
        }

        public static LanguageMode minimumRequiredFor(FeatureSet.Feature feature) {
            for (LanguageMode mode : LanguageMode.values()) {
                if (!mode.featureSet.has(feature)) continue;
                return mode;
            }
            throw new IllegalStateException("No input language mode supports feature: " + (Object)((Object)feature));
        }

        public static LanguageMode minimumRequiredForSet(FeatureSet featureSet) {
            for (LanguageMode mode : LanguageMode.values()) {
                if (!mode.featureSet.contains(featureSet)) continue;
                return mode;
            }
            throw new IllegalStateException("No input language mode supports feature set: " + featureSet);
        }

        public static LanguageMode latestEcmaScript() {
            return ECMASCRIPT8;
        }
    }

    public static enum StrictMode {
        STRICT,
        SLOPPY;

    }
}

