/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import java.io.Serializable;

public final class Typedef
implements Serializable {
    private final Node defSite;
    private State state;
    private JSTypeExpression typeExpr;
    private JSType type;

    private Typedef(Node defSite, JSTypeExpression typeExpr) {
        Preconditions.checkState((boolean)defSite.isQualifiedName(), (Object)defSite);
        this.defSite = defSite;
        this.state = State.NOT_RESOLVED;
        this.type = null;
        this.typeExpr = typeExpr;
    }

    public static Typedef make(Node defSite, JSTypeExpression typeExpr) {
        return new Typedef(defSite, typeExpr);
    }

    public boolean isResolved() {
        return this.state == State.RESOLVED;
    }

    public JSType getType() {
        Preconditions.checkState((this.state == State.RESOLVED ? 1 : 0) != 0);
        return this.type;
    }

    public JSTypeExpression getTypeExpr() {
        Preconditions.checkState((this.state != State.RESOLVED ? 1 : 0) != 0);
        if (this.state == State.DURING_RESOLUTION) {
            return null;
        }
        this.state = State.DURING_RESOLUTION;
        return this.typeExpr;
    }

    public JSTypeExpression getTypeExprForErrorReporting() {
        Preconditions.checkState((this.state == State.DURING_RESOLUTION ? 1 : 0) != 0);
        return this.typeExpr;
    }

    void resolveTypedef(JSType t) {
        Preconditions.checkNotNull((Object)t);
        if (this.state == State.RESOLVED) {
            return;
        }
        Preconditions.checkState((this.state == State.DURING_RESOLUTION ? 1 : 0) != 0, (String)"Expected state DURING_RESOLUTION but found %s", (Object)this.state.toString());
        this.state = State.RESOLVED;
        this.typeExpr = null;
        this.type = t;
    }

    public String toString() {
        return this.defSite.getQualifiedName();
    }

    private static enum State {
        NOT_RESOLVED,
        DURING_RESOLUTION,
        RESOLVED;

    }
}

