/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Immutable
public final class SimpleDependencyInfo
implements DependencyInfo {
    private final ImmutableList<String> provides;
    private final ImmutableList<String> requires;
    private final ImmutableMap<String, String> loadFlags;
    private final String srcPathRelativeToClosure;
    private final String pathOfDefiningFile;
    public static final SimpleDependencyInfo EMPTY = new SimpleDependencyInfo("", "", (Collection<String>)ImmutableList.of(), (Collection<String>)ImmutableList.of(), (Map<String, String>)ImmutableMap.of());

    public SimpleDependencyInfo(String srcPathRelativeToClosure, String pathOfDefiningFile, List<String> provides, List<String> requires, boolean isModule) {
        this(srcPathRelativeToClosure, pathOfDefiningFile, provides, requires, SimpleDependencyInfo.loadFlags(isModule));
    }

    public SimpleDependencyInfo(String srcPathRelativeToClosure, String pathOfDefiningFile, Collection<String> provides, Collection<String> requires, Map<String, String> loadFlags) {
        this.srcPathRelativeToClosure = srcPathRelativeToClosure;
        this.pathOfDefiningFile = pathOfDefiningFile;
        this.provides = provides != null ? ImmutableList.copyOf(provides) : ImmutableList.of();
        this.requires = requires != null ? ImmutableList.copyOf(requires) : ImmutableList.of();
        this.loadFlags = ImmutableMap.copyOf(loadFlags);
    }

    @Override
    public String getName() {
        return this.pathOfDefiningFile;
    }

    @Override
    public String getPathRelativeToClosureBase() {
        return this.srcPathRelativeToClosure;
    }

    @Override
    public ImmutableMap<String, String> getLoadFlags() {
        return this.loadFlags;
    }

    private static Map<String, String> loadFlags(boolean isModule) {
        return isModule ? ImmutableMap.of((Object)"module", (Object)"goog") : ImmutableMap.of();
    }

    @Override
    public boolean isModule() {
        return "goog".equals(this.getLoadFlags().get((Object)"module"));
    }

    public ImmutableList<String> getProvides() {
        return this.provides;
    }

    public ImmutableList<String> getRequires() {
        return this.requires;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleDependencyInfo)) {
            return false;
        }
        SimpleDependencyInfo other = (SimpleDependencyInfo)obj;
        return Objects.equals(other.srcPathRelativeToClosure, this.srcPathRelativeToClosure) && Objects.equals(other.pathOfDefiningFile, this.pathOfDefiningFile) && Objects.equals(other.requires, this.requires) && Objects.equals(other.provides, this.provides) && Objects.equals(other.loadFlags, this.loadFlags);
    }

    public String toString() {
        return SimpleFormat.format("DependencyInfo(relativePath='%1$s', path='%2$s', provides=%3$s, requires=%4$s, loadFlags=%5$s)", this.srcPathRelativeToClosure, this.pathOfDefiningFile, this.provides, this.requires, this.loadFlags);
    }

    public int hashCode() {
        return Objects.hash(this.provides, this.requires, this.srcPathRelativeToClosure, this.pathOfDefiningFile, this.loadFlags);
    }
}

