/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public interface DependencyInfo
extends Serializable {
    public String getName();

    public String getPathRelativeToClosureBase();

    public Collection<String> getProvides();

    public Collection<String> getRequires();

    public ImmutableMap<String, String> getLoadFlags();

    public boolean isModule();

    public static class Util {
        private Util() {
        }

        public static void writeAddDependency(Appendable out, DependencyInfo info) throws IOException {
            out.append("goog.addDependency('").append(info.getPathRelativeToClosureBase()).append("', ");
            Util.writeJsArray(out, info.getProvides());
            out.append(", ");
            Util.writeJsArray(out, info.getRequires());
            ImmutableMap<String, String> loadFlags = info.getLoadFlags();
            if (!loadFlags.isEmpty()) {
                out.append(", ");
                Util.writeJsObject(out, loadFlags);
            }
            out.append(");\n");
        }

        private static void writeJsObject(Appendable out, Map<String, String> map) throws IOException {
            ArrayList<String> entries = new ArrayList<String>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey().replace("'", "\\'");
                String value = entry.getValue().replace("'", "\\'");
                entries.add("'" + key + "': '" + value + "'");
            }
            out.append("{");
            out.append(Joiner.on((String)", ").join(entries));
            out.append("}");
        }

        private static void writeJsArray(Appendable out, Collection<String> values) throws IOException {
            Iterable quoted = Iterables.transform(values, (Function)new Function<String, String>(){

                public String apply(String arg) {
                    return "'" + arg.replace("'", "\\'") + "'";
                }
            });
            out.append("[");
            out.append(Joiner.on((String)", ").join(quoted));
            out.append("]");
        }
    }

    public static abstract class Base
    implements DependencyInfo {
        @Override
        public boolean isModule() {
            return "goog".equals(this.getLoadFlags().get((Object)"module"));
        }
    }
}

