/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.io.Files;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefinitionProvider;
import com.google.javascript.jscomp.DefinitionSite;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.J2clSourceFileChecker;
import com.google.javascript.jscomp.NameBasedDefinitionProvider;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.FixedPointGraphTraversal;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.FunctionTypeI;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PureFunctionIdentifier
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final DefinitionProvider definitionProvider;
    private static final String HAS_RUN_PURE_FUNCTION_IDENTIFIER = "hasRunPureFunctionIdentifier";
    private final Map<String, FunctionInformation> functionInfoByName = new HashMap<String, FunctionInformation>();
    private final Multimap<Node, FunctionInformation> functionSideEffectMap;
    private final List<Node> allFunctionCalls;
    private final LinkedDirectedGraph<FunctionInformation, CallSitePropagationInfo> sideEffectGraph = LinkedDirectedGraph.createWithoutAnnotations();
    private Node externs;
    private Node root;

    public PureFunctionIdentifier(AbstractCompiler compiler, DefinitionProvider definitionProvider) {
        this.compiler = (AbstractCompiler)Preconditions.checkNotNull((Object)compiler);
        this.definitionProvider = definitionProvider;
        this.functionSideEffectMap = ArrayListMultimap.create();
        this.allFunctionCalls = new ArrayList<Node>();
        this.externs = null;
        this.root = null;
    }

    @Override
    public void process(Node externsAst, Node srcAst) {
        Preconditions.checkState((this.externs == null && this.root == null ? 1 : 0) != 0, (Object)"It is illegal to call PureFunctionIdentifier.process  twice the same instance.  Please  use a new PureFunctionIdentifier instance each time.");
        this.externs = externsAst;
        this.root = srcAst;
        this.buildGraph();
        NodeTraversal.traverseEs6(this.compiler, this.externs, new FunctionAnalyzer(true));
        NodeTraversal.traverseEs6(this.compiler, this.root, new FunctionAnalyzer(false));
        this.propagateSideEffects();
        this.markPureFunctionCalls();
    }

    @VisibleForTesting
    String getDebugReport() {
        Preconditions.checkNotNull((Object)this.externs);
        Preconditions.checkNotNull((Object)this.root);
        StringBuilder sb = new StringBuilder();
        for (Node call : this.allFunctionCalls) {
            sb.append("  ");
            Iterable<Node> expanded = PureFunctionIdentifier.unwrapCallableExpression(call.getFirstChild());
            if (expanded != null) {
                for (Node comp : expanded) {
                    String name = NameBasedDefinitionProvider.getSimplifiedName(comp);
                    sb.append(name).append("|");
                }
            } else {
                sb.append("<cant expand>");
            }
            sb.append(" ").append(new Node.SideEffectFlags(call.getSideEffectFlags())).append(" from: ").append(call.getSourceFileName()).append("\n");
        }
        return sb.toString();
    }

    private static Iterable<Node> unwrapCallableExpression(Node exp) {
        switch (exp.getToken()) {
            case GETPROP: {
                String propName = exp.getLastChild().getString();
                if (propName.equals("apply") || propName.equals("call")) {
                    return PureFunctionIdentifier.unwrapCallableExpression(exp.getFirstChild());
                }
                return ImmutableList.of((Object)exp);
            }
            case FUNCTION: 
            case NAME: {
                return ImmutableList.of((Object)exp);
            }
            case OR: 
            case HOOK: {
                Node firstVal = exp.isHook() ? exp.getSecondChild() : exp.getFirstChild();
                Iterable<Node> firstCallable = PureFunctionIdentifier.unwrapCallableExpression(firstVal);
                Iterable<Node> secondCallable = PureFunctionIdentifier.unwrapCallableExpression(firstVal.getNext());
                if (firstCallable == null || secondCallable == null) {
                    return null;
                }
                return Iterables.concat(firstCallable, secondCallable);
            }
        }
        return null;
    }

    private static boolean isSupportedFunctionDefinition(Node definitionRValue) {
        if (definitionRValue == null) {
            return false;
        }
        switch (definitionRValue.getToken()) {
            case FUNCTION: {
                return true;
            }
            case HOOK: {
                return PureFunctionIdentifier.isSupportedFunctionDefinition(definitionRValue.getSecondChild()) && PureFunctionIdentifier.isSupportedFunctionDefinition(definitionRValue.getLastChild());
            }
        }
        return false;
    }

    private Iterable<Node> getGoogCacheCallableExpression(CodingConvention.Cache cacheCall) {
        Preconditions.checkNotNull((Object)cacheCall);
        if (cacheCall.keyFn == null) {
            return PureFunctionIdentifier.unwrapCallableExpression(cacheCall.valueFn);
        }
        return Iterables.concat(PureFunctionIdentifier.unwrapCallableExpression(cacheCall.valueFn), PureFunctionIdentifier.unwrapCallableExpression(cacheCall.keyFn));
    }

    private List<FunctionInformation> getSideEffectsForCall(Node call) {
        Preconditions.checkArgument((call.isCall() || call.isNew() ? 1 : 0) != 0);
        CodingConvention.Cache cacheCall = this.compiler.getCodingConvention().describeCachingCall(call);
        Iterable<Node> expanded = cacheCall != null ? this.getGoogCacheCallableExpression(cacheCall) : PureFunctionIdentifier.unwrapCallableExpression(call.getFirstChild());
        if (expanded == null) {
            return null;
        }
        ArrayList<FunctionInformation> results = new ArrayList<FunctionInformation>();
        for (Node expression : expanded) {
            if (NodeUtil.isFunctionExpression(expression)) {
                results.addAll((Collection)Preconditions.checkNotNull((Object)this.functionSideEffectMap.get((Object)expression)));
                continue;
            }
            String name = NameBasedDefinitionProvider.getSimplifiedName(expression);
            if (name != null && this.functionInfoByName.containsKey(name)) {
                results.add(this.functionInfoByName.get(name));
                continue;
            }
            return null;
        }
        return results;
    }

    private void buildGraph() {
        FunctionInformation unknownDefinitionFunction = new FunctionInformation();
        unknownDefinitionFunction.setTaintsGlobalState();
        unknownDefinitionFunction.setFunctionThrows();
        unknownDefinitionFunction.setTaintsReturn();
        unknownDefinitionFunction.graphNode = this.sideEffectGraph.createNode((Object)unknownDefinitionFunction);
        for (DefinitionSite site : this.definitionProvider.getDefinitionSites()) {
            DefinitionsRemover.Definition definition = site.definition;
            if (definition.getLValue() == null) continue;
            Node getOrName = definition.getLValue();
            Preconditions.checkArgument((getOrName.isGetProp() || getOrName.isName() ? 1 : 0) != 0, (Object)getOrName);
            String name = NameBasedDefinitionProvider.getSimplifiedName(getOrName);
            Preconditions.checkNotNull((Object)name);
            if (PureFunctionIdentifier.isSupportedFunctionDefinition(definition.getRValue())) {
                this.addSupportedDefinition(site, name);
                continue;
            }
            if (this.functionInfoByName.containsKey(name)) {
                this.functionInfoByName.get(name).setTaintsGlobalState();
                this.functionInfoByName.get(name).setFunctionThrows();
                this.functionInfoByName.get(name).setTaintsReturn();
                continue;
            }
            this.functionInfoByName.put(name, unknownDefinitionFunction);
        }
    }

    private void addSupportedDefinition(DefinitionSite definitionSite, String name) {
        for (Node function : PureFunctionIdentifier.unwrapCallableExpression(definitionSite.definition.getRValue())) {
            FunctionInformation functionInfo;
            if (this.functionInfoByName.containsKey(name)) {
                functionInfo = this.functionInfoByName.get(name);
            } else {
                functionInfo = new FunctionInformation();
                functionInfo.graphNode = this.sideEffectGraph.createNode((Object)functionInfo);
                this.functionInfoByName.put(name, functionInfo);
            }
            this.functionSideEffectMap.put((Object)function, (Object)functionInfo);
            if (!definitionSite.inExterns) continue;
            functionInfo.updateSideEffectsFromExtern(function, this.compiler);
        }
    }

    private void propagateSideEffects() {
        FixedPointGraphTraversal.newTraversal(new FixedPointGraphTraversal.EdgeCallback<FunctionInformation, CallSitePropagationInfo>(){

            @Override
            public boolean traverseEdge(FunctionInformation source, CallSitePropagationInfo edge, FunctionInformation destination) {
                return edge.propagate(source, destination);
            }
        }).computeFixedPoint(this.sideEffectGraph);
    }

    private void markPureFunctionCalls() {
        for (Node callNode : this.allFunctionCalls) {
            List<FunctionInformation> possibleSideEffects = this.getSideEffectsForCall(callNode);
            Node.SideEffectFlags flags = new Node.SideEffectFlags();
            if (possibleSideEffects == null) {
                flags.setMutatesGlobalState();
                flags.setThrows();
                flags.setReturnsTainted();
            } else {
                flags.clearAllFlags();
                for (FunctionInformation functionInfo : possibleSideEffects) {
                    Preconditions.checkNotNull((Object)functionInfo);
                    if (functionInfo.mutatesGlobalState()) {
                        flags.setMutatesGlobalState();
                    }
                    if (functionInfo.mutatesArguments()) {
                        flags.setMutatesArguments();
                    }
                    if (functionInfo.functionThrows()) {
                        flags.setThrows();
                    }
                    if (callNode.isCall() && functionInfo.taintsThis()) {
                        if (PureFunctionIdentifier.isCallOrApply(callNode)) {
                            flags.setMutatesArguments();
                        } else {
                            flags.setMutatesThis();
                        }
                    }
                    if (!functionInfo.taintsReturn()) continue;
                    flags.setReturnsTainted();
                }
            }
            if (callNode.isCall()) {
                if (!NodeUtil.functionCallHasSideEffects(callNode, this.compiler)) {
                    flags.clearSideEffectFlags();
                }
            } else if (callNode.isNew() && !NodeUtil.constructorCallHasSideEffects(callNode)) {
                flags.clearSideEffectFlags();
            }
            int newSideEffectFlags = flags.valueOf();
            if (callNode.getSideEffectFlags() == newSideEffectFlags) continue;
            callNode.setSideEffectFlags(newSideEffectFlags);
            this.compiler.reportChangeToEnclosingScope(callNode);
        }
    }

    private static boolean isIncDec(Node n) {
        Token type = n.getToken();
        return type == Token.INC || type == Token.DEC;
    }

    private static boolean isCallOrApply(Node callSite) {
        return NodeUtil.isFunctionObjectCall(callSite) || NodeUtil.isFunctionObjectApply(callSite);
    }

    private static boolean isLocalValueType(TypeI typei, AbstractCompiler compiler) {
        Preconditions.checkNotNull((Object)typei);
        Object nativeObj = compiler.getTypeIRegistry().getNativeType(JSTypeNative.OBJECT_TYPE);
        TypeI subtype = typei.meetWith((TypeI)nativeObj);
        return subtype.isBottom();
    }

    static boolean hasRunPureFunctionIdentifier(AbstractCompiler compiler) {
        return Boolean.TRUE.equals(compiler.getAnnotation(HAS_RUN_PURE_FUNCTION_IDENTIFIER));
    }

    static class DriverInJ2cl
    extends Driver {
        DriverInJ2cl(AbstractCompiler compiler, String reportPath) {
            super(compiler, reportPath);
            this.checkJ2cl = false;
        }
    }

    static class Driver
    implements CompilerPass {
        private final AbstractCompiler compiler;
        private final String reportPath;
        protected boolean checkJ2cl = true;

        Driver(AbstractCompiler compiler, String reportPath) {
            this.compiler = compiler;
            this.reportPath = reportPath;
        }

        @Override
        public void process(Node externs, Node root) {
            if (this.checkJ2cl && J2clSourceFileChecker.shouldRunJ2clPasses(this.compiler)) {
                return;
            }
            if (!PureFunctionIdentifier.hasRunPureFunctionIdentifier(this.compiler)) {
                this.compiler.setAnnotation(PureFunctionIdentifier.HAS_RUN_PURE_FUNCTION_IDENTIFIER, Boolean.TRUE);
            }
            NameBasedDefinitionProvider defFinder = new NameBasedDefinitionProvider(this.compiler, true);
            defFinder.process(externs, root);
            PureFunctionIdentifier pureFunctionIdentifier = new PureFunctionIdentifier(this.compiler, defFinder);
            pureFunctionIdentifier.process(externs, root);
            if (this.reportPath != null) {
                try {
                    Files.write((CharSequence)pureFunctionIdentifier.getDebugReport(), (File)new File(this.reportPath), (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static class FunctionInformation {
        DiGraph.DiGraphNode<FunctionInformation, CallSitePropagationInfo> graphNode;
        private int bitmask = 0;
        private static final int FUNCTION_THROWS_MASK = 2;
        private static final int TAINTS_GLOBAL_STATE_MASK = 4;
        private static final int TAINTS_THIS_MASK = 8;
        private static final int TAINTS_ARGUMENTS_MASK = 16;
        private static final int TAINTS_RETURN_MASK = 32;

        private FunctionInformation() {
        }

        void setMask(int mask) {
            this.bitmask |= mask;
        }

        boolean getMask(int mask) {
            return (this.bitmask & mask) != 0;
        }

        boolean taintsGlobalState() {
            return this.getMask(4);
        }

        boolean taintsThis() {
            return this.getMask(8);
        }

        boolean taintsReturn() {
            return this.getMask(32);
        }

        boolean functionThrows() {
            return this.getMask(2);
        }

        boolean isPure() {
            return !this.getMask(30);
        }

        void setTaintsGlobalState() {
            this.setMask(4);
        }

        void setTaintsThis() {
            this.setMask(8);
        }

        void setTaintsArguments() {
            this.setMask(16);
        }

        void setFunctionThrows() {
            this.setMask(2);
        }

        void setTaintsReturn() {
            this.setMask(32);
        }

        boolean mutatesGlobalState() {
            return this.getMask(4);
        }

        boolean mutatesArguments() {
            return this.getMask(20);
        }

        boolean mutatesThis() {
            return this.taintsThis();
        }

        public String toString() {
            ArrayList<String> status = new ArrayList<String>();
            if (this.taintsThis()) {
                status.add("this");
            }
            if (this.taintsGlobalState()) {
                status.add("global");
            }
            if (this.mutatesArguments()) {
                status.add("args");
            }
            if (this.functionThrows()) {
                status.add("throw");
            }
            return "Side effects: " + status;
        }

        private void updateSideEffectsFromExtern(Node externFunction, AbstractCompiler compiler) {
            TypeI retType;
            FunctionTypeI functionType;
            Preconditions.checkArgument((boolean)externFunction.isFunction());
            Preconditions.checkArgument((boolean)externFunction.isFromExterns());
            JSDocInfo info = NodeUtil.getBestJSDocInfo(externFunction);
            TypeI typei = externFunction.getTypeI();
            FunctionTypeI functionTypeI = functionType = typei == null ? null : typei.toMaybeFunctionType();
            if (functionType != null && !PureFunctionIdentifier.isLocalValueType(retType = functionType.getReturnType(), compiler)) {
                this.setTaintsReturn();
            }
            if (info == null) {
                this.setTaintsGlobalState();
                this.setFunctionThrows();
            } else if (info.modifiesThis()) {
                this.setTaintsThis();
            } else if (info.hasSideEffectsArgumentsAnnotation()) {
                this.setTaintsArguments();
            } else if (!info.getThrownTypes().isEmpty()) {
                this.setFunctionThrows();
            } else if (!info.isNoSideEffects()) {
                this.setTaintsGlobalState();
            }
        }
    }

    private static class CallSitePropagationInfo {
        private final boolean allArgsUnescapedLocal;
        private final boolean calleeThisEqualsCallerThis;
        private final Token callType;

        private CallSitePropagationInfo(boolean allArgsUnescapedLocal, boolean calleeThisEqualsCallerThis, Token callType) {
            Preconditions.checkArgument((callType == Token.CALL || callType == Token.NEW ? 1 : 0) != 0);
            this.allArgsUnescapedLocal = allArgsUnescapedLocal;
            this.calleeThisEqualsCallerThis = calleeThisEqualsCallerThis;
            this.callType = callType;
        }

        boolean propagate(FunctionInformation callee, FunctionInformation caller) {
            CallSitePropagationInfo propagationType = this;
            boolean changed = false;
            if (callee.mutatesGlobalState() && !caller.mutatesGlobalState()) {
                caller.setTaintsGlobalState();
                changed = true;
            }
            if (callee.functionThrows() && !caller.functionThrows()) {
                caller.setFunctionThrows();
                changed = true;
            }
            if (callee.mutatesArguments() && !propagationType.allArgsUnescapedLocal && !caller.mutatesGlobalState()) {
                caller.setTaintsGlobalState();
                changed = true;
            }
            if (callee.mutatesThis() && propagationType.calleeThisEqualsCallerThis) {
                if (!caller.mutatesThis()) {
                    caller.setTaintsThis();
                    changed = true;
                }
            } else if (callee.mutatesThis() && propagationType.callType != Token.NEW && !caller.mutatesGlobalState()) {
                caller.setTaintsGlobalState();
                changed = true;
            }
            return changed;
        }

        static CallSitePropagationInfo computePropagationType(Node callSite) {
            Preconditions.checkArgument((callSite.isCall() || callSite.isNew() ? 1 : 0) != 0);
            boolean thisIsOuterThis = false;
            if (callSite.isCall()) {
                Node objectNode;
                boolean isCallOrApply = PureFunctionIdentifier.isCallOrApply(callSite);
                Node node = objectNode = isCallOrApply ? callSite.getSecondChild() : callSite.getFirstFirstChild();
                if ((objectNode == null || !objectNode.isName() || isCallOrApply) && objectNode != null && objectNode.isThis()) {
                    thisIsOuterThis = true;
                }
            }
            boolean argsUnescapedLocal = NodeUtil.allArgsUnescapedLocal(callSite);
            return new CallSitePropagationInfo(argsUnescapedLocal, thisIsOuterThis, callSite.getToken());
        }
    }

    private class FunctionAnalyzer
    implements NodeTraversal.ScopedCallback {
        private final SetMultimap<Node, Var> blacklistedVarsByFunction = HashMultimap.create();
        private final SetMultimap<Node, Var> taintedVarsByFunction = HashMultimap.create();
        private final boolean inExterns;

        FunctionAnalyzer(boolean inExterns) {
            this.inExterns = inExterns;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal traversal, Node node, Node parent) {
            if (node.isFunction() && !PureFunctionIdentifier.this.functionSideEffectMap.containsKey((Object)node)) {
                FunctionInformation functionInfo = new FunctionInformation();
                PureFunctionIdentifier.this.functionSideEffectMap.put((Object)node, (Object)functionInfo);
                functionInfo.graphNode = PureFunctionIdentifier.this.sideEffectGraph.createNode(functionInfo);
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal traversal, Node node, Node parent) {
            Node enclosingFunction;
            if (this.inExterns) {
                return;
            }
            if (!NodeUtil.nodeTypeMayHaveSideEffects(node, PureFunctionIdentifier.this.compiler) && !node.isReturn()) {
                return;
            }
            if (NodeUtil.isCallOrNew(node)) {
                PureFunctionIdentifier.this.allFunctionCalls.add(node);
            }
            if ((enclosingFunction = traversal.getEnclosingFunction()) == null) {
                return;
            }
            for (FunctionInformation sideEffectInfo : PureFunctionIdentifier.this.functionSideEffectMap.get((Object)enclosingFunction)) {
                Preconditions.checkNotNull((Object)sideEffectInfo);
                this.updateSideEffectsForNode(sideEffectInfo, traversal, node, enclosingFunction);
            }
        }

        public void updateSideEffectsForNode(FunctionInformation sideEffectInfo, NodeTraversal traversal, Node node, Node enclosingFunction) {
            if (NodeUtil.isAssignmentOp(node) || node.isInc() || node.isDelProp() || node.isDec()) {
                this.visitAssignmentOrUnaryOperator(sideEffectInfo, traversal.getScope(), node, enclosingFunction);
            } else if (NodeUtil.isCallOrNew(node)) {
                this.visitCall(sideEffectInfo, node);
            } else if (node.isName()) {
                Preconditions.checkArgument((boolean)NodeUtil.isNameDeclaration(node.getParent()));
                Node value = node.getFirstChild();
                if (value != null && !NodeUtil.evaluatesToLocalValue(value)) {
                    Scope scope = traversal.getScope();
                    Var var = scope.getVar(node.getString());
                    this.blacklistedVarsByFunction.put((Object)enclosingFunction, (Object)var);
                }
            } else if (node.isThrow()) {
                sideEffectInfo.setFunctionThrows();
            } else if (node.isReturn()) {
                if (node.hasChildren() && !NodeUtil.evaluatesToLocalValue(node.getFirstChild())) {
                    sideEffectInfo.setTaintsReturn();
                }
            } else if (node.isYield()) {
                if (node.hasChildren() && !NodeUtil.evaluatesToLocalValue(node.getFirstChild())) {
                    sideEffectInfo.setTaintsReturn();
                }
            } else {
                throw new IllegalArgumentException("Unhandled side effect node type " + (Object)((Object)node.getToken()));
            }
        }

        @Override
        public void enterScope(NodeTraversal t) {
        }

        @Override
        public void exitScope(NodeTraversal t) {
            if (!t.getScope().isFunctionBlockScope() && !t.getScope().isFunctionScope()) {
                return;
            }
            Node function = NodeUtil.getEnclosingFunction(t.getScopeRoot());
            if (function == null) {
                return;
            }
            block0: for (FunctionInformation sideEffectInfo : PureFunctionIdentifier.this.functionSideEffectMap.get((Object)function)) {
                Preconditions.checkNotNull((Object)sideEffectInfo, (String)"%s has no side effect info.", (Object)function);
                if (sideEffectInfo.mutatesGlobalState()) continue;
                for (Var var : t.getScope().getVarIterable()) {
                    boolean param = var.getParentNode().isParamList();
                    if (param && !this.blacklistedVarsByFunction.containsEntry((Object)function, (Object)var) && this.taintedVarsByFunction.containsEntry((Object)function, (Object)var)) {
                        sideEffectInfo.setTaintsArguments();
                        continue;
                    }
                    boolean localVar = false;
                    if (var.getParentNode().isVar()) {
                        localVar = true;
                    }
                    if (localVar && !this.blacklistedVarsByFunction.containsEntry((Object)function, (Object)var) || !this.taintedVarsByFunction.containsEntry((Object)function, (Object)var)) continue;
                    sideEffectInfo.setTaintsGlobalState();
                    continue block0;
                }
            }
            if (t.getScopeRoot().isFunction()) {
                this.blacklistedVarsByFunction.removeAll((Object)function);
                this.taintedVarsByFunction.removeAll((Object)function);
            }
        }

        private boolean isVarDeclaredInScope(Var v, Scope scope) {
            Node scopeRoot;
            if (v == null) {
                return false;
            }
            if (v.scope == scope) {
                return true;
            }
            Node declarationRoot = NodeUtil.getEnclosingFunction(v.scope.rootNode);
            return declarationRoot == (scopeRoot = NodeUtil.getEnclosingFunction(scope.rootNode));
        }

        private void visitAssignmentOrUnaryOperator(FunctionInformation sideEffectInfo, Scope scope, Node op, Node enclosingFunction) {
            Node lhs = op.getFirstChild();
            Preconditions.checkState((lhs.isName() || NodeUtil.isGet(lhs) ? 1 : 0) != 0, (String)"Unexpected LHS expression:", (Object)lhs);
            if (lhs.isName()) {
                Var var = scope.getVar(lhs.getString());
                if (this.isVarDeclaredInScope(var, scope)) {
                    Preconditions.checkState((NodeUtil.isAssignmentOp(op) || PureFunctionIdentifier.isIncDec(op) || op.isDelProp() ? 1 : 0) != 0);
                    Node rhs = op.getLastChild();
                    if (rhs != null && op.isAssign() && !NodeUtil.evaluatesToLocalValue(rhs)) {
                        this.blacklistedVarsByFunction.put((Object)enclosingFunction, (Object)var);
                    }
                } else {
                    sideEffectInfo.setTaintsGlobalState();
                }
            } else if (NodeUtil.isGet(lhs)) {
                if (lhs.getFirstChild().isThis()) {
                    sideEffectInfo.setTaintsThis();
                } else {
                    Node objectNode = lhs.getFirstChild();
                    if (objectNode.isName()) {
                        Var var = scope.getVar(objectNode.getString());
                        if (this.isVarDeclaredInScope(var, scope)) {
                            this.taintedVarsByFunction.put((Object)enclosingFunction, (Object)var);
                        } else {
                            sideEffectInfo.setTaintsGlobalState();
                        }
                    } else {
                        sideEffectInfo.setTaintsGlobalState();
                    }
                }
            }
        }

        private void visitCall(FunctionInformation sideEffectInfo, Node node) {
            if (node.isCall() && !NodeUtil.functionCallHasSideEffects(node, PureFunctionIdentifier.this.compiler)) {
                return;
            }
            if (node.isNew() && !NodeUtil.constructorCallHasSideEffects(node)) {
                return;
            }
            List possibleSideEffects = PureFunctionIdentifier.this.getSideEffectsForCall(node);
            if (possibleSideEffects == null) {
                sideEffectInfo.setTaintsGlobalState();
                sideEffectInfo.setFunctionThrows();
                return;
            }
            for (FunctionInformation sideEffectNode : possibleSideEffects) {
                CallSitePropagationInfo edge = CallSitePropagationInfo.computePropagationType(node);
                PureFunctionIdentifier.this.sideEffectGraph.connect(sideEffectNode.graphNode, edge, sideEffectInfo.graphNode);
            }
        }
    }
}

