/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class PrebuildAst {
    private final AbstractCompiler compiler;
    private final int numParallelThreads;

    PrebuildAst(AbstractCompiler compiler, int numParalleThreads) {
        this.compiler = compiler;
        this.numParallelThreads = numParalleThreads;
    }

    void prebuild(List<CompilerInput> inputList) {
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(null, r, "jscompiler-PrebuildAst", 0x2000000L);
                t.setDaemon(true);
                return t;
            }
        };
        ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(this.numParallelThreads, this.numParallelThreads, Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)poolExecutor);
        ArrayList<ListenableFuture> futureList = new ArrayList<ListenableFuture>(inputList.size());
        for (final CompilerInput input : inputList) {
            futureList.add(executorService.submit(new Runnable(){

                @Override
                public void run() {
                    input.getAstRoot(PrebuildAst.this.compiler);
                }
            }));
        }
        poolExecutor.shutdown();
        try {
            Futures.allAsList(futureList).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

