/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.Es6TemplateLiterals;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.ObjectTypeI;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.ArrayList;
import java.util.List;

public final class LateEs6ToEs3Converter
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private final boolean addTypes;
    private final TypeIRegistry registry;
    private final TypeI unknownType;
    private final TypeI stringType;
    private final TypeI booleanType;
    private static final String FRESH_COMP_PROP_VAR = "$jscomp$compprop";
    private static final String ITER_BASE = "$jscomp$iter$";
    private static final String ITER_RESULT = "$jscomp$key$";

    public LateEs6ToEs3Converter(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.addTypes = AbstractCompiler.MostRecentTypechecker.NTI.equals((Object)compiler.getMostRecentTypechecker());
        this.registry = compiler.getTypeIRegistry();
        this.unknownType = Es6ToEs3Util.createType(this.addTypes, this.registry, JSTypeNative.UNKNOWN_TYPE);
        this.stringType = Es6ToEs3Util.createType(this.addTypes, this.registry, JSTypeNative.STRING_TYPE);
        this.booleanType = Es6ToEs3Util.createType(this.addTypes, this.registry, JSTypeNative.BOOLEAN_TYPE);
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, this);
        TranspilationPasses.processTranspile(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case GETTER_DEF: 
            case SETTER_DEF: {
                if (this.compiler.getOptions().getLanguageOut() != CompilerOptions.LanguageMode.ECMASCRIPT3) break;
                Es6ToEs3Util.cannotConvert(this.compiler, n, "ES5 getters/setters (consider using --language_out=ES5)");
                return false;
            }
            case FUNCTION: {
                if (!n.isAsyncFunction()) break;
                throw new IllegalStateException("async functions should have already been converted");
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case OBJECTLIT: {
                this.visitObject(n);
                break;
            }
            case MEMBER_FUNCTION_DEF: {
                if (!parent.isObjectLit()) break;
                this.visitMemberFunctionDefInObjectLit(n, parent);
                break;
            }
            case FOR_OF: {
                this.visitForOf(t, n, parent);
                break;
            }
            case STRING_KEY: {
                this.visitStringKey(n);
                break;
            }
            case TAGGED_TEMPLATELIT: {
                Es6TemplateLiterals.visitTaggedTemplateLiteral(t, n, this.addTypes);
                break;
            }
            case TEMPLATELIT: {
                if (parent.isTaggedTemplateLit()) break;
                Es6TemplateLiterals.visitTemplateLiteral(t, n, this.addTypes);
                break;
            }
        }
    }

    private void visitMemberFunctionDefInObjectLit(Node n, Node parent) {
        String name = n.getString();
        Node nameNode = n.getFirstFirstChild();
        Node stringKey = Es6ToEs3Util.withType(IR.stringKey(name, n.getFirstChild().detach()), n.getTypeI());
        stringKey.setJSDocInfo(n.getJSDocInfo());
        parent.replaceChild(n, stringKey);
        stringKey.useSourceInfoFrom(nameNode);
        this.compiler.reportChangeToEnclosingScope(stringKey);
    }

    private void visitStringKey(Node n) {
        if (!n.hasChildren()) {
            Node name = Es6ToEs3Util.withType(IR.name(n.getString()), n.getTypeI());
            name.useSourceInfoIfMissingFrom(n);
            n.addChildToBack(name);
            this.compiler.reportChangeToEnclosingScope(name);
        }
    }

    private void visitForOf(NodeTraversal t, Node node, Node parent) {
        Node declarationOrAssign;
        String variableName;
        Token declType;
        Node variable = node.removeFirstChild();
        Node iterable = node.removeFirstChild();
        Node body = node.removeFirstChild();
        ObjectTypeI iterableType = null;
        TypeI typeParam = this.unknownType;
        if (this.addTypes) {
            iterableType = iterable.getTypeI().autobox().toMaybeObjectType();
            typeParam = (TypeI)iterableType.getTemplateTypes().get(0);
        }
        TypeI iteratorType = this.createGenericType(JSTypeNative.ITERATOR_TYPE, typeParam);
        TypeI iIterableResultType = this.createGenericType(JSTypeNative.I_ITERABLE_RESULT_TYPE, typeParam);
        TypeI iteratorNextType = this.addTypes ? iteratorType.toMaybeObjectType().getPropertyType("next") : null;
        JSDocInfo varJSDocInfo = variable.getJSDocInfo();
        Node iterName = Es6ToEs3Util.withType(IR.name(ITER_BASE + (String)this.compiler.getUniqueNameIdSupplier().get()), iteratorType);
        iterName.makeNonIndexable();
        Node getNext = Es6ToEs3Util.withType(IR.call(Es6ToEs3Util.withType(IR.getprop(iterName.cloneTree(), this.withStringType(IR.string("next"))), iteratorNextType), new Node[0]), iIterableResultType);
        if (variable.isName()) {
            declType = Token.NAME;
            variableName = variable.getQualifiedName();
        } else {
            Preconditions.checkState((boolean)NodeUtil.isNameDeclaration(variable), (String)"Expected var, let, or const. Got %s", (Object)variable);
            declType = variable.getToken();
            variableName = variable.getFirstChild().getQualifiedName();
        }
        Node iterResult = Es6ToEs3Util.withType(IR.name(ITER_RESULT + variableName), iIterableResultType);
        iterResult.makeNonIndexable();
        Node call = Es6ToEs3Util.makeIterator(this.compiler, iterable);
        if (this.addTypes) {
            TypeI jscompType = t.getScope().getVar("$jscomp").getNode().getTypeI();
            TypeI makeIteratorType = jscompType.toMaybeObjectType().getPropertyType("makeIterator");
            call.getFirstChild().setTypeI(makeIteratorType);
            call.getFirstFirstChild().setTypeI(jscompType);
        }
        Node init = IR.var(iterName.cloneTree(), Es6ToEs3Util.withType(call, iteratorType));
        Node initIterResult = iterResult.cloneTree();
        initIterResult.addChildToFront(getNext.cloneTree());
        init.addChildToBack(initIterResult);
        Node cond = this.withBooleanType(IR.not(this.withBooleanType(IR.getprop(iterResult.cloneTree(), this.withStringType(IR.string("done"))))));
        Node incr = Es6ToEs3Util.withType(IR.assign(iterResult.cloneTree(), getNext.cloneTree()), iIterableResultType);
        if (declType == Token.NAME) {
            declarationOrAssign = Es6ToEs3Util.withType(IR.assign(Es6ToEs3Util.withType(IR.name(variableName).useSourceInfoFrom(variable), typeParam), Es6ToEs3Util.withType(IR.getprop(iterResult.cloneTree(), this.withStringType(IR.string("value"))), typeParam)), typeParam);
            declarationOrAssign.setJSDocInfo(varJSDocInfo);
            declarationOrAssign = IR.exprResult(declarationOrAssign);
        } else {
            declarationOrAssign = new Node(declType, Es6ToEs3Util.withType(IR.name(variableName).useSourceInfoFrom(variable.getFirstChild()), typeParam));
            declarationOrAssign.getFirstChild().addChildToBack(Es6ToEs3Util.withType(IR.getprop(iterResult.cloneTree(), this.withStringType(IR.string("value"))), typeParam));
            declarationOrAssign.setJSDocInfo(varJSDocInfo);
        }
        Node newBody = IR.block(declarationOrAssign, body).useSourceInfoFrom(body);
        Node newFor = IR.forNode(init, cond, incr, newBody);
        newFor.useSourceInfoIfMissingFromForTree(node);
        parent.replaceChild(node, newFor);
        this.compiler.reportChangeToEnclosingScope(newFor);
    }

    private void visitObject(Node obj) {
        for (Node child : obj.children()) {
            if (!child.isComputedProp()) continue;
            this.visitObjectWithComputedProperty(obj);
            return;
        }
    }

    private void visitObjectWithComputedProperty(Node obj) {
        Preconditions.checkArgument((boolean)obj.isObjectLit());
        List<Node> props = new ArrayList();
        Node currElement = obj.getFirstChild();
        TypeI objectType = obj.getTypeI();
        while (currElement != null) {
            if (currElement.getBooleanProp((byte)73) || currElement.getBooleanProp((byte)74)) {
                Es6ToEs3Util.cannotConvertYet(this.compiler, currElement, "computed getter/setter in an object literal");
                return;
            }
            if (currElement.isGetterDef() || currElement.isSetterDef()) {
                currElement = currElement.getNext();
                continue;
            }
            Node nextNode = currElement.getNext();
            obj.removeChild(currElement);
            props.add(currElement);
            currElement = nextNode;
        }
        String objName = FRESH_COMP_PROP_VAR + (String)this.compiler.getUniqueNameIdSupplier().get();
        props = Lists.reverse(props);
        Node result = Es6ToEs3Util.withType(IR.name(objName), objectType);
        for (Node propdef : props) {
            if (propdef.isComputedProp()) {
                Node propertyExpression = propdef.removeFirstChild();
                Node value = propdef.removeFirstChild();
                TypeI valueType = value.getTypeI();
                result = Es6ToEs3Util.withType(IR.comma(Es6ToEs3Util.withType(IR.assign(this.withUnknownType(IR.getelem(Es6ToEs3Util.withType(IR.name(objName), objectType), propertyExpression)), value), valueType), result), objectType);
                continue;
            }
            if (!propdef.hasChildren()) {
                Node name = Es6ToEs3Util.withType(IR.name(propdef.getString()), propdef.getTypeI()).useSourceInfoIfMissingFrom(propdef);
                propdef.addChildToBack(name);
            }
            Node val = propdef.removeFirstChild();
            TypeI valueType = val.getTypeI();
            propdef.setToken(Token.STRING);
            propdef.setTypeI(null);
            Token token = propdef.isQuotedString() ? Token.GETELEM : Token.GETPROP;
            Node access = Es6ToEs3Util.withType(new Node(token, Es6ToEs3Util.withType(IR.name(objName), objectType), propdef), valueType);
            result = Es6ToEs3Util.withType(IR.comma(Es6ToEs3Util.withType(IR.assign(access, val), valueType), result), objectType);
        }
        Node statement = obj;
        while (!NodeUtil.isStatement(statement)) {
            statement = statement.getParent();
        }
        result.useSourceInfoIfMissingFromForTree(obj);
        obj.replaceWith(result);
        TypeI simpleObjectType = Es6ToEs3Util.createType(this.addTypes, this.registry, JSTypeNative.EMPTY_OBJECT_LITERAL_TYPE);
        Node var = IR.var(Es6ToEs3Util.withType(IR.name(objName), objectType), Es6ToEs3Util.withType(obj, simpleObjectType));
        var.useSourceInfoIfMissingFromForTree(statement);
        statement.getParent().addChildBefore(var, statement);
        this.compiler.reportChangeToEnclosingScope(var);
    }

    private TypeI createGenericType(JSTypeNative typeName, TypeI typeArg) {
        return Es6ToEs3Util.createGenericType(this.addTypes, this.registry, typeName, typeArg);
    }

    private Node withStringType(Node n) {
        return Es6ToEs3Util.withType(n, this.stringType);
    }

    private Node withBooleanType(Node n) {
        return Es6ToEs3Util.withType(n, this.booleanType);
    }

    private Node withUnknownType(Node n) {
        return Es6ToEs3Util.withType(n, this.unknownType);
    }
}

