/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.FunctionInjector;
import com.google.javascript.jscomp.J2clSourceFileChecker;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.Map;

public class J2clPropertyInlinerPass
implements CompilerPass {
    final AbstractCompiler compiler;

    public J2clPropertyInlinerPass(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        if (!J2clSourceFileChecker.shouldRunJ2clPasses(this.compiler)) {
            return;
        }
        new StaticFieldGetterSetterInliner(root).run();
    }

    class StaticFieldGetterSetterInliner {
        Node root;

        StaticFieldGetterSetterInliner(Node root) {
            this.root = root;
        }

        private void run() {
            GatherJ2CLClassGetterSetters gatherer = new GatherJ2CLClassGetterSetters();
            NodeTraversal.traverseEs6(J2clPropertyInlinerPass.this.compiler, this.root, gatherer);
            Map result = gatherer.getResults();
            NodeTraversal.traverseEs6(J2clPropertyInlinerPass.this.compiler, this.root, new DetermineInlinableProperties(result));
            new InlinePropertiesPass(result).run();
        }

        private boolean matchesJ2clGetKeySignature(String className, Node getKey) {
            if (!getKey.hasChildren() || !getKey.getFirstChild().isFunction()) {
                return false;
            }
            Node getFunction = getKey.getFirstChild();
            if (!getFunction.hasChildren() || !getFunction.getLastChild().isNormalBlock()) {
                return false;
            }
            Node getBlock = getFunction.getLastChild();
            if (!(getBlock.hasChildren() && getBlock.hasOneChild() && getBlock.getFirstChild().isReturn())) {
                return false;
            }
            Node returnStatement = getBlock.getFirstChild();
            if (!returnStatement.getFirstChild().isComma()) {
                return false;
            }
            Node multiExpression = returnStatement.getFirstChild();
            if (!multiExpression.getFirstChild().isCall() || !multiExpression.getSecondChild().isGetProp()) {
                return false;
            }
            Node clinitFunction = multiExpression.getFirstFirstChild();
            Node internalProp = multiExpression.getSecondChild();
            if (!clinitFunction.matchesQualifiedName(className + ".$clinit")) {
                return false;
            }
            return internalProp.getQualifiedName().startsWith(className + ".$");
        }

        private boolean matchesJ2clSetKeySignature(String className, Node setKey) {
            if (!setKey.hasChildren() || !setKey.getFirstChild().isFunction()) {
                return false;
            }
            Node setFunction = setKey.getFirstChild();
            if (!(setFunction.hasChildren() && setFunction.getLastChild().isNormalBlock() && setFunction.getSecondChild().isParamList())) {
                return false;
            }
            if (!setFunction.getSecondChild().hasOneChild()) {
                return false;
            }
            Node setBlock = setFunction.getLastChild();
            if (!(setBlock.hasChildren() && setBlock.getFirstChild().isExprResult() && setBlock.getFirstFirstChild().isComma())) {
                return false;
            }
            Node multiExpression = setBlock.getFirstFirstChild();
            if (multiExpression.getChildCount() != 2 || !multiExpression.getSecondChild().isAssign()) {
                return false;
            }
            Node clinitFunction = multiExpression.getFirstFirstChild();
            return clinitFunction.matchesQualifiedName(className + ".$clinit");
        }

        private class InlinePropertiesPass
        extends NodeTraversal.AbstractPostOrderCallback {
            private Map<String, J2clProperty> propertiesByName;

            InlinePropertiesPass(Map<String, J2clProperty> allGetterSetters) {
                this.propertiesByName = allGetterSetters;
            }

            private void run() {
                NodeTraversal.traverseEs6(J2clPropertyInlinerPass.this.compiler, StaticFieldGetterSetterInliner.this.root, this);
                for (J2clProperty prop : this.propertiesByName.values()) {
                    if (!prop.isSafeToInline) continue;
                    prop.remove();
                }
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (n.isGetProp()) {
                    if (parent.isExprResult()) {
                        return;
                    }
                    if (NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == n) {
                        return;
                    }
                    String accessName = n.getQualifiedName();
                    J2clProperty prop = this.propertiesByName.get(accessName);
                    if (prop != null && prop.isSafeToInline) {
                        FunctionInjector injector = new FunctionInjector(J2clPropertyInlinerPass.this.compiler, J2clPropertyInlinerPass.this.compiler.getUniqueNameIdSupplier(), true, true, true);
                        Node inlinedCall = injector.inline(new FunctionInjector.Reference(n, t.getScope(), t.getModule(), FunctionInjector.InliningMode.DIRECT), null, prop.getKey.getFirstChild());
                        t.getCompiler().reportChangeToEnclosingScope(inlinedCall);
                    }
                }
                if (n.isAssign()) {
                    String accessName;
                    J2clProperty prop;
                    Node assignmentTarget = n.getFirstChild();
                    Node assignmentValue = n.getLastChild();
                    if (assignmentTarget.isGetProp() && (prop = this.propertiesByName.get(accessName = assignmentTarget.getQualifiedName())) != null && prop.isSafeToInline) {
                        FunctionInjector injector = new FunctionInjector(J2clPropertyInlinerPass.this.compiler, J2clPropertyInlinerPass.this.compiler.getUniqueNameIdSupplier(), true, true, true);
                        assignmentValue.detach();
                        Node functionCall = IR.call(IR.empty(), assignmentValue);
                        parent.replaceChild(n, functionCall);
                        FunctionInjector.Reference reference = new FunctionInjector.Reference(functionCall, t.getScope(), t.getModule(), FunctionInjector.InliningMode.BLOCK);
                        injector.maybePrepareCall(reference);
                        Node inlinedCall = injector.inline(reference, null, prop.setKey.getFirstChild());
                        t.getCompiler().reportChangeToEnclosingScope(inlinedCall);
                    }
                }
            }
        }

        private class DetermineInlinableProperties
        extends NodeTraversal.AbstractPostOrderCallback {
            private Map<String, J2clProperty> propertiesByName;

            DetermineInlinableProperties(Map<String, J2clProperty> allGetterSetters) {
                this.propertiesByName = allGetterSetters;
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                String accessName;
                J2clProperty prop;
                Node assignmentTarget;
                if ((NodeUtil.isCompoundAssignmentOp(n) || n.isInc() || n.isDec()) && (assignmentTarget = n.getFirstChild()).isGetProp() && (prop = this.propertiesByName.get(accessName = assignmentTarget.getQualifiedName())) != null) {
                    prop.isSafeToInline = false;
                }
            }
        }

        private class GatherJ2CLClassGetterSetters
        extends NodeTraversal.AbstractPostOrderCallback {
            private Map<String, J2clProperty> j2clPropertiesByName = new HashMap<String, J2clProperty>();

            private GatherJ2CLClassGetterSetters() {
            }

            private Map<String, J2clProperty> getResults() {
                return this.j2clPropertiesByName;
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (!NodeUtil.isObjectDefinePropertiesDefinition(n)) {
                    return;
                }
                Node className = n.getSecondChild();
                if (!className.isName()) {
                    return;
                }
                String classNameString = className.getQualifiedName();
                for (Node p : NodeUtil.getObjectDefinedPropertiesKeys(n)) {
                    String name = p.getString();
                    Node propertyLiteral = p.getFirstChild();
                    Node getKey = null;
                    Node setKey = null;
                    for (Node innerKey : propertyLiteral.children()) {
                        if (!innerKey.isStringKey()) continue;
                        switch (innerKey.getString()) {
                            case "get": {
                                if (!StaticFieldGetterSetterInliner.this.matchesJ2clGetKeySignature(classNameString, innerKey)) break;
                                getKey = innerKey;
                                break;
                            }
                            case "set": {
                                if (!StaticFieldGetterSetterInliner.this.matchesJ2clSetKeySignature(classNameString, innerKey)) break;
                                setKey = innerKey;
                            }
                        }
                    }
                    if (getKey == null || setKey == null) continue;
                    this.j2clPropertiesByName.put(classNameString + "." + name, new J2clProperty(getKey, setKey));
                }
            }
        }

        private class J2clProperty {
            private Node getKey;
            private Node setKey;
            private boolean isSafeToInline;

            public J2clProperty(Node getKey, Node setKey) {
                this.getKey = getKey;
                this.setKey = setKey;
                this.isSafeToInline = true;
            }

            void remove() {
                Node nodeToDetach = this.getKey.getGrandparent();
                Node objectLit = nodeToDetach.getParent();
                Preconditions.checkArgument((boolean)objectLit.isObjectLit());
                nodeToDetach.detach();
                NodeUtil.markFunctionsDeleted(nodeToDetach, J2clPropertyInlinerPass.this.compiler);
                J2clPropertyInlinerPass.this.compiler.reportChangeToEnclosingScope(objectLit);
                if (!objectLit.hasChildren()) {
                    objectLit.getParent().getParent().detach();
                }
            }
        }
    }
}

