/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Reference;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.ReferenceCollection;
import com.google.javascript.jscomp.ReferenceMap;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class InlineObjectLiterals
implements CompilerPass {
    public static final String VAR_PREFIX = "JSCompiler_object_inline_";
    private final AbstractCompiler compiler;
    private final Supplier<String> safeNameIdSupplier;

    InlineObjectLiterals(AbstractCompiler compiler, Supplier<String> safeNameIdSupplier) {
        this.compiler = compiler;
        this.safeNameIdSupplier = safeNameIdSupplier;
    }

    @Override
    public void process(Node externs, Node root) {
        ReferenceCollectingCallback callback = new ReferenceCollectingCallback(this.compiler, new InliningBehavior(), new Es6SyntacticScopeCreator(this.compiler));
        callback.process(externs, root);
    }

    private class InliningBehavior
    implements ReferenceCollectingCallback.Behavior {
        private final Set<Var> staleVars = new HashSet<Var>();

        private InliningBehavior() {
        }

        @Override
        public void afterExitScope(NodeTraversal t, ReferenceMap referenceMap) {
            for (Var var : t.getScope().getVarIterable()) {
                if (this.isVarInlineForbidden(var)) continue;
                ReferenceCollection referenceInfo = referenceMap.getReferences(var);
                if (!this.isInlinableObject(referenceInfo.references)) continue;
                this.staleVars.add(var);
                Reference init = referenceInfo.getInitializingReference();
                this.splitObject(var, init, referenceInfo);
            }
        }

        private void blacklistVarReferencesInTree(Node root, final Scope scope) {
            NodeUtil.visitPreOrder(root, new NodeUtil.Visitor(){

                @Override
                public void visit(Node node) {
                    if (node.isName()) {
                        InliningBehavior.this.staleVars.add(scope.getVar(node.getString()));
                    }
                }
            }, NodeUtil.MATCH_NOT_FUNCTION);
        }

        private boolean isVarInlineForbidden(Var var) {
            return var.isGlobal() || var.isExtern() || InlineObjectLiterals.this.compiler.getCodingConvention().isExported(var.name) || InlineObjectLiterals.this.compiler.getCodingConvention().isPropertyRenameFunction(var.nameNode.getQualifiedName()) || this.staleVars.contains(var);
        }

        private boolean isInlinableObject(List<Reference> refs) {
            boolean ret = false;
            HashSet<String> validProperties = new HashSet<String>();
            for (Reference ref : refs) {
                Node name = ref.getNode();
                Node parent = ref.getParent();
                Node grandparent = ref.getGrandparent();
                if (parent.isGetProp()) {
                    Preconditions.checkState((parent.getFirstChild() == name ? 1 : 0) != 0);
                    if (grandparent.isCall() && grandparent.getFirstChild() == parent) {
                        return false;
                    }
                    if (grandparent.isDelProp()) {
                        return false;
                    }
                    String propName = parent.getLastChild().getString();
                    if (validProperties.contains(propName)) continue;
                    if (NodeUtil.isNameDeclOrSimpleAssignLhs(parent, grandparent)) {
                        validProperties.add(propName);
                        continue;
                    }
                    return false;
                }
                if (!this.isVarOrAssignExprLhs(name)) {
                    return false;
                }
                Node val = ref.getAssignedValue();
                if (val == null) continue;
                if (!val.isObjectLit()) {
                    return false;
                }
                for (Node child = val.getFirstChild(); child != null; child = child.getNext()) {
                    if (child.isGetterDef() || child.isSetterDef()) {
                        return false;
                    }
                    if (child.isComputedProp()) {
                        return false;
                    }
                    validProperties.add(child.getString());
                    Node childVal = child.getFirstChild();
                    for (Reference t : refs) {
                        Node refNode = t.getParent();
                        while (!NodeUtil.isStatementBlock(refNode)) {
                            if (refNode == childVal) {
                                return false;
                            }
                            refNode = refNode.getParent();
                        }
                    }
                }
                ret = true;
            }
            return ret;
        }

        private boolean isVarOrAssignExprLhs(Node n) {
            Node parent = n.getParent();
            return parent.isVar() || parent.isAssign() && parent.getFirstChild() == n && parent.getParent().isExprResult();
        }

        private Map<String, String> computeVarList(ReferenceCollection referenceInfo) {
            LinkedHashMap<String, String> varmap = new LinkedHashMap<String, String>();
            for (Reference ref : referenceInfo.references) {
                if (ref.isLvalue() || ref.isInitializingDeclaration()) {
                    Node val = ref.getAssignedValue();
                    if (val == null) continue;
                    Preconditions.checkState((boolean)val.isObjectLit(), (Object)val);
                    for (Node child = val.getFirstChild(); child != null; child = child.getNext()) {
                        String varname = child.getString();
                        if (varmap.containsKey(varname)) continue;
                        String var = InlineObjectLiterals.VAR_PREFIX + varname + "_" + (String)InlineObjectLiterals.this.safeNameIdSupplier.get();
                        varmap.put(varname, var);
                    }
                    continue;
                }
                if (ref.getParent().isVar()) continue;
                Node getprop = ref.getParent();
                Preconditions.checkState((boolean)getprop.isGetProp(), (Object)getprop);
                String varname = getprop.getLastChild().getString();
                if (varmap.containsKey(varname)) continue;
                String var = InlineObjectLiterals.VAR_PREFIX + varname + "_" + (String)InlineObjectLiterals.this.safeNameIdSupplier.get();
                varmap.put(varname, var);
            }
            return varmap;
        }

        private void fillInitialValues(Reference init, Map<String, Node> initvals) {
            Node object = init.getAssignedValue();
            Preconditions.checkState((boolean)object.isObjectLit(), (Object)object);
            for (Node key = object.getFirstChild(); key != null; key = key.getNext()) {
                initvals.put(key.getString(), key.removeFirstChild());
            }
        }

        private void replaceAssignmentExpression(Var v, Reference ref, Map<String, String> varmap) {
            Node replacement;
            List nodes = new ArrayList<Node>();
            Node val = ref.getAssignedValue();
            this.blacklistVarReferencesInTree(val, v.scope);
            Preconditions.checkState((boolean)val.isObjectLit(), (Object)val);
            LinkedHashSet<String> all = new LinkedHashSet<String>(varmap.keySet());
            for (Object key = val.getFirstChild(); key != null; key = ((Node)key).getNext()) {
                String var = ((Node)key).getString();
                Node value = ((Node)key).removeFirstChild();
                nodes.add(IR.assign(IR.name(varmap.get(var)), value));
                all.remove(var);
            }
            for (String var : all) {
                nodes.add(IR.assign(IR.name(varmap.get(var)), NodeUtil.newUndefinedNode(null)));
            }
            if (nodes.isEmpty()) {
                replacement = IR.trueNode();
            } else {
                int i;
                nodes.add(IR.trueNode());
                nodes = Lists.reverse(nodes);
                Node cur = replacement = new Node(Token.COMMA);
                for (i = 0; i < nodes.size() - 2; ++i) {
                    cur.addChildToFront((Node)nodes.get(i));
                    Node t = new Node(Token.COMMA);
                    cur.addChildToFront(t);
                    cur = t;
                }
                cur.addChildToFront((Node)nodes.get(i));
                cur.addChildToFront((Node)nodes.get(i + 1));
            }
            Node replace = ref.getParent();
            replacement.useSourceInfoIfMissingFromForTree(replace);
            if (replace.isVar()) {
                replace.replaceWith(NodeUtil.newExpr(replacement));
            } else {
                replace.replaceWith(replacement);
            }
        }

        private void splitObject(Var v, Reference init, ReferenceCollection referenceInfo) {
            Node vnode;
            boolean defined;
            Map<String, String> varmap = this.computeVarList(referenceInfo);
            HashMap<String, Node> initvals = new HashMap<String, Node>();
            boolean bl = defined = referenceInfo.isWellDefined() && init.getParent().isVar();
            if (defined) {
                vnode = init.getParent();
                this.fillInitialValues(init, initvals);
            } else {
                vnode = v.getScope().getClosestHoistScope().getRootNode().getFirstChild();
            }
            Preconditions.checkState((boolean)NodeUtil.isStatement(vnode), (Object)vnode);
            for (Map.Entry<String, String> entry : varmap.entrySet()) {
                Node val = (Node)initvals.get(entry.getKey());
                Node newVarNode = NodeUtil.newVarNode(entry.getValue(), val);
                if (val == null) {
                    newVarNode.useSourceInfoIfMissingFromForTree(vnode);
                } else {
                    this.blacklistVarReferencesInTree(val, v.scope);
                }
                vnode.getParent().addChildBefore(newVarNode, vnode);
                InlineObjectLiterals.this.compiler.reportChangeToEnclosingScope(vnode);
            }
            if (defined) {
                InlineObjectLiterals.this.compiler.reportChangeToEnclosingScope(vnode.getParent());
                vnode.detach();
            }
            for (Reference ref : referenceInfo.references) {
                if (defined && ref == init) continue;
                InlineObjectLiterals.this.compiler.reportChangeToEnclosingScope(ref.getNode());
                if (ref.isLvalue()) {
                    this.replaceAssignmentExpression(v, ref, varmap);
                    continue;
                }
                if (ref.getParent().isVar()) {
                    ref.getGrandparent().removeChild(ref.getParent());
                    continue;
                }
                Node getprop = ref.getParent();
                Preconditions.checkState((boolean)getprop.isGetProp(), (Object)getprop);
                String var = getprop.getSecondChild().getString();
                Preconditions.checkState((boolean)varmap.containsKey(var));
                Node replacement = IR.name(varmap.get(var));
                replacement.useSourceInfoIfMissingFrom(getprop);
                ref.getGrandparent().replaceChild(ref.getParent(), replacement);
            }
        }
    }
}

