/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import java.util.Set;
import javax.annotation.Nullable;

public class Es6SyntacticScopeCreator
implements ScopeCreator {
    private final AbstractCompiler compiler;
    private final RedeclarationHandler redeclarationHandler;
    private final ScopeFactory scopeFactory;
    private static final String ARGUMENTS = "arguments";
    public static final RedeclarationHandler DEFAULT_REDECLARATION_HANDLER = new DefaultRedeclarationHandler();

    public Es6SyntacticScopeCreator(AbstractCompiler compiler) {
        this(compiler, DEFAULT_REDECLARATION_HANDLER);
    }

    public Es6SyntacticScopeCreator(AbstractCompiler compiler, ScopeFactory scopeFactory) {
        this(compiler, DEFAULT_REDECLARATION_HANDLER, scopeFactory);
    }

    Es6SyntacticScopeCreator(AbstractCompiler compiler, RedeclarationHandler redeclarationHandler) {
        this(compiler, redeclarationHandler, new DefaultScopeFactory());
    }

    Es6SyntacticScopeCreator(AbstractCompiler compiler, RedeclarationHandler redeclarationHandler, ScopeFactory scopeFactory) {
        this.compiler = compiler;
        this.redeclarationHandler = redeclarationHandler;
        this.scopeFactory = scopeFactory;
    }

    @Override
    public boolean hasBlockScope() {
        return true;
    }

    public Scope createScope(Node n, Scope parent) {
        Scope scope = this.scopeFactory.create(parent, n);
        new ScopeScanner(this.compiler, this.redeclarationHandler, scope, null).populate();
        return scope;
    }

    static class DefaultRedeclarationHandler
    implements RedeclarationHandler {
        DefaultRedeclarationHandler() {
        }

        @Override
        public void onRedeclaration(Scope s, String name, Node n, CompilerInput input) {
        }
    }

    static interface RedeclarationHandler {
        public void onRedeclaration(Scope var1, String var2, Node var3, CompilerInput var4);
    }

    static class ScopeScanner {
        private final Scope scope;
        private final AbstractCompiler compiler;
        private final RedeclarationHandler redeclarationHandler;
        private InputId inputId;
        private final Set<Node> changeRootSet;

        ScopeScanner(AbstractCompiler compiler, Scope scope) {
            this(compiler, DEFAULT_REDECLARATION_HANDLER, scope, null);
        }

        ScopeScanner(AbstractCompiler compiler, RedeclarationHandler redeclarationHandler, Scope scope, Set<Node> changeRootSet) {
            this.compiler = compiler;
            this.redeclarationHandler = redeclarationHandler;
            this.scope = scope;
            this.changeRootSet = changeRootSet;
            Preconditions.checkState((changeRootSet == null || scope.isGlobal() ? 1 : 0) != 0);
        }

        void populate() {
            Node n = this.scope.getRootNode();
            this.inputId = NodeUtil.getInputId(n);
            switch (n.getToken()) {
                case FUNCTION: {
                    Node fnNameNode = n.getFirstChild();
                    Node args = fnNameNode.getNext();
                    Preconditions.checkState((boolean)args.isParamList());
                    this.declareLHS(this.scope, args);
                    String fnName = fnNameNode.getString();
                    if (!fnName.isEmpty() && NodeUtil.isFunctionExpression(n)) {
                        this.declareVar(this.scope, fnNameNode);
                    }
                    return;
                }
                case CLASS: {
                    Node classNameNode = n.getFirstChild();
                    if (!classNameNode.isEmpty() && NodeUtil.isClassExpression(n)) {
                        this.declareVar(this.scope, classNameNode);
                    }
                    return;
                }
                case ROOT: 
                case SCRIPT: {
                    Preconditions.checkState((boolean)this.scope.isGlobal(), (Object)this.scope);
                    this.scanVars(n, this.scope, this.scope);
                    return;
                }
                case MODULE_BODY: {
                    this.scanVars(n, this.scope, this.scope);
                    return;
                }
                case FOR: 
                case FOR_OF: 
                case FOR_IN: 
                case SWITCH: {
                    this.scanVars(n, null, this.scope);
                    return;
                }
                case BLOCK: {
                    if (NodeUtil.isFunctionBlock(n)) {
                        this.scanVars(n, this.scope, this.scope);
                    } else {
                        this.scanVars(n, null, this.scope);
                    }
                    return;
                }
            }
            throw new RuntimeException("Illegal scope root: " + n);
        }

        private void declareLHS(Scope s, Node n) {
            for (Node lhs : NodeUtil.getLhsNodesOfDeclaration(n)) {
                this.declareVar(s, lhs);
            }
        }

        private void scanVars(Node n, @Nullable Scope hoistScope, @Nullable Scope blockScope) {
            boolean enteringNewBlock;
            switch (n.getToken()) {
                case VAR: {
                    if (hoistScope != null) {
                        this.declareLHS(hoistScope, n);
                    }
                    return;
                }
                case LET: 
                case CONST: {
                    if (blockScope != null) {
                        this.declareLHS(blockScope, n);
                    }
                    return;
                }
                case IMPORT: {
                    this.declareLHS(hoistScope, n);
                    return;
                }
                case FUNCTION: {
                    if (NodeUtil.isFunctionExpression(n) || blockScope == null) {
                        return;
                    }
                    String fnName = n.getFirstChild().getString();
                    if (fnName.isEmpty()) {
                        return;
                    }
                    this.declareVar(blockScope, n.getFirstChild());
                    return;
                }
                case CLASS: {
                    if (NodeUtil.isClassExpression(n) || blockScope == null) {
                        return;
                    }
                    String className = n.getFirstChild().getString();
                    if (className.isEmpty()) {
                        return;
                    }
                    this.declareVar(blockScope, n.getFirstChild());
                    return;
                }
                case CATCH: {
                    Preconditions.checkState((boolean)n.hasTwoChildren(), (Object)n);
                    if (blockScope != null) {
                        this.declareLHS(blockScope, n);
                    }
                    Node block = n.getSecondChild();
                    this.scanVars(block, hoistScope, blockScope);
                    return;
                }
                case SCRIPT: {
                    if (this.changeRootSet != null && !this.changeRootSet.contains(n)) {
                        return;
                    }
                    this.inputId = n.getInputId();
                    Preconditions.checkNotNull((Object)this.inputId);
                    break;
                }
                case MODULE_BODY: {
                    if (!hoistScope.isGlobal()) break;
                    return;
                }
            }
            boolean isBlockStart = blockScope != null && n == blockScope.getRootNode();
            boolean bl = enteringNewBlock = !isBlockStart && NodeUtil.createsBlockScope(n);
            if (enteringNewBlock && hoistScope == null) {
                return;
            }
            if (NodeUtil.isControlStructure(n) || NodeUtil.isStatementBlock(n)) {
                Node child = n.getFirstChild();
                while (child != null) {
                    Node next = child.getNext();
                    this.scanVars(child, hoistScope, enteringNewBlock ? null : blockScope);
                    child = next;
                }
            }
        }

        private void declareVar(Scope s, Node n) {
            Preconditions.checkState((n.isName() || n.isStringKey() || n.isImportStar() ? 1 : 0) != 0, (String)"Invalid node for declareVar: %s", (Object)n);
            String name = n.getString();
            Var v = s.getOwnSlot(name);
            if (v != null && v.getNode() == n) {
                return;
            }
            CompilerInput input = this.compiler.getInput(this.inputId);
            if (v != null || !ScopeScanner.isShadowingAllowed(name, s) || (s.isFunctionScope() || s.isFunctionBlockScope()) && name.equals(Es6SyntacticScopeCreator.ARGUMENTS)) {
                this.redeclarationHandler.onRedeclaration(s, name, n, input);
            } else {
                s.declare(name, n, input);
            }
        }

        private static boolean isShadowingAllowed(String name, Scope s) {
            if (s.isFunctionBlockScope()) {
                Var maybeParam = s.getParent().getOwnSlot(name);
                return maybeParam == null || !maybeParam.isParam();
            }
            return true;
        }
    }

    private static class DefaultScopeFactory
    implements ScopeFactory {
        private DefaultScopeFactory() {
        }

        @Override
        public Scope create(Scope parent, Node n) {
            return parent == null ? Scope.createGlobalScope(n) : new Scope(parent, n);
        }
    }

    public static interface ScopeFactory {
        public Scope create(Scope var1, Node var2);
    }
}

