/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.ExpressionDecomposer;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.rhino.FunctionTypeI;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.ObjectTypeI;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public final class Es6RewriteGenerators
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final String GENERATOR_PRELOAD_FUNCTION_NAME = "$jscomp$generator$function$name";
    private static final String GENERATOR_STATE = "$jscomp$generator$state";
    private static final String GENERATOR_DO_WHILE_INITIAL = "$jscomp$generator$first$do";
    private static final String GENERATOR_YIELD_ALL_NAME = "$jscomp$generator$yield$all";
    private static final String GENERATOR_YIELD_ALL_ENTRY = "$jscomp$generator$yield$entry";
    private static final String GENERATOR_ARGUMENTS = "$jscomp$generator$arguments";
    private static final String GENERATOR_THIS = "$jscomp$generator$this";
    private static final String GENERATOR_ACTION_ARG = "$jscomp$generator$action$arg";
    private static final double GENERATOR_ACTION_NEXT = 0.0;
    private static final double GENERATOR_ACTION_THROW = 1.0;
    private static final String GENERATOR_NEXT_ARG = "$jscomp$generator$next$arg";
    private static final String GENERATOR_THROW_ARG = "$jscomp$generator$throw$arg";
    private static final String GENERATOR_SWITCH_ENTERED = "$jscomp$generator$switch$entered";
    private static final String GENERATOR_SWITCH_VAL = "$jscomp$generator$switch$val";
    private static final String GENERATOR_FINALLY_JUMP = "$jscomp$generator$finally";
    private static final String GENERATOR_ERROR = "$jscomp$generator$global$error";
    private static final String GENERATOR_FOR_IN_ARRAY = "$jscomp$generator$forin$array";
    private static final String GENERATOR_FOR_IN_VAR = "$jscomp$generator$forin$var";
    private static final String GENERATOR_FOR_IN_ITER = "$jscomp$generator$forin$iter";
    private static final String GENERATOR_LOOP_GUARD = "$jscomp$generator$loop$guard";
    private final AbstractCompiler compiler;
    private final List<LoopContext> currentLoopContext;
    private final List<ExceptionContext> currentExceptionContext;
    private static int generatorCaseCount;
    private Supplier<String> generatorCounter;
    private Node enclosingBlock;
    private Node hoistRoot;
    private Node originalGeneratorBody;
    private Node currentStatement;
    private boolean hasTranslatedTry;
    private final boolean addTypes;
    private final TypeIRegistry registry;
    private final TypeI unknownType;
    private final TypeI undefinedType;
    private final TypeI stringType;
    private final TypeI booleanType;
    private final TypeI falseType;
    private final TypeI trueType;
    private final TypeI numberType;

    public Es6RewriteGenerators(AbstractCompiler compiler) {
        Preconditions.checkNotNull((Object)compiler);
        this.compiler = compiler;
        this.currentLoopContext = new ArrayList<LoopContext>();
        this.currentExceptionContext = new ArrayList<ExceptionContext>();
        this.generatorCounter = compiler.getUniqueNameIdSupplier();
        this.addTypes = AbstractCompiler.MostRecentTypechecker.NTI.equals((Object)compiler.getMostRecentTypechecker());
        this.registry = compiler.getTypeIRegistry();
        this.unknownType = Es6ToEs3Util.createType(this.addTypes, this.registry, JSTypeNative.UNKNOWN_TYPE);
        this.undefinedType = Es6ToEs3Util.createType(this.addTypes, this.registry, JSTypeNative.VOID_TYPE);
        this.stringType = Es6ToEs3Util.createType(this.addTypes, this.registry, JSTypeNative.STRING_TYPE);
        this.booleanType = Es6ToEs3Util.createType(this.addTypes, this.registry, JSTypeNative.BOOLEAN_TYPE);
        this.falseType = Es6ToEs3Util.createType(this.addTypes, this.registry, JSTypeNative.FALSE_TYPE);
        this.trueType = Es6ToEs3Util.createType(this.addTypes, this.registry, JSTypeNative.TRUE_TYPE);
        this.numberType = Es6ToEs3Util.createType(this.addTypes, this.registry, JSTypeNative.NUMBER_TYPE);
    }

    @Override
    public void process(Node externs, Node root) {
        boolean reportChange = Es6RewriteGenerators.getPreloadedGeneratorFunc(this.compiler.getJsRoot()) != null;
        TranspilationPasses.processTranspile(this.compiler, root, new DecomposeYields(this.compiler), this);
        this.cleanUpGeneratorSkeleton(reportChange);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, new DecomposeYields(this.compiler), this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case FUNCTION: {
                if (!n.isGeneratorFunction()) break;
                generatorCaseCount = 0;
                this.visitGenerator(n, parent);
                break;
            }
            case NAME: {
                Node enclosing = NodeUtil.getEnclosingFunction(n);
                if (enclosing == null || !enclosing.isGeneratorFunction() || !n.matchesQualifiedName("arguments")) break;
                n.setString(GENERATOR_ARGUMENTS);
                break;
            }
            case THIS: {
                Node enclosing = NodeUtil.getEnclosingFunction(n);
                if (enclosing == null || !enclosing.isGeneratorFunction()) break;
                n.replaceWith(Es6ToEs3Util.withType(IR.name(GENERATOR_THIS), n.getTypeI()));
                break;
            }
            case YIELD: {
                if (n.isYieldAll()) {
                    this.visitYieldAll(t, n, parent);
                    break;
                }
                if (!parent.isExprResult()) {
                    this.visitYieldExpr(t, n, parent);
                    break;
                }
                this.visitYieldThrows(t, parent, parent.getParent());
                break;
            }
        }
    }

    private void visitYieldThrows(NodeTraversal t, Node n, Node parent) {
        Node ifThrows = IR.ifNode(this.withBooleanType(IR.eq(this.withNumberType(IR.name(GENERATOR_ACTION_ARG)), this.withNumberType(IR.number(1.0)))), IR.block(IR.throwNode(this.withUnknownType(IR.name(GENERATOR_THROW_ARG)))));
        parent.addChildAfter(ifThrows, n);
        t.reportCodeChange();
    }

    private void visitYieldAll(NodeTraversal t, Node n, Node parent) {
        ObjectTypeI yieldAllType = null;
        TypeI typeParam = this.unknownType;
        if (this.addTypes) {
            yieldAllType = n.getFirstChild().getTypeI().autobox().toMaybeObjectType();
            typeParam = (TypeI)yieldAllType.getTemplateTypes().get(0);
        }
        TypeI iteratorType = this.createGenericType(JSTypeNative.ITERATOR_TYPE, typeParam);
        TypeI iteratorNextType = this.addTypes ? iteratorType.toMaybeObjectType().getPropertyType("next") : null;
        TypeI iIterableResultType = this.createGenericType(JSTypeNative.I_ITERABLE_RESULT_TYPE, typeParam);
        TypeI iIterableResultDoneType = this.addTypes ? iIterableResultType.toMaybeObjectType().getPropertyType("done") : null;
        TypeI iIterableResultValueType = this.addTypes ? iIterableResultType.toMaybeObjectType().getPropertyType("value") : null;
        Node enclosingStatement = NodeUtil.getEnclosingStatement(n);
        Node iterator = Es6ToEs3Util.makeIterator(this.compiler, n.removeFirstChild());
        if (this.addTypes) {
            TypeI jscompType = t.getScope().getVar("$jscomp").getNode().getTypeI();
            TypeI makeIteratorType = jscompType.toMaybeObjectType().getPropertyType("makeIterator");
            iterator.getFirstChild().setTypeI(makeIteratorType);
            iterator.getFirstFirstChild().setTypeI(jscompType);
        }
        Node generator = IR.var(Es6ToEs3Util.withType(IR.name(GENERATOR_YIELD_ALL_NAME), iteratorType), Es6ToEs3Util.withType(iterator, iteratorType));
        Node entryDecl = IR.var(Es6ToEs3Util.withType(IR.name(GENERATOR_YIELD_ALL_ENTRY), iIterableResultType));
        Node assignIterResult = Es6ToEs3Util.withType(IR.assign(Es6ToEs3Util.withType(IR.name(GENERATOR_YIELD_ALL_ENTRY), iIterableResultType), Es6ToEs3Util.withType(IR.call(Es6ToEs3Util.withType(IR.getprop(Es6ToEs3Util.withType(IR.name(GENERATOR_YIELD_ALL_NAME), iteratorType), this.withStringType(IR.string("next"))), iteratorNextType), this.withUnknownType(IR.name(GENERATOR_NEXT_ARG))), iIterableResultType)), iIterableResultType);
        Node loopCondition = this.withBooleanType(IR.not(Es6ToEs3Util.withType(IR.getprop(assignIterResult, this.withStringType(IR.string("done"))), iIterableResultDoneType)));
        Node elemValue = Es6ToEs3Util.withType(IR.getprop(Es6ToEs3Util.withType(IR.name(GENERATOR_YIELD_ALL_ENTRY), iIterableResultType), this.withStringType(IR.string("value"))), iIterableResultValueType);
        Node yieldStatement = IR.exprResult(this.withUnknownType(IR.yield(elemValue.cloneTree())));
        Node loop = IR.whileNode(loopCondition, IR.block(yieldStatement));
        enclosingStatement.getParent().addChildBefore(generator, enclosingStatement);
        enclosingStatement.getParent().addChildBefore(entryDecl, enclosingStatement);
        enclosingStatement.getParent().addChildBefore(loop, enclosingStatement);
        if (parent.isExprResult()) {
            parent.detach();
        } else {
            parent.replaceChild(n, elemValue);
        }
        this.visitYieldThrows(t, yieldStatement, yieldStatement.getParent());
        t.reportCodeChange();
    }

    private void visitYieldExpr(NodeTraversal t, Node n, Node parent) {
        Node enclosingStatement = NodeUtil.getEnclosingStatement(n);
        Node yieldStatement = IR.exprResult(n.hasChildren() ? Es6ToEs3Util.withType(IR.yield(n.removeFirstChild()), n.getTypeI()) : Es6ToEs3Util.withType(IR.yield(), n.getTypeI()));
        Node yieldResult = this.withUnknownType(IR.name(GENERATOR_NEXT_ARG + (String)this.generatorCounter.get()));
        Node yieldResultDecl = IR.var(yieldResult.cloneTree(), this.withUnknownType(IR.name(GENERATOR_NEXT_ARG)));
        parent.replaceChild(n, yieldResult);
        enclosingStatement.getParent().addChildBefore(yieldStatement, enclosingStatement);
        enclosingStatement.getParent().addChildBefore(yieldResultDecl, enclosingStatement);
        this.visitYieldThrows(t, yieldStatement, yieldStatement.getParent());
        t.reportCodeChange();
    }

    private void visitGenerator(Node n, Node parent) {
        Es6ToEs3Util.preloadEs6Symbol(this.compiler);
        this.hasTranslatedTry = false;
        Node genBlock = Es6RewriteGenerators.preloadGeneratorSkeleton(this.compiler, false).getLastChild().cloneTree();
        ++generatorCaseCount;
        this.originalGeneratorBody = n.getLastChild();
        n.replaceChild(this.originalGeneratorBody, genBlock);
        NodeUtil.markNewScopesChanged(genBlock, this.compiler);
        n.setIsGeneratorFunction(false);
        TypeI generatorFuncType = n.getTypeI();
        TypeI generatorReturnType = this.addTypes ? generatorFuncType.toMaybeFunctionType().getReturnType() : null;
        TypeI yieldType = this.unknownType;
        if (this.addTypes) {
            if (generatorReturnType.isGenericObjectType()) {
                yieldType = (TypeI)generatorReturnType.autobox().toMaybeObjectType().getTemplateTypes().get(0);
            }
            this.addTypesToGeneratorSkeleton(genBlock, yieldType);
        }
        JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(n.getJSDocInfo());
        builder.recordSuppressions((Set<String>)ImmutableSet.of((Object)"uselessCode"));
        JSDocInfo info = builder.build();
        n.setJSDocInfo(info);
        this.originalGeneratorBody.addChildToBack(IR.exprResult(this.withNumberType(IR.assign(this.withNumberType(IR.name(GENERATOR_STATE)), this.withNumberType(IR.number(-1.0))))));
        this.enclosingBlock = this.getUnique(genBlock, Token.CASE).getLastChild();
        this.hoistRoot = genBlock.getFirstChild();
        if (NodeUtil.isNameReferenced(this.originalGeneratorBody, GENERATOR_ARGUMENTS)) {
            this.hoistRoot.getParent().addChildAfter(IR.var(this.withUnknownType(IR.name(GENERATOR_ARGUMENTS)), this.withUnknownType(IR.name("arguments"))), this.hoistRoot);
        }
        if (NodeUtil.isNameReferenced(this.originalGeneratorBody, GENERATOR_THIS)) {
            this.hoistRoot.getParent().addChildAfter(IR.var(this.withUnknownType(IR.name(GENERATOR_THIS)), this.withUnknownType(IR.thisNode())), this.hoistRoot);
        }
        while (this.originalGeneratorBody.hasChildren()) {
            this.currentStatement = this.originalGeneratorBody.removeFirstChild();
            boolean advanceCase = this.translateStatementInOriginalBody();
            if (!advanceCase) continue;
            int caseNumber = this.currentStatement.isGeneratorMarker() ? (int)this.currentStatement.getFirstChild().getDouble() : generatorCaseCount++;
            Node oldCase = this.enclosingBlock.getParent();
            Node newCase = this.withBooleanType(IR.caseNode(this.withNumberType(IR.number(caseNumber)), IR.block()));
            this.enclosingBlock = newCase.getLastChild();
            if (oldCase.isTry()) {
                oldCase = oldCase.getGrandparent();
                if (!this.currentExceptionContext.isEmpty()) {
                    Node newTry = IR.tryCatch(IR.block(), this.currentExceptionContext.get((int)0).catchBlock.cloneTree());
                    newCase.getLastChild().addChildToBack(newTry);
                    this.enclosingBlock = newCase.getLastChild().getLastChild().getFirstChild();
                }
            }
            oldCase.getParent().addChildAfter(newCase, oldCase);
        }
        parent.useSourceInfoIfMissingFromForTree(parent);
        this.compiler.reportChangeToEnclosingScope(genBlock);
    }

    private boolean translateStatementInOriginalBody() {
        if (this.currentStatement.isVar()) {
            this.visitVar();
            return false;
        }
        if (this.currentStatement.isGeneratorMarker()) {
            this.visitGeneratorMarker();
            return true;
        }
        if (this.currentStatement.isFunction()) {
            this.visitFunctionStatement();
            return false;
        }
        if (this.currentStatement.isNormalBlock()) {
            this.visitBlock();
            return false;
        }
        if (this.controlCanExit(this.currentStatement)) {
            switch (this.currentStatement.getToken()) {
                case WHILE: 
                case DO: 
                case FOR: {
                    this.visitLoop(null);
                    return false;
                }
                case FOR_IN: {
                    this.visitForIn();
                    return false;
                }
                case LABEL: {
                    this.visitLabel();
                    return false;
                }
                case SWITCH: {
                    this.visitSwitch();
                    return false;
                }
                case IF: {
                    if (this.currentStatement.isGeneratorSafe()) break;
                    this.visitIf();
                    return false;
                }
                case TRY: {
                    this.visitTry();
                    return false;
                }
                case EXPR_RESULT: {
                    if (!this.currentStatement.getFirstChild().isYield()) break;
                    this.visitYieldExprResult();
                    return true;
                }
                case RETURN: {
                    this.visitReturn();
                    return false;
                }
                case CONTINUE: {
                    this.visitContinue();
                    return false;
                }
                case BREAK: {
                    if (this.currentStatement.isGeneratorSafe()) break;
                    this.visitBreak();
                    return false;
                }
                case THROW: {
                    this.visitThrow();
                    return false;
                }
                default: {
                    throw new RuntimeException("Untranslatable control-exiting statement in generator function: " + (Object)((Object)this.currentStatement.getToken()));
                }
            }
        }
        this.enclosingBlock.addChildToBack(this.currentStatement);
        return false;
    }

    private void visitFunctionStatement() {
        this.hoistRoot.getParent().addChildAfter(this.currentStatement, this.hoistRoot);
    }

    private void visitTry() {
        Node catchBody;
        Node caughtError;
        Node tryBody = this.currentStatement.getFirstChild();
        Node catchBlock = tryBody.getNext();
        if (catchBlock.hasChildren()) {
            caughtError = catchBlock.getFirstChild().removeFirstChild();
            catchBody = catchBlock.getFirstChild().removeFirstChild();
        } else {
            caughtError = this.withUnknownType(IR.name("$jscomp$generator$global$errortemp"));
            catchBody = IR.block(IR.throwNode(caughtError.cloneTree()));
            catchBody.getFirstChild().setGeneratorSafe(true);
        }
        Node finallyBody = catchBlock.getNext();
        int catchStartState = generatorCaseCount++;
        Node catchStart = this.makeGeneratorMarker(catchStartState);
        Node errorNameGenerated = this.withUnknownType(IR.name("$jscomp$generator$" + caughtError.getString()));
        this.originalGeneratorBody.addChildToFront(catchStart);
        this.originalGeneratorBody.addChildAfter(catchBody, catchStart);
        Node assignError = this.withUnknownType(IR.assign(this.withUnknownType(IR.name(GENERATOR_ERROR)), errorNameGenerated.cloneTree()));
        Node newCatchBody = IR.block(IR.exprResult(assignError), this.createStateUpdate(catchStartState), Es6RewriteGenerators.createSafeBreak());
        Node newCatch = IR.catchNode(errorNameGenerated, newCatchBody);
        this.currentExceptionContext.add(0, new ExceptionContext(catchStartState, newCatch));
        if (finallyBody != null) {
            Node finallyName = this.withNumberType(IR.name(GENERATOR_FINALLY_JUMP + (String)this.generatorCounter.get()));
            int finallyStartState = generatorCaseCount++;
            Node finallyStart = this.makeGeneratorMarker(finallyStartState);
            int finallyEndState = generatorCaseCount++;
            Node finallyEnd = this.makeGeneratorMarker(finallyEndState);
            NodeTraversal.traverseEs6(this.compiler, tryBody, new ControlExitsCheck(finallyName, finallyStartState));
            NodeTraversal.traverseEs6(this.compiler, catchBody, new ControlExitsCheck(finallyName, finallyStartState));
            this.originalGeneratorBody.addChildToFront(tryBody.detach());
            this.originalGeneratorBody.addChildAfter(finallyStart, catchBody);
            this.originalGeneratorBody.addChildAfter(finallyBody.detach(), finallyStart);
            this.originalGeneratorBody.addChildAfter(finallyEnd, finallyBody);
            this.originalGeneratorBody.addChildToFront(IR.var(finallyName.cloneTree()));
            finallyBody.addChildToBack(IR.exprResult(this.withNumberType(IR.assign(this.withNumberType(IR.name(GENERATOR_STATE)), finallyName.cloneTree()))));
            finallyBody.addChildToBack(Es6RewriteGenerators.createSafeBreak());
            tryBody.addChildToBack(IR.exprResult(this.withNumberType(IR.assign(finallyName.cloneTree(), this.withNumberType(IR.number(finallyEndState))))));
            tryBody.addChildToBack(this.createStateUpdate(finallyStartState));
            tryBody.addChildToBack(Es6RewriteGenerators.createSafeBreak());
            catchBody.addChildToBack(IR.exprResult(this.withNumberType(IR.assign(finallyName.cloneTree(), this.withNumberType(IR.number(finallyEndState))))));
        } else {
            int catchEndState = generatorCaseCount++;
            Node catchEnd = this.makeGeneratorMarker(catchEndState);
            this.originalGeneratorBody.addChildAfter(catchEnd, catchBody);
            tryBody.addChildToBack(this.createStateUpdate(catchEndState));
            tryBody.addChildToBack(Es6RewriteGenerators.createSafeBreak());
            this.originalGeneratorBody.addChildToFront(tryBody.detach());
        }
        catchBody.addChildToFront(IR.var(caughtError, this.withUnknownType(IR.name(GENERATOR_ERROR))));
        if (this.enclosingBlock.getParent().isTry()) {
            this.enclosingBlock = this.enclosingBlock.getGrandparent();
        }
        this.enclosingBlock.addChildToBack(IR.tryCatch(IR.block(), newCatch));
        this.enclosingBlock = this.enclosingBlock.getLastChild().getFirstChild();
        if (!this.hasTranslatedTry) {
            this.hasTranslatedTry = true;
            this.hoistRoot.getParent().addChildAfter(IR.var(this.withUnknownType(IR.name(GENERATOR_ERROR))), this.hoistRoot);
        }
    }

    private void visitContinue() {
        Preconditions.checkState((this.currentLoopContext.get((int)0).continueCase != -1 ? 1 : 0) != 0);
        int continueCase = this.currentStatement.hasChildren() ? this.getLoopContext((String)this.currentStatement.removeFirstChild().getString()).continueCase : this.currentLoopContext.get((int)0).continueCase;
        this.enclosingBlock.addChildToBack(this.createStateUpdate(continueCase));
        this.enclosingBlock.addChildToBack(Es6RewriteGenerators.createSafeBreak());
    }

    private void visitThrow() {
        this.enclosingBlock.addChildToBack(this.createStateUpdate(-1));
        this.enclosingBlock.addChildToBack(this.currentStatement);
    }

    private void visitBreak() {
        int breakCase;
        if (this.currentStatement.hasChildren()) {
            LoopContext loop = this.getLoopContext(this.currentStatement.removeFirstChild().getString());
            if (loop == null) {
                this.compiler.report(JSError.make(this.currentStatement, Es6ToEs3Util.CANNOT_CONVERT_YET, "Breaking to a label that is not a loop"));
                return;
            }
            breakCase = loop.breakCase;
        } else {
            breakCase = this.currentLoopContext.get((int)0).breakCase;
        }
        this.enclosingBlock.addChildToBack(this.createStateUpdate(breakCase));
        this.enclosingBlock.addChildToBack(Es6RewriteGenerators.createSafeBreak());
    }

    private void visitLabel() {
        Node labelName = this.currentStatement.removeFirstChild();
        Node child = this.currentStatement.removeFirstChild();
        if (NodeUtil.isLoopStructure(child)) {
            this.currentStatement = child;
            this.visitLoop(labelName.getString());
        } else {
            this.originalGeneratorBody.addChildToFront(child);
        }
    }

    private void visitGeneratorMarker() {
        if (!this.currentLoopContext.isEmpty() && (double)this.currentLoopContext.get((int)0).breakCase == this.currentStatement.getFirstChild().getDouble()) {
            this.currentLoopContext.remove(0);
        }
        if (!this.currentExceptionContext.isEmpty() && (double)this.currentExceptionContext.get((int)0).catchStartCase == this.currentStatement.getFirstChild().getDouble()) {
            this.currentExceptionContext.remove(0);
        }
    }

    private void visitIf() {
        Node condition = this.currentStatement.removeFirstChild();
        Node ifBody = this.currentStatement.removeFirstChild();
        boolean hasElse = this.currentStatement.hasChildren();
        int ifEndState = generatorCaseCount++;
        Node invertedConditional = IR.ifNode(this.withBooleanType(IR.not(condition)), IR.block(this.createStateUpdate(ifEndState), Es6RewriteGenerators.createSafeBreak()));
        invertedConditional.setGeneratorSafe(true);
        Node endIf = this.makeGeneratorMarker(ifEndState);
        this.originalGeneratorBody.addChildToFront(invertedConditional);
        this.originalGeneratorBody.addChildAfter(ifBody, invertedConditional);
        this.originalGeneratorBody.addChildAfter(endIf, ifBody);
        if (hasElse) {
            Node elseBlock = this.currentStatement.removeFirstChild();
            int elseEndState = generatorCaseCount++;
            Node endElse = this.makeGeneratorMarker(elseEndState);
            ifBody.addChildToBack(this.createStateUpdate(elseEndState));
            ifBody.addChildToBack(Es6RewriteGenerators.createSafeBreak());
            this.originalGeneratorBody.addChildAfter(elseBlock, endIf);
            this.originalGeneratorBody.addChildAfter(endElse, elseBlock);
        }
    }

    private void visitSwitch() {
        Node didEnter = this.withBooleanType(IR.name(GENERATOR_SWITCH_ENTERED + (String)this.generatorCounter.get()));
        Node didEnterDecl = IR.var(didEnter.cloneTree(), this.withFalseType(IR.falseNode()));
        Node switchVal = Es6ToEs3Util.withType(IR.name(GENERATOR_SWITCH_VAL + (String)this.generatorCounter.get()), this.currentStatement.getFirstChild().getTypeI());
        Node switchValDecl = IR.var(switchVal.cloneTree(), this.currentStatement.removeFirstChild());
        this.originalGeneratorBody.addChildToFront(didEnterDecl);
        this.originalGeneratorBody.addChildAfter(switchValDecl, didEnterDecl);
        Node insertionPoint = switchValDecl;
        while (this.currentStatement.hasChildren()) {
            Node equivBlock;
            Node currCase = this.currentStatement.removeFirstChild();
            currCase.getLastChild().addChildToFront(IR.exprResult(this.withBooleanType(IR.assign(didEnter.cloneTree(), this.withTrueType(IR.trueNode())))));
            if (currCase.isDefaultCase()) {
                if (this.currentStatement.hasChildren()) {
                    this.compiler.report(JSError.make(this.currentStatement, Es6ToEs3Util.CANNOT_CONVERT_YET, "Default case as intermediate case"));
                }
                equivBlock = IR.block(currCase.removeFirstChild());
            } else {
                equivBlock = IR.ifNode(this.withBooleanType(IR.or(didEnter.cloneTree(), this.withBooleanType(IR.sheq(switchVal.cloneTree(), currCase.removeFirstChild())))), currCase.removeFirstChild());
            }
            this.originalGeneratorBody.addChildAfter(equivBlock, insertionPoint);
            insertionPoint = equivBlock;
        }
        int breakTarget = generatorCaseCount++;
        int cont = this.currentLoopContext.isEmpty() ? -1 : this.currentLoopContext.get((int)0).continueCase;
        this.currentLoopContext.add(0, new LoopContext(breakTarget, cont, null));
        Node breakCase = this.makeGeneratorMarker(breakTarget);
        this.originalGeneratorBody.addChildAfter(breakCase, insertionPoint);
    }

    private void visitBlock() {
        if (!this.currentStatement.hasChildren()) {
            return;
        }
        Node insertionPoint = this.currentStatement.removeFirstChild();
        this.originalGeneratorBody.addChildToFront(insertionPoint);
        Node child = this.currentStatement.removeFirstChild();
        while (child != null) {
            this.originalGeneratorBody.addChildAfter(child, insertionPoint);
            insertionPoint = child;
            child = this.currentStatement.removeFirstChild();
        }
    }

    private void visitForIn() {
        Node variable = this.currentStatement.removeFirstChild();
        Node iterable = this.currentStatement.removeFirstChild();
        Node body = this.currentStatement.removeFirstChild();
        TypeI iterableType = iterable.getTypeI();
        TypeI typeParam = this.unknownType;
        if (this.addTypes) {
            typeParam = (TypeI)iterableType.autobox().toMaybeObjectType().getTemplateTypes().get(0);
        }
        TypeI arrayType = this.createGenericType(JSTypeNative.ARRAY_TYPE, typeParam);
        String loopId = (String)this.generatorCounter.get();
        Node arrayName = Es6ToEs3Util.withType(IR.name(GENERATOR_FOR_IN_ARRAY + loopId), arrayType);
        Node varName = this.withNumberType(IR.name(GENERATOR_FOR_IN_VAR + loopId));
        Node iterableName = Es6ToEs3Util.withType(IR.name(GENERATOR_FOR_IN_ITER + loopId), iterableType);
        if (variable.isVar()) {
            variable = variable.removeFirstChild();
        }
        body.addChildToFront(IR.ifNode(this.withBooleanType(IR.not(IR.in(variable.cloneTree(), iterableName.cloneTree()))), IR.block(IR.continueNode())));
        body.addChildToFront(IR.var(variable.cloneTree(), IR.getelem(arrayName.cloneTree(), varName.cloneTree())));
        this.hoistRoot.getParent().addChildAfter(IR.var(arrayName.cloneTree()), this.hoistRoot);
        this.hoistRoot.getParent().addChildAfter(IR.var(varName.cloneTree()), this.hoistRoot);
        this.hoistRoot.getParent().addChildAfter(IR.var(iterableName.cloneTree()), this.hoistRoot);
        Node arrayDef = IR.exprResult(Es6ToEs3Util.withType(IR.assign(arrayName.cloneTree(), Es6ToEs3Util.withType(IR.arraylit(new Node[0]), arrayType)), arrayType));
        Node iterDef = IR.exprResult(Es6ToEs3Util.withType(IR.assign(iterableName.cloneTree(), iterable), iterableType));
        Node newForIn = IR.forIn(variable.cloneTree(), iterableName, IR.block(IR.exprResult(this.withNumberType(IR.call(IR.getprop(arrayName.cloneTree(), IR.string("push")), variable)))));
        Node newFor = IR.forNode(this.withNumberType(IR.assign(varName.cloneTree(), this.withNumberType(IR.number(0.0)))), this.withBooleanType(IR.lt(varName.cloneTree(), this.withNumberType(IR.getprop(arrayName, IR.string("length"))))), this.withNumberType(IR.inc(varName, true)), body);
        this.enclosingBlock.addChildToBack(arrayDef);
        this.enclosingBlock.addChildToBack(iterDef);
        this.enclosingBlock.addChildToBack(newForIn);
        this.originalGeneratorBody.addChildToFront(newFor);
    }

    private void visitLoop(String label) {
        int loopBeginState;
        Node condition;
        Node prestatement;
        Node incr;
        Node initializer;
        Node body;
        Node guard;
        if (this.currentStatement.isWhile()) {
            guard = this.currentStatement.removeFirstChild();
            body = this.currentStatement.removeFirstChild();
            initializer = IR.empty();
            incr = IR.empty();
        } else if (this.currentStatement.isVanillaFor()) {
            initializer = this.currentStatement.removeFirstChild();
            if (initializer.isAssign()) {
                initializer = IR.exprResult(initializer);
            }
            guard = this.currentStatement.removeFirstChild();
            incr = this.currentStatement.removeFirstChild();
            body = this.currentStatement.removeFirstChild();
        } else {
            Preconditions.checkState((boolean)this.currentStatement.isDo());
            initializer = IR.empty();
            incr = this.withBooleanType(IR.assign(this.withBooleanType(IR.name(GENERATOR_DO_WHILE_INITIAL)), this.withFalseType(IR.falseNode())));
            body = this.currentStatement.removeFirstChild();
            guard = this.currentStatement.removeFirstChild();
        }
        if (guard.isNormalBlock()) {
            prestatement = guard.removeFirstChild();
            condition = guard.removeFirstChild();
        } else {
            prestatement = IR.block();
            condition = guard;
        }
        int continueState = loopBeginState = generatorCaseCount++;
        if (!incr.isEmpty()) {
            continueState = generatorCaseCount++;
            Node continueCase = this.makeGeneratorMarker(continueState);
            body.addChildToBack(continueCase);
            body.addChildToBack(incr.isNormalBlock() ? incr : IR.exprResult(incr));
        }
        this.currentLoopContext.add(0, new LoopContext(generatorCaseCount, continueState, label));
        Node beginCase = this.makeGeneratorMarker(loopBeginState);
        Node conditionalBranch = IR.ifNode(condition.isEmpty() ? this.withTrueType(IR.trueNode()) : condition, body);
        Node setStateLoopStart = this.createStateUpdate(loopBeginState);
        Node breakToStart = Es6RewriteGenerators.createSafeBreak();
        this.originalGeneratorBody.addChildToFront(conditionalBranch);
        if (!prestatement.isEmpty()) {
            this.originalGeneratorBody.addChildToFront(prestatement);
        }
        this.originalGeneratorBody.addChildToFront(beginCase);
        if (!initializer.isEmpty()) {
            this.originalGeneratorBody.addChildToFront(initializer);
        }
        body.addChildToBack(setStateLoopStart);
        body.addChildToBack(breakToStart);
    }

    private void visitVar() {
        Node name = this.currentStatement.removeFirstChild();
        while (name != null) {
            if (name.hasChildren()) {
                this.enclosingBlock.addChildToBack(IR.exprResult(Es6ToEs3Util.withType(IR.assign(name, name.removeFirstChild()), name.getTypeI())));
            }
            this.hoistRoot.getParent().addChildAfter(IR.var(name.cloneTree()), this.hoistRoot);
            name.makeNonIndexable();
            name = this.currentStatement.removeFirstChild();
        }
    }

    private void visitYieldExprResult() {
        this.enclosingBlock.addChildToBack(this.createStateUpdate());
        Node yield = this.currentStatement.getFirstChild();
        Node value = yield.hasChildren() ? yield.removeFirstChild() : this.withUndefinedType(IR.name("undefined"));
        this.enclosingBlock.addChildToBack(IR.returnNode(this.createIteratorResult(value, false)));
    }

    private void visitReturn() {
        this.enclosingBlock.addChildToBack(this.createStateUpdate(-1));
        this.enclosingBlock.addChildToBack(IR.returnNode(this.createIteratorResult(this.currentStatement.hasChildren() ? this.currentStatement.removeFirstChild() : this.withUndefinedType(IR.name("undefined")), true)));
    }

    private Node createStateUpdate() {
        return IR.exprResult(this.withNumberType(IR.assign(this.withNumberType(IR.name(GENERATOR_STATE)), this.withNumberType(IR.number(generatorCaseCount)))));
    }

    private Node createStateUpdate(int state) {
        return IR.exprResult(this.withNumberType(IR.assign(this.withNumberType(IR.name(GENERATOR_STATE)), this.withNumberType(IR.number(state)))));
    }

    private Node createIteratorResult(Node value, boolean done) {
        TypeI iIterableResultType = this.createGenericType(JSTypeNative.I_ITERABLE_RESULT_TYPE, value.getTypeI());
        return Es6ToEs3Util.withType(IR.objectlit(IR.propdef(IR.stringKey("value"), value), IR.propdef(IR.stringKey("done"), done ? this.withTrueType(IR.trueNode()) : this.withFalseType(IR.falseNode()))), iIterableResultType);
    }

    private static Node createSafeBreak() {
        Node breakNode = IR.breakNode();
        breakNode.setGeneratorSafe(true);
        return breakNode;
    }

    private Node createFinallyJumpBlock(Node finallyName, int finallyStartState) {
        int jumpPoint = generatorCaseCount++;
        Node setReturnState = IR.exprResult(this.withNumberType(IR.assign(finallyName.cloneTree(), this.withNumberType(IR.number(jumpPoint)))));
        Node toFinally = this.createStateUpdate(finallyStartState);
        Node returnPoint = this.makeGeneratorMarker(jumpPoint);
        Node returnBlock = IR.block(setReturnState, toFinally, Es6RewriteGenerators.createSafeBreak());
        returnBlock.addChildToBack(returnPoint);
        return returnBlock;
    }

    private LoopContext getLoopContext(String label) {
        for (LoopContext context : this.currentLoopContext) {
            if (!label.equals(context.label)) continue;
            return context;
        }
        return null;
    }

    private boolean controlCanExit(Node n) {
        ControlExitsCheck exits = new ControlExitsCheck();
        NodeTraversal.traverseEs6(this.compiler, n, exits);
        return exits.didExit();
    }

    private Node getUnique(Node node, Token type) {
        ArrayList<Node> matches = new ArrayList<Node>();
        this.insertAll(node, type, matches);
        Preconditions.checkState((matches.size() == 1 ? 1 : 0) != 0, matches);
        return (Node)matches.get(0);
    }

    private void insertAll(Node node, Token type, List<Node> matchingNodes) {
        if (node.getToken() == type) {
            matchingNodes.add(node);
        }
        for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
            this.insertAll(c, type, matchingNodes);
        }
    }

    private Node makeGeneratorMarker(int i) {
        Node n = IR.exprResult(this.withNumberType(IR.number(i)));
        n.setGeneratorMarker(true);
        return n;
    }

    static Node preloadGeneratorSkeletonAndReportChange(AbstractCompiler compiler) {
        return Es6RewriteGenerators.preloadGeneratorSkeleton(compiler, true);
    }

    private static Node preloadGeneratorSkeleton(AbstractCompiler compiler, boolean reportChange) {
        Node root = compiler.getJsRoot();
        Node generatorFunc = Es6RewriteGenerators.getPreloadedGeneratorFunc(root);
        if (generatorFunc != null) {
            return generatorFunc;
        }
        Node genFunc = compiler.parseSyntheticCode(Joiner.on((char)'\n').join((Object)"function $jscomp$generator$function$name() {", (Object)"  var $jscomp$generator$state = 0;", new Object[]{"  function $jscomp$generator$impl(", "      $jscomp$generator$action$arg,", "      $jscomp$generator$next$arg,", "      $jscomp$generator$throw$arg) {", "    while (1) switch ($jscomp$generator$state) {", "      case 0:", "      default:", "        return {value: undefined, done: true};", "    }", "  }", "  var iterator = /** @type {!Generator<?>} */ ({", "    next: function(arg) {", "      return $jscomp$generator$impl(0.0, arg, undefined);", "    },", "    throw: function(arg) {", "      return $jscomp$generator$impl(1.0, undefined, arg);", "    },", "    return: function(arg) { throw Error('Not yet implemented'); },", "  });", "  $jscomp.initSymbolIterator();", "  /** @this {!Generator<?>} */", "  iterator[Symbol.iterator] = function() { return this; };", "  return iterator;", "}"})).getFirstChild().detach();
        root.getFirstChild().addChildToFront(genFunc);
        if (reportChange) {
            NodeUtil.markNewScopesChanged(genFunc, compiler);
            compiler.reportChangeToEnclosingScope(genFunc);
        }
        return genFunc;
    }

    private void addTypesToGeneratorSkeleton(Node genBlock, TypeI yieldType) {
        TypeI generatorType = this.createGenericType(JSTypeNative.GENERATOR_TYPE, yieldType);
        TypeI iIterableResultType = this.createGenericType(JSTypeNative.I_ITERABLE_RESULT_TYPE, yieldType);
        Node impl = genBlock.getSecondChild();
        Preconditions.checkState((boolean)impl.isFunction());
        FunctionTypeI implFuncType = impl.getTypeI().toMaybeFunctionType();
        implFuncType = implFuncType.withReturnType(iIterableResultType);
        impl.setTypeI(implFuncType);
        impl.getFirstChild().setTypeI(implFuncType);
        Node objectLit = impl.getChildAtIndex(2).getFirstChild().getSecondChild().getFirstChild().getChildAtIndex(2).getFirstFirstChild().getFirstChild();
        Preconditions.checkState((boolean)objectLit.isObjectLit());
        objectLit.setTypeI(iIterableResultType);
        objectLit.getFirstChild().setTypeI(iIterableResultType);
        Node iteratorVar = impl.getNext();
        Preconditions.checkState((boolean)iteratorVar.isVar());
        iteratorVar.getFirstChild().setTypeI(generatorType);
        iteratorVar.getFirstFirstChild().setTypeI(generatorType);
        iteratorVar.getFirstFirstChild().getFirstChild().setTypeI(generatorType);
        Node next = iteratorVar.getFirstFirstChild().getFirstFirstChild();
        Preconditions.checkState((boolean)next.isStringKey());
        FunctionTypeI nextFunctionType = next.getTypeI().toMaybeFunctionType();
        nextFunctionType = nextFunctionType.withReturnType(iIterableResultType);
        next.setTypeI(nextFunctionType);
        next.getFirstChild().setTypeI(nextFunctionType);
        Node call = next.getFirstChild().getChildAtIndex(2).getFirstFirstChild();
        Preconditions.checkState((boolean)call.isCall());
        call.setTypeI(iIterableResultType);
        Node genImplName = call.getFirstChild();
        Preconditions.checkState((boolean)genImplName.isName());
        FunctionTypeI genImplType = genImplName.getTypeI().toMaybeFunctionType();
        genImplType = genImplType.withReturnType(iIterableResultType);
        genImplName.setTypeI(genImplType);
        Node exprResult = iteratorVar.getNext().getNext();
        Preconditions.checkState((boolean)exprResult.isExprResult());
        FunctionTypeI funcType = exprResult.getFirstChild().getTypeI().toMaybeFunctionType();
        funcType = funcType.withReturnType(iIterableResultType);
        exprResult.getFirstChild().setTypeI(funcType);
        exprResult.getFirstFirstChild().setTypeI(funcType);
        exprResult.getFirstFirstChild().getFirstChild().setTypeI(generatorType);
        exprResult.getFirstChild().getSecondChild().setTypeI(funcType);
        exprResult.getFirstChild().getSecondChild().getChildAtIndex(2).getFirstFirstChild().setTypeI(generatorType);
        exprResult.getNext().getFirstChild().setTypeI(generatorType);
    }

    @Nullable
    private static Node getPreloadedGeneratorFunc(Node root) {
        if (root.getFirstChild() == null) {
            return null;
        }
        for (Node c = root.getFirstFirstChild(); c != null; c = c.getNext()) {
            if (!c.isFunction() || !GENERATOR_PRELOAD_FUNCTION_NAME.equals(c.getFirstChild().getString())) continue;
            return c;
        }
        return null;
    }

    private void cleanUpGeneratorSkeleton(boolean reportChange) {
        Node genFunc = Es6RewriteGenerators.getPreloadedGeneratorFunc(this.compiler.getJsRoot());
        if (genFunc != null) {
            if (reportChange) {
                NodeUtil.deleteNode(genFunc, this.compiler);
            } else {
                genFunc.detach();
            }
        }
    }

    private TypeI createGenericType(JSTypeNative typeName, TypeI typeArg) {
        return Es6ToEs3Util.createGenericType(this.addTypes, this.registry, typeName, typeArg);
    }

    private Node withStringType(Node n) {
        return Es6ToEs3Util.withType(n, this.stringType);
    }

    private Node withBooleanType(Node n) {
        return Es6ToEs3Util.withType(n, this.booleanType);
    }

    private Node withFalseType(Node n) {
        return Es6ToEs3Util.withType(n, this.falseType);
    }

    private Node withTrueType(Node n) {
        return Es6ToEs3Util.withType(n, this.trueType);
    }

    private Node withUnknownType(Node n) {
        return Es6ToEs3Util.withType(n, this.unknownType);
    }

    private Node withNumberType(Node n) {
        return Es6ToEs3Util.withType(n, this.numberType);
    }

    private Node withUndefinedType(Node n) {
        return Es6ToEs3Util.withType(n, this.undefinedType);
    }

    private static final class ExceptionContext {
        int catchStartCase;
        Node catchBlock;

        ExceptionContext(int catchStartCase, Node catchBlock) {
            this.catchStartCase = catchStartCase;
            this.catchBlock = catchBlock;
        }
    }

    private static final class LoopContext {
        int breakCase;
        int continueCase;
        String label;

        LoopContext(int breakCase, int continueCase, String label) {
            this.breakCase = breakCase;
            this.continueCase = continueCase;
            this.label = label;
        }
    }

    private final class ControlExitsCheck
    implements NodeTraversal.Callback {
        int continueCatchers;
        int breakCatchers;
        int throwCatchers;
        List<String> labels = new ArrayList<String>();
        boolean exited;
        boolean addJumps;
        private Node finallyName;
        private int finallyStartState;

        ControlExitsCheck(Node finallyName, int finallyStartState) {
            this.finallyName = finallyName;
            this.finallyStartState = finallyStartState;
            this.addJumps = true;
        }

        ControlExitsCheck() {
            this.addJumps = false;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            switch (n.getToken()) {
                case FUNCTION: {
                    return false;
                }
                case LABEL: {
                    this.labels.add(0, n.getFirstChild().getString());
                    break;
                }
                case WHILE: 
                case DO: 
                case FOR: 
                case FOR_IN: {
                    ++this.continueCatchers;
                    ++this.breakCatchers;
                    break;
                }
                case SWITCH: {
                    ++this.breakCatchers;
                    break;
                }
                case BLOCK: {
                    parent = n.getParent();
                    if (parent == null || !parent.isTry() || parent.getFirstChild() != n || !n.getNext().hasChildren()) break;
                    ++this.throwCatchers;
                    break;
                }
                case BREAK: {
                    if (n.isGeneratorSafe() || (this.breakCatchers != 0 || n.hasChildren()) && (!n.hasChildren() || this.labels.contains(n.getFirstChild().getString()))) break;
                    this.exited = true;
                    if (!this.addJumps) break;
                    parent.addChildBefore(Es6RewriteGenerators.this.createFinallyJumpBlock(this.finallyName, this.finallyStartState), n);
                    break;
                }
                case CONTINUE: {
                    if (this.continueCatchers != 0 && (!n.hasChildren() || this.labels.contains(n.getFirstChild().getString()))) break;
                    this.exited = true;
                    if (!this.addJumps) break;
                    parent.addChildBefore(Es6RewriteGenerators.this.createFinallyJumpBlock(this.finallyName, this.finallyStartState), n);
                    break;
                }
                case THROW: {
                    if (this.throwCatchers != 0) break;
                    this.exited = true;
                    if (!this.addJumps || n.isGeneratorSafe()) break;
                    parent.addChildBefore(Es6RewriteGenerators.this.createFinallyJumpBlock(this.finallyName, this.finallyStartState), n);
                    break;
                }
                case RETURN: {
                    this.exited = true;
                    if (!this.addJumps) break;
                    parent.addChildBefore(Es6RewriteGenerators.this.createFinallyJumpBlock(this.finallyName, this.finallyStartState), n);
                    break;
                }
                case YIELD: {
                    this.exited = true;
                    break;
                }
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case LABEL: {
                    this.labels.remove(0);
                    break;
                }
                case WHILE: 
                case DO: 
                case FOR: 
                case FOR_IN: {
                    --this.continueCatchers;
                    --this.breakCatchers;
                    break;
                }
                case SWITCH: {
                    --this.breakCatchers;
                    break;
                }
                case BLOCK: {
                    parent = n.getParent();
                    if (parent == null || !parent.isTry() || parent.getFirstChild() != n || !n.getNext().hasChildren()) break;
                    --this.throwCatchers;
                    break;
                }
            }
        }

        public boolean didExit() {
            return this.exited;
        }
    }

    private final class DecomposeYields
    extends NodeTraversal.AbstractPreOrderCallback {
        private final AbstractCompiler compiler;
        private final ExpressionDecomposer decomposer;

        DecomposeYields(AbstractCompiler compiler) {
            this.compiler = compiler;
            HashSet<String> consts = new HashSet<String>();
            this.decomposer = new ExpressionDecomposer(compiler, compiler.getUniqueNameIdSupplier(), consts, Scope.createGlobalScope(new Node(Token.SCRIPT)));
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case YIELD: {
                    this.visitYieldExpression(t, n);
                    break;
                }
                case WHILE: 
                case DO: 
                case FOR: {
                    this.visitLoop(t, n);
                    break;
                }
                case CASE: {
                    if (!Es6RewriteGenerators.this.controlCanExit(n.getFirstChild())) break;
                    this.compiler.report(JSError.make(n, Es6ToEs3Util.CANNOT_CONVERT_YET, "Case statements that contain yields"));
                    return false;
                }
            }
            return true;
        }

        private void visitYieldExpression(NodeTraversal t, Node n) {
            if (n.getParent().isExprResult()) {
                return;
            }
            if (this.decomposer.canExposeExpression(n) != ExpressionDecomposer.DecompositionType.UNDECOMPOSABLE) {
                this.decomposer.exposeExpression(n);
                t.reportCodeChange();
            } else {
                this.compiler.report(JSError.make(n, Es6ToEs3Util.CANNOT_CONVERT, "Undecomposable expression"));
            }
        }

        private void visitLoop(NodeTraversal t, Node n) {
            Node enclosingFunc = NodeUtil.getEnclosingFunction(n);
            if (enclosingFunc == null || !enclosingFunc.isGeneratorFunction() || n.isForIn()) {
                return;
            }
            Node enclosingBlock = NodeUtil.getEnclosingBlock(n);
            Node guard = null;
            Node incr = null;
            switch (n.getToken()) {
                case FOR: {
                    guard = n.getSecondChild();
                    incr = guard.getNext();
                    break;
                }
                case WHILE: {
                    guard = n.getFirstChild();
                    incr = IR.empty();
                    break;
                }
                case DO: {
                    guard = n.getLastChild();
                    if (!guard.isEmpty()) {
                        Node firstEntry = IR.name(Es6RewriteGenerators.GENERATOR_DO_WHILE_INITIAL);
                        enclosingBlock.addChildToFront(IR.var(firstEntry.cloneTree(), Es6RewriteGenerators.this.withTrueType(IR.trueNode())));
                        guard = Es6RewriteGenerators.this.withBooleanType(IR.or(firstEntry, n.getLastChild().detach()));
                        n.addChildToBack(guard);
                    }
                    incr = IR.empty();
                    break;
                }
            }
            if (!Es6RewriteGenerators.this.controlCanExit(guard) && !Es6RewriteGenerators.this.controlCanExit(incr)) {
                return;
            }
            Node guardName = IR.name(Es6RewriteGenerators.GENERATOR_LOOP_GUARD + (String)Es6RewriteGenerators.this.generatorCounter.get());
            if (!guard.isEmpty()) {
                Node container = new Node(Token.BLOCK);
                n.replaceChild(guard, container);
                container.addChildToFront(IR.block(IR.exprResult(Es6ToEs3Util.withType(IR.assign(guardName.cloneTree(), guard.cloneTree()), guard.getTypeI()))));
                container.addChildToBack(guardName.cloneTree());
            }
            if (!incr.isEmpty()) {
                n.addChildBefore(IR.block(IR.exprResult(incr.detach())), n.getLastChild());
            }
            enclosingBlock.addChildToFront(IR.var(guardName));
            t.reportCodeChange();
        }
    }
}

