/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.GraphvizGraph;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeI;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public final class DotFormatter {
    private static final String INDENT = "  ";
    private static final String ARROW = " -> ";
    private static final String LINE = " -- ";
    private final HashMap<Node, Integer> assignments = new HashMap();
    private int keyCount = 0;
    private final Appendable builder;
    private final ControlFlowGraph<Node> cfg;
    private final boolean printAnnotations;

    private DotFormatter() {
        this.builder = new StringBuilder();
        this.cfg = null;
        this.printAnnotations = false;
    }

    private DotFormatter(Node n, ControlFlowGraph<Node> cfg, Appendable builder, boolean printAnnotations) throws IOException {
        this.cfg = cfg;
        this.builder = builder;
        this.printAnnotations = printAnnotations;
        this.formatPreamble();
        this.traverseNodes(n);
        this.formatConclusion();
    }

    public static String toDot(Node n) throws IOException {
        return DotFormatter.toDot(n, null);
    }

    static String toDot(Node n, ControlFlowGraph<Node> inCFG) throws IOException {
        StringBuilder builder = new StringBuilder();
        new DotFormatter(n, inCFG, builder, false);
        return builder.toString();
    }

    static void appendDot(Node n, ControlFlowGraph<Node> inCFG, Appendable builder) throws IOException {
        new DotFormatter(n, inCFG, builder, false);
    }

    static DotFormatter newInstanceForTesting() {
        return new DotFormatter();
    }

    private void traverseNodes(Node parent) throws IOException {
        int keyParent = this.key(parent);
        for (Node child = parent.getFirstChild(); child != null; child = child.getNext()) {
            int keyChild = this.key(child);
            this.builder.append(INDENT);
            this.builder.append(DotFormatter.formatNodeName(keyParent));
            this.builder.append(ARROW);
            this.builder.append(DotFormatter.formatNodeName(keyChild));
            this.builder.append(" [weight=1];\n");
            this.traverseNodes(child);
        }
        if (this.cfg != null && this.cfg.hasNode(parent)) {
            List outEdges = this.cfg.getOutEdges(parent);
            Object[] edgeList = new String[outEdges.size()];
            for (int i = 0; i < edgeList.length; ++i) {
                DiGraph.DiGraphEdge edge = outEdges.get(i);
                DiGraph.DiGraphNode succ = edge.getDestination();
                String toNode = null;
                if (succ == this.cfg.getImplicitReturn()) {
                    toNode = "RETURN";
                } else {
                    int keySucc = this.key((Node)succ.getValue());
                    toNode = DotFormatter.formatNodeName(keySucc);
                }
                edgeList[i] = DotFormatter.formatNodeName(keyParent) + ARROW + toNode + " [label=\"" + edge.getValue() + "\", fontcolor=\"red\", weight=0.01, color=\"red\"];\n";
            }
            Arrays.sort(edgeList);
            for (Object element : edgeList) {
                this.builder.append(INDENT);
                this.builder.append((CharSequence)element);
            }
        }
    }

    int key(Node n) throws IOException {
        Integer key = this.assignments.get(n);
        if (key == null) {
            Object annotation;
            key = this.keyCount++;
            this.assignments.put(n, key);
            this.builder.append(INDENT);
            this.builder.append(DotFormatter.formatNodeName(key));
            this.builder.append(" [label=\"");
            this.builder.append(n.getToken().toString());
            TypeI type = n.getTypeI();
            if (type != null) {
                this.builder.append(" : ");
                this.builder.append(type.toString());
            }
            if (this.printAnnotations && this.cfg != null && this.cfg.hasNode(n) && (annotation = this.cfg.getNode(n).getAnnotation()) != null) {
                this.builder.append("\\n");
                this.builder.append(annotation.toString());
            }
            this.builder.append("\"");
            if (n.getJSDocInfo() != null) {
                this.builder.append(" color=\"green\"");
            }
            this.builder.append("];\n");
        }
        return key;
    }

    private static String formatNodeName(Integer key) {
        return "node" + key;
    }

    private void formatPreamble() throws IOException {
        this.builder.append("digraph AST {\n");
        this.builder.append(INDENT);
        this.builder.append("node [color=lightblue2, style=filled];\n");
    }

    private void formatConclusion() throws IOException {
        this.builder.append("}\n");
    }

    public static String toDot(GraphvizGraph graph) {
        StringBuilder builder = new StringBuilder();
        builder.append(graph.isDirected() ? "digraph" : "graph");
        builder.append(INDENT);
        builder.append(graph.getName());
        builder.append(" {\n");
        builder.append(INDENT);
        builder.append("node [color=lightblue2, style=filled];\n");
        String edgeSymbol = graph.isDirected() ? ARROW : LINE;
        List<GraphvizGraph.GraphvizNode> nodes = graph.getGraphvizNodes();
        Object[] nodeNames = new String[nodes.size()];
        for (int i = 0; i < nodeNames.length; ++i) {
            GraphvizGraph.GraphvizNode gNode = nodes.get(i);
            nodeNames[i] = gNode.getId() + " [label=\"" + gNode.getLabel() + "\" color=\"" + gNode.getColor() + "\"]";
        }
        Arrays.sort(nodeNames);
        for (Object nodeName : nodeNames) {
            builder.append(INDENT);
            builder.append((String)nodeName);
            builder.append(";\n");
        }
        List<GraphvizGraph.GraphvizEdge> edges = graph.getGraphvizEdges();
        Object[] edgeNames = new String[edges.size()];
        for (int i = 0; i < edgeNames.length; ++i) {
            GraphvizGraph.GraphvizEdge edge = edges.get(i);
            edgeNames[i] = edge.getNode1Id() + edgeSymbol + edge.getNode2Id();
        }
        Arrays.sort(edgeNames);
        for (Object edgeName : edgeNames) {
            builder.append(INDENT);
            builder.append((String)edgeName);
            builder.append(";\n");
        }
        builder.append("}\n");
        return builder.toString();
    }
}

