/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import java.util.List;

final class CombinedCompilerPass
implements HotSwapCompilerPass,
NodeTraversal.ScopedCallback {
    private final CallbackWrapper[] callbacks;
    private final AbstractCompiler compiler;

    CombinedCompilerPass(AbstractCompiler compiler, NodeTraversal.Callback ... callbacks) {
        this(compiler, (List<NodeTraversal.Callback>)ImmutableList.copyOf((Object[])callbacks));
    }

    CombinedCompilerPass(AbstractCompiler compiler, List<NodeTraversal.Callback> callbacks) {
        this.compiler = compiler;
        this.callbacks = new CallbackWrapper[callbacks.size()];
        for (int i = 0; i < callbacks.size(); ++i) {
            this.callbacks[i] = new CallbackWrapper(callbacks.get(i));
        }
    }

    static void traverse(AbstractCompiler compiler, Node root, List<NodeTraversal.Callback> callbacks) {
        if (callbacks.size() == 1) {
            NodeTraversal.traverseEs6(compiler, root, callbacks.get(0));
        } else {
            new CombinedCompilerPass(compiler, callbacks).process(null, root);
        }
    }

    @Override
    public final void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (this.compiler.hasHaltingErrors()) {
            return false;
        }
        for (CallbackWrapper callback : this.callbacks) {
            callback.shouldTraverseIfActive(t, n, parent);
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (this.compiler.hasHaltingErrors()) {
            return;
        }
        for (CallbackWrapper callback : this.callbacks) {
            callback.visitOrMaybeActivate(t, n, parent);
        }
    }

    @Override
    public void enterScope(NodeTraversal t) {
        for (CallbackWrapper callback : this.callbacks) {
            callback.enterScopeIfActive(t);
        }
    }

    @Override
    public void exitScope(NodeTraversal t) {
        for (CallbackWrapper callback : this.callbacks) {
            callback.exitScopeIfActive(t);
        }
    }

    private static class CallbackWrapper {
        private final NodeTraversal.Callback callback;
        private final NodeTraversal.ScopedCallback scopedCallback;
        private Node waiting = null;

        private CallbackWrapper(NodeTraversal.Callback callback) {
            this.callback = callback;
            this.scopedCallback = callback instanceof NodeTraversal.ScopedCallback ? (NodeTraversal.ScopedCallback)callback : null;
        }

        void visitOrMaybeActivate(NodeTraversal t, Node n, Node parent) {
            if (this.isActive()) {
                this.callback.visit(t, n, parent);
            } else if (this.waiting == n) {
                this.waiting = null;
            }
        }

        void shouldTraverseIfActive(NodeTraversal t, Node n, Node parent) {
            if (this.isActive() && !this.callback.shouldTraverse(t, n, parent)) {
                this.waiting = n;
            }
        }

        void enterScopeIfActive(NodeTraversal t) {
            if (this.isActive() && this.scopedCallback != null) {
                this.scopedCallback.enterScope(t);
            }
        }

        void exitScopeIfActive(NodeTraversal t) {
            if (this.isActive() && this.scopedCallback != null) {
                this.scopedCallback.exitScope(t);
            }
        }

        boolean isActive() {
            return this.waiting == null;
        }
    }
}

