/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AnonymousFunctionNamingCallback;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.FunctionNames;
import com.google.javascript.jscomp.NodeNameExtractor;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

class CollectFunctionNames
implements CompilerPass {
    private final transient AbstractCompiler compiler;
    private final FunctionNamesMap functionNames = new FunctionNamesMap();
    private final transient FunctionListExtractor functionListExtractor;

    CollectFunctionNames(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.functionListExtractor = new FunctionListExtractor(this.functionNames);
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this.functionListExtractor);
        FunctionExpressionNamer namer = new FunctionExpressionNamer(this.functionNames);
        AnonymousFunctionNamingCallback namingCallback = new AnonymousFunctionNamingCallback(namer);
        NodeTraversal.traverseEs6(this.compiler, root, namingCallback);
    }

    public FunctionNames getFunctionNames() {
        return this.functionNames;
    }

    private static class FunctionExpressionNamer
    implements AnonymousFunctionNamingCallback.FunctionNamer {
        private static final char DELIMITER = '.';
        private static final NodeNameExtractor extractor = new NodeNameExtractor('.');
        private final FunctionNamesMap functionNames;

        FunctionExpressionNamer(FunctionNamesMap functionNames) {
            this.functionNames = functionNames;
        }

        @Override
        public final String getName(Node node) {
            return extractor.getName(node);
        }

        @Override
        public final void setFunctionName(String name, Node fnNode) {
            this.functionNames.setFunctionName(name, fnNode);
        }

        @Override
        public final String getCombinedName(String lhs, String rhs) {
            return lhs + '.' + rhs;
        }
    }

    private static class FunctionListExtractor
    extends NodeTraversal.AbstractPostOrderCallback {
        private final FunctionNamesMap functionNames;

        FunctionListExtractor(FunctionNamesMap functionNames) {
            this.functionNames = functionNames;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isFunction()) {
                Node functionNameNode = n.getFirstChild();
                String functionName = functionNameNode.getString();
                Node enclosingFunction = t.getEnclosingFunction();
                this.functionNames.put(n, enclosingFunction, functionName);
            }
        }
    }

    private static class FunctionRecord
    implements Serializable {
        public final int id;
        public final Node parent;
        public String name;

        FunctionRecord(int id, Node parent, String name) {
            this.id = id;
            this.parent = parent;
            this.name = name;
        }
    }

    private static class FunctionNamesMap
    implements FunctionNames {
        private int nextId = 0;
        private final Map<Node, FunctionRecord> functionMap = new LinkedHashMap<Node, FunctionRecord>();

        private FunctionNamesMap() {
        }

        @Override
        public Iterable<Node> getFunctionNodeList() {
            return this.functionMap.keySet();
        }

        @Override
        public int getFunctionId(Node f) {
            FunctionRecord record = this.functionMap.get(f);
            if (record != null) {
                return record.id;
            }
            return -1;
        }

        @Override
        public String getFunctionName(Node f) {
            Node parent;
            FunctionRecord record = this.functionMap.get(f);
            if (record == null) {
                return null;
            }
            String str = record.name;
            if (str.isEmpty()) {
                str = "<anonymous>";
            }
            if ((parent = record.parent) != null) {
                str = this.getFunctionName(parent) + "::" + str;
            }
            str = str.replace("::this.", ".");
            str = str.replace("..", ".");
            str = str.replaceFirst("^(<anonymous>::)*", "");
            return str;
        }

        private void put(Node n, Node enclosingFunction, String functionName) {
            this.functionMap.put(n, new FunctionRecord(this.nextId++, enclosingFunction, functionName));
        }

        private void setFunctionName(String name, Node fnNode) {
            FunctionRecord record = this.functionMap.get(fnNode);
            assert (record != null);
            assert (record.name.isEmpty());
            record.name = name;
        }
    }
}

