/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class CheckSideEffects
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final DiagnosticType USELESS_CODE_ERROR = DiagnosticType.warning("JSC_USELESS_CODE", "Suspicious code. {0}");
    static final String PROTECTOR_FN = "JSCOMPILER_PRESERVE";
    private final boolean report;
    private final List<Node> problemNodes = new ArrayList<Node>();
    private final Set<String> noSideEffectExterns = new HashSet<String>();
    private final AbstractCompiler compiler;
    private final boolean protectSideEffectFreeCode;

    CheckSideEffects(AbstractCompiler compiler, boolean report, boolean protectSideEffectFreeCode) {
        this.compiler = compiler;
        this.report = report;
        this.protectSideEffectFreeCode = protectSideEffectFreeCode;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, externs, new GetNoSideEffectExterns());
        NodeTraversal.traverseEs6(this.compiler, root, this);
        if (this.protectSideEffectFreeCode) {
            this.protectSideEffects();
        }
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isEmpty() || n.isComma()) {
            return;
        }
        if (parent == null) {
            return;
        }
        if (n.isExprResult() || n.isNormalBlock()) {
            return;
        }
        if (n.isQualifiedName() && n.getJSDocInfo() != null) {
            return;
        }
        boolean isResultUsed = NodeUtil.isExpressionResultUsed(n);
        boolean isSimpleOp = NodeUtil.isSimpleOperator(n);
        if (!isResultUsed) {
            if (isSimpleOp || !NodeUtil.mayHaveSideEffects(n, t.getCompiler())) {
                if (this.report) {
                    String msg = "This code lacks side-effects. Is there a bug?";
                    if (n.isString() || n.isTemplateLit()) {
                        msg = "Is there a missing '+' on the previous line?";
                    } else if (isSimpleOp) {
                        msg = "The result of the '" + n.getToken().toString().toLowerCase() + "' operator is not being used.";
                    }
                    t.report(n, USELESS_CODE_ERROR, msg);
                }
                if (!NodeUtil.isStatement(n)) {
                    this.problemNodes.add(n);
                }
            } else if (n.isCall() && (n.getFirstChild().isGetProp() || n.getFirstChild().isName() || n.getFirstChild().isString())) {
                String qname = n.getFirstChild().getQualifiedName();
                boolean isDefinedInSrc = false;
                if (qname != null) {
                    if (n.getFirstChild().isGetProp()) {
                        Node rootNameNode = NodeUtil.getRootOfQualifiedName(n.getFirstChild());
                        isDefinedInSrc = rootNameNode != null && rootNameNode.isName() && t.getScope().getVar(rootNameNode.getString()) != null;
                    } else {
                        boolean bl = isDefinedInSrc = t.getScope().getVar(qname) != null;
                    }
                }
                if (qname != null && this.noSideEffectExterns.contains(qname) && !isDefinedInSrc) {
                    this.problemNodes.add(n);
                    if (this.report) {
                        String msg = "The result of the extern function call '" + qname + "' is not being used.";
                        t.report(n, USELESS_CODE_ERROR, msg);
                    }
                }
            }
        }
    }

    private void protectSideEffects() {
        if (!this.problemNodes.isEmpty()) {
            this.addExtern();
            for (Node n : this.problemNodes) {
                Node name = IR.name(PROTECTOR_FN).srcref(n);
                name.putBooleanProp((byte)43, true);
                Node replacement = IR.call(name, new Node[0]).srcref(n);
                replacement.putBooleanProp((byte)50, true);
                n.replaceWith(replacement);
                replacement.addChildToBack(n);
                this.compiler.reportChangeToEnclosingScope(replacement);
            }
        }
    }

    private void addExtern() {
        Node name = IR.name(PROTECTOR_FN);
        name.putBooleanProp((byte)43, true);
        Node var = IR.var(name);
        JSDocInfoBuilder builder = new JSDocInfoBuilder(false);
        builder.recordNoAlias();
        var.setJSDocInfo(builder.build());
        CompilerInput input = this.compiler.getSynthesizedExternsInput();
        Node root = input.getAstRoot(this.compiler);
        name.setStaticSourceFileFrom(root);
        var.setStaticSourceFileFrom(root);
        root.addChildToBack(var);
        this.compiler.reportChangeToEnclosingScope(var);
    }

    private class GetNoSideEffectExterns
    extends NodeTraversal.AbstractPostOrderCallback {
        private GetNoSideEffectExterns() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            JSDocInfo jsDoc;
            if (n.isFunction() && (jsDoc = NodeUtil.getBestJSDocInfo(n)) != null && jsDoc.isNoSideEffects()) {
                String name = NodeUtil.getName(n);
                CheckSideEffects.this.noSideEffectExterns.add(name);
            }
        }
    }

    static class StripProtection
    extends NodeTraversal.AbstractPostOrderCallback
    implements CompilerPass {
        private final AbstractCompiler compiler;

        StripProtection(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public void process(Node externs, Node root) {
            NodeTraversal.traverseEs6(this.compiler, root, this);
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            Node target;
            if (n.isCall() && (target = n.getFirstChild()).isName() && target.getString().equals(CheckSideEffects.PROTECTOR_FN)) {
                Node expr = n.getLastChild();
                n.detachChildren();
                parent.replaceChild(n, expr);
                t.reportCodeChange();
            }
        }
    }
}

