/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.rhino.Node;

final class CheckMissingSuper
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final DiagnosticType MISSING_CALL_TO_SUPER = DiagnosticType.error("JSC_MISSING_CALL_TO_SUPER", "constructor is missing a call to super()");
    static final DiagnosticType THIS_BEFORE_SUPER = DiagnosticType.error("JSC_THIS_BEFORE_SUPER", "cannot access this before calling super()");
    private final AbstractCompiler compiler;

    public CheckMissingSuper(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processCheck(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapCheck(this.compiler, scriptRoot, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isClass()) {
            Node superclass = n.getSecondChild();
            if (superclass.isEmpty()) {
                return;
            }
            Node constructor = NodeUtil.getFirstPropMatchingKey(NodeUtil.getClassMembers(n), "constructor");
            if (constructor == null) {
                return;
            }
            FindSuper finder = new FindSuper();
            NodeTraversal.traverseEs6(this.compiler, NodeUtil.getFunctionBody(constructor), finder);
            if (!finder.found) {
                t.report(constructor, MISSING_CALL_TO_SUPER, new String[0]);
            }
        }
    }

    private static final class FindSuper
    implements NodeTraversal.Callback {
        boolean found = false;

        private FindSuper() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return !this.found && !n.isFunction();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isThis()) {
                t.report(n, THIS_BEFORE_SUPER, new String[0]);
            }
            if (n.isSuper() && parent.isCall()) {
                this.found = true;
                return;
            }
        }
    }
}

