/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.Collections;
import java.util.Iterator;

public final class TransformAMDToCJSModule
implements CompilerPass {
    @VisibleForTesting
    static final DiagnosticType UNSUPPORTED_DEFINE_SIGNATURE_ERROR = DiagnosticType.error("UNSUPPORTED_DEFINE_SIGNATURE", "Only define(function() ...), define(OBJECT_LITERAL) and define(['dep', 'dep1'], function(d0, d2, [exports, module]) ...) forms are currently supported.");
    static final DiagnosticType NON_TOP_LEVEL_STATEMENT_DEFINE_ERROR = DiagnosticType.error("NON_TOP_LEVEL_STATEMENT_DEFINE", "The define function must be called as a top-level statement.");
    static final DiagnosticType REQUIREJS_PLUGINS_NOT_SUPPORTED_WARNING = DiagnosticType.warning("REQUIREJS_PLUGINS_NOT_SUPPORTED", "Plugins in define requirements are not supported: {0}");
    static final String VAR_RENAME_SUFFIX = "__alias";
    private final AbstractCompiler compiler;
    private int renameIndex = 0;

    public TransformAMDToCJSModule(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, new TransformAMDModulesCallback());
    }

    private static void unsupportedDefineError(NodeTraversal t, Node n) {
        t.report(n, UNSUPPORTED_DEFINE_SIGNATURE_ERROR, new String[0]);
    }

    private static boolean isVirtualModuleName(String moduleName) {
        return "exports".equals(moduleName) || "require".equals(moduleName) || "module".equals(moduleName);
    }

    private static class RenameCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private final String from;
        private final String to;

        public RenameCallback(String from, String to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName() && this.from.equals(n.getString())) {
                n.setString(this.to);
                n.setOriginalName(this.from);
            }
        }
    }

    private static class DefineCallbackReturnCallback
    extends NodeTraversal.AbstractShallowStatementCallback {
        private DefineCallbackReturnCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isReturn() && n.hasChildren()) {
                Node retVal = n.getFirstChild();
                n.removeChild(retVal);
                parent.replaceChild(n, IR.exprResult(IR.assign(IR.getprop(IR.name("module"), IR.string("exports")), retVal)).useSourceInfoFromForTree(n));
            }
        }
    }

    private class TransformAMDModulesCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private TransformAMDModulesCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isCall() && n.getFirstChild() != null && n.getFirstChild().isName() && "define".equals(n.getFirstChild().getString())) {
                Var define = t.getScope().getVar(n.getFirstChild().getString());
                if (define != null && !define.isGlobal()) {
                    return;
                }
                if (!parent.isExprResult() || !parent.getParent().isScript()) {
                    t.report(n, NON_TOP_LEVEL_STATEMENT_DEFINE_ERROR, new String[0]);
                    return;
                }
                Node script = parent.getParent();
                Node requiresNode = null;
                Node callback = null;
                int defineArity = n.getChildCount() - 1;
                if (defineArity == 0) {
                    TransformAMDToCJSModule.unsupportedDefineError(t, n);
                    return;
                }
                if (defineArity == 1) {
                    callback = n.getSecondChild();
                    if (callback.isObjectLit()) {
                        this.handleDefineObjectLiteral(parent, callback, script);
                        return;
                    }
                } else if (defineArity == 2) {
                    requiresNode = n.getSecondChild();
                    callback = n.getChildAtIndex(2);
                } else if (defineArity >= 3) {
                    TransformAMDToCJSModule.unsupportedDefineError(t, n);
                    return;
                }
                if (!callback.isFunction() || requiresNode != null && !requiresNode.isArrayLit()) {
                    TransformAMDToCJSModule.unsupportedDefineError(t, n);
                    return;
                }
                this.handleRequiresAndParamList(t, n, script, requiresNode, callback);
                Node callbackBlock = callback.getChildAtIndex(2);
                NodeTraversal.traverseEs6(TransformAMDToCJSModule.this.compiler, callbackBlock, new DefineCallbackReturnCallback());
                this.moveCallbackContentToTopLevel(parent, script, callbackBlock);
                TransformAMDToCJSModule.this.compiler.reportCodeChange();
            }
        }

        private void handleDefineObjectLiteral(Node parent, Node onlyExport, Node script) {
            onlyExport.getParent().removeChild(onlyExport);
            script.replaceChild(parent, IR.exprResult(IR.assign(NodeUtil.newQName(TransformAMDToCJSModule.this.compiler, "module.exports"), onlyExport)).useSourceInfoIfMissingFromForTree(onlyExport));
            TransformAMDToCJSModule.this.compiler.reportCodeChange();
        }

        private void handleRequiresAndParamList(NodeTraversal t, Node defineNode, Node script, Node requiresNode, Node callback) {
            Iterator requires;
            Iterator<Node> paramList = callback.getSecondChild().children().iterator();
            Iterator<Object> iterator = requires = requiresNode != null ? requiresNode.children().iterator() : Collections.emptyIterator();
            while (paramList.hasNext() || requires.hasNext()) {
                Node aliasNode = paramList.hasNext() ? paramList.next() : null;
                Node modNode = requires.hasNext() ? (Node)requires.next() : null;
                this.handleRequire(t, defineNode, script, callback, aliasNode, modNode);
            }
        }

        private void handleRequire(NodeTraversal t, Node defineNode, Node script, Node callback, Node aliasNode, Node modNode) {
            Node requireNode;
            String moduleName = null;
            if (modNode != null) {
                moduleName = this.handlePlugins(t, script, modNode.getString(), modNode);
            }
            if (TransformAMDToCJSModule.isVirtualModuleName(moduleName)) {
                return;
            }
            String aliasName = aliasNode != null ? aliasNode.getString() : null;
            Scope globalScope = t.getScope();
            if (aliasName != null && globalScope.isDeclared(aliasName, true)) {
                while (true) {
                    String renamed;
                    if (!globalScope.isDeclared(renamed = aliasName + TransformAMDToCJSModule.VAR_RENAME_SUFFIX + TransformAMDToCJSModule.this.renameIndex, true)) {
                        NodeTraversal.traverseEs6(TransformAMDToCJSModule.this.compiler, callback, new RenameCallback(aliasName, renamed));
                        aliasName = renamed;
                        break;
                    }
                    TransformAMDToCJSModule.this.renameIndex++;
                }
            }
            if (moduleName != null) {
                Node call = IR.call(IR.name("require"), IR.string(moduleName));
                call.putBooleanProp(50, true);
                requireNode = aliasName != null ? IR.var(IR.name(aliasName), call).useSourceInfoIfMissingFromForTree(aliasNode) : IR.exprResult(call).useSourceInfoIfMissingFromForTree(modNode);
            } else {
                if (TransformAMDToCJSModule.isVirtualModuleName(aliasName)) {
                    return;
                }
                requireNode = IR.var(IR.name(aliasName), IR.nullNode()).useSourceInfoIfMissingFromForTree(aliasNode);
            }
            script.addChildBefore(requireNode, defineNode.getParent());
        }

        private String handlePlugins(NodeTraversal t, Node script, String moduleName, Node modNode) {
            if (moduleName.contains("!")) {
                t.report(modNode, REQUIREJS_PLUGINS_NOT_SUPPORTED_WARNING, moduleName);
                int condition = moduleName.indexOf(63);
                if (condition > 0) {
                    if (moduleName.contains(":")) {
                        return null;
                    }
                    return this.handlePlugins(t, script, moduleName.substring(condition + 1), modNode);
                }
                moduleName = null;
            }
            return moduleName;
        }

        private void moveCallbackContentToTopLevel(Node defineParent, Node script, Node callbackBlock) {
            int curIndex = script.getIndexOfChild(defineParent);
            script.removeChild(defineParent);
            callbackBlock.getParent().removeChild(callbackBlock);
            Node before = script.getChildAtIndex(curIndex);
            if (before != null) {
                script.addChildBefore(callbackBlock, before);
            }
            script.addChildToBack(callbackBlock);
            NodeUtil.tryMergeBlock(callbackBlock);
        }
    }
}

