/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class RewritePolyfills
implements HotSwapCompilerPass {
    static final DiagnosticType INSUFFICIENT_OUTPUT_VERSION_ERROR = DiagnosticType.warning("JSC_INSUFFICIENT_OUTPUT_VERSION", "Built-in ''{0}'' not supported in output version {1}: set --language_out to at least {2}");
    private static final String GLOBAL = "goog.global.";
    private static final String WINDOW = "window.";
    private static final Polyfills POLYFILLS = new Polyfills.Builder().addClasses(FeatureSet.ES6, FeatureSet.ES6, "", "Proxy", "Reflect").addClasses(FeatureSet.ES6_IMPL, FeatureSet.ES6_IMPL, "", "WeakMap", "WeakSet").addStatics(FeatureSet.ES6_IMPL, FeatureSet.ES6_IMPL, "", "Object", "getOwnPropertySymbols", "setPrototypeOf").addStatics(FeatureSet.ES6_IMPL, FeatureSet.ES6_IMPL, "", "String", "raw").addMethods(FeatureSet.ES6_IMPL, FeatureSet.ES6_IMPL, "", "normalize").addClasses(FeatureSet.ES6_IMPL, FeatureSet.ES3, "", "Symbol").addClasses(FeatureSet.ES6_IMPL, FeatureSet.ES3, "$jscomp", "Map", "Set").addStatics(FeatureSet.ES6_IMPL, FeatureSet.ES3, "$jscomp.math", "Math", "clz32", "imul", "sign", "log2", "log10", "log1p", "expm1", "cosh", "sinh", "tanh", "acosh", "asinh", "atanh", "hypot", "trunc", "cbrt").addStatics(FeatureSet.ES6_IMPL, FeatureSet.ES3, "$jscomp.number", "Number", "isFinite", "isInteger", "isNaN", "isSafeInteger", "EPSILON", "MAX_SAFE_INTEGER", "MIN_SAFE_INTEGER").addStatics(FeatureSet.ES6_IMPL, FeatureSet.ES3, "$jscomp.object", "Object", "assign", "is").addStatics(FeatureSet.ES6_IMPL, FeatureSet.ES3, "$jscomp.string", "String", "fromCodePoint").addMethods(FeatureSet.ES6_IMPL, FeatureSet.ES3, "$jscomp.string", "repeat", "codePointAt", "includes", "startsWith", "endsWith").addStatics(FeatureSet.ES6_IMPL, FeatureSet.ES3, "$jscomp.array", "Array", "from", "of").addMethods(FeatureSet.ES6_IMPL, FeatureSet.ES3, "$jscomp.array", "entries", "keys", "values", "copyWithin", "fill", "find", "findIndex").build();
    private final AbstractCompiler compiler;
    private final Polyfills polyfills;
    private GlobalNamespace globals;

    public RewritePolyfills(AbstractCompiler compiler) {
        this(compiler, POLYFILLS);
    }

    RewritePolyfills(AbstractCompiler compiler, Polyfills polyfills) {
        this.compiler = compiler;
        this.polyfills = polyfills;
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        Traverser traverser = new Traverser();
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, traverser);
        if (traverser.changed) {
            this.compiler.needsEs6Runtime = true;
            this.compiler.reportCodeChange();
        }
    }

    @Override
    public void process(Node externs, Node root) {
        if (this.languageOutIsAtLeast(FeatureSet.ES6) || !this.compiler.getOptions().rewritePolyfills) {
            return;
        }
        this.globals = new GlobalNamespace(this.compiler, externs, root);
        this.hotSwapScript(root, null);
    }

    private boolean languageOutIsAtLeast(CompilerOptions.LanguageMode mode) {
        return this.compiler.getOptions().getLanguageOut().compareTo(mode) >= 0;
    }

    private boolean languageOutIsAtLeast(FeatureSet features) {
        switch (features.version()) {
            case "ts": {
                return this.languageOutIsAtLeast(CompilerOptions.LanguageMode.ECMASCRIPT6_TYPED);
            }
            case "es6": 
            case "es6-impl": {
                return this.languageOutIsAtLeast(CompilerOptions.LanguageMode.ECMASCRIPT6);
            }
            case "es5": {
                return this.languageOutIsAtLeast(CompilerOptions.LanguageMode.ECMASCRIPT5);
            }
            case "es3": {
                return this.languageOutIsAtLeast(CompilerOptions.LanguageMode.ECMASCRIPT3);
            }
        }
        return false;
    }

    private static boolean isRootInScope(Node node, NodeTraversal traversal) {
        String rootName = NodeUtil.getRootOfQualifiedName(node).getQualifiedName();
        return traversal.getScope().getVar(rootName) != null;
    }

    private class Traverser
    extends NodeTraversal.AbstractPostOrderCallback {
        Set<InjectedInstaller> installers = new HashSet<InjectedInstaller>();
        boolean changed = false;

        private Traverser() {
        }

        @Override
        public void visit(NodeTraversal traversal, Node node, Node parent) {
            JSDocInfo doc = node.getJSDocInfo();
            if (doc != null) {
                this.fixJsdoc(traversal.getScope(), doc);
            }
            if (node.isQualifiedName()) {
                String name = node.getQualifiedName();
                Polyfill polyfill = null;
                if (RewritePolyfills.this.polyfills.statics.containsKey((Object)name)) {
                    polyfill = (Polyfill)RewritePolyfills.this.polyfills.statics.get((Object)name);
                }
                if (polyfill != null) {
                    if (RewritePolyfills.isRootInScope(node, traversal) || NodeUtil.isVarOrSimpleAssignLhs(node, parent)) {
                        return;
                    }
                    if (!RewritePolyfills.this.languageOutIsAtLeast(polyfill.polyfillVersion)) {
                        traversal.report(node, INSUFFICIENT_OUTPUT_VERSION_ERROR, name, RewritePolyfills.this.compiler.getOptions().getLanguageOut().toString(), polyfill.polyfillVersion.toLanguageModeString());
                    }
                    if (!RewritePolyfills.this.languageOutIsAtLeast(polyfill.nativeVersion)) {
                        if (!polyfill.installer.isEmpty()) {
                            this.addInstaller(node, polyfill.installer);
                        }
                        if (!polyfill.rewrite.isEmpty()) {
                            this.changed = true;
                            Node replacement = NodeUtil.newQName(RewritePolyfills.this.compiler, polyfill.rewrite);
                            replacement.useSourceInfoIfMissingFromForTree(node);
                            parent.replaceChild(node, replacement);
                        }
                    }
                    return;
                }
            }
            if (node.isGetProp() && node.getLastChild().isString()) {
                for (Polyfill polyfill : RewritePolyfills.this.polyfills.methods.get((Object)node.getLastChild().getString())) {
                    if (RewritePolyfills.this.languageOutIsAtLeast(polyfill.nativeVersion) || polyfill.installer.isEmpty() || this.isStaticFunction(node, traversal)) continue;
                    this.addInstaller(node, polyfill.installer);
                }
            }
        }

        private boolean isStaticFunction(Node node, NodeTraversal traversal) {
            if (!node.isQualifiedName()) {
                return false;
            }
            String root = NodeUtil.getRootOfQualifiedName(node).getQualifiedName();
            if (RewritePolyfills.this.globals == null) {
                return false;
            }
            GlobalNamespace.Name fullName = RewritePolyfills.this.globals.getOwnSlot(node.getQualifiedName());
            GlobalNamespace.Name rootName = RewritePolyfills.this.globals.getOwnSlot(root);
            if (fullName == null || rootName == null) {
                return false;
            }
            GlobalNamespace.Ref rootDecl = rootName.getDeclaration();
            if (rootDecl == null) {
                return false;
            }
            Node globalDeclNode = rootDecl.getNode();
            if (globalDeclNode == null) {
                return false;
            }
            Var rootScope = traversal.getScope().getVar(root);
            if (rootScope == null) {
                return true;
            }
            Node scopeDeclNode = rootScope.getNode();
            return scopeDeclNode == globalDeclNode;
        }

        private void fixJsdoc(Scope scope, JSDocInfo doc) {
            for (Node node : doc.getTypeNodes()) {
                this.fixJsdocType(scope, node);
            }
        }

        private void fixJsdocType(Scope scope, Node node) {
            Polyfill polyfill;
            if (node.isString() && (polyfill = (Polyfill)RewritePolyfills.this.polyfills.statics.get((Object)node.getString())) != null && scope.getVar(node.getString()) == null && !RewritePolyfills.this.languageOutIsAtLeast(polyfill.nativeVersion)) {
                node.setString(polyfill.rewrite);
            }
            for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
                this.fixJsdocType(scope, child);
            }
        }

        private void addInstaller(Node sourceNode, String function) {
            InputId inputId = sourceNode.getInputId();
            CompilerInput input = inputId != null ? RewritePolyfills.this.compiler.getInput(inputId) : null;
            JSModule module = input != null ? input.getModule() : null;
            InjectedInstaller injected = new InjectedInstaller(module, function);
            if (this.installers.add(injected)) {
                this.changed = true;
                Node installer = RewritePolyfills.this.compiler.parseSyntheticCode(function).removeChildren();
                installer.useSourceInfoIfMissingFromForTree(sourceNode);
                Node enclosingScript = NodeUtil.getEnclosingScript(sourceNode);
                enclosingScript.addChildrenToFront(installer);
            }
        }
    }

    private static class InjectedInstaller {
        final JSModule module;
        final String installer;

        InjectedInstaller(JSModule module, String installer) {
            this.module = module;
            this.installer = installer;
        }

        public int hashCode() {
            return Objects.hash(this.module, this.installer);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof InjectedInstaller && ((InjectedInstaller)other).installer.equals(this.installer) && Objects.equals(((InjectedInstaller)other).module, this.module);
        }
    }

    static class Polyfills {
        private final ImmutableMultimap<String, Polyfill> methods;
        private final ImmutableMap<String, Polyfill> statics;

        private Polyfills(Builder builder) {
            this.methods = builder.methodsBuilder.build();
            this.statics = builder.staticsBuilder.build();
        }

        static class Builder {
            private final ImmutableMultimap.Builder<String, Polyfill> methodsBuilder = ImmutableMultimap.builder();
            private final ImmutableMap.Builder<String, Polyfill> staticsBuilder = ImmutableMap.builder();

            Builder() {
            }

            Builder addMethods(FeatureSet nativeVersion, FeatureSet polyfillVersion, String base, String ... methods) {
                if (!base.isEmpty()) {
                    for (String method : methods) {
                        this.methodsBuilder.put((Object)method, (Object)new Polyfill(nativeVersion, polyfillVersion, "", base + "." + method + "$install();"));
                    }
                }
                return this;
            }

            Builder addStatics(FeatureSet nativeVersion, FeatureSet polyfillVersion, String polyfillBase, String nativeBase, String ... statics) {
                for (String item : statics) {
                    String nativeName = nativeBase + "." + item;
                    String polyfillName = !polyfillBase.isEmpty() ? polyfillBase + "." + item : "";
                    Polyfill polyfill = new Polyfill(nativeVersion, polyfillVersion, polyfillName, "");
                    this.staticsBuilder.put((Object)nativeName, (Object)polyfill);
                    this.staticsBuilder.put((Object)(RewritePolyfills.GLOBAL + nativeName), (Object)polyfill);
                    this.staticsBuilder.put((Object)(RewritePolyfills.WINDOW + nativeName), (Object)polyfill);
                }
                return this;
            }

            Builder addClasses(FeatureSet nativeVersion, FeatureSet polyfillVersion, String base, String ... classes) {
                for (String className : classes) {
                    String polyfillName = base + "." + className;
                    Polyfill polyfill = !base.isEmpty() ? new Polyfill(nativeVersion, polyfillVersion, polyfillName, polyfillName + "$install();") : new Polyfill(nativeVersion, polyfillVersion, "", "");
                    this.staticsBuilder.put((Object)className, (Object)polyfill);
                    this.staticsBuilder.put((Object)(RewritePolyfills.GLOBAL + className), (Object)polyfill);
                    this.staticsBuilder.put((Object)(RewritePolyfills.WINDOW + className), (Object)polyfill);
                }
                return this;
            }

            Polyfills build() {
                return new Polyfills(this);
            }
        }
    }

    private static class Polyfill {
        final FeatureSet nativeVersion;
        final FeatureSet polyfillVersion;
        final String rewrite;
        final String installer;

        Polyfill(FeatureSet nativeVersion, FeatureSet polyfillVersion, String rewrite, String installer) {
            this.nativeVersion = nativeVersion;
            this.polyfillVersion = polyfillVersion;
            this.rewrite = rewrite;
            this.installer = installer;
        }
    }
}

