/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ES6ModuleLoader;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public final class ProcessCommonJSModules
implements CompilerPass {
    private static final String EXPORTS = "exports";
    private static final String MODULE = "module";
    private final Compiler compiler;
    private final ES6ModuleLoader loader;
    private final boolean reportDependencies;

    public ProcessCommonJSModules(Compiler compiler, ES6ModuleLoader loader) {
        this(compiler, loader, true);
    }

    public ProcessCommonJSModules(Compiler compiler, ES6ModuleLoader loader, boolean reportDependencies) {
        this.compiler = compiler;
        this.loader = loader;
        this.reportDependencies = reportDependencies;
    }

    @Override
    public void process(Node externs, Node root) {
        FindGoogProvideOrGoogModule finder = new FindGoogProvideOrGoogModule();
        NodeTraversal.traverseEs6(this.compiler, root, finder);
        NodeTraversal.traverseEs6(this.compiler, root, new ProcessCommonJsModulesCallback(!finder.found));
    }

    String inputToModuleName(CompilerInput input) {
        return ES6ModuleLoader.toModuleName(this.loader.normalizeInputAddress(input));
    }

    private class SuffixVarsCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private final String suffix;
        private final boolean fullRewrite;

        SuffixVarsCallback(String suffix, boolean fullRewrite) {
            this.suffix = suffix;
            this.fullRewrite = fullRewrite;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            boolean isShorthandObjLitKey;
            JSDocInfo info = n.getJSDocInfo();
            if (info != null) {
                for (Node typeNode : info.getTypeNodes()) {
                    this.fixTypeNode(t, typeNode);
                }
            }
            boolean bl = isShorthandObjLitKey = n.isStringKey() && !n.hasChildren();
            if (this.fullRewrite && n.isName() || isShorthandObjLitKey) {
                String name = n.getString();
                if (this.suffix.equals(name)) {
                    return;
                }
                if (ProcessCommonJSModules.EXPORTS.equals(name)) {
                    return;
                }
                if (((ProcessCommonJSModules)ProcessCommonJSModules.this).compiler.getOptions().exportTestFunctions && name.startsWith("test")) {
                    return;
                }
                Var var = t.getScope().getVar(name);
                if (var != null && var.isGlobal()) {
                    String newName = name + "$$" + this.suffix;
                    if (isShorthandObjLitKey) {
                        n.addChildToBack(IR.name(newName).useSourceInfoIfMissingFrom(n));
                    } else {
                        n.setString(newName);
                        n.setOriginalName(name);
                    }
                }
            }
        }

        private void fixTypeNode(NodeTraversal t, Node typeNode) {
            if (typeNode.isString()) {
                String name = typeNode.getString();
                if (ES6ModuleLoader.isRelativeIdentifier(name)) {
                    int lastSlash = name.lastIndexOf(47);
                    int endIndex = name.indexOf(46, lastSlash);
                    String localTypeName = null;
                    if (endIndex == -1) {
                        endIndex = name.length();
                    } else {
                        localTypeName = name.substring(endIndex);
                    }
                    String moduleName = name.substring(0, endIndex);
                    URI loadAddress = ProcessCommonJSModules.this.loader.locateCommonJsModule(moduleName, t.getInput());
                    if (loadAddress == null) {
                        t.makeError(typeNode, ES6ModuleLoader.LOAD_ERROR, moduleName);
                        return;
                    }
                    String globalModuleName = ES6ModuleLoader.toModuleName(loadAddress);
                    typeNode.setString(localTypeName == null ? globalModuleName : globalModuleName + localTypeName);
                } else if (this.fullRewrite) {
                    int endIndex = name.indexOf(46);
                    if (endIndex == -1) {
                        endIndex = name.length();
                    }
                    String baseName = name.substring(0, endIndex);
                    Var var = t.getScope().getVar(baseName);
                    if (var != null && var.isGlobal()) {
                        typeNode.setString(baseName + "$$" + this.suffix + name.substring(endIndex));
                        typeNode.setOriginalName(name);
                    }
                }
            }
            for (Node child = typeNode.getFirstChild(); child != null; child = child.getNext()) {
                this.fixTypeNode(t, child);
            }
        }
    }

    private class ProcessCommonJsModulesCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private int scriptNodeCount = 0;
        private List<Node> moduleExportRefs = new ArrayList<Node>();
        private List<Node> exportRefs = new ArrayList<Node>();
        Multiset<String> propertyExportRefCount = HashMultiset.create();
        private final boolean allowFullRewrite;

        public ProcessCommonJsModulesCallback(boolean allowFullRewrite) {
            this.allowFullRewrite = allowFullRewrite;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            Var v;
            if (n.isCall() && n.getChildCount() == 2 && n.getFirstChild().matchesQualifiedName("require") && n.getSecondChild().isString()) {
                this.visitRequireCall(t, n, parent);
            }
            if (this.allowFullRewrite && n.isIf()) {
                FindModuleExportStatements commonjsFinder = new FindModuleExportStatements();
                Node condition = n.getFirstChild();
                NodeTraversal.traverseEs6(ProcessCommonJSModules.this.compiler, condition, commonjsFinder);
                if (commonjsFinder.isFound()) {
                    this.visitCommonJSIfStatement(n);
                } else {
                    FindDefineAmdStatements amdFinder = new FindDefineAmdStatements();
                    NodeTraversal.traverseEs6(ProcessCommonJSModules.this.compiler, condition, amdFinder);
                    if (amdFinder.isFound()) {
                        this.visitAMDIfStatement(n);
                    }
                }
            }
            if (n.isScript()) {
                ++this.scriptNodeCount;
                this.visitScript(t, n);
            }
            if (this.allowFullRewrite && n.isGetProp() && "module.exports".equals(n.getQualifiedName()) && (v = t.getScope().getVar(ProcessCommonJSModules.MODULE)) == null) {
                this.moduleExportRefs.add(n);
                this.maybeAddReferenceCount(n);
            }
            if (this.allowFullRewrite && n.isName() && ProcessCommonJSModules.EXPORTS.equals(n.getString()) && ((v = t.getScope().getVar(n.getString())) == null || v.isGlobal())) {
                this.exportRefs.add(n);
                this.maybeAddReferenceCount(n);
            }
        }

        private Node getBaseQualifiedNameNode(Node n) {
            Node refParent = n;
            while (refParent.getParent() != null && refParent.getParent().isQualifiedName()) {
                refParent = refParent.getParent();
            }
            if (refParent == null || !refParent.getParent().isAssign()) {
                return null;
            }
            return refParent;
        }

        private void maybeAddReferenceCount(Node n) {
            Node refParent = this.getBaseQualifiedNameNode(n);
            if (refParent == null) {
                return;
            }
            String qName = refParent.getQualifiedName();
            if (qName.startsWith("module.exports.")) {
                qName = qName.substring("module.exports.".length());
            } else if (qName.startsWith("exports.")) {
                qName = qName.substring("exports.".length());
            } else {
                return;
            }
            this.propertyExportRefCount.add((Object)qName);
        }

        private void visitRequireCall(NodeTraversal t, Node require, Node parent) {
            String requireName = require.getSecondChild().getString();
            URI loadAddress = ProcessCommonJSModules.this.loader.locateCommonJsModule(requireName, t.getInput());
            if (loadAddress == null) {
                ProcessCommonJSModules.this.compiler.report(t.makeError(require, ES6ModuleLoader.LOAD_ERROR, requireName));
                return;
            }
            String moduleName = ES6ModuleLoader.toModuleName(loadAddress);
            Node moduleRef = IR.name(moduleName).srcref(require);
            parent.replaceChild(require, moduleRef);
            Node script = this.getCurrentScriptNode(parent);
            if (ProcessCommonJSModules.this.reportDependencies) {
                t.getInput().addRequire(moduleName);
            }
            script.addChildToFront(IR.exprResult(IR.call(IR.getprop(IR.name("goog"), IR.string("require")), IR.string(moduleName))).useSourceInfoIfMissingFromForTree(require));
            ProcessCommonJSModules.this.compiler.reportCodeChange();
        }

        private void visitScript(NodeTraversal t, Node script) {
            Preconditions.checkArgument((this.scriptNodeCount == 1 ? 1 : 0) != 0, (Object)"ProcessCommonJSModules supports only one invocation per CompilerInput / script node");
            String moduleName = ProcessCommonJSModules.this.inputToModuleName(t.getInput());
            boolean hasExports = !this.moduleExportRefs.isEmpty() || !this.exportRefs.isEmpty();
            NodeTraversal.traverseEs6(ProcessCommonJSModules.this.compiler, script, new SuffixVarsCallback(moduleName, hasExports));
            if (!hasExports) {
                return;
            }
            this.processExports(script, moduleName);
            this.moduleExportRefs.clear();
            this.exportRefs.clear();
            if (ProcessCommonJSModules.this.reportDependencies) {
                CompilerInput ci = t.getInput();
                ci.addProvide(moduleName);
            }
            script.addChildToFront(IR.exprResult(IR.call(IR.getprop(IR.name("goog"), IR.string("provide")), IR.string(moduleName))).useSourceInfoIfMissingFromForTree(script));
            ProcessCommonJSModules.this.compiler.reportCodeChange();
        }

        private void visitCommonJSIfStatement(Node n) {
            Node p = n.getParent();
            if (p != null) {
                this.replaceIfStatementWithBranch(n, n.getSecondChild());
            }
        }

        private void visitAMDIfStatement(Node n) {
            Node p = n.getParent();
            if (p != null) {
                if (n.getChildCount() == 3) {
                    this.replaceIfStatementWithBranch(n, n.getChildAtIndex(2));
                } else {
                    p.removeChild(n);
                }
            }
        }

        private void replaceIfStatementWithBranch(Node ifStatement, Node branch) {
            Node p = ifStatement.getParent();
            Node newNode = branch;
            if (branch.isBlock() && branch.getChildCount() == 1) {
                newNode = branch.getFirstChild();
                branch.detachChildren();
            } else {
                ifStatement.detachChildren();
            }
            p.replaceChild(ifStatement, newNode);
        }

        private void processExports(Node script, String moduleName) {
            if (this.hasOneTopLevelModuleExportAssign()) {
                Node ref = this.moduleExportRefs.get(0);
                Node newName = IR.name(moduleName).srcref(ref);
                newName.setOriginalName(ref.getQualifiedName());
                Node rhsValue = ref.getNext();
                if (rhsValue.isObjectLit()) {
                    this.addConstToObjLitKeys(rhsValue);
                }
                Node assign = ref.getParent();
                assign.replaceChild(ref, newName);
                JSDocInfoBuilder builder = new JSDocInfoBuilder(true);
                builder.recordConstancy();
                JSDocInfo info = builder.build();
                assign.setJSDocInfo(info);
                return;
            }
            boolean hasLValues = this.hasExportLValues();
            Iterable<Node> exports = hasLValues ? this.moduleExportRefs : Iterables.concat(this.moduleExportRefs, this.exportRefs);
            boolean declaredModuleExports = false;
            for (Node ref : exports) {
                Node baseName;
                if (ref.getParent().isAssign() && !ref.getGrandparent().isExprResult() && !declaredModuleExports) {
                    script.addChildToFront(IR.var(IR.name(moduleName)).useSourceInfoIfMissingFromForTree(ref));
                    declaredModuleExports = true;
                }
                String qName = null;
                if (ref.isQualifiedName() && (baseName = this.getBaseQualifiedNameNode(ref)) != null) {
                    qName = baseName.getQualifiedName();
                    qName = qName.startsWith("module.exports.") ? qName.substring("module.exports.".length()) : qName.substring("exports.".length());
                }
                Node rhsValue = ref.getNext();
                Node newName = IR.name(moduleName).srcref(ref);
                newName.setOriginalName(qName);
                Node parent = ref.getParent();
                parent.replaceChild(ref, newName);
                if (!parent.isAssign() || qName == null || this.propertyExportRefCount.count((Object)qName) != 1) continue;
                if (rhsValue != null && rhsValue.isObjectLit()) {
                    this.addConstToObjLitKeys(rhsValue);
                }
                JSDocInfoBuilder builder = new JSDocInfoBuilder(true);
                builder.recordConstancy();
                JSDocInfo info = builder.build();
                parent.setJSDocInfo(info);
            }
            if (!hasLValues) {
                return;
            }
            if (!this.exportRefs.isEmpty()) {
                String aliasName = "exports$$" + moduleName;
                Node aliasNode = IR.var(IR.name(aliasName), IR.name(moduleName)).useSourceInfoIfMissingFromForTree(script);
                script.addChildToFront(aliasNode);
                for (Node ref : this.exportRefs) {
                    ref.setOriginalName(ref.getString());
                    ref.setString(aliasName);
                }
            }
        }

        private void addConstToObjLitKeys(Node n) {
            Preconditions.checkState((boolean)n.isObjectLit());
            for (Node key = n.getFirstChild(); key != null; key = key.getNext()) {
                if (key.getJSDocInfo() != null) continue;
                JSDocInfoBuilder builder = new JSDocInfoBuilder(true);
                builder.recordConstancy();
                JSDocInfo info = builder.build();
                key.setJSDocInfo(info);
            }
        }

        private boolean hasOneTopLevelModuleExportAssign() {
            return this.moduleExportRefs.size() == 1 && this.exportRefs.isEmpty() && this.isTopLevelAssignLhs(this.moduleExportRefs.get(0));
        }

        private boolean isTopLevelAssignLhs(Node n) {
            Node parent = n.getParent();
            return parent.isAssign() && n == parent.getFirstChild() && parent.getParent().isExprResult() && parent.getGrandparent().isScript();
        }

        private boolean hasExportLValues() {
            for (Node ref : Iterables.concat(this.moduleExportRefs, this.exportRefs)) {
                if (!NodeUtil.isLValue(ref)) continue;
                return true;
            }
            return false;
        }

        private Node getCurrentScriptNode(Node n) {
            while (!n.isScript()) {
                n = n.getParent();
            }
            return n;
        }
    }

    static class FindDefineAmdStatements
    extends NodeTraversal.AbstractPreOrderCallback {
        private boolean found;

        FindDefineAmdStatements() {
        }

        boolean isFound() {
            return this.found;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            if (n.isGetProp() && "define.amd".equals(n.getQualifiedName())) {
                this.found = true;
            }
            return true;
        }
    }

    static class FindModuleExportStatements
    extends NodeTraversal.AbstractPreOrderCallback {
        private boolean found;

        FindModuleExportStatements() {
        }

        boolean isFound() {
            return this.found;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            if (n.isGetProp() && "module.exports".equals(n.getQualifiedName()) || n.isName() && ProcessCommonJSModules.EXPORTS.equals(n.getString())) {
                this.found = true;
            }
            return true;
        }
    }

    static class FindGoogProvideOrGoogModule
    extends NodeTraversal.AbstractPreOrderCallback {
        private boolean found;

        FindGoogProvideOrGoogModule() {
        }

        boolean isFound() {
            return this.found;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            if (this.found) {
                return false;
            }
            if (parent == null || NodeUtil.isControlStructure(parent) || NodeUtil.isStatementBlock(parent)) {
                Node maybeGetProp;
                if (n.isExprResult() && (maybeGetProp = n.getFirstFirstChild()) != null && (maybeGetProp.matchesQualifiedName("goog.provide") || maybeGetProp.matchesQualifiedName("goog.module"))) {
                    this.found = true;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

