/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.FunctionInjector;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class J2clPropertyInlinerPass
implements CompilerPass {
    final AbstractCompiler compiler;

    public J2clPropertyInlinerPass(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        new StaticFieldGetterSetterInliner(root).run();
    }

    class StaticFieldGetterSetterInliner {
        Node root;
        private Pattern matchJ2CLStaticFieldName;

        StaticFieldGetterSetterInliner(Node root) {
            this.root = root;
            String pattern = "\\Af_[A-Za-z0-9$_]+__([A-Za-z0-9$]+_)*[A-Za-z0-9$]+\\z";
            this.matchJ2CLStaticFieldName = Pattern.compile(pattern);
        }

        @VisibleForTesting
        boolean matchesJ2clStaticFieldName(String fieldName) {
            Matcher m = this.matchJ2CLStaticFieldName.matcher(fieldName);
            return m.find();
        }

        private void run() {
            GatherJ2CLClassGetterSetters gatherer = new GatherJ2CLClassGetterSetters();
            NodeTraversal.traverseEs6(J2clPropertyInlinerPass.this.compiler, this.root, gatherer);
            Map result = gatherer.getResults();
            NodeTraversal.traverseEs6(J2clPropertyInlinerPass.this.compiler, this.root, new DetermineInlinableProperties(result));
            new InlinePropertiesPass(result).run();
        }

        private class InlinePropertiesPass
        extends NodeTraversal.AbstractPostOrderCallback {
            private Map<String, J2clProperty> propertiesByName;

            InlinePropertiesPass(Map<String, J2clProperty> allGetterSetters) {
                this.propertiesByName = allGetterSetters;
            }

            private void run() {
                NodeTraversal.traverseEs6(J2clPropertyInlinerPass.this.compiler, StaticFieldGetterSetterInliner.this.root, this);
                for (J2clProperty prop : this.propertiesByName.values()) {
                    if (!prop.isSafeToInline) continue;
                    prop.remove();
                }
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (n.isGetProp()) {
                    if (parent.isExprResult()) {
                        return;
                    }
                    if (NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == n) {
                        return;
                    }
                    String accessName = n.getLastChild().getString();
                    J2clProperty prop = this.propertiesByName.get(accessName);
                    if (prop != null && prop.isSafeToInline) {
                        FunctionInjector injector = new FunctionInjector(J2clPropertyInlinerPass.this.compiler, J2clPropertyInlinerPass.this.compiler.getUniqueNameIdSupplier(), true, true, true);
                        Node inlinedCall = injector.inline(new FunctionInjector.Reference(n, t.getScope(), t.getModule(), FunctionInjector.InliningMode.DIRECT), null, prop.getKey.getFirstChild());
                        t.getCompiler().reportChangeToEnclosingScope(inlinedCall);
                    }
                }
                if (n.isAssign()) {
                    String accessName;
                    J2clProperty prop;
                    Node assignmentTarget = n.getFirstChild();
                    Node assignmentValue = n.getLastChild();
                    if (assignmentTarget.isGetProp() && (prop = this.propertiesByName.get(accessName = assignmentTarget.getLastChild().getString())) != null && prop.isSafeToInline) {
                        FunctionInjector injector = new FunctionInjector(J2clPropertyInlinerPass.this.compiler, J2clPropertyInlinerPass.this.compiler.getUniqueNameIdSupplier(), true, true, true);
                        assignmentValue.detachFromParent();
                        Node functionCall = IR.call(IR.empty(), assignmentValue);
                        parent.replaceChild(n, functionCall);
                        FunctionInjector.Reference reference = new FunctionInjector.Reference(functionCall, t.getScope(), t.getModule(), FunctionInjector.InliningMode.BLOCK);
                        injector.maybePrepareCall(reference);
                        Node inlinedCall = injector.inline(reference, null, prop.setKey.getFirstChild());
                        t.getCompiler().reportChangeToEnclosingScope(inlinedCall);
                    }
                }
            }
        }

        private class DetermineInlinableProperties
        extends NodeTraversal.AbstractPostOrderCallback {
            private Map<String, J2clProperty> propertiesByName;

            DetermineInlinableProperties(Map<String, J2clProperty> allGetterSetters) {
                this.propertiesByName = allGetterSetters;
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                String accessName;
                J2clProperty prop;
                Node assignmentTarget;
                if ((NodeUtil.isCompoundAssignementOp(n) || n.isInc() || n.isDec()) && (assignmentTarget = n.getFirstChild()).isGetProp() && (prop = this.propertiesByName.get(accessName = assignmentTarget.getLastChild().getString())) != null) {
                    prop.isSafeToInline = false;
                }
            }
        }

        private class GatherJ2CLClassGetterSetters
        extends NodeTraversal.AbstractPostOrderCallback {
            private Map<String, J2clProperty> propertiesByName = new HashMap<String, J2clProperty>();

            private GatherJ2CLClassGetterSetters() {
            }

            private Map<String, J2clProperty> getResults() {
                return this.propertiesByName;
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (!NodeUtil.isObjectDefinePropertiesDefinition(n)) {
                    return;
                }
                for (Node p : NodeUtil.getObjectDefinedPropertiesKeys(n)) {
                    String name = p.getString();
                    if (!StaticFieldGetterSetterInliner.this.matchesJ2clStaticFieldName(name)) continue;
                    Node propertyLiteral = p.getFirstChild();
                    Node getKey = null;
                    Node setKey = null;
                    for (Node innerKey : propertyLiteral.children()) {
                        if (!innerKey.isStringKey()) continue;
                        switch (innerKey.getString()) {
                            case "get": {
                                getKey = innerKey;
                                break;
                            }
                            case "set": {
                                setKey = innerKey;
                            }
                        }
                    }
                    Preconditions.checkArgument((getKey != null && setKey != null ? 1 : 0) != 0, (Object)"J2cl Properties should have both a getter and setter");
                    this.propertiesByName.put(name, new J2clProperty(getKey, setKey));
                }
            }
        }

        private class J2clProperty {
            private Node getKey;
            private Node setKey;
            private boolean isSafeToInline;

            public J2clProperty(Node getKey, Node setKey) {
                this.getKey = getKey;
                this.setKey = setKey;
                this.isSafeToInline = true;
            }

            void remove() {
                Node objectLit = this.getKey.getParent().getParent().getParent();
                Preconditions.checkArgument((boolean)objectLit.isObjectLit());
                this.getKey.getParent().getParent().detachFromParent();
                J2clPropertyInlinerPass.this.compiler.reportCodeChange();
                if (objectLit.getChildCount() == 0) {
                    objectLit.getParent().getParent().detachFromParent();
                }
            }
        }
    }
}

