/*
 * Decompiled with CFR 0.152.
 */
package com.google.debugging.sourcemap;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.debugging.sourcemap.Base64VLQ;
import com.google.debugging.sourcemap.FilePosition;
import com.google.debugging.sourcemap.SourceMapConsumerV3;
import com.google.debugging.sourcemap.SourceMapGenerator;
import com.google.debugging.sourcemap.SourceMapParseException;
import com.google.debugging.sourcemap.SourceMapSection;
import com.google.debugging.sourcemap.Util;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@GwtIncompatible(value="com.google.gson")
public final class SourceMapGeneratorV3
implements SourceMapGenerator {
    private static final int UNMAPPED = -1;
    private List<Mapping> mappings = new ArrayList<Mapping>();
    private LinkedHashMap<String, Integer> sourceFileMap = new LinkedHashMap();
    private LinkedHashMap<String, Integer> originalNameMap = new LinkedHashMap();
    private String lastSourceFile = null;
    private int lastSourceFileIndex = -1;
    private Mapping lastMapping;
    private FilePosition offsetPosition = new FilePosition(0, 0);
    private FilePosition prefixPosition = new FilePosition(0, 0);
    private LinkedHashMap<String, Object> extensions = new LinkedHashMap();
    private String sourceRootPath;

    @Override
    public void reset() {
        this.mappings.clear();
        this.lastMapping = null;
        this.sourceFileMap.clear();
        this.originalNameMap.clear();
        this.lastSourceFile = null;
        this.lastSourceFileIndex = -1;
        this.offsetPosition = new FilePosition(0, 0);
        this.prefixPosition = new FilePosition(0, 0);
    }

    @Override
    public void validate(boolean validate) {
    }

    @Override
    public void setWrapperPrefix(String prefix) {
        int prefixLine = 0;
        int prefixIndex = 0;
        for (int i = 0; i < prefix.length(); ++i) {
            if (prefix.charAt(i) == '\n') {
                ++prefixLine;
                prefixIndex = 0;
                continue;
            }
            ++prefixIndex;
        }
        this.prefixPosition = new FilePosition(prefixLine, prefixIndex);
    }

    @Override
    public void setStartingPosition(int offsetLine, int offsetIndex) {
        Preconditions.checkState((offsetLine >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((offsetIndex >= 0 ? 1 : 0) != 0);
        this.offsetPosition = new FilePosition(offsetLine, offsetIndex);
    }

    @Override
    public void addMapping(String sourceName, @Nullable String symbolName, FilePosition sourceStartPosition, FilePosition startPosition, FilePosition endPosition) {
        if (sourceName == null || sourceStartPosition.getLine() < 0) {
            return;
        }
        FilePosition adjustedStart = startPosition;
        FilePosition adjustedEnd = endPosition;
        if (this.offsetPosition.getLine() != 0 || this.offsetPosition.getColumn() != 0) {
            int offsetLine = this.offsetPosition.getLine();
            int startOffsetPosition = this.offsetPosition.getColumn();
            int endOffsetPosition = this.offsetPosition.getColumn();
            if (startPosition.getLine() > 0) {
                startOffsetPosition = 0;
            }
            if (endPosition.getLine() > 0) {
                endOffsetPosition = 0;
            }
            adjustedStart = new FilePosition(startPosition.getLine() + offsetLine, startPosition.getColumn() + startOffsetPosition);
            adjustedEnd = new FilePosition(endPosition.getLine() + offsetLine, endPosition.getColumn() + endOffsetPosition);
        }
        Mapping mapping = new Mapping();
        mapping.sourceFile = sourceName;
        mapping.originalPosition = sourceStartPosition;
        mapping.originalName = symbolName;
        mapping.startPosition = adjustedStart;
        mapping.endPosition = adjustedEnd;
        if (this.lastMapping != null) {
            int lastLine = this.lastMapping.startPosition.getLine();
            int lastColumn = this.lastMapping.startPosition.getColumn();
            int nextLine = mapping.startPosition.getLine();
            int nextColumn = mapping.startPosition.getColumn();
            Preconditions.checkState((nextLine > lastLine || nextLine == lastLine && nextColumn >= lastColumn ? 1 : 0) != 0, (String)"Incorrect source mappings order, previous : (%s,%s)\nnew : (%s,%s)", (Object[])new Object[]{lastLine, lastColumn, nextLine, nextColumn});
        }
        this.lastMapping = mapping;
        this.mappings.add(mapping);
    }

    public void mergeMapSection(int line, int column, String mapSectionContents) throws SourceMapParseException {
        this.setStartingPosition(line, column);
        SourceMapConsumerV3 section = new SourceMapConsumerV3();
        section.parse(mapSectionContents);
        section.visitMappings(new ConsumerEntryVisitor());
    }

    public void mergeMapSection(int line, int column, String mapSectionContents, ExtensionMergeAction mergeAction) throws SourceMapParseException {
        this.setStartingPosition(line, column);
        SourceMapConsumerV3 section = new SourceMapConsumerV3();
        section.parse(mapSectionContents);
        section.visitMappings(new ConsumerEntryVisitor());
        for (Map.Entry<String, Object> entry : section.getExtensions().entrySet()) {
            String extensionKey = entry.getKey();
            if (this.extensions.containsKey(extensionKey)) {
                this.extensions.put(extensionKey, mergeAction.merge(extensionKey, this.extensions.get(extensionKey), entry.getValue()));
                continue;
            }
            this.extensions.put(extensionKey, entry.getValue());
        }
    }

    @Override
    public void appendTo(Appendable out, String name) throws IOException {
        int maxLine = this.prepMappings() + 1;
        out.append("{\n");
        SourceMapGeneratorV3.appendFirstField(out, "version", "3");
        SourceMapGeneratorV3.appendField(out, "file", SourceMapGeneratorV3.escapeString(name));
        SourceMapGeneratorV3.appendField(out, "lineCount", String.valueOf(maxLine));
        if (this.sourceRootPath != null && !this.sourceRootPath.isEmpty()) {
            SourceMapGeneratorV3.appendField(out, "sourceRoot", SourceMapGeneratorV3.escapeString(this.sourceRootPath));
        }
        SourceMapGeneratorV3.appendFieldStart(out, "mappings");
        new LineMapper(out, maxLine).appendLineMappings();
        SourceMapGeneratorV3.appendFieldEnd(out);
        SourceMapGeneratorV3.appendFieldStart(out, "sources");
        out.append("[");
        this.addSourceNameMap(out);
        out.append("]");
        SourceMapGeneratorV3.appendFieldEnd(out);
        SourceMapGeneratorV3.appendFieldStart(out, "names");
        out.append("[");
        this.addSymbolNameMap(out);
        out.append("]");
        SourceMapGeneratorV3.appendFieldEnd(out);
        for (String key : this.extensions.keySet()) {
            Object objValue = this.extensions.get(key);
            String value = objValue.toString();
            if (objValue instanceof String) {
                value = new Gson().toJson((Object)value);
            }
            SourceMapGeneratorV3.appendField(out, key, value);
        }
        out.append("\n}\n");
    }

    public void setSourceRoot(String path) {
        this.sourceRootPath = path;
    }

    public void addExtension(String name, Object object) throws SourceMapParseException {
        if (!name.startsWith("x_")) {
            throw new SourceMapParseException("Extension '" + name + "' must start with 'x_'");
        }
        this.extensions.put(name, object);
    }

    public void removeExtension(String name) {
        if (this.extensions.containsKey(name)) {
            this.extensions.remove(name);
        }
    }

    public boolean hasExtension(String name) {
        return this.extensions.containsKey(name);
    }

    public Object getExtension(String name) {
        return this.extensions.get(name);
    }

    private void addSourceNameMap(Appendable out) throws IOException {
        SourceMapGeneratorV3.addNameMap(out, this.sourceFileMap);
    }

    private void addSymbolNameMap(Appendable out) throws IOException {
        SourceMapGeneratorV3.addNameMap(out, this.originalNameMap);
    }

    private static void addNameMap(Appendable out, Map<String, Integer> map) throws IOException {
        int i = 0;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String key = entry.getKey();
            if (i != 0) {
                out.append(",");
            }
            out.append(SourceMapGeneratorV3.escapeString(key));
            ++i;
        }
    }

    private static String escapeString(String value) {
        return Util.escapeString(value);
    }

    private static void appendFirstField(Appendable out, String name, CharSequence value) throws IOException {
        out.append("\"");
        out.append(name);
        out.append("\"");
        out.append(":");
        out.append(value);
    }

    private static void appendField(Appendable out, String name, CharSequence value) throws IOException {
        out.append(",\n");
        out.append("\"");
        out.append(name);
        out.append("\"");
        out.append(":");
        out.append(value);
    }

    private static void appendFieldStart(Appendable out, String name) throws IOException {
        SourceMapGeneratorV3.appendField(out, name, "");
    }

    private static void appendFieldEnd(Appendable out) throws IOException {
    }

    private int prepMappings() throws IOException {
        new MappingTraversal().traverse(new UsedMappingCheck());
        int id = 0;
        int maxLine = 0;
        for (Mapping m : this.mappings) {
            if (!m.used) continue;
            m.id = id++;
            int endPositionLine = m.endPosition.getLine();
            maxLine = Math.max(maxLine, endPositionLine);
        }
        return maxLine + this.prefixPosition.getLine();
    }

    @Override
    public void appendIndexMapTo(Appendable out, String name, List<SourceMapSection> sections) throws IOException {
        out.append("{\n");
        SourceMapGeneratorV3.appendFirstField(out, "version", "3");
        SourceMapGeneratorV3.appendField(out, "file", SourceMapGeneratorV3.escapeString(name));
        SourceMapGeneratorV3.appendFieldStart(out, "sections");
        out.append("[\n");
        boolean first = true;
        for (SourceMapSection section : sections) {
            if (first) {
                first = false;
            } else {
                out.append(",\n");
            }
            out.append("{\n");
            SourceMapGeneratorV3.appendFirstField(out, "offset", SourceMapGeneratorV3.offsetValue(section.getLine(), section.getColumn()));
            if (section.getSectionType() == SourceMapSection.SectionType.URL) {
                SourceMapGeneratorV3.appendField(out, "url", SourceMapGeneratorV3.escapeString(section.getSectionValue()));
            } else if (section.getSectionType() == SourceMapSection.SectionType.MAP) {
                SourceMapGeneratorV3.appendField(out, "map", section.getSectionValue());
            } else {
                throw new IOException("Unexpected section type");
            }
            out.append("\n}");
        }
        out.append("\n]");
        SourceMapGeneratorV3.appendFieldEnd(out);
        out.append("\n}\n");
    }

    private static CharSequence offsetValue(int line, int column) throws IOException {
        StringBuilder out = new StringBuilder();
        out.append("{\n");
        SourceMapGeneratorV3.appendFirstField(out, "line", String.valueOf(line));
        SourceMapGeneratorV3.appendField(out, "column", String.valueOf(column));
        out.append("\n}");
        return out;
    }

    private int getSourceId(String sourceName) {
        if (sourceName != this.lastSourceFile) {
            this.lastSourceFile = sourceName;
            Integer index = this.sourceFileMap.get(sourceName);
            if (index != null) {
                this.lastSourceFileIndex = index;
            } else {
                this.lastSourceFileIndex = this.sourceFileMap.size();
                this.sourceFileMap.put(sourceName, this.lastSourceFileIndex);
            }
        }
        return this.lastSourceFileIndex;
    }

    private int getNameId(String symbolName) {
        int originalNameIndex;
        Integer index = this.originalNameMap.get(symbolName);
        if (index != null) {
            originalNameIndex = index;
        } else {
            originalNameIndex = this.originalNameMap.size();
            this.originalNameMap.put(symbolName, originalNameIndex);
        }
        return originalNameIndex;
    }

    private class LineMapper
    implements MappingVisitor {
        private final Appendable out;
        private final int maxLine;
        private int previousLine = -1;
        private int previousColumn = 0;
        private int previousSourceFileId;
        private int previousSourceLine;
        private int previousSourceColumn;
        private int previousNameId;

        LineMapper(Appendable out, int maxLine) {
            this.out = out;
            this.maxLine = maxLine;
        }

        @Override
        public void visit(Mapping m, int line, int col, int nextLine, int nextCol) throws IOException {
            if (this.previousLine != line) {
                this.previousColumn = 0;
            }
            if (line != nextLine || col != nextCol) {
                if (line < this.maxLine) {
                    if (this.previousLine == line) {
                        this.out.append(',');
                    }
                    this.writeEntry(m, col);
                    this.previousLine = line;
                    this.previousColumn = col;
                } else {
                    Preconditions.checkState((m == null ? 1 : 0) != 0);
                }
            }
            for (int i = line; i <= nextLine && i < this.maxLine && i != nextLine; ++i) {
                this.closeLine(false);
                this.openLine(false);
            }
        }

        void writeEntry(Mapping m, int column) throws IOException {
            Base64VLQ.encode(this.out, column - this.previousColumn);
            this.previousColumn = column;
            if (m != null) {
                int sourceId = SourceMapGeneratorV3.this.getSourceId(m.sourceFile);
                Base64VLQ.encode(this.out, sourceId - this.previousSourceFileId);
                this.previousSourceFileId = sourceId;
                int srcline = m.originalPosition.getLine();
                int srcColumn = m.originalPosition.getColumn();
                Base64VLQ.encode(this.out, srcline - this.previousSourceLine);
                this.previousSourceLine = srcline;
                Base64VLQ.encode(this.out, srcColumn - this.previousSourceColumn);
                this.previousSourceColumn = srcColumn;
                if (m.originalName != null) {
                    int nameId = SourceMapGeneratorV3.this.getNameId(m.originalName);
                    Base64VLQ.encode(this.out, nameId - this.previousNameId);
                    this.previousNameId = nameId;
                }
            }
        }

        void appendLineMappings() throws IOException {
            this.openLine(true);
            new MappingTraversal().traverse(this);
            this.closeLine(true);
        }

        private void openLine(boolean firstEntry) throws IOException {
            if (firstEntry) {
                this.out.append('\"');
            }
        }

        private void closeLine(boolean finalEntry) throws IOException {
            this.out.append(';');
            if (finalEntry) {
                this.out.append('\"');
            }
        }
    }

    private class MappingTraversal {
        private int line;
        private int col;

        MappingTraversal() {
        }

        void traverse(MappingVisitor v) throws IOException {
            ArrayDeque<Mapping> stack = new ArrayDeque<Mapping>();
            for (Mapping m : SourceMapGeneratorV3.this.mappings) {
                while (!stack.isEmpty() && !this.isOverlapped((Mapping)stack.peek(), m)) {
                    Mapping previous = (Mapping)stack.pop();
                    this.maybeVisit(v, previous);
                }
                Mapping parent = (Mapping)stack.peek();
                this.maybeVisitParent(v, parent, m);
                stack.push(m);
            }
            while (!stack.isEmpty()) {
                Mapping m = (Mapping)stack.pop();
                this.maybeVisit(v, m);
            }
        }

        private int getAdjustedLine(FilePosition p) {
            return p.getLine() + SourceMapGeneratorV3.this.prefixPosition.getLine();
        }

        private int getAdjustedCol(FilePosition p) {
            int rawLine = p.getLine();
            int rawCol = p.getColumn();
            return rawLine != 0 ? rawCol : rawCol + SourceMapGeneratorV3.this.prefixPosition.getColumn();
        }

        private boolean isOverlapped(Mapping m1, Mapping m2) {
            int l1 = m1.endPosition.getLine();
            int l2 = m2.startPosition.getLine();
            int c1 = m1.endPosition.getColumn();
            int c2 = m2.startPosition.getColumn();
            return l1 == l2 && c1 >= c2 || l1 > l2;
        }

        private void maybeVisit(MappingVisitor v, Mapping m) throws IOException {
            int nextLine = this.getAdjustedLine(m.endPosition);
            int nextCol = this.getAdjustedCol(m.endPosition);
            if (this.line < nextLine || this.line == nextLine && this.col < nextCol) {
                this.visit(v, m, nextLine, nextCol);
            }
        }

        private void maybeVisitParent(MappingVisitor v, Mapping parent, Mapping m) throws IOException {
            int nextLine = this.getAdjustedLine(m.startPosition);
            int nextCol = this.getAdjustedCol(m.startPosition);
            Preconditions.checkState((this.line < nextLine || this.col <= nextCol ? 1 : 0) != 0);
            if (this.line < nextLine || this.line == nextLine && this.col < nextCol) {
                this.visit(v, parent, nextLine, nextCol);
            }
        }

        private void visit(MappingVisitor v, Mapping m, int nextLine, int nextCol) throws IOException {
            Preconditions.checkState((this.line <= nextLine ? 1 : 0) != 0);
            Preconditions.checkState((this.line < nextLine || this.col < nextCol ? 1 : 0) != 0);
            if (this.line == nextLine && this.col == nextCol) {
                throw new IllegalStateException();
            }
            v.visit(m, this.line, this.col, nextLine, nextCol);
            this.line = nextLine;
            this.col = nextCol;
        }
    }

    private static interface MappingVisitor {
        public void visit(Mapping var1, int var2, int var3, int var4, int var5) throws IOException;
    }

    private class UsedMappingCheck
    implements MappingVisitor {
        private UsedMappingCheck() {
        }

        @Override
        public void visit(Mapping m, int line, int col, int nextLine, int nextCol) throws IOException {
            if (m != null) {
                m.used = true;
            }
        }
    }

    static class Mapping {
        int id = -1;
        String sourceFile;
        FilePosition originalPosition;
        FilePosition startPosition;
        FilePosition endPosition;
        String originalName;
        boolean used = false;

        Mapping() {
        }
    }

    class ConsumerEntryVisitor
    implements SourceMapConsumerV3.EntryVisitor {
        ConsumerEntryVisitor() {
        }

        @Override
        public void visit(String sourceName, String symbolName, FilePosition sourceStartPosition, FilePosition startPosition, FilePosition endPosition) {
            SourceMapGeneratorV3.this.addMapping(sourceName, symbolName, sourceStartPosition, startPosition, endPosition);
        }
    }

    public static interface ExtensionMergeAction {
        public Object merge(String var1, Object var2, Object var3);
    }
}

