/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.testing.fieldbinder;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.internal.Annotations;
import com.google.inject.spi.Message;
import com.google.inject.testing.fieldbinder.Bind;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public final class BoundFieldModule
implements Module {
    private final Object instance;
    private Binder binder;

    private BoundFieldModule(Object instance) {
        this.instance = instance;
    }

    public static BoundFieldModule of(Object instance) {
        return new BoundFieldModule(instance);
    }

    private static boolean hasInject(Field field) {
        return field.isAnnotationPresent(javax.inject.Inject.class) || field.isAnnotationPresent(Inject.class);
    }

    private Optional<BoundFieldInfo> getBoundFieldInfo(TypeLiteral<?> containingClassType, Field field) {
        Bind bindAnnotation = field.getAnnotation(Bind.class);
        if (bindAnnotation == null) {
            return Optional.absent();
        }
        if (BoundFieldModule.hasInject(field)) {
            this.throwBoundFieldException(field, "Fields annotated with both @Bind and @Inject are illegal.", new Object[0]);
        }
        return Optional.of((Object)new BoundFieldInfo(field, bindAnnotation, containingClassType.getFieldType(field)));
    }

    private LinkedBindingBuilder<?> verifyBindingAnnotations(Field field, AnnotatedBindingBuilder<?> annotatedBinder) {
        LinkedBindingBuilder binderRet = annotatedBinder;
        for (Annotation annotation : field.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!Annotations.isBindingAnnotation(annotationType)) continue;
            binderRet = annotatedBinder.annotatedWith(annotation);
        }
        return binderRet;
    }

    private static boolean isTransparentProvider(Class<?> clazz) {
        return Provider.class == clazz || javax.inject.Provider.class == clazz;
    }

    private void bindField(final BoundFieldInfo fieldInfo) {
        if (fieldInfo.naturalType.isPresent()) {
            Class naturalRawType = ((TypeLiteral)fieldInfo.naturalType.get()).getRawType();
            Class boundRawType = fieldInfo.boundType.getRawType();
            if (!boundRawType.isAssignableFrom(naturalRawType)) {
                this.throwBoundFieldException(fieldInfo.field, "Requested binding type \"%s\" is not assignable from field binding type \"%s\"", boundRawType.getName(), naturalRawType.getName());
            }
        }
        AnnotatedBindingBuilder annotatedBinder = this.binder.bind(fieldInfo.boundType);
        LinkedBindingBuilder<?> binder = this.verifyBindingAnnotations(fieldInfo.field, annotatedBinder);
        AnnotatedBindingBuilder binderUnsafe = (AnnotatedBindingBuilder)binder;
        if (BoundFieldModule.isTransparentProvider(fieldInfo.type.getRawType())) {
            if (fieldInfo.bindAnnotation.lazy()) {
                this.throwBoundFieldException(fieldInfo.field, "'lazy' is incompatible with Provider valued fields", new Object[0]);
            }
            Provider fieldValueUnsafe = (Provider)this.getFieldValue(fieldInfo);
            binderUnsafe.toProvider(fieldValueUnsafe);
        } else if (fieldInfo.bindAnnotation.lazy()) {
            binderUnsafe.toProvider((Provider)new Provider<Object>(){

                public Object get() {
                    return BoundFieldModule.this.getFieldValue(fieldInfo);
                }
            });
        } else {
            binderUnsafe.toInstance(this.getFieldValue(fieldInfo));
        }
    }

    private Object getFieldValue(BoundFieldInfo fieldInfo) {
        Object fieldValue = fieldInfo.getValue();
        if (fieldValue == null) {
            this.throwBoundFieldException(fieldInfo.field, "Binding to null values is not allowed. Use Providers.of(null) if this is your intended behavior.", fieldInfo.field.getName());
        }
        return fieldValue;
    }

    private void throwBoundFieldException(Field field, String format, Object ... args) {
        Preconditions.checkNotNull((Object)this.binder);
        String source = String.format("%s field %s", field.getDeclaringClass().getName(), field.getName());
        throw new BoundFieldException(new Message((Object)source, String.format(format, args)));
    }

    public void configure(Binder binder) {
        this.binder = binder = binder.skipSources(new Class[]{BoundFieldModule.class});
        TypeLiteral currentClassType = TypeLiteral.get(this.instance.getClass());
        while (currentClassType.getRawType() != Object.class) {
            for (Field field : currentClassType.getRawType().getDeclaredFields()) {
                try {
                    Optional<BoundFieldInfo> fieldInfoOpt = this.getBoundFieldInfo(currentClassType, field);
                    if (!fieldInfoOpt.isPresent()) continue;
                    this.bindField((BoundFieldInfo)fieldInfoOpt.get());
                }
                catch (BoundFieldException e) {
                    binder.addError(e.message);
                }
            }
            currentClassType = currentClassType.getSupertype(currentClassType.getRawType().getSuperclass());
        }
    }

    private class BoundFieldInfo {
        final Field field;
        final TypeLiteral<?> type;
        final Bind bindAnnotation;
        final TypeLiteral<?> boundType;
        final Optional<TypeLiteral<?>> naturalType;

        BoundFieldInfo(Field field, Bind bindAnnotation, TypeLiteral<?> fieldType) {
            this.field = field;
            this.type = fieldType;
            this.bindAnnotation = bindAnnotation;
            field.setAccessible(true);
            this.naturalType = this.getNaturalFieldType();
            this.boundType = this.getBoundType();
        }

        private TypeLiteral<?> getBoundType() {
            Class<?> bindClass = this.bindAnnotation.to();
            if (bindClass == Bind.class) {
                Preconditions.checkState((this.naturalType != null ? 1 : 0) != 0);
                if (!this.naturalType.isPresent()) {
                    BoundFieldModule.this.throwBoundFieldException(this.field, "Non parameterized Provider fields must have an explicit binding class via @Bind(to = Foo.class)", new Object[0]);
                }
                return (TypeLiteral)this.naturalType.get();
            }
            return TypeLiteral.get(bindClass);
        }

        private Optional<TypeLiteral<?>> getNaturalFieldType() {
            if (BoundFieldModule.isTransparentProvider(this.type.getRawType())) {
                Type providerType = this.type.getType();
                if (providerType instanceof Class) {
                    return Optional.absent();
                }
                Preconditions.checkState((boolean)(providerType instanceof ParameterizedType));
                Type[] providerTypeArguments = ((ParameterizedType)providerType).getActualTypeArguments();
                Preconditions.checkState((providerTypeArguments.length == 1 ? 1 : 0) != 0);
                return Optional.of((Object)TypeLiteral.get((Type)providerTypeArguments[0]));
            }
            return Optional.of(this.type);
        }

        Object getValue() {
            try {
                return this.field.get(BoundFieldModule.this.instance);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static class BoundFieldException
    extends RuntimeException {
        private final Message message;

        BoundFieldException(Message message) {
            super(message.getMessage());
            this.message = message;
        }
    }
}

