/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.xml;

import com.google.api.client.http.HttpMediaType;
import com.google.api.client.util.ArrayValueMap;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Charsets;
import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.Data;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.Types;
import com.google.api.client.xml.GenericXml;
import com.google.api.client.xml.XmlNamespaceDictionary;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

@Beta
public class Xml {
    public static final String MEDIA_TYPE = new HttpMediaType("application/xml").setCharsetParameter(Charsets.UTF_8).build();
    static final String TEXT_CONTENT = "text()";
    private static XmlPullParserFactory factory;

    private static synchronized XmlPullParserFactory getParserFactory() throws XmlPullParserException {
        if (factory == null) {
            factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
            factory.setNamespaceAware(true);
        }
        return factory;
    }

    public static XmlSerializer createSerializer() {
        try {
            return Xml.getParserFactory().newSerializer();
        }
        catch (XmlPullParserException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static XmlPullParser createParser() throws XmlPullParserException {
        return Xml.getParserFactory().newPullParser();
    }

    public static String toStringOf(Object element) {
        return new XmlNamespaceDictionary().toStringOf(null, element);
    }

    private static void parseAttributeOrTextContent(String stringValue, Field field, Type valueType, List<Type> context, Object destination, GenericXml genericXml, Map<String, Object> destinationMap, String name) {
        if (field != null || genericXml != null || destinationMap != null) {
            valueType = field == null ? valueType : field.getGenericType();
            Object value = Xml.parseValue(valueType, context, stringValue);
            Xml.setValue(value, field, destination, genericXml, destinationMap, name);
        }
    }

    private static void setValue(Object value, Field field, Object destination, GenericXml genericXml, Map<String, Object> destinationMap, String name) {
        if (field != null) {
            FieldInfo.setFieldValue((Field)field, (Object)destination, (Object)value);
        } else if (genericXml != null) {
            genericXml.set(name, value);
        } else {
            destinationMap.put(name, value);
        }
    }

    public static void parseElement(XmlPullParser parser, Object destination, XmlNamespaceDictionary namespaceDictionary, CustomizeParser customizeParser) throws IOException, XmlPullParserException {
        ArrayList<Type> context = new ArrayList<Type>();
        if (destination != null) {
            context.add(destination.getClass());
        }
        Xml.parseElementInternal(parser, context, destination, null, namespaceDictionary, customizeParser);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static boolean parseElementInternal(XmlPullParser parser, ArrayList<Type> context, Object destination, Type valueType, XmlNamespaceDictionary namespaceDictionary, CustomizeParser customizeParser) throws IOException, XmlPullParserException {
        genericXml = destination instanceof GenericXml != false ? (GenericXml)destination : null;
        destinationMap = genericXml == null && destination instanceof Map != false ? (Map)Map.class.cast(destination) : null;
        v0 = classInfo = destinationMap != null || destination == null ? null : ClassInfo.of(destination.getClass());
        if (parser.getEventType() == 0) {
            parser.next();
        }
        Xml.parseNamespacesForElement(parser, namespaceDictionary);
        if (genericXml != null) {
            genericXml.namespaceDictionary = namespaceDictionary;
            name = parser.getName();
            namespace = parser.getNamespace();
            alias = namespaceDictionary.getNamespaceAliasForUriErrorOnUnknown(namespace);
            v1 = genericXml.name = alias.length() == 0 ? name : alias + ":" + name;
        }
        if (destination != null) {
            attributeCount = parser.getAttributeCount();
            for (i = 0; i < attributeCount; ++i) {
                attributeName = parser.getAttributeName(i);
                attributeNamespace = parser.getAttributeNamespace(i);
                attributeAlias = attributeNamespace.length() == 0 ? "" : namespaceDictionary.getNamespaceAliasForUriErrorOnUnknown(attributeNamespace);
                fieldName = Xml.getFieldName(true, attributeAlias, attributeNamespace, attributeName);
                field = classInfo == null ? null : classInfo.getField(fieldName);
                Xml.parseAttributeOrTextContent(parser.getAttributeValue(i), field, valueType, context, destination, genericXml, destinationMap, fieldName);
            }
        }
        arrayValueMap = new ArrayValueMap(destination);
        isStopped = false;
        block13: while (true) {
            event = parser.next();
            switch (event) {
                case 1: {
                    isStopped = true;
                    break block13;
                }
                case 3: {
                    isStopped = customizeParser != null && customizeParser.stopAfterEndTag(parser.getNamespace(), parser.getName()) != false;
                    break block13;
                }
                case 4: {
                    if (destination == null) ** GOTO lbl179
                    field = classInfo == null ? null : classInfo.getField("text()");
                    Xml.parseAttributeOrTextContent(parser.getText(), field, valueType, context, destination, genericXml, destinationMap, "text()");
                    ** GOTO lbl179
                }
                case 2: {
                    if (customizeParser != null && customizeParser.stopBeforeStartTag(parser.getNamespace(), parser.getName())) {
                        isStopped = true;
                        break block13;
                    }
                    if (destination == null) {
                        Xml.parseTextContentForElement(parser, context, true, null);
                    } else {
                        Xml.parseNamespacesForElement(parser, namespaceDictionary);
                        namespace = parser.getNamespace();
                        alias = namespaceDictionary.getNamespaceAliasForUriErrorOnUnknown(namespace);
                        fieldName = Xml.getFieldName(false, alias, namespace, parser.getName());
                        field = classInfo == null ? null : classInfo.getField(fieldName);
                        fieldType = field == null ? valueType : field.getGenericType();
                        fieldType = Data.resolveWildcardTypeOrTypeVariable(context, (Type)fieldType);
                        v2 = fieldClass = fieldType instanceof Class != false ? (Class)fieldType : null;
                        if (fieldType instanceof ParameterizedType) {
                            fieldClass = Types.getRawClass((ParameterizedType)((ParameterizedType)fieldType));
                        }
                        isArray = Types.isArray((Type)fieldType);
                        ignore = field == null && destinationMap == null && genericXml == null;
                        v3 = isEnum = fieldClass != null && fieldClass.isEnum() != false;
                        if (ignore || Data.isPrimitive((Type)fieldType) || isEnum) {
                            level = 1;
                            block14: while (level != 0) {
                                switch (parser.next()) {
                                    case 1: {
                                        isStopped = true;
                                        break block13;
                                    }
                                    case 2: {
                                        ++level;
                                        continue block14;
                                    }
                                    case 3: {
                                        --level;
                                        continue block14;
                                    }
                                    case 4: {
                                        if (ignore || level != 1) continue block14;
                                        Xml.parseAttributeOrTextContent(parser.getText(), field, valueType, context, destination, genericXml, destinationMap, fieldName);
                                        continue block14;
                                    }
                                }
                            }
                        } else if (fieldType == null || fieldClass != null && Types.isAssignableToOrFrom((Class)fieldClass, Map.class)) {
                            mapValue = Data.newMapInstance((Class)fieldClass);
                            contextSize = context.size();
                            if (fieldType != null) {
                                context.add(fieldType);
                            }
                            subValueType = fieldType != null && Map.class.isAssignableFrom(fieldClass) != false ? Types.getMapValueParameter((Type)fieldType) : null;
                            subValueType = Data.resolveWildcardTypeOrTypeVariable(context, subValueType);
                            isStopped = Xml.parseElementInternal(parser, context, mapValue, subValueType, namespaceDictionary, customizeParser);
                            if (fieldType != null) {
                                context.remove(contextSize);
                            }
                            if (destinationMap != null) {
                                list = (ArrayList<Map>)destinationMap.get(fieldName);
                                if (list == null) {
                                    list = new ArrayList<Map>(1);
                                    destinationMap.put(fieldName, list);
                                }
                                list.add(mapValue);
                            } else if (field != null) {
                                fieldInfo = FieldInfo.of((Field)field);
                                if (fieldClass == Object.class) {
                                    list /* !! */  = (Collection)fieldInfo.getValue(destination);
                                    if (list /* !! */  == null) {
                                        list /* !! */  = new ArrayList<E>(1);
                                        fieldInfo.setValue(destination, list /* !! */ );
                                    }
                                    list /* !! */ .add(mapValue);
                                } else {
                                    fieldInfo.setValue(destination, (Object)mapValue);
                                }
                            } else {
                                atom = (GenericXml)destination;
                                list /* !! */  = (ArrayList<Map>)atom.get(fieldName);
                                if (list /* !! */  == null) {
                                    list /* !! */  = new ArrayList<Map>(1);
                                    atom.set(fieldName, list /* !! */ );
                                }
                                list /* !! */ .add(mapValue);
                            }
                        } else if (isArray || Types.isAssignableToOrFrom((Class)fieldClass, Collection.class)) {
                            fieldInfo = FieldInfo.of((Field)field);
                            elementValue = null;
                            subFieldType = isArray != false ? Types.getArrayComponentType((Type)fieldType) : Types.getIterableParameter((Type)fieldType);
                            rawArrayComponentType = Types.getRawArrayComponentType(context, (Type)subFieldType);
                            subFieldType = Data.resolveWildcardTypeOrTypeVariable(context, (Type)subFieldType);
                            v4 = subFieldClass = subFieldType instanceof Class != false ? (Class)subFieldType : null;
                            if (subFieldType instanceof ParameterizedType) {
                                subFieldClass = Types.getRawClass((ParameterizedType)((ParameterizedType)subFieldType));
                            }
                            v5 = isSubEnum = subFieldClass != null && subFieldClass.isEnum() != false;
                            if (Data.isPrimitive((Type)subFieldType) || isSubEnum) {
                                elementValue = Xml.parseTextContentForElement(parser, context, false, subFieldType);
                            } else if (subFieldType == null || subFieldClass != null && Types.isAssignableToOrFrom((Class)subFieldClass, Map.class)) {
                                elementValue = Data.newMapInstance((Class)subFieldClass);
                                contextSize = context.size();
                                if (subFieldType != null) {
                                    context.add(subFieldType);
                                }
                                subValueType = subFieldType != null && Map.class.isAssignableFrom(subFieldClass) != false ? Types.getMapValueParameter((Type)subFieldType) : null;
                                subValueType = Data.resolveWildcardTypeOrTypeVariable(context, subValueType);
                                isStopped = Xml.parseElementInternal(parser, context, elementValue, subValueType, namespaceDictionary, customizeParser);
                                if (subFieldType != null) {
                                    context.remove(contextSize);
                                }
                            } else {
                                elementValue = Types.newInstance((Class)rawArrayComponentType);
                                contextSize = context.size();
                                context.add(fieldType);
                                isStopped = Xml.parseElementInternal(parser, context, elementValue, null, namespaceDictionary, customizeParser);
                                context.remove(contextSize);
                            }
                            if (isArray) {
                                if (field == null) {
                                    arrayValueMap.put(fieldName, rawArrayComponentType, elementValue);
                                } else {
                                    arrayValueMap.put(field, rawArrayComponentType, elementValue);
                                }
                            } else {
                                collectionValue = (Collection)(field == null ? destinationMap.get(fieldName) : fieldInfo.getValue(destination));
                                if (collectionValue == null) {
                                    collectionValue = Data.newCollectionInstance((Type)fieldType);
                                    Xml.setValue(collectionValue, field, destination, genericXml, destinationMap, fieldName);
                                }
                                collectionValue.add(elementValue);
                            }
                        } else {
                            value = Types.newInstance((Class)fieldClass);
                            contextSize = context.size();
                            context.add(fieldType);
                            isStopped = Xml.parseElementInternal(parser, context, value, null, namespaceDictionary, customizeParser);
                            context.remove(contextSize);
                            Xml.setValue(value, field, destination, genericXml, destinationMap, fieldName);
                        }
                    }
                    if (isStopped || parser.getEventType() == 1) {
                        isStopped = true;
                        break block13;
                    }
                }
lbl179:
                // 5 sources

                default: {
                    continue block13;
                }
            }
            break;
        }
        arrayValueMap.setValues();
        return isStopped;
    }

    private static String getFieldName(boolean isAttribute, String alias, String namespace, String name) {
        if (!isAttribute && alias.length() == 0) {
            return name;
        }
        StringBuilder buf = new StringBuilder(2 + alias.length() + name.length());
        if (isAttribute) {
            buf.append('@');
        }
        if (alias.length() != 0) {
            buf.append(alias).append(':');
        }
        return buf.append(name).toString();
    }

    private static Object parseTextContentForElement(XmlPullParser parser, List<Type> context, boolean ignoreTextContent, Type textContentType) throws XmlPullParserException, IOException {
        Object result = null;
        int level = 1;
        block6: while (level != 0) {
            switch (parser.next()) {
                case 1: {
                    level = 0;
                    continue block6;
                }
                case 2: {
                    ++level;
                    continue block6;
                }
                case 3: {
                    --level;
                    continue block6;
                }
                case 4: {
                    if (ignoreTextContent || level != 1) continue block6;
                    result = Xml.parseValue(textContentType, context, parser.getText());
                    continue block6;
                }
            }
        }
        return result;
    }

    private static Object parseValue(Type valueType, List<Type> context, String value) {
        if ((valueType = Data.resolveWildcardTypeOrTypeVariable(context, (Type)valueType)) == Double.class || valueType == Double.TYPE) {
            if (value.equals("INF")) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            if (value.equals("-INF")) {
                return new Double(Double.NEGATIVE_INFINITY);
            }
        }
        if (valueType == Float.class || valueType == Float.TYPE) {
            if (value.equals("INF")) {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
            if (value.equals("-INF")) {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
        }
        return Data.parsePrimitiveValue((Type)valueType, (String)value);
    }

    private static void parseNamespacesForElement(XmlPullParser parser, XmlNamespaceDictionary namespaceDictionary) throws XmlPullParserException {
        int eventType = parser.getEventType();
        Preconditions.checkState((eventType == 2 ? 1 : 0) != 0, (String)"expected start of XML element, but got something else (event type %s)", (Object[])new Object[]{eventType});
        int depth = parser.getDepth();
        int nsStart = parser.getNamespaceCount(depth - 1);
        int nsEnd = parser.getNamespaceCount(depth);
        for (int i = nsStart; i < nsEnd; ++i) {
            String originalAlias;
            String namespace = parser.getNamespaceUri(i);
            if (namespaceDictionary.getAliasForUri(namespace) != null) continue;
            String prefix = parser.getNamespacePrefix(i);
            String alias = originalAlias = prefix == null ? "" : prefix;
            int suffix = 1;
            while (namespaceDictionary.getUriForAlias(alias) != null) {
                alias = originalAlias + ++suffix;
            }
            namespaceDictionary.set(alias, namespace);
        }
    }

    private Xml() {
    }

    public static class CustomizeParser {
        public boolean stopBeforeStartTag(String namespace, String localName) {
            return false;
        }

        public boolean stopAfterEndTag(String namespace, String localName) {
            return false;
        }
    }
}

