/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.xml.atom;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Charsets;
import com.google.api.client.util.Lists;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.escape.PercentEscaper;
import com.google.api.client.xml.Xml;
import java.util.Arrays;

@Beta
public final class Atom {
    public static final String ATOM_NAMESPACE = "http://www.w3.org/2005/Atom";
    public static final String MEDIA_TYPE = new HttpMediaType("application/atom+xml").setCharsetParameter(Charsets.UTF_8).build();
    private static final PercentEscaper SLUG_ESCAPER = new PercentEscaper(" !\"#$&'()*+,-./:;<=>?@[\\]^_`{|}~", false);

    private Atom() {
    }

    public static void checkContentType(String contentType) {
        Preconditions.checkArgument((contentType != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)HttpMediaType.equalsIgnoreParameters((String)MEDIA_TYPE, (String)contentType), (String)("Wrong content type: expected <" + MEDIA_TYPE + "> but got <%s>"), (Object[])new Object[]{contentType});
    }

    public static void setSlugHeader(HttpHeaders headers, String value) {
        if (value == null) {
            headers.remove((Object)"Slug");
        } else {
            headers.set("Slug", (Object)Lists.newArrayList(Arrays.asList(SLUG_ESCAPER.escape(value))));
        }
    }

    static final class StopAtAtomEntry
    extends Xml.CustomizeParser {
        static final StopAtAtomEntry INSTANCE = new StopAtAtomEntry();

        StopAtAtomEntry() {
        }

        @Override
        public boolean stopBeforeStartTag(String namespace, String localName) {
            return "entry".equals(localName) && Atom.ATOM_NAMESPACE.equals(namespace);
        }
    }
}

